<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.human.vo.HumanListVo"
%><%
HumanListVo vo = (HumanListVo)request.getAttribute(MospConst.ATT_VO);
String[] aryKCode		= vo.getEscAryKCode();
String[] aryKName		= vo.getEscAryKName();
String[] aryOffice		= vo.getEscAryOffice();
String[] arySection		= vo.getEscArySection();
String[] aryPosition	= vo.getEscAryPosition();
String[] aryRetirement	= vo.getEscAryRetirement();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="employeeSelect">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Search">
		<table>
			<tr>
				<td id="tdOffice">
					<span class="TitleLabel"><%= vo.NAM_OFFICE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="OfficeSelect" id="<%= HumanListVo.PRM_PLT_OFFICE %>" name="<%= HumanListVo.PRM_PLT_OFFICE %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltOffice, vo.getPltOfiice()) %>
					</select>
				</td>
				<td id="tdSection">
					<span class="TitleLabel"><%= vo.NAM_SECTION %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="SectionSelect" id="<%= HumanListVo.PRM_PLT_SECTION %>" name="<%= HumanListVo.PRM_PLT_SECTION %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltSection, vo.getPltSection()) %>
					</select>
				</td>
				<td>
					<span class="TitleLabel"><%= vo.NAM_POSITION %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="PositionSelect" id="<%= HumanListVo.PRM_PLT_POSITION %>" name="<%= HumanListVo.PRM_PLT_POSITION %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltPosition, vo.getPltPosition()) %>
					</select>
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="submitForm(document.form, 'H1011')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
			<tr>
				<td id="tdKCode">
					<span class="TitleLabel"><%= vo.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="UserIdText" id="<%= HumanListVo.PRM_TXT_K_CODE %>" name="<%= HumanListVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>" />
				</td>
				<td id="tdKName">
					<span class="TitleLabel"><%= vo.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= HumanListVo.PRM_TXT_K_NAME %>" name="<%= HumanListVo.PRM_TXT_K_NAME %>" value="<%= vo.getEscTxtKName() %>" />
				</td>
				<td>
					<span class="TitleLabel">&nbsp;<%= vo.NAM_RETIREMENT_TYPE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="RetirementSelect" id="<%= HumanListVo.PRM_PLT_RETIREMENT %>" name="<%= HumanListVo.PRM_PLT_RETIREMENT %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltRetirement, vo.getPltRetirement()) %>
					</select>
				</td>
			</tr>
		</table>
	</div>
	<%=HtmlUtility.getListInfo(vo)%>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th class="ButtonTh"></th>
					<th id="thKCode"		onclick="doSubmitKey(document.form, 'H1013', '<%= vo.KEY_K_CODE     %>', '')">&nbsp;<%= vo.NAM_K_CODE          %>&nbsp;<%= vo.getSortMark(vo.KEY_K_CODE)     %></th>
					<th id="thKName"		onclick="doSubmitKey(document.form, 'H1013', '<%= vo.KEY_K_NAME     %>', '')">&nbsp;<%= vo.NAM_K_NAME          %>&nbsp;<%= vo.getSortMark(vo.KEY_K_NAME)     %></th>
					<th id="thOffice"		onclick="doSubmitKey(document.form, 'H1013', '<%= vo.KEY_OFFICE     %>', '')">&nbsp;<%= vo.NAM_OFFICE          %>&nbsp;<%= vo.getSortMark(vo.KEY_OFFICE)     %></th>
					<th id="thSection"		onclick="doSubmitKey(document.form, 'H1013', '<%= vo.KEY_SECTION    %>', '')">&nbsp;<%= vo.NAM_SECTION         %>&nbsp;<%= vo.getSortMark(vo.KEY_SECTION)    %></th>
					<th id="thPosition"		onclick="doSubmitKey(document.form, 'H1013', '<%= vo.KEY_POSITION   %>', '')">&nbsp;<%= vo.NAM_POSITION        %>&nbsp;<%= vo.getSortMark(vo.KEY_POSITION)   %></th>
					<th id="thRetirement"	onclick="doSubmitKey(document.form, 'H1013', '<%= vo.KEY_RETIREMENT %>', '')">&nbsp;<%= vo.NAM_RETIREMENT_TYPE %>&nbsp;<%= vo.getSortMark(vo.KEY_RETIREMENT) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'H1021', '<%= aryKCode[i] %>', '')"><%= CommonConst.NAM_EDIT %></button>
					</td>
					<td                 ><%= aryKCode     [i] %></td>
					<td                 ><%= aryKName     [i] %></td>
					<td                 ><%= aryOffice    [i] %></td>
					<td                 ><%= arySection   [i] %></td>
					<td                 ><%= aryPosition  [i] %></td>
					<td class="CenterTd"><%= aryRetirement[i] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
