<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.kintai.payroll.vo.EmployeePaidHolidayListVo"
%><%
EmployeePaidHolidayListVo vo = (EmployeePaidHolidayListVo)request.getAttribute(MospConst.ATT_VO);
String[][] aryEmployee        = vo.getEscAryEmployee();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="employeeList">
	<%=HtmlUtility.getMessages(vo)%>
	<div class="Search">
		<table>
			<tr>
				<td id="tdKCode">
					<span class="TitleLabel"><%= vo.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="UserIdText" id="<%= EmployeePaidHolidayListVo.PRM_TXT_K_CODE %>" name="<%= EmployeePaidHolidayListVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>" />
				</td>
				<td id="tdKName">
					<span class="TitleLabel"><%= vo.NAM_K_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= EmployeePaidHolidayListVo.PRM_TXT_K_NAME %>" name="<%= EmployeePaidHolidayListVo.PRM_TXT_K_NAME %>" value="<%= vo.getEscTxtKName() %>" />
				</td>
				<td class="ButtonTd" rowspan="2">
					<button type="button" onclick="submitForm(document.form, 'P1111')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
			<tr>
				<td id="tdStation">
					<span class="TitleLabel"><%= vo.NAM_STATION %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="StationSelect" id="<%= EmployeePaidHolidayListVo.PRM_PLT_SECTION %>" name="<%= EmployeePaidHolidayListVo.PRM_PLT_SECTION %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltSection, vo.getPltSection()) %>
					</select>
				</td>
				<td id="tdYearMonth">
					<button type="button" id="btnFormer" onclick="submitMonth(document.form, 'P1111', 'former')">
						<%= CommonConst.NAM_PREVIOUS_MONTH %>
					</button>
					<select id="<%= EmployeePaidHolidayListVo.PRM_PLT_YEAR %>" name="<%= EmployeePaidHolidayListVo.PRM_PLT_YEAR %>" onchange="submitMonth(document.form, 'P1111', '')">
						<%= HtmlUtility.getSelectOption(vo.aryPltYear, vo.getPltYear()) %>
					</select><%= CommonConst.NAM_YEAR %>
					<select id="<%= EmployeePaidHolidayListVo.PRM_PLT_MONTH %>" name="<%= EmployeePaidHolidayListVo.PRM_PLT_MONTH %>" onchange="submitMonth(document.form, 'P1111', '')">
						<%= HtmlUtility.getSelectOption(vo.aryPltMonth, vo.getPltMonth()) %>
					</select><%= CommonConst.NAM_MONTH %>
					<button type="button" id="btnNext" onclick="submitMonth(document.form, 'P1111', 'next')">
						<%= CommonConst.NAM_NEXT_MONTH %>
					</button>
				</td>
			</tr>
		</table>
	</div>
	<%=HtmlUtility.getListInfo(vo)%>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thKCode"          onclick="doSubmitKey(document.form, 'P1113', '<%= vo.KEY_K_CODE  %>', '')">&nbsp;<%= CommonConst.NAM_K_CODE %>&nbsp;<%= vo.getSortMark(vo.KEY_K_CODE) %></th>
					<th id="thKName"          onclick="doSubmitKey(document.form, 'P1113', '<%= vo.KEY_K_NAME  %>', '')">&nbsp;<%= CommonConst.NAM_K_NAME %>&nbsp;<%= vo.getSortMark(vo.KEY_K_NAME) %></th>
					<th id="thStation"        onclick="doSubmitKey(document.form, 'P1113', '<%= vo.KEY_SECTION %>', '')">&nbsp;<%= CommonConst.NAM_STATION %>&nbsp;<%= vo.getSortMark(vo.KEY_SECTION) %></th>
					<th id="thPosition"       onclick="doSubmitKey(document.form, 'P1113', '<%= vo.KEY_POSITION %>', '')">&nbsp;<%= CommonConst.NAM_POSITION %>&nbsp;<%= vo.getSortMark(vo.KEY_POSITION) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, '<%= aryEmployee[i][0] %>', '<%= aryEmployee[i][1] %>', '<%= vo.getEscHidSelectYearMonth() %>')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td><%= aryEmployee[i][1] %></td>
					<td><%= aryEmployee[i][2] %></td>
					<td><%= aryEmployee[i][3] %></td>
					<td><%= aryEmployee[i][4] %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
