<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.mospcommon.system.vo.LimitStandardMasterListVo"
%><%
LimitStandardMasterListVo vo = (LimitStandardMasterListVo)request.getAttribute(MospConst.ATT_VO);
String[] aryLCode   = vo.getEscAryLCode();
String[] aryLName   = vo.getEscAryLName();
String[] aryDelete   = vo.getAryDelete();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>

<%@page import="jp.mosp.common.common.BaseVo"%><div class="Body" id="limitStandardMasterList">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Search">
		<table>
			<tr>
				<td id="tdCode">
					<span><%= vo.NAM_LCODE %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="CodeTextBox" id="<%= LimitStandardMasterListVo.PRM_TXT_LCODE %>" name="<%= LimitStandardMasterListVo.PRM_TXT_LCODE %>" value="<%= vo.getEscTxtLCode() %>" />
				</td>
				<td id="tdName">
					<span><%= vo.NAM_LNAME %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<input type="text" class="TextBox" id="<%= LimitStandardMasterListVo.PRM_TXT_LNAME %>" name="<%= LimitStandardMasterListVo.PRM_TXT_LNAME %>" value="<%= vo.getEscTxtLName() %>" />
				</td>
				<td id="tdDeleteFlag">
					<span><%= vo.NAM_DELETE_FLAG %><%= CommonConst.STR_TITLE_SEPARATOR %></span>
					<select class="DeleteFlagSelect" id="<%= LimitStandardMasterListVo.PRM_PLT_DELETE_FLAG %>" name="<%= LimitStandardMasterListVo.PRM_PLT_DELETE_FLAG %>">
						<option value=""></option>
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDeleteFlag()) %>
					</select>
				</td>
				<td class="ButtonTd">
					<button type="button" onclick="doSubmitKey(document.form, 'S2541', '')"><%= CommonConst.NAM_SEARCH %></button>
				</td>
			</tr>
		</table>
	</div>
	<%= HtmlUtility.getListInfo(vo) %>
	<div class="List">
		<table id="list">
			<thead>
				<tr>
					<th id="thButton"></th>
					<th id="thCode" onclick="doSubmitKey(document.form, 'S2543', '<%= vo.KEY_LCODE  %>')">&nbsp;<%= vo.NAM_LCODE  %>&nbsp;<%= vo.getSortMark(vo.KEY_LCODE  ) %></th>
					<th id="thName" onclick="doSubmitKey(document.form, 'S2543', '<%= vo.KEY_LNAME %>')">&nbsp;<%= vo.NAM_LNAME %>&nbsp;<%= vo.getSortMark(vo.KEY_LNAME ) %></th>
					<th id="thDelete" onclick="doSubmitKey(document.form, 'S2543', '<%= vo.KEY_DELETE %>')">&nbsp;<%= vo.NAM_DELETE_FLAG %>&nbsp;<%= vo.getSortMark(vo.KEY_DELETE ) %></th>
				</tr>
			</thead>
			<tbody>
<%
for (int i = vo.getStart(); i <= vo.getEnd(); i++) {
%>
				<tr>
					<td class="ButtonTd">
						<button type="button" onclick="doSubmitKey(document.form, 'S2546', '<%= aryLCode[i] %>')"><%= CommonConst.NAM_SELECT %></button>
					</td>
					<td ><%= aryLCode  [i] %></td>
					<td ><%= aryLName  [i] %></td>
					<td class="DeleteTd"><%= BaseVo.escapeHTML(aryDelete[i]) %></td>
				</tr>
<%
}
%>
			</tbody>
		</table>
	</div>
	<div class="ButtonDiv">
		<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'S2545')"><%= CommonConst.NAM_MAKE_NEW_DATA %></button>
		<button type="button" class="MenuButton" onclick="doSubmit(document.form, 'S2500')"><%= CommonConst.TTL_LABOR_AGREEMENT_MANAGEMENT %></button>
	</div>
</div>
<%= HtmlUtility.getFooter(vo) %>
