<%--
MosP - Mind Open Source Project    http://www.mosp.jp/
Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "16kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.CommonConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.system.vo.FirstHumanAccountCardVo"
%><%
FirstHumanAccountCardVo vo = (FirstHumanAccountCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="accountCard">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_K_CODE %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td class="InputTd">
					<input type="text" class="UserIdText" id="<%= FirstHumanAccountCardVo.PRM_TXT_K_CODE %>" name="<%= FirstHumanAccountCardVo.PRM_TXT_K_CODE %>" value="<%= vo.getEscTxtKCode() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_USER_NAME %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td class="InputTd">
					<input type="text" class="TextBox" id="<%= FirstHumanAccountCardVo.PRM_TXT_USER_NAME %>" name="<%= FirstHumanAccountCardVo.PRM_TXT_USER_NAME %>" value="<%= vo.getEscTxtUserName() %>" />
				</td>
			</tr>
			<tr>
				<td class="Title1Td">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_OFFICE %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td class="InputTd">
					<select class="OfficeSelect" id="<%= FirstHumanAccountCardVo.PRM_PLT_OFFICE %>" name="<%= FirstHumanAccountCardVo.PRM_PLT_OFFICE %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltOfficeAll, vo.getPltOffice()) %>
					</select>
				</td>
			</tr>
			<tr>
				<td class="Title1Td">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_SECTION %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td class="InputTd">
					<select class="SectionSelect" id="<%= FirstHumanAccountCardVo.PRM_PLT_SECTION %>" name="<%= FirstHumanAccountCardVo.PRM_PLT_SECTION %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltSectionAll, vo.getPltSection()) %>
					</select>
				</td>
			</tr>
			<tr>
				<td class="Title1Td">
					<%= HtmlUtility.getRequiredMark() %><%= vo.NAM_POSITION %><%= CommonConst.STR_TITLE_SEPARATOR %>
				</td>
				<td>
					<select id="<%= FirstHumanAccountCardVo.PRM_PLT_POSITION %>" name="<%= FirstHumanAccountCardVo.PRM_PLT_POSITION %>">
						<%= HtmlUtility.getSelectOption(vo.aryPltPosition, vo.getPltPosition()) %>
					</select>
				</td>
			</tr>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" id="btnRegist" class="ExecuteButton" onclick="submitForm(document.form, 'S2417')"><%= CommonConst.NAM_REGIST %></button>
	<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'S2402')"><%= CommonConst.NAM_TO_LIST %></button>
</div>
<%= HtmlUtility.getFooter(vo) %>
