/*
 * Decompiled with CFR 0.152.
 */
package galatea.agent;

import galatea.agent.Agent;
import galatea.agent.Vector3D;
import galatea.util.AMBuffer;
import galatea.util.Getopt;
import galatea.util.HashArray;
import galatea.util.Property;
import galatea.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BehaviorManager {
    Random random_;
    private Pattern pattern1_;
    private Pattern pattern2_;
    private Pattern pattern3_;
    private Pattern pattern4_;
    private AMBuffer ambuf_;
    private HashArray agents_;
    private long prevTime_;
    private boolean isFsmAlive_ = false;
    private boolean useAutoMove_ = false;
    private String currAgent_;
    private boolean eventViewerMode_ = false;
    private boolean debugMode_ = false;
    private Vector3D prevEyeRot_ = new Vector3D(0.0, 0.0, 0.0);
    private Vector3D prevHeadRot_ = new Vector3D(0.0, 0.0, 0.0);
    private Vector3D prevBodyRot_ = new Vector3D(0.0, 0.0, 0.0);
    private Vector3D prevBodyTrans_ = new Vector3D(0.0, 0.0, 0.0);
    private Agent prevAgent_ = null;
    private double prevBodyScale_ = 0.0;
    private String prevExpType_ = "NEUTRAL";
    private double prevExpLevel_ = 0.0;
    private DecimalFormat formatter_;
    public static final String COPYRIGHT = "(c)2003-2006 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)\n";

    public BehaviorManager() {
        this.ambuf_ = new AMBuffer(Util.getSystemDefaultCharset());
        this.pattern1_ = Pattern.compile("^From @(\\S+) (\\S+) (\\S+) = (.*)$");
        this.pattern2_ = Pattern.compile("^(\\S+) (\\S+)$");
        this.pattern3_ = Pattern.compile("^(\\S+) (\\S+) (\\S+)$");
        this.pattern4_ = Pattern.compile("^(\\S+) (\\S+) = (.*)$");
        this.random_ = new Random();
        this.formatter_ = new DecimalFormat("0.000");
        this.agents_ = new HashArray();
        this.currAgent_ = Property.getAsStr("Behavior.DefaultAgent", "woman01");
        int nagent = Property.getAsInt("Behavior.NumAgent", 3);
        int i = 0;
        while (i < nagent) {
            String key = "Behavior.Agent." + (i + 1);
            String str = Property.getAsStr(key, "woman01 woman01 female01 bg01 1.0");
            ArrayList v = Util.makeTokenizedList(str, " ");
            double d = Double.parseDouble((String)v.get(4));
            this.agents_.put((String)v.get(0), new Agent((String)v.get(1), (String)v.get(2), (String)v.get(3), d));
            ++i;
        }
    }

    private String _format(double d) {
        return this.formatter_.format(d);
    }

    private void _send(String str) {
        this.ambuf_.send(str);
    }

    private void _sleep(int millisec) {
        try {
            Thread.sleep(millisec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Agent _getCurrAgent() {
        return (Agent)this.agents_.get(this.currAgent_);
    }

    private Agent _getAgentByName(String name) {
        return (Agent)this.agents_.get(name);
    }

    private void _outputEventValue() {
        Agent agent = this._getCurrAgent();
        Vector3D e = agent.getEyeRot();
        this._send("to @GEV set Ex = " + this._format(e.x));
        this._send("to @GEV set Ey = " + this._format(e.y));
        Vector3D h = agent.getHeadRot();
        this._send("to @GEV set Hx = " + this._format(h.x));
        this._send("to @GEV set Hy = " + this._format(h.y));
        this._send("to @GEV set Hz = " + this._format(h.z));
    }

    private void _outputFaceExp() {
        Agent agent = this._getCurrAgent();
        boolean maskChanged = true;
        if (agent == this.prevAgent_) {
            maskChanged = false;
        }
        Vector3D e = agent.getEyeRot();
        if (maskChanged || !e.equals(this.prevEyeRot_)) {
            this._send("to @FSM set EyeRot = " + this._format(e.x) + " " + this._format(e.y) + " " + this._format(e.z));
        }
        Vector3D h = agent.getHeadRot();
        if (maskChanged || !h.equals(this.prevHeadRot_)) {
            this._send("to @FSM set HeadRotAbs.1 = " + this._format(h.x) + " " + this._format(h.y) + " " + this._format(h.z));
        }
        Vector3D b = agent.getBodyRot();
        if (maskChanged || !b.equals(this.prevBodyRot_)) {
            this._send("to @FSM set AgentRot = " + this._format(b.x) + " " + this._format(b.y) + " " + this._format(b.z));
        }
        Vector3D t = agent.getBodyTrans();
        if (maskChanged || !t.equals(this.prevBodyTrans_)) {
            this._send("to @FSM set AgentTrans = " + this._format(t.x) + " " + this._format(t.y));
        }
        double scale = agent.getBodyScale();
        if (maskChanged || Math.abs(scale - this.prevBodyScale_) > 0.01) {
            this._send("to @FSM set AgentScale = " + this._format(scale));
        }
        String exptype = agent.getExpType();
        double explevel = agent.getExpLevel();
        if (maskChanged || !exptype.equals(this.prevExpType_) || Math.abs(explevel - this.prevExpLevel_) > 3.0) {
            this._send("to @FSM set FaceExp = " + exptype + " 1 " + this._format(explevel) + " 0");
        }
        this.prevAgent_ = agent;
        this.prevEyeRot_.set(e);
        this.prevHeadRot_.set(h);
        this.prevBodyRot_.set(b);
        this.prevBodyTrans_.set(t);
        this.prevBodyScale_ = scale;
        this.prevExpType_ = exptype;
        this.prevExpLevel_ = explevel;
    }

    private void _setupCurrMask() {
        String bg = this._getCurrAgent().getBackground();
        String mask = this._getCurrAgent().getMask();
        this._send("to @FSM set Background = " + bg);
        this._send("to @FSM set Mask = " + mask);
        this._outputFaceExp();
    }

    private void _handleRep(String module, String slot, String arg) {
        if (module.equals("FSM") && slot.equals("Run") && arg.equals("LIVE")) {
            this.isFsmAlive_ = true;
        }
    }

    private void _sendFadeOut() {
        this._send("to @FSM set AgentEnable = DISABLE");
    }

    private void _sendFadeIn() {
        this._send("to @FSM set AgentEnable = ENABLE");
    }

    private void _handleSet(String module, String slot, String arg) {
        if (slot.equals("AutoMove")) {
            boolean bl = this.useAutoMove_ = Integer.parseInt(arg) != 0;
            if (this.useAutoMove_) {
                this._setupCurrMask();
            }
        } else if (slot.equals("AgentSpeakState")) {
            this._getCurrAgent().setAgentSpeakState(Integer.parseInt(arg));
        } else if (slot.equals("Emotion")) {
            Matcher matcher2 = this.pattern2_.matcher(arg);
            if (matcher2.matches()) {
                String type = matcher2.group(1);
                double level = Double.parseDouble(matcher2.group(2));
                this._getCurrAgent().setEmotionTarget(type, level);
            } else {
                this._getCurrAgent().setEmotionTarget(arg);
            }
        } else if (slot.equals("EmotionNow")) {
            Matcher matcher2 = this.pattern2_.matcher(arg);
            if (matcher2.matches()) {
                String type = matcher2.group(1);
                double level = Double.parseDouble(matcher2.group(2));
                this._getCurrAgent().setEmotionNow(type, level);
            } else {
                this._getCurrAgent().setEmotionNow(arg);
            }
        } else if (slot.equals("Rot")) {
            Matcher matcher3 = this.pattern3_.matcher(arg);
            if (matcher3.matches()) {
                double tx = Double.parseDouble(matcher3.group(1));
                double ty = Double.parseDouble(matcher3.group(2));
                double tz = Double.parseDouble(matcher3.group(3));
                this._getCurrAgent().setRotTarget(tx, ty, tz);
            }
        } else if (slot.equals("RotNow")) {
            Matcher matcher3 = this.pattern3_.matcher(arg);
            if (matcher3.matches()) {
                double tx = Double.parseDouble(matcher3.group(1));
                double ty = Double.parseDouble(matcher3.group(2));
                double tz = Double.parseDouble(matcher3.group(3));
                this._getCurrAgent().setRotNow(tx, ty, tz);
            }
        } else if (slot.equals("Background")) {
            Matcher matcher2 = this.pattern2_.matcher(arg);
            if (matcher2.matches()) {
                Agent ag = this._getAgentByName(matcher2.group(1));
                ag.setBackground(matcher2.group(2));
            }
        } else if (slot.equals("HeadMoveRatio")) {
            Matcher matcher2 = this.pattern2_.matcher(arg);
            if (matcher2.matches()) {
                double d1 = Double.parseDouble(matcher2.group(1));
                double d2 = Double.parseDouble(matcher2.group(2));
                this._getCurrAgent().setHeadMove(d1, d2);
            }
        } else if (slot.equals("Mask")) {
            if (arg.equals("DISABLE")) {
                this._sendFadeOut();
            } else {
                if (!arg.equals(this.currAgent_)) {
                    this._sendFadeOut();
                }
                this.currAgent_ = arg;
                this._setupCurrMask();
                this._sendFadeIn();
            }
        } else if (slot.equals("FaceMot")) {
            this._send("to @FSM set FaceMot = " + arg);
        } else if (slot.equals("Action")) {
            if (arg.equals("Thinking")) {
                this._getCurrAgent().setRotTarget(0.3, 0.0, 0.0);
                int v = this.random_.nextInt(8);
                switch (v) {
                    case 0: {
                        this._getCurrAgent().setEyeRotNow(-5.0, 0.0, 0.0);
                        break;
                    }
                    case 1: {
                        this._getCurrAgent().setEyeRotNow(5.0, 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        this._getCurrAgent().setEyeRotNow(0.0, -7.0, 0.0);
                        break;
                    }
                    case 3: {
                        this._getCurrAgent().setEyeRotNow(0.0, 7.0, 0.0);
                        break;
                    }
                    case 4: {
                        this._getCurrAgent().setEyeRotNow(-4.0, -4.0, 0.0);
                        break;
                    }
                    case 5: {
                        this._getCurrAgent().setEyeRotNow(-4.0, 4.0, 0.0);
                        break;
                    }
                    case 6: {
                        this._getCurrAgent().setEyeRotNow(4.0, -4.0, 0.0);
                        break;
                    }
                    case 7: {
                        this._getCurrAgent().setEyeRotNow(4.0, 4.0, 0.0);
                    }
                }
            } else if (arg.equals("InfoRequest")) {
                this._getCurrAgent().setRotTarget(0.0, 0.0, 0.0);
            } else if (arg.equals("Speaking")) {
                this._getCurrAgent().setRotTarget(-0.5, 0.0, 0.0);
            } else if (arg.equals("Busy")) {
                this._getCurrAgent().setRotTarget(5.0, 3.0, 0.0);
            } else if (arg.equals("Blink")) {
                this._send("to @FSM set FaceMot = BLINK 2");
            }
        } else if (slot.equals("Nod")) {
            double d = Double.parseDouble(arg);
            this._getCurrAgent().startNodding(d);
        } else if (slot.equals("Refuse")) {
            double d = Double.parseDouble(arg);
            this._getCurrAgent().startRefuse(d);
        } else if (slot.equals("Tilt")) {
            double d = Double.parseDouble(arg);
            this._getCurrAgent().setHeadRotTarget(0.0, 0.0, d);
        }
    }

    private void _iteration() {
        long currentTime;
        long delta;
        String str = this.ambuf_.receive();
        if (str.length() > 0) {
            Matcher matcher4;
            Matcher matcher1 = this.pattern1_.matcher(str);
            if (matcher1.matches()) {
                String module = matcher1.group(1);
                String cmd = matcher1.group(2);
                String slot = matcher1.group(3);
                String arg = matcher1.group(4);
                if (cmd.equals("set")) {
                    this._handleSet(module, slot, arg);
                } else if (cmd.equals("rep")) {
                    this._handleRep(module, slot, arg);
                }
            }
            if ((matcher4 = this.pattern4_.matcher(str)).matches()) {
                String module = "___";
                String cmd = matcher4.group(1);
                String slot = matcher4.group(2);
                String arg = matcher4.group(3);
                if (cmd.equals("set")) {
                    this._handleSet(module, slot, arg);
                }
            }
        }
        if (this.useAutoMove_ && (delta = (currentTime = System.currentTimeMillis()) - this.prevTime_) >= 100L) {
            this._getCurrAgent().calc();
            this._outputFaceExp();
            if (this.eventViewerMode_) {
                this._outputEventValue();
            }
            this._getCurrAgent().addClock((double)delta / 1000.0);
            this.prevTime_ = currentTime;
        }
    }

    public void run() {
        this.prevTime_ = System.currentTimeMillis();
        this._send("rep Status.power = ON");
        while (true) {
            this._iteration();
            if (this.isFsmAlive_ || this.debugMode_) {
                this._sleep(1);
                continue;
            }
            this._send("to @FSM inq Run");
            this._sleep(100);
        }
    }

    public static void showVersion() {
        System.err.println("BehaviorManager");
        System.err.println("Galatea Dialog Manager 2.1.1 (070114)");
        System.err.print(COPYRIGHT);
        System.err.println();
    }

    public static void showUsage() {
    }

    public static void main(String[] argv) {
        int c;
        String conf = "gdm.conf";
        Getopt g = new Getopt("", argv, "a:c:dev");
        g.setOpterr(false);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 97: {
                    break;
                }
                case 99: {
                    conf = g.getOptarg();
                    break;
                }
                case 100: {
                    break;
                }
                case 101: {
                    break;
                }
                case 118: {
                    BehaviorManager.showVersion();
                }
            }
        }
        File conffile = new File(conf);
        if (conffile.canRead()) {
            try {
                Properties props = new Properties(System.getProperties());
                props.load(new FileInputStream(conffile));
                System.setProperties(props);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        BehaviorManager behaviorManager = new BehaviorManager();
        behaviorManager.run();
    }
}

