/*
 * Decompiled with CFR 0.152.
 */
package galatea.dialog;

import galatea.dialog.IC;
import galatea.dialog.IControllerModeManager;
import galatea.dialog.IInteractionController;
import galatea.dialog.RuntimeError;
import galatea.document.DocError;
import galatea.document.DocLoader;
import galatea.document.StateMap;
import galatea.util.Getopt;
import galatea.util.Logger;
import galatea.util.Messages;
import galatea.util.Property;
import galatea.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import org.xml.sax.SAXParseException;

public class DialogManager {
    private static final String propertiesPath = "/res/config/dialog.properties";
    private static final String messagesPath = "res.messages.messages";
    private Logger dbg = new Logger("DM");
    private IC theIC_;
    private IInteractionController interactionController_;
    private IControllerModeManager modeManager_;
    private String filename;
    static /* synthetic */ Class class$0;

    public static String getResourceAsString(String res) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("galatea.dialog.DialogManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream is = clazz.getResourceAsStream(res);
        String str = Util.readInputStream(is, Charset.forName("UTF-8"));
        return str;
    }

    public static void main(String[] argv) {
        DialogManager dm = new DialogManager();
        dm._setup(argv);
        dm._waitDevicesForReady();
        dm._execute();
        Util.halt("Galatea Dialog Manager terminated.");
    }

    private void _setup(String[] argv) {
        int c;
        Messages.setup(messagesPath);
        String conf = "gdm.conf";
        boolean isPrintOnly = false;
        Getopt g = new Getopt("", argv, "c:vp");
        g.setOpterr(false);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    conf = g.getOptarg();
                    break;
                }
                case 118: {
                    this.showVersion();
                    this.showUsage();
                    System.exit(1);
                    break;
                }
                case 112: {
                    isPrintOnly = true;
                }
            }
        }
        Properties props = new Properties(System.getProperties());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("galatea.dialog.DialogManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream is = clazz.getResourceAsStream(propertiesPath);
        try {
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        File conffile = new File(conf);
        if (conffile.canRead()) {
            try {
                props.load(new FileInputStream(conffile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.setProperties(props);
        if (isPrintOnly) {
            System.out.print(DocLoader.convert(argv[g.getOptind()]));
            System.exit(0);
        }
        if (Property.getAsBoolean("ShowVersion", true)) {
            this.showVersion();
        }
        if (argv.length - g.getOptind() != 1) {
            this.filename = null;
        } else {
            this.filename = argv[g.getOptind()];
            if (Util.isWindows()) {
                this.filename = this.filename.replaceAll("\\\\", "/");
            }
        }
        this.theIC_ = new IC();
        this.theIC_.start();
        this.interactionController_ = this.theIC_;
        this.modeManager_ = this.theIC_;
    }

    public void showVersion() {
        System.err.println("Galatea Dialog Manager 2.1.1 (070114)");
        System.err.print("(c)2003-2007 Takuya NISHIMOTO (nishimoto@m.ieice.org)\nUses Mozilla Rhino from mozilla.org.\nSee http://www.mozilla.org/rhino/.\n");
        System.err.println();
    }

    public void showUsage() {
        System.err.println("Usage:\tgalatea [options] [document.vxml]");
        System.err.println("\t -c file : config file");
        System.err.println("\t -v      : show version");
        System.err.println("\t -p      : print translation results");
        System.err.println();
    }

    private void _waitDevicesForReady() {
        this.interactionController_.waitDevicesForReady();
    }

    private void _execute() {
        while (true) {
            try {
                if (this.filename != null && this.filename.length() > 0) {
                    this.dbg.print("filename:" + this.filename);
                    this.modeManager_.setStatelessMode(false);
                    String path = Util.getUriWithoutFragment(this.filename);
                    String dialog = Util.getUriFragment(this.filename);
                    DocLoader loader = new DocLoader(this.filename, path, dialog);
                    StateMap stateMap = loader.getStateMap();
                    if (stateMap == null) {
                        throw new DocError("Document not found: " + this.filename);
                    }
                    this.interactionController_.setStateMap(stateMap);
                    String state = "[Load] " + this.filename;
                    String src = loader.getSrcAsString();
                    String trans = String.valueOf(loader.getWarnings()) + "\n" + loader.getTranslatedAsString();
                    this.interactionController_.dispDocInfo(this.filename, state, src, trans);
                } else {
                    this.dbg.print("StatelessMode=true");
                    this.interactionController_.dispDocInfo("", "(stateless)", "", "");
                    this.modeManager_.setStatelessMode(true);
                }
                this.interactionController_.mainLoop();
                this.filename = this.interactionController_.getNextDocFile();
                this.interactionController_.resetNextDocFile();
                continue;
            }
            catch (RuntimeError e) {
                System.err.println(e);
                this.modeManager_.setStatelessMode(true);
                this.modeManager_.setPauseMode(true);
                this.interactionController_.dispDocInfo("", "(stateless)", "", "");
                this.interactionController_.resetNextDocFile();
                continue;
            }
            catch (DocError e) {
                System.err.println(e);
                this.modeManager_.setStatelessMode(true);
                this.modeManager_.setPauseMode(true);
                this.interactionController_.dispDocInfo("", "(stateless)", "", "");
                this.interactionController_.resetNextDocFile();
                continue;
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
                this.modeManager_.setStatelessMode(true);
                this.modeManager_.setPauseMode(true);
                this.interactionController_.dispDocInfo("", "(stateless)", "", "");
                this.interactionController_.resetNextDocFile();
                this.filename = "";
                continue;
            }
            catch (SAXParseException e) {
                e.printStackTrace();
                this.interactionController_.resetNextDocFile();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.interactionController_.resetNextDocFile();
                continue;
            }
            break;
        }
    }
}

