/*
 * Decompiled with CFR 0.152.
 */
package galatea.document;

import galatea.command.AddOutItemCommand;
import galatea.command.Command;
import galatea.command.CompositeCommand;
import galatea.command.EndCommand;
import galatea.command.EvaluateCommand;
import galatea.command.GotoCommand;
import galatea.command.SetNextCommand;
import galatea.command.StopOutputCommand;
import galatea.document.ContentState;
import galatea.document.DocError;
import galatea.document.DocUtil;
import galatea.document.DocWarning;
import galatea.document.IAbstractDoc;
import galatea.document.StateMap;
import galatea.grammar.GrammarUtil;
import galatea.outitem.AudioOutItem;
import galatea.outitem.BreakOutItem;
import galatea.outitem.GrammarOutItem;
import galatea.outitem.LogOutItem;
import galatea.outitem.NativeOutItem;
import galatea.outitem.VoiceOutItem;
import galatea.relaxer.vxml20.IVxmlFormChoice;
import galatea.relaxer.vxml20.IVxmlVxmlChoice;
import galatea.relaxer.vxml20.RString;
import galatea.relaxer.vxml20.RVisitorBase;
import galatea.relaxer.vxml20.URVisitor;
import galatea.relaxer.vxml20.VxmlAllOf;
import galatea.relaxer.vxml20.VxmlAssign;
import galatea.relaxer.vxml20.VxmlAudio;
import galatea.relaxer.vxml20.VxmlBlock;
import galatea.relaxer.vxml20.VxmlBreak;
import galatea.relaxer.vxml20.VxmlCONTEXT;
import galatea.relaxer.vxml20.VxmlCatch;
import galatea.relaxer.vxml20.VxmlChoice;
import galatea.relaxer.vxml20.VxmlClear;
import galatea.relaxer.vxml20.VxmlDisconnect;
import galatea.relaxer.vxml20.VxmlEMPH;
import galatea.relaxer.vxml20.VxmlElse;
import galatea.relaxer.vxml20.VxmlElseif;
import galatea.relaxer.vxml20.VxmlEmotion;
import galatea.relaxer.vxml20.VxmlEmphasis;
import galatea.relaxer.vxml20.VxmlEnumerate;
import galatea.relaxer.vxml20.VxmlError;
import galatea.relaxer.vxml20.VxmlExit;
import galatea.relaxer.vxml20.VxmlField;
import galatea.relaxer.vxml20.VxmlFilled;
import galatea.relaxer.vxml20.VxmlForm;
import galatea.relaxer.vxml20.VxmlGoto;
import galatea.relaxer.vxml20.VxmlGrammar;
import galatea.relaxer.vxml20.VxmlHelp;
import galatea.relaxer.vxml20.VxmlIf;
import galatea.relaxer.vxml20.VxmlInitial;
import galatea.relaxer.vxml20.VxmlJVOICE;
import galatea.relaxer.vxml20.VxmlLink;
import galatea.relaxer.vxml20.VxmlLog;
import galatea.relaxer.vxml20.VxmlMark;
import galatea.relaxer.vxml20.VxmlMedia;
import galatea.relaxer.vxml20.VxmlMenu;
import galatea.relaxer.vxml20.VxmlMeta;
import galatea.relaxer.vxml20.VxmlNative;
import galatea.relaxer.vxml20.VxmlNoinput;
import galatea.relaxer.vxml20.VxmlNomatch;
import galatea.relaxer.vxml20.VxmlObject;
import galatea.relaxer.vxml20.VxmlP;
import galatea.relaxer.vxml20.VxmlPITCH;
import galatea.relaxer.vxml20.VxmlPRON;
import galatea.relaxer.vxml20.VxmlParagraph;
import galatea.relaxer.vxml20.VxmlParam;
import galatea.relaxer.vxml20.VxmlPhoneme;
import galatea.relaxer.vxml20.VxmlPrompt;
import galatea.relaxer.vxml20.VxmlProperty;
import galatea.relaxer.vxml20.VxmlProsody;
import galatea.relaxer.vxml20.VxmlRATE;
import galatea.relaxer.vxml20.VxmlRecord;
import galatea.relaxer.vxml20.VxmlReprompt;
import galatea.relaxer.vxml20.VxmlReturn;
import galatea.relaxer.vxml20.VxmlS;
import galatea.relaxer.vxml20.VxmlSILENCE;
import galatea.relaxer.vxml20.VxmlSPELL;
import galatea.relaxer.vxml20.VxmlSayAs;
import galatea.relaxer.vxml20.VxmlScript;
import galatea.relaxer.vxml20.VxmlSentence;
import galatea.relaxer.vxml20.VxmlSubmit;
import galatea.relaxer.vxml20.VxmlThrow;
import galatea.relaxer.vxml20.VxmlTransfer;
import galatea.relaxer.vxml20.VxmlVOLUME;
import galatea.relaxer.vxml20.VxmlValue;
import galatea.relaxer.vxml20.VxmlVar;
import galatea.relaxer.vxml20.VxmlVoice;
import galatea.relaxer.vxml20.VxmlVxml;
import galatea.util.HashArray;
import galatea.util.Logger;
import galatea.util.NetUtil;
import galatea.util.Property;
import galatea.util.Util;
import java.util.ArrayList;
import java.util.Stack;
import org.w3c.dom.Element;

public class VXMLDoc
implements IAbstractDoc {
    private static final String VXML_START_NAME = "@vxml_start";
    private Logger dbg = new Logger("VXMLDoc");
    private String docAddress_ = null;
    private StateMap stateMap_ = null;
    private ArrayList docErrors_ = null;
    private ArrayList docWarnings_ = null;
    private double promptTimeout_ = Property.getAsDouble("VXMLDoc.PromptTimeout", 10.0);
    private int unique_ = 0;

    private String _getEvalWith(String s, String w) {
        if (s == null) {
            return "true";
        }
        if (w.length() > 0) {
            StringBuffer script = new StringBuffer("with(");
            script.append(w);
            script.append("){");
            script.append(s);
            script.append("}");
            return script.toString();
        }
        return s;
    }

    private String _getUniqueId(String str) {
        ++this.unique_;
        return "vxml_" + str + this.unique_;
    }

    private String resolveAdrs(String org) {
        return Util.resolveAdrs(this.docAddress_, org);
    }

    private void _addAppInitStates(VxmlVxml vxmlVxml, StateMap stateMap, String dialog) throws Exception {
        String firstID;
        String app = vxmlVxml.getApplication();
        String appInitScript = "document = {};dialog = {};";
        if (app == null) {
            appInitScript = String.valueOf(appInitScript) + "session={telephone:{ani:\"0\"}};application={lastresult$:{}};";
        } else {
            appInitScript = String.valueOf(appInitScript) + "var $root='" + this.docAddress_ + "';" + "if ($current_root==undefined) {" + "  var $current_root;" + "}" + "if ($current_root!=$root) {" + "  $current_root=$root;" + "  session={};" + "  application={};" + "  application.lastresult$={};";
            String applicationRoot = this.resolveAdrs(app);
            this.dbg.print("rootVxml:" + applicationRoot);
            VxmlVxml rootVxml = new VxmlVxml(applicationRoot);
            this.dbg.print("Parsing applicationRoot...", 2);
            int nContent = rootVxml.sizeContent();
            int i = 0;
            while (i < nContent) {
                IVxmlVxmlChoice choice = rootVxml.getContent(i);
                if (choice instanceof VxmlVar) {
                    VxmlVar var = (VxmlVar)choice;
                    String name = var.getName();
                    String expr = var.getExpr();
                    String command = "application." + name + "=" + expr + ";";
                    appInitScript = String.valueOf(appInitScript) + command;
                } else if (choice instanceof VxmlLink) {
                    VxmlLink link = (VxmlLink)choice;
                    String n = link.getNext();
                    String next = Util.resolveAdrs(applicationRoot, n);
                    this.dbg.print("link next=" + next);
                }
                ++i;
            }
            appInitScript = String.valueOf(appInitScript) + "}";
        }
        ContentState appInitState = new ContentState();
        String docName = VXML_START_NAME;
        appInitState.setName(docName);
        if (appInitScript.length() > 0) {
            appInitState.addCommand(new EvaluateCommand(appInitScript));
        }
        if (((firstID = dialog) == null || firstID.equals("")) && (firstID = DocUtil.getFirstDialogID(vxmlVxml)) == null) {
            throw new DocError("VXML leaf document " + this.docAddress_ + " has no menu or form.");
        }
        stateMap.add(appInitState);
        stateMap.setFirstStateName(docName);
        stateMap.addSetNextCommand(docName, "@" + firstID);
        String script = "$prompt_timeout = " + Double.toString(this.promptTimeout_ * 1000.0);
        stateMap.addCommand(docName, new EvaluateCommand(script));
        stateMap.addCommand(docName, new EvaluateCommand("$restart_document='" + this.docAddress_ + "';"));
    }

    public VXMLDoc(Element e, String adrs, String dialog) throws Exception {
        this.docErrors_ = new ArrayList();
        this.docWarnings_ = new ArrayList();
        if (!VxmlVxml.isMatch(e)) {
            throw new DocError("Not a valid <vxml> document: " + adrs + "#" + dialog);
        }
        this.docAddress_ = String.valueOf(adrs) + "#" + dialog;
        this.stateMap_ = new StateMap();
        VxmlVxml vxmlVxml = new VxmlVxml(e);
        this._addAppInitStates(vxmlVxml, this.stateMap_, dialog);
        Visitor visitor = new Visitor();
        URVisitor.traverse(vxmlVxml, visitor);
        if (this.docErrors_.size() > 0) {
            String err = "";
            int i = 0;
            while (i < this.docErrors_.size()) {
                err = String.valueOf(err) + this.docErrors_.get(i).toString() + "\n";
                ++i;
            }
            throw new DocError("Leaf document has following error(s):\n" + err);
        }
    }

    public StateMap getStateMap() {
        return this.stateMap_;
    }

    public String getDocWarnings() {
        String w = "";
        int i = 0;
        int n = this.docWarnings_.size();
        while (i < n) {
            w = String.valueOf(w) + this.docWarnings_.get(i) + "\n";
            ++i;
        }
        return w;
    }

    protected class Visitor
    extends RVisitorBase {
        private Dialog dialog_ = new Dialog();
        private HashArray formItems_ = null;
        private String formVarInitScript_ = null;
        private Stack visitorStack_ = new Stack();
        private ArrayList promptList_ = null;
        Commands commands_ = new Commands();
        ExecContents execContents_ = new ExecContents();
        TextBuf textBuf_ = new TextBuf();
        private HashArray submitItems_;
        private String documentBargeinProperty_ = null;
        private String dialogBargeinProperty_ = null;
        private String currPromptCond_ = null;
        private String currPromptCount_ = null;
        private boolean currPromptBargein_ = true;
        private String currIfCond_ = null;
        private boolean isParallel_ = false;
        private int mediaCount_ = 0;
        private String leaveProsodyTag_ = null;

        protected Visitor() {
        }

        public boolean enter(VxmlVxml v) {
            this._resetDocumentProperty();
            this.visitorStack_.push(v);
            return true;
        }

        public void leave(VxmlVxml v) {
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlGrammar gram) {
            String type = gram.getType();
            String cmd1 = "";
            String cmd2 = "";
            if (type != null && type.equals("application/julian")) {
                cmd1 = "'to @SRM set Grammar = " + gram.getSrc() + ".dfa'";
                cmd2 = "'to @SRM set Dic = " + gram.getSrc() + ".dict'";
            } else {
                String root = gram.getRoot();
                String id = "";
                if (root != null && root.startsWith("#")) {
                    if (this.visitorStack_.peek() instanceof VxmlForm) {
                        id = String.valueOf(this.dialog_.getName()) + "_" + root.replaceAll("#", "");
                    } else if (this.visitorStack_.peek() instanceof VxmlField) {
                        id = String.valueOf(this.dialog_.getName()) + "_" + this.dialog_.getItemName() + "_" + root.replaceAll("#", "");
                    }
                } else {
                    id = VXMLDoc.this._getUniqueId("rule");
                }
                String g = GrammarUtil.getJulianXmlGrammar(gram, VXMLDoc.this.docAddress_);
                GrammarOutItem o1 = new GrammarOutItem(g, id);
                AddOutItemCommand c1 = new AddOutItemCommand(o1);
                VXMLDoc.this.stateMap_.addCommand(VXMLDoc.VXML_START_NAME, c1);
                cmd1 = "'to @SRM set Grammar = " + o1.getLocation() + ".dfa'";
                cmd2 = "'to @SRM set Dic = " + o1.getLocation() + ".dict'";
            }
            String state = "";
            if (this.visitorStack_.peek() instanceof VxmlForm) {
                state = "@" + this.dialog_.getName();
            } else if (this.visitorStack_.peek() instanceof VxmlField) {
                state = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            }
            NativeOutItem o2 = new NativeOutItem(cmd1);
            AddOutItemCommand c2 = new AddOutItemCommand(o2);
            NativeOutItem o3 = new NativeOutItem(cmd2);
            AddOutItemCommand c3 = new AddOutItemCommand(o3);
            VXMLDoc.this.stateMap_.addCommand(state, c2);
            VXMLDoc.this.stateMap_.addCommand(state, c3);
            return true;
        }

        private String _makeFormState() {
            Object fi;
            String form = "@" + this.dialog_.getName();
            String t = VXMLDoc.this.stateMap_.newState(form);
            VXMLDoc.this.dbg.ASSERT(t.equals(form), "VxmlForm#leave");
            String dname = this.dialog_.getName();
            String sc = String.valueOf(dname) + "={next$:undefined, nextitem$:undefined}; ";
            sc = String.valueOf(sc) + this.formVarInitScript_;
            int i = 0;
            int n = this.formItems_.size();
            while (i < n) {
                String name = this.formItems_.getKey(i);
                fi = this.formItems_.get(i);
                String fname = String.valueOf(this.dialog_.getName()) + "." + name;
                String guardcond = "false";
                String shadow = String.valueOf(fname) + "$";
                if (fi instanceof VxmlField) {
                    VxmlField field = (VxmlField)fi;
                    sc = field.getExpr() != null ? String.valueOf(sc) + fname + " = " + field.getExpr() + "; " : String.valueOf(sc) + fname + " = undefined; ";
                    if (field.getCond() != null) {
                        guardcond = field.getCond();
                    }
                    sc = String.valueOf(sc) + shadow + "={" + "guardcond:" + guardcond + ", " + "justfilled:false, " + "promptcount:1, " + "promptcond:true}; ";
                } else if (fi instanceof VxmlBlock) {
                    VxmlBlock block = (VxmlBlock)fi;
                    if (block.getCond() != null) {
                        guardcond = block.getCond();
                    }
                    sc = String.valueOf(sc) + shadow + "={guardcond:" + guardcond + "}; ";
                } else if (fi instanceof VxmlInitial) {
                    VxmlInitial initial = (VxmlInitial)fi;
                    if (initial.getCond() != null) {
                        guardcond = initial.getCond();
                    }
                    sc = String.valueOf(sc) + shadow + "={guardcond:" + guardcond + "}; ";
                }
                ++i;
            }
            VXMLDoc.this.stateMap_.addScriptCommand(form, sc);
            ArrayList<NativeOutItem> items = new ArrayList<NativeOutItem>();
            String s = "'to @SIM set DialogName = " + this.dialog_.getName() + "'";
            items.add(new NativeOutItem(s));
            s = "'to @SIM set SlotAlias = RESET'";
            items.add(new NativeOutItem(s));
            int i2 = 0;
            while (i2 < this.formItems_.size()) {
                VxmlField f;
                fi = this.formItems_.get(i2);
                if (fi instanceof VxmlField && (f = (VxmlField)fi).getSlot() != null) {
                    String name = this.formItems_.getKey(i2);
                    s = "'to @SIM set SlotAlias = " + f.getSlot() + " " + name + "'";
                    items.add(new NativeOutItem(s));
                }
                ++i2;
            }
            VXMLDoc.this.stateMap_.addCommand(form, new AddOutItemCommand(items));
            return form;
        }

        private String _makeFormSelectState() {
            String name;
            String select = "@" + this.dialog_.getName() + ".vxml_select";
            String t = VXMLDoc.this.stateMap_.newState(select);
            VXMLDoc.this.dbg.ASSERT(t.equals(select), "VxmlForm#leave");
            String sc = "";
            int i = 0;
            while (i < this.formItems_.size()) {
                name = this.formItems_.getKey(i);
                if (i > 0) {
                    sc = String.valueOf(sc) + "} else ";
                }
                String dname = this.dialog_.getName();
                String fname = String.valueOf(dname) + "." + name;
                String sname = String.valueOf(fname) + "$";
                sc = String.valueOf(sc) + "if (" + sname + ".guardcond==false && " + fname + "==undefined) {";
                sc = String.valueOf(sc) + dname + ".next$ = '@" + fname + "';";
                ++i;
            }
            sc = String.valueOf(sc) + "}";
            VXMLDoc.this.stateMap_.addCommand(select, new EvaluateCommand(sc));
            VXMLDoc.this.stateMap_.addCommand(select, new StopOutputCommand());
            i = 0;
            while (i < this.formItems_.size()) {
                name = this.formItems_.getKey(i);
                Object fi = this.formItems_.get(i);
                if (fi instanceof VxmlField) {
                    sc = String.valueOf(this.dialog_.getName()) + "." + name + "$.justfilled=false;";
                    VXMLDoc.this.stateMap_.addCommand(select, new EvaluateCommand(sc));
                }
                ++i;
            }
            sc = String.valueOf(this.dialog_.getName()) + ".next$";
            VXMLDoc.this.stateMap_.addCommand(select, new SetNextCommand(sc));
            return select;
        }

        private String _makeFormFilledState() {
            String filled = "@" + this.dialog_.getName() + ".vxml_process";
            String t = VXMLDoc.this.stateMap_.newState(filled);
            VXMLDoc.this.dbg.ASSERT(t.equals(filled), "VxmlForm#leave");
            return filled;
        }

        private void _setupSubmitItems(VxmlForm vxmlForm) {
            this.submitItems_ = new HashArray();
            int i = 0;
            while (i < vxmlForm.sizeContent()) {
                IVxmlFormChoice c = vxmlForm.getContent(i);
                if (c instanceof VxmlVar) {
                    this.submitItems_.put(((VxmlVar)c).getName(), c);
                } else if (c instanceof VxmlField) {
                    this.submitItems_.put(((VxmlField)c).getName(), c);
                }
                ++i;
            }
        }

        public boolean enter(VxmlForm vxmlForm) {
            String dialogId = vxmlForm.getId();
            if (dialogId == null) {
                dialogId = "";
            }
            this.dialog_.setName(dialogId);
            this.formItems_ = new HashArray();
            this.formVarInitScript_ = "";
            this._setupSubmitItems(vxmlForm);
            this._resetDialogProperty();
            this.visitorStack_.push(vxmlForm);
            return true;
        }

        public void leave(VxmlForm o) {
            String form = this._makeFormState();
            String select = this._makeFormSelectState();
            String filled = this._makeFormFilledState();
            VXMLDoc.this.stateMap_.addSetNextCommand(form, select);
            VXMLDoc.this.stateMap_.addSetNextCommand(filled, select);
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlBlock vxmlBlock) {
            if (vxmlBlock.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId("block"));
            } else {
                this.dialog_.setItemName(vxmlBlock.getName());
            }
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String t = VXMLDoc.this.stateMap_.newState(s);
            VXMLDoc.this.dbg.ASSERT(t.equals(s), "VxmlBlock#enter");
            VXMLDoc.this.stateMap_.addCommand(s, new EvaluateCommand(String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "=true;"));
            this.visitorStack_.push(vxmlBlock);
            this.formItems_.put(this.dialog_.getItemName(), vxmlBlock);
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlBlock vxmlBlock) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            this.commands_.flushCommands(s);
            VXMLDoc.this.stateMap_.addSetNextCommand(s, "@" + this.dialog_.getName() + ".vxml_select");
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlFilled e) {
            String cond = "true";
            VXMLDoc.this.dbg.print("VXMLDoc:enter#VxmlFilled peek:" + this.visitorStack_.peek());
            this.commands_.setupCommands();
            if (this.visitorStack_.peek() instanceof VxmlField) {
                String item = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName();
                cond = String.valueOf(item) + "$.justfilled";
                cond = String.valueOf(cond) + " && " + item + "!=undefined";
            } else {
                cond = "with(" + this.dialog_.getName() + "){";
                int i = 0;
                while (i < this.formItems_.size()) {
                    String name = this.formItems_.getKey(i);
                    if (i > 0) {
                        cond = String.valueOf(cond) + " && ";
                    }
                    cond = String.valueOf(cond) + name + "!=undefined";
                    ++i;
                }
                cond = String.valueOf(cond) + "}";
            }
            this.execContents_.setupExecContent(cond);
            this.textBuf_.setupSpeak();
            this.visitorStack_.push(e);
            return true;
        }

        public void leave(VxmlFilled e) {
            this.visitorStack_.pop();
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String filled = "@" + this.dialog_.getName() + ".vxml_process";
            this.commands_.flushCommands(filled);
        }

        private void _makeInputEventHandler(String field) {
            String select = "@" + this.dialog_.getName() + ".vxml_select";
            String noinput = VXMLDoc.this.stateMap_.newState(String.valueOf(field) + ".noinput");
            VXMLDoc.this.stateMap_.addSetNextCommand(field, noinput);
            VXMLDoc.this.stateMap_.addSetNextCommand(noinput, select);
            String formitem = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName();
            String filled = "@" + this.dialog_.getName() + ".vxml_process";
            String s = "@" + formitem + "." + VXMLDoc.this._getUniqueId("grammar");
            String newID = VXMLDoc.this.stateMap_.newState(s);
            VXMLDoc.this.stateMap_.addDefaultTrans("@" + formitem, newID);
            VXMLDoc.this.stateMap_.addCommand(newID, new EvaluateCommand(String.valueOf(formitem) + "$.utterance=$utterance;"));
            VXMLDoc.this.stateMap_.addSetNextCommand(newID, filled);
        }

        public boolean enter(VxmlField vxmlField) {
            String fieldType;
            if (vxmlField.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId("field"));
            } else {
                if (this.formItems_.has(vxmlField.getName())) {
                    VXMLDoc.this.docErrors_.add(new DocError("Field name dupulication."));
                    return false;
                }
                this.dialog_.setItemName(vxmlField.getName());
            }
            this.formItems_.put(this.dialog_.getItemName(), vxmlField);
            VXMLDoc.this.dbg.ASSERT(this.dialog_.getItemName() != null, "vxmlForm#enter");
            String f = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String field = VXMLDoc.this.stateMap_.newState(f);
            if (vxmlField.getExpr() != null) {
                String script = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + " = " + vxmlField.getExpr() + ";";
                VXMLDoc.this.stateMap_.addScriptCommand(field, script);
            }
            if ((fieldType = vxmlField.getType()) != null && fieldType.startsWith("digits")) {
                String msg = "'to @KBD set FieldName = " + this.dialog_.getName() + "." + vxmlField.getName() + "'";
                VXMLDoc.this.stateMap_.addOutputNativeCommand(field, msg);
                msg = "'to @KBD set FieldType = " + vxmlField.getType() + "'";
                VXMLDoc.this.stateMap_.addOutputNativeCommand(field, msg);
            }
            this._makeInputEventHandler(field);
            this.promptList_ = new ArrayList();
            this.visitorStack_.push(vxmlField);
            return true;
        }

        private void _makePromptSelect() {
            int n;
            Prompt prompt;
            String field = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String promptCond = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$" + ".promptcond";
            CompositeCommand promptCmd = new CompositeCommand(new ArrayList(), promptCond);
            if (this.promptList_ == null) {
                return;
            }
            String sWith = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            String script = "";
            int i = 0;
            while (i < this.promptList_.size()) {
                prompt = (Prompt)this.promptList_.get(i);
                script = prompt.cond == null ? String.valueOf(script) + "p" + i + "=true;" : String.valueOf(script) + "p" + i + "=(" + prompt.cond + ");";
                ++i;
            }
            promptCmd.addScriptCommand(script, sWith);
            script = "cc=1;";
            i = 0;
            while (i < this.promptList_.size()) {
                prompt = (Prompt)this.promptList_.get(i);
                n = prompt.count;
                script = String.valueOf(script) + "if (" + n + "<=promptcount && cc<" + n + ") {cc=" + n + "};";
                ++i;
            }
            promptCmd.addScriptCommand(script, sWith);
            script = "";
            i = 0;
            while (i < this.promptList_.size()) {
                prompt = (Prompt)this.promptList_.get(i);
                n = prompt.count;
                script = String.valueOf(script) + "if (" + n + "!=cc){p" + i + "=false};";
                ++i;
            }
            promptCmd.addScriptCommand(script, sWith);
            script = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$" + ".promptcount++;";
            promptCmd.addScriptCommand(script);
            i = 0;
            while (i < this.promptList_.size()) {
                Command co;
                prompt = (Prompt)this.promptList_.get(i);
                String cond = "with (" + sWith + ") {p" + i + "}";
                if (prompt.commands.size() == 1 && prompt.commands.get(0) instanceof CompositeCommand) {
                    co = (Command)prompt.commands.get(0);
                    co.setCondition(cond);
                    promptCmd.addCommand(co);
                } else {
                    co = new CompositeCommand(prompt.commands, cond);
                    promptCmd.addCommand(co);
                }
                ++i;
            }
            VXMLDoc.this.stateMap_.addCommand(field, promptCmd);
            AddOutItemCommand c = new AddOutItemCommand(new BreakOutItem("$prompt_timeout", this.currPromptBargein_));
            VXMLDoc.this.stateMap_.addCommand(field, c);
        }

        public void leave(VxmlField vxmlField) {
            this.visitorStack_.pop();
            this._makePromptSelect();
        }

        public boolean enter(VxmlVar e) {
            if (e.getName() == null) {
                return false;
            }
            String aname = e.getName();
            String aexpr = "undefined";
            if (e.getExpr() != null) {
                aexpr = e.getExpr();
            }
            if (this.visitorStack_.peek() instanceof VxmlVxml) {
                String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, "document");
                this.formVarInitScript_ = String.valueOf(this.formVarInitScript_) + sc + ";";
            } else if (this.visitorStack_.peek() instanceof VxmlForm) {
                String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, this.dialog_.getName());
                this.formVarInitScript_ = String.valueOf(this.formVarInitScript_) + sc + ";";
            }
            return true;
        }

        public boolean enter(VxmlMenu vxmlMenu) {
            this.visitorStack_.push(vxmlMenu);
            this.promptList_ = new ArrayList();
            this._resetDialogProperty();
            String dialogName = vxmlMenu.getId() == null ? VXMLDoc.this._getUniqueId("menu") : vxmlMenu.getId();
            this.dialog_.setName(dialogName);
            String fieldName = "field";
            this.dialog_.setItemName(fieldName);
            String dialogState = "@" + dialogName;
            VXMLDoc.this.stateMap_.newState(dialogState);
            String selectState = String.valueOf(dialogState) + ".vxml_select";
            VXMLDoc.this.stateMap_.newState(selectState);
            String fieldState = String.valueOf(dialogState) + "." + fieldName;
            VXMLDoc.this.stateMap_.newState(fieldState);
            VXMLDoc.this.stateMap_.addSetNextCommand(dialogState, selectState);
            VXMLDoc.this.stateMap_.addSetNextCommand(selectState, fieldState);
            VXMLDoc.this.stateMap_.addScriptCommand(dialogState, String.valueOf(dialogName) + "={" + fieldName + "$:{promptcount:1,promptcond:true}};");
            GrammarOutItem o1 = new GrammarOutItem("g", dialogName);
            AddOutItemCommand c1 = new AddOutItemCommand(o1);
            VXMLDoc.this.stateMap_.addCommand(VXMLDoc.VXML_START_NAME, c1);
            return true;
        }

        public void leave(VxmlMenu menu) {
            this.visitorStack_.pop();
            this._makePromptSelect();
        }

        public boolean enter(VxmlChoice vxmlChoice) {
            this.visitorStack_.push(vxmlChoice);
            String next = null;
            String n = vxmlChoice.getNext();
            if (n == null) {
                VXMLDoc.this.docErrors_.add(new DocError("No next in choice."));
                return false;
            }
            next = Util.removeSpaces(n);
            String image = "";
            String im = vxmlChoice.getImage();
            if (im != null) {
                image = Util.removeSpaces(im);
                image = VXMLDoc.this.resolveAdrs(image);
                VXMLDoc.this.dbg.ASSERT(image != null, "VxmlChoice#enter");
            }
            String menuState = "@" + this.dialog_.getName() + "._menu_";
            int i = 0;
            while (i < vxmlChoice.sizeContent()) {
                String text = DocUtil.getText(vxmlChoice.getContent(i));
                VXMLDoc.this.dbg.ASSERT(text != null, "VxmlChoice#enter");
                if (text.length() > 0 && next.startsWith("#")) {
                    String nextState = "@" + next.substring(1);
                    VXMLDoc.this.stateMap_.addTrans(menuState, nextState, text);
                }
                ++i;
            }
            return true;
        }

        public void leave(VxmlChoice vxmlChoice) {
            this.visitorStack_.pop();
        }

        private void _resetDocumentProperty() {
            this.documentBargeinProperty_ = null;
        }

        private void _resetDialogProperty() {
            this.dialogBargeinProperty_ = null;
        }

        public boolean enter(VxmlPrompt vxmlPrompt) {
            if (vxmlPrompt.getBargein() != null) {
                this.currPromptBargein_ = Boolean.getBoolean(vxmlPrompt.getBargein());
            } else if (this.dialogBargeinProperty_ != null) {
                this.currPromptBargein_ = Boolean.getBoolean(this.dialogBargeinProperty_);
            } else if (this.documentBargeinProperty_ != null) {
                this.currPromptBargein_ = Boolean.getBoolean(this.documentBargeinProperty_);
            }
            if (this.visitorStack_.peek() instanceof VxmlMenu || this.visitorStack_.peek() instanceof VxmlField) {
                this.currPromptCond_ = vxmlPrompt.getCond();
                this.currPromptCount_ = vxmlPrompt.getCount();
                this.commands_.setCommands(new ArrayList());
                this.execContents_.setupExecContent();
            }
            if (vxmlPrompt.getTimeout() != null) {
                int msec = DocUtil.getCSS2TimesAsMsec(vxmlPrompt.getTimeout());
                String script = "$prompt_timeout=" + Integer.toString(msec);
                this.commands_.appendCommands(new EvaluateCommand(script));
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlPrompt vxmlPrompt) {
            this.textBuf_.flushSpeak();
            if (this.visitorStack_.peek() instanceof VxmlMenu || this.visitorStack_.peek() instanceof VxmlField) {
                this.execContents_.flushExecContent();
                Prompt prompt = new Prompt();
                prompt.cond = this.currPromptCond_ == null ? "true" : this.currPromptCond_;
                prompt.count = this.currPromptCount_ == null ? 1 : Integer.valueOf(this.currPromptCount_);
                prompt.commands = this.commands_.getCommands();
                this.commands_.clearCommands();
                this.promptList_.add(prompt);
            }
            this.currPromptBargein_ = true;
        }

        private void _enterNomatch() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("promptcond=false;", shadow));
        }

        public boolean enter(VxmlNomatch o) {
            this._enterNomatch();
            this.visitorStack_.push(o);
            return true;
        }

        private void _leaveNomatch() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String nomatch = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".nomatch";
            this.commands_.flushCommands(nomatch);
        }

        public void leave(VxmlNomatch o) {
            this._leaveNomatch();
            this.visitorStack_.pop();
        }

        private void _enterNoinput() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("promptcond=false;", shadow));
        }

        public boolean enter(VxmlNoinput o) {
            this._enterNoinput();
            this.visitorStack_.push(o);
            return true;
        }

        private void _leaveNoinput() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String noinput = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".noinput";
            this.commands_.flushCommands(noinput);
        }

        public void leave(VxmlNoinput o) {
            this._leaveNoinput();
            this.visitorStack_.pop();
        }

        private void _enterHelp() {
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            this.execContents_.appendExecContent(new EvaluateCommand("condprompt=false;", shadow));
        }

        public boolean enter(VxmlHelp o) {
            this._enterHelp();
            this.visitorStack_.push(o);
            return true;
        }

        private void _leaveHelp() {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String help = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName() + ".vxml_help";
            this.commands_.flushCommands(help);
        }

        public void leave(VxmlHelp e) {
            this._leaveHelp();
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlCatch o) {
            if (o.getEvent() == null) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("No EVENT in <catch>"));
            }
            String event = o.getEvent();
            String[] events = event.split(" ");
            boolean hasNomatch = false;
            boolean hasNoinput = false;
            boolean hasHelp = false;
            boolean hasError = false;
            int i = 0;
            while (i < events.length) {
                if (events[i].equals("nomatch")) {
                    hasNomatch = true;
                } else if (events[i].equals("noinput")) {
                    hasNoinput = true;
                } else if (events[i].equals("help")) {
                    hasHelp = true;
                } else if (events[i].equals("error")) {
                    hasError = true;
                }
                ++i;
            }
            if (hasNomatch) {
                this._enterNomatch();
            }
            if (hasNoinput) {
                this._enterNoinput();
            }
            if (hasHelp) {
                this._enterHelp();
            }
            if (hasError) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Not supported feature: <catch event=error>"));
            }
            this.visitorStack_.push(o);
            return true;
        }

        public void leave(VxmlCatch o) {
            if (this.visitorStack_.peek() instanceof VxmlCatch && ((VxmlCatch)this.visitorStack_.peek()).getEvent() != null) {
                String event = ((VxmlCatch)this.visitorStack_.peek()).getEvent();
                if (event.equals("nomatch")) {
                    this._leaveNomatch();
                } else if (event.equals("noinput")) {
                    this._leaveNoinput();
                } else if (event.equals("help")) {
                    this._leaveHelp();
                }
            }
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlReprompt e) {
            this.textBuf_.flushSpeak();
            String shadow = String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "$";
            String script = "promptcond=true;\n";
            this.execContents_.appendExecContent(new EvaluateCommand(script, shadow));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(RString rs) {
            String text = rs.getText();
            VXMLDoc.this.dbg.print("RString: " + text);
            this.textBuf_.appendString(text);
            return true;
        }

        public boolean enter(VxmlValue vxmlValue) {
            if (vxmlValue.getExpr() != null) {
                String expr = vxmlValue.getExpr();
                this.textBuf_.appendValue("(" + expr + ")");
            }
            return true;
        }

        public boolean enter(VxmlGoto g) {
            this.textBuf_.flushSpeak();
            String n = g.getNext();
            if (n == null) {
                VXMLDoc.this.docErrors_.add(new DocError("no next in <goto>"));
                return false;
            }
            String next = Util.removeSpaces(n);
            if (next.startsWith("#")) {
                String eval = "'" + next.replaceAll("#", "@") + "'";
                GotoCommand c = new GotoCommand(eval, "true");
                this.execContents_.appendExecContent(c);
            } else {
                String eval = "'" + VXMLDoc.this.resolveAdrs(next) + "'";
                EndCommand c = new EndCommand(eval, "true");
                this.execContents_.appendExecContent(c);
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlExit e) {
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(false));
            return true;
        }

        public boolean enter(VxmlAssign e) {
            this.textBuf_.flushSpeak();
            String aname = e.getName();
            String aexpr = e.getExpr();
            if (aname == null || aexpr == null) {
                VXMLDoc.this.docErrors_.add(new DocError("<assign> needs NAME and EXPR."));
                return false;
            }
            String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, this.dialog_.getName());
            this.execContents_.appendExecContent(new EvaluateCommand(sc));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlScript e) {
            this.textBuf_.flushSpeak();
            String text = "";
            if (e.getSrc() != null) {
                String srcpath = VXMLDoc.this.resolveAdrs(e.getSrc());
                try {
                    text = NetUtil.loadTextFile(srcpath);
                }
                catch (Exception ex) {
                    VXMLDoc.this.docErrors_.add(new DocError("<script> can't read external file. " + ex.toString()));
                }
            } else {
                text = e.getContent();
            }
            String sc = VXMLDoc.this._getEvalWith(text, this.dialog_.getName());
            this.execContents_.appendExecContent(new EvaluateCommand(sc));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlIf e) {
            this.currIfCond_ = e.getCond();
            String cond = VXMLDoc.this._getEvalWith(this.currIfCond_, this.dialog_.getName());
            this.execContents_.setupExecContent(cond);
            return true;
        }

        public void leave(VxmlIf e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
        }

        public boolean enter(VxmlElse e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String cond = VXMLDoc.this._getEvalWith("!(" + this.currIfCond_ + ")", this.dialog_.getName());
            this.execContents_.setupExecContent(cond);
            return true;
        }

        public boolean enter(VxmlElseif e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String c = e.getCond();
            String cond = VXMLDoc.this._getEvalWith(c, this.dialog_.getName());
            this.currIfCond_ = String.valueOf(this.currIfCond_) + " || " + c;
            this.execContents_.setupExecContent(cond);
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlBreak e) {
            String time = e.getTime();
            int msec = 500;
            if (time != null) {
                msec = time.equals("large") ? 2000 : (time.equals("medium") ? 500 : (time.equals("small") ? 200 : (time.equals("none") ? 1 : DocUtil.getCSS2TimesAsMsec(time))));
            }
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new AddOutItemCommand(new BreakOutItem(msec, this.currPromptBargein_)));
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlClear e) {
            if (e.getNamelist() == null) {
                if (this.submitItems_ == null || this.submitItems_.size() == 0) {
                    return true;
                }
                this.textBuf_.flushSpeak();
                int i = 0;
                while (i < this.submitItems_.size()) {
                    String aname = this.submitItems_.getKey(i);
                    String aexpr = "undefined";
                    String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, this.dialog_.getName());
                    this.execContents_.appendExecContent(new EvaluateCommand(sc));
                    ++i;
                }
                this.textBuf_.setupSpeak();
                return true;
            }
            this.textBuf_.flushSpeak();
            String[] names = e.getNamelist().split(" ");
            int i = 0;
            while (i < names.length) {
                String aname = names[i];
                String aexpr = "undefined";
                String sc = VXMLDoc.this._getEvalWith(String.valueOf(aname) + "=" + aexpr, this.dialog_.getName());
                this.execContents_.appendExecContent(new EvaluateCommand(sc));
                ++i;
            }
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlDisconnect e) {
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(true));
            return true;
        }

        public boolean enter(VxmlEmphasis e) {
            if (e.getLevel() != null) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <emphasis level>"));
                return false;
            }
            this.textBuf_.appendString("<EMPH>");
            return true;
        }

        public void leave(VxmlEmphasis e) {
            this.textBuf_.appendString("</EMPH>");
        }

        public boolean enter(VxmlEnumerate e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <enumerate>"));
            return false;
        }

        public boolean enter(VxmlError e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <error>"));
            return false;
        }

        public boolean enter(VxmlInitial e) {
            if (e.getName() == null) {
                this.dialog_.setItemName(VXMLDoc.this._getUniqueId("initial"));
            } else {
                this.dialog_.setItemName(e.getName());
            }
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            String t = VXMLDoc.this.stateMap_.newState(s);
            VXMLDoc.this.dbg.ASSERT(t.equals(s), "VxmlInitial#enter");
            VXMLDoc.this.stateMap_.addCommand(s, new EvaluateCommand(String.valueOf(this.dialog_.getName()) + "." + this.dialog_.getItemName() + "=true;"));
            this.visitorStack_.push(e);
            this.formItems_.put(this.dialog_.getItemName(), e);
            this.commands_.setupCommands();
            this.execContents_.setupExecContent();
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlInitial e) {
            this.textBuf_.flushSpeak();
            this.execContents_.flushExecContent();
            String s = "@" + this.dialog_.getName() + "." + this.dialog_.getItemName();
            this.commands_.flushCommands(s);
            VXMLDoc.this.stateMap_.addSetNextCommand(s, "@" + this.dialog_.getName() + ".vxml_select");
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlLink e) {
            this.visitorStack_.push(e);
            return true;
        }

        public void leave(VxmlLink e) {
            this.visitorStack_.pop();
        }

        public boolean enter(VxmlLog e) {
            this.textBuf_.flushSpeak();
            this.textBuf_.setupLog();
            String expr = e.getExpr();
            if (expr != null) {
                this.textBuf_.appendValue("(" + expr + ")");
            }
            return true;
        }

        public void leave(VxmlLog e) {
            this.textBuf_.flushLog();
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlNative e) {
            String expr;
            this.textBuf_.flushSpeak();
            this.textBuf_.setupNative();
            if (this.visitorStack_.peek() instanceof VxmlMedia && this.isParallel_) {
                this.textBuf_.appendValue("'to @PAR set Cmd = '");
            }
            if ((expr = e.getExpr()) != null) {
                this.textBuf_.appendValue("(" + expr + ")");
            }
            return true;
        }

        public void leave(VxmlNative e) {
            this.textBuf_.flushNative();
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlAllOf e) {
            this.textBuf_.flushSpeak();
            this.mediaCount_ = 0;
            this.visitorStack_.push(e);
            return true;
        }

        public void leave(VxmlAllOf e) {
            this.visitorStack_.pop();
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlMedia e) {
            this.textBuf_.flushSpeak();
            if (this.visitorStack_.peek() instanceof VxmlAllOf) {
                ++this.mediaCount_;
                if (this.mediaCount_ == 1) {
                    this.textBuf_.setupNative();
                    this.textBuf_.appendValue("'to @PAR set Init = 1'");
                    this.textBuf_.flushNative();
                    this.isParallel_ = true;
                } else {
                    this.textBuf_.setupSpeak();
                }
            }
            this.visitorStack_.push(e);
            return true;
        }

        public void leave(VxmlMedia e) {
            this.visitorStack_.pop();
            if (this.visitorStack_.peek() instanceof VxmlAllOf) {
                this.textBuf_.flushSpeak();
                this.isParallel_ = false;
            }
        }

        public boolean enter(VxmlMark e) {
            return true;
        }

        public boolean enter(VxmlMeta e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <meta>"));
            return true;
        }

        public boolean enter(VxmlObject e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <object>"));
            return true;
        }

        public boolean enter(VxmlParam e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Not supported feature: <param>"));
            return true;
        }

        public boolean enter(VxmlPhoneme e) {
            this.textBuf_.appendString("<PRON SYM=\"" + e.getPh() + "\">");
            return true;
        }

        public void leave(VxmlPhoneme e) {
            this.textBuf_.appendString("</PRON>");
        }

        public boolean enter(VxmlProperty e) {
            String name = e.getName();
            String value = e.getValue();
            Object parent = this.visitorStack_.peek();
            if (name.equals("bargein")) {
                if (parent instanceof VxmlMenu || parent instanceof VxmlForm) {
                    this.dialogBargeinProperty_ = value;
                } else if (parent instanceof VxmlVxml) {
                    this.documentBargeinProperty_ = value;
                }
            } else if (name.equals("timeout")) {
                if (parent instanceof VxmlMenu || parent instanceof VxmlForm) {
                    VXMLDoc.this.docWarnings_.add(new DocWarning("Not supported feature: property timeout for dialog"));
                } else if (parent instanceof VxmlVxml) {
                    String script = "$prompt_timeout = " + DocUtil.getCSS2TimesInMsecAsString(value);
                    VXMLDoc.this.stateMap_.addCommand(VXMLDoc.VXML_START_NAME, new EvaluateCommand(script));
                }
            } else if (name.equals("inputmodes")) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Not supported feature: property inputmodes"));
            }
            return true;
        }

        public boolean enter(VxmlRecord e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <record>"));
            return false;
        }

        public boolean enter(VxmlReturn e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <return>"));
            return false;
        }

        public boolean enter(VxmlSayAs e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Ignored feature: <say-as>"));
            return true;
        }

        public boolean enter(VxmlSubmit e) {
            int i;
            String script = "";
            if (e.getNext() != null) {
                script = "'" + VXMLDoc.this.resolveAdrs(Util.removeSpaces(e.getNext())) + "'";
            } else if (e.getExpr() != null) {
                script = Util.removeSpaces(e.getExpr());
            } else {
                VXMLDoc.this.docErrors_.add(new DocError("No next in <submit>"));
                return false;
            }
            String namelist = e.getNamelist();
            if (namelist == null) {
                i = 0;
                while (i < this.submitItems_.size()) {
                    script = i == 0 ? String.valueOf(script) + "+'?'" : String.valueOf(script) + "+'&'";
                    script = String.valueOf(script) + "+'" + this.submitItems_.getKey(i) + "='+" + this.submitItems_.getKey(i);
                    ++i;
                }
            } else {
                String[] names = namelist.split(" ");
                i = 0;
                while (i < names.length) {
                    script = i == 0 ? String.valueOf(script) + "+'?'" : String.valueOf(script) + "+'&'";
                    script = String.valueOf(script) + "+'" + names[i] + "='+" + names[i];
                    ++i;
                }
            }
            script = String.valueOf(script) + ";";
            this.textBuf_.flushSpeak();
            String eval = VXMLDoc.this._getEvalWith(script, this.dialog_.getName());
            EndCommand c = new EndCommand(eval, "true");
            this.execContents_.appendExecContent(c);
            this.textBuf_.setupSpeak();
            return true;
        }

        public boolean enter(VxmlThrow e) {
            VXMLDoc.this.docErrors_.add(new DocError("Not supported feature: <throw>"));
            return false;
        }

        public boolean enter(VxmlTransfer e) {
            VXMLDoc.this.docWarnings_.add(new DocWarning("Not supported feature: <transfer>"));
            this.textBuf_.flushSpeak();
            this.execContents_.appendExecContent(new EndCommand(false));
            return true;
        }

        public boolean enter(VxmlVoice e) {
            String optional = "male01";
            if (e.getName() != null) {
                optional = e.getName();
            } else if (e.getGender() != null) {
                if (e.getGender().equals("male")) {
                    optional = "male01";
                } else if (e.getGender().equals("female")) {
                    optional = "female01";
                }
            }
            this.textBuf_.appendString("<VOICE OPTIONAL=\"" + optional + "\">");
            return true;
        }

        public void leave(VxmlVoice e) {
            this.textBuf_.appendString("</VOICE>");
        }

        public boolean enter(VxmlProsody e) {
            String enterProsodyTag = "";
            this.leaveProsodyTag_ = "";
            if (e.getPitch() != null) {
                if (e.getPitch().equals("x-high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"140\">";
                } else if (e.getPitch().equals("high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"120\">";
                } else if (e.getPitch().equals("medium")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"100\">";
                } else if (e.getPitch().equals("low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"80\">";
                } else if (e.getPitch().equals("x-low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"60\">";
                } else if (e.getPitch().equals("default")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH LEVEL=\"100\">";
                }
                this.leaveProsodyTag_ = "</PITCH>" + this.leaveProsodyTag_;
            }
            if (e.getRange() != null) {
                if (e.getRange().equals("x-high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"140\">";
                } else if (e.getRange().equals("high")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"120\">";
                } else if (e.getRange().equals("medium")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"100\">";
                } else if (e.getRange().equals("low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"80\">";
                } else if (e.getRange().equals("x-low")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"60\">";
                } else if (e.getRange().equals("default")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<PITCH RANGE=\"100\">";
                }
                this.leaveProsodyTag_ = "</PITCH>" + this.leaveProsodyTag_;
            }
            if (e.getVolume() != null) {
                if (e.getRange().equals("silent")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"0\">";
                } else if (e.getRange().equals("x-soft")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"60\">";
                } else if (e.getRange().equals("soft")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"80\">";
                } else if (e.getRange().equals("medium")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"100\">";
                } else if (e.getRange().equals("loud")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"120\">";
                } else if (e.getRange().equals("x-loud")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"140\">";
                } else if (e.getRange().equals("default")) {
                    enterProsodyTag = String.valueOf(enterProsodyTag) + "<VOLUME LEVEL=\"100\">";
                }
                this.leaveProsodyTag_ = "</VOLUME>" + this.leaveProsodyTag_;
            }
            this.textBuf_.appendString(enterProsodyTag);
            return true;
        }

        public void leave(VxmlProsody e) {
            VXMLDoc.this.dbg.ASSERT(this.leaveProsodyTag_ != null, "leave VxmlProsody");
            this.textBuf_.appendString(this.leaveProsodyTag_);
            this.leaveProsodyTag_ = null;
        }

        public boolean enter(VxmlP e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlP e) {
            this.textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlParagraph e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlParagraph e) {
            this.textBuf_.appendString("<SILENCE MSEC=\"500\"/>");
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlS e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlS e) {
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlSentence e) {
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlSentence e) {
            this.textBuf_.flushSpeak();
        }

        public boolean enter(VxmlEMPH e) {
            this.textBuf_.appendString("<EMPH>");
            return true;
        }

        public void leave(VxmlEMPH e) {
            this.textBuf_.appendString("</EMPH>");
        }

        public boolean enter(VxmlSILENCE e) {
            this.textBuf_.appendString("<SILENCE MSEC=\"" + e.getMSEC() + "\"/>");
            return true;
        }

        public boolean enter(VxmlPRON e) {
            this.textBuf_.appendString("<PRON SYM=\"" + e.getSYM() + "\">");
            return true;
        }

        public void leave(VxmlPRON e) {
            this.textBuf_.appendString("</PRON>");
        }

        public boolean enter(VxmlJVOICE e) {
            String alpha;
            String optional = e.getOPTIONAL();
            if (optional == null && e.getREQUIRED() != null) {
                optional = e.getREQUIRED().equals("FEMALE") || e.getREQUIRED().equals("female") ? "female01" : "male01";
            }
            String str = "<VOICE";
            if (optional != null) {
                str = String.valueOf(str) + " OPTIONAL=\"" + optional + "\"";
            }
            if ((alpha = e.getALPHA()) != null) {
                str = String.valueOf(str) + " ALPHA=\"" + alpha + "\"";
            }
            str = String.valueOf(str) + ">";
            this.textBuf_.appendString(str);
            return true;
        }

        public void leave(VxmlJVOICE e) {
            this.textBuf_.appendString("</VOICE>");
        }

        public boolean enter(VxmlRATE e) {
            this.textBuf_.appendString("<RATE SPEED=\"" + e.getSPEED() + "\">");
            return true;
        }

        public void leave(VxmlRATE e) {
            this.textBuf_.appendString("</RATE>");
        }

        public boolean enter(VxmlVOLUME e) {
            this.textBuf_.appendString("<VOLUME LEVEL=\"" + e.getLEVEL() + "\">");
            return true;
        }

        public void leave(VxmlVOLUME e) {
            this.textBuf_.appendString("</VOLUME>");
        }

        public boolean enter(VxmlPITCH e) {
            String att = "";
            if (e.getLEVEL() != null) {
                att = String.valueOf(att) + " LEVEL=\"" + e.getLEVEL() + "\"";
            }
            if (e.getRANGE() != null) {
                att = String.valueOf(att) + " RANGE=\"" + e.getRANGE() + "\"";
            }
            this.textBuf_.appendString("<PITCH" + att + ">");
            return true;
        }

        public void leave(VxmlPITCH e) {
            this.textBuf_.appendString("</PITCH>");
        }

        public boolean enter(VxmlSPELL e) {
            this.textBuf_.appendString("<SPELL>");
            return true;
        }

        public void leave(VxmlSPELL e) {
            this.textBuf_.appendString("</SPELL>");
        }

        public boolean enter(VxmlCONTEXT e) {
            String att = "";
            if (e.getTYPE() != null) {
                att = String.valueOf(att) + " TYPE=\"" + e.getTYPE() + "\"";
            }
            if (e.getTYPE().equals("NUMBER") && e.getFORMAT() != null) {
                att = String.valueOf(att) + " FORMAT=\"" + e.getFORMAT() + "\"";
            }
            if (e.getTYPE().equals("DATE")) {
                if (e.getFORMAT() != null) {
                    att = String.valueOf(att) + " FORMAT=\"" + e.getFORMAT() + "\"";
                }
                if (e.getDELIM() != null) {
                    att = String.valueOf(att) + " DELIM=\"" + e.getDELIM() + "\"";
                }
            }
            this.textBuf_.appendString("<CONTEXT" + att + ">");
            return true;
        }

        public void leave(VxmlCONTEXT e) {
            this.textBuf_.appendString("</CONTEXT>");
        }

        public boolean enter(VxmlAudio e) {
            this.textBuf_.flushSpeak();
            String src = e.getSrc();
            if (src == null) {
                VXMLDoc.this.docWarnings_.add(new DocWarning("Error: <audio src> missing."));
                return true;
            }
            String file = "'" + VXMLDoc.this.resolveAdrs(src) + "'";
            this.execContents_.appendExecContent(new AddOutItemCommand(new AudioOutItem(file, this.currPromptBargein_)));
            return true;
        }

        public void leave(VxmlAudio e) {
            this.textBuf_.setupSpeak();
        }

        public boolean enter(VxmlEmotion e) {
            this.textBuf_.flushSpeak();
            String typename = e.getType();
            int value = 100;
            int duration = 0;
            if (e.checkPattern()) {
                value = e.getPattern();
            }
            if (e.checkValue()) {
                value = e.getValue();
            }
            if (e.checkDuration()) {
                duration = e.getDuration();
            }
            if (typename == null) {
                typename = "NEUTRAL";
            }
            typename = typename.toUpperCase();
            String text = "'to @AM-MCL set Emotion = " + typename + " " + value + " " + duration + "'";
            NativeOutItem item = new NativeOutItem(text, this.dialog_.getName());
            this.execContents_.appendExecContent(new AddOutItemCommand(item));
            this.textBuf_.setupSpeak();
            return true;
        }

        public void leave(VxmlEmotion emotion) {
            this.textBuf_.flushSpeak();
            this.textBuf_.setupSpeak();
        }

        protected class Dialog {
            private String currFormName_ = null;
            private String currFormItemName_ = null;

            protected Dialog() {
            }

            public void setName(String s) {
                this.currFormName_ = s;
            }

            public String getName() {
                return this.currFormName_;
            }

            public void setItemName(String s) {
                this.currFormItemName_ = s;
            }

            public String getItemName() {
                return this.currFormItemName_;
            }
        }

        protected class Prompt {
            public int count = 1;
            public String cond = null;
            public ArrayList commands = null;

            protected Prompt() {
            }
        }

        protected class Commands {
            private ArrayList cmdvec_ = null;

            protected Commands() {
            }

            public void setupCommands() {
                if (this.cmdvec_ == null) {
                    this.cmdvec_ = new ArrayList();
                } else {
                    String str = "";
                    int i = 0;
                    int n = this.cmdvec_.size();
                    while (i < n) {
                        str = String.valueOf(str) + this.cmdvec_.get(i).toString();
                        ++i;
                    }
                    VXMLDoc.this.docWarnings_.add(new DocWarning("commands not used before setupCommands()\n" + str));
                }
            }

            public void appendCommands(Command c) {
                VXMLDoc.this.dbg.print("appendCommands:" + c.toString());
                if (this.cmdvec_ != null) {
                    this.cmdvec_.add(c);
                }
            }

            public void flushCommands(String s) {
                if (this.cmdvec_ != null && this.cmdvec_.size() > 0) {
                    VXMLDoc.this.stateMap_.addCommand(s, this.cmdvec_);
                    this.cmdvec_ = null;
                }
            }

            public ArrayList getCommands() {
                return this.cmdvec_;
            }

            public void setCommands(ArrayList v) {
                if (this.cmdvec_ != null && this.cmdvec_.size() > 0) {
                    String str = "";
                    int i = 0;
                    int n = this.cmdvec_.size();
                    while (i < n) {
                        str = String.valueOf(str) + this.cmdvec_.get(i).toString();
                        ++i;
                    }
                    VXMLDoc.this.docWarnings_.add(new DocWarning("commands not used before setCommands(ArrayList v)\n" + str));
                }
                this.cmdvec_ = v;
            }

            public void clearCommands() {
                if (this.cmdvec_ != null && this.cmdvec_.size() > 0) {
                    String str = "";
                    int i = 0;
                    int n = this.cmdvec_.size();
                    while (i < n) {
                        str = String.valueOf(str) + this.cmdvec_.get(i).toString();
                        ++i;
                    }
                    VXMLDoc.this.docWarnings_.add(new DocWarning("commands not used before clearCommands()\n" + str));
                }
                this.cmdvec_ = null;
            }
        }

        protected class ExecContents {
            private Stack execContentsStack_ = new Stack();
            private int stackCount_ = 0;

            protected ExecContents() {
            }

            private void setupExecContent(String cond) {
                ++this.stackCount_;
                VXMLDoc.this.dbg.print("setupExecContent: " + this.stackCount_ + " " + cond);
                ArrayList c = new ArrayList();
                CompositeCommand co = new CompositeCommand(c, cond);
                this.execContentsStack_.push(co);
            }

            private void setupExecContent() {
                this.setupExecContent("true");
            }

            private void appendExecContent(Command c) {
                CompositeCommand co;
                VXMLDoc.this.dbg.print("appendExecContent: " + this.stackCount_ + " " + c);
                if (!this.execContentsStack_.empty() && (co = (CompositeCommand)this.execContentsStack_.peek()) != null) {
                    co.getCommands().add(c);
                }
            }

            private void flushExecContent() {
                VXMLDoc.this.dbg.print("flushExecContent: " + this.stackCount_);
                --this.stackCount_;
                if (!this.execContentsStack_.empty()) {
                    CompositeCommand co = (CompositeCommand)this.execContentsStack_.pop();
                    if (this.execContentsStack_.empty()) {
                        Visitor.this.commands_.appendCommands(co);
                    } else {
                        CompositeCommand c = (CompositeCommand)this.execContentsStack_.peek();
                        c.getCommands().add(co);
                    }
                }
            }
        }

        protected class TextBuf {
            private BaseText speakText_ = new SpeakText();
            private BaseText logText_ = new LogText();
            private BaseText nativeText_ = new NativeText();
            private BaseText context_ = this.speakText_;

            protected TextBuf() {
            }

            public void appendString(String text) {
                this.context_.appendString(text);
            }

            public void appendValue(String expr) {
                this.context_.appendValue(expr);
            }

            public void setupSpeak() {
                this.context_ = this.speakText_;
                this.context_.resetText();
            }

            public void flushSpeak() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof SpeakText, "error");
                StringBuffer sb = this.context_.getText();
                if (sb != null) {
                    String text = new String(sb).trim();
                    if (text.length() > 0) {
                        VoiceOutItem item = new VoiceOutItem(text, Visitor.this.dialog_.getName(), Visitor.this.currPromptBargein_);
                        AddOutItemCommand c = new AddOutItemCommand(item);
                        Visitor.this.execContents_.appendExecContent(c);
                    }
                    this.context_.resetText();
                }
            }

            public void setupLog() {
                this.context_ = this.logText_;
                this.context_.resetText();
            }

            public void flushLog() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof LogText, "error flushLog()");
                StringBuffer log = this.context_.getText();
                if (log != null) {
                    String text = new String(log).trim();
                    if (text.length() > 0) {
                        LogOutItem item = new LogOutItem(text, Visitor.this.dialog_.getName());
                        AddOutItemCommand c = new AddOutItemCommand(item);
                        Visitor.this.execContents_.appendExecContent(c);
                    }
                    this.context_.resetText();
                }
                this.context_ = this.speakText_;
            }

            public void setupNative() {
                this.context_ = this.nativeText_;
                this.context_.resetText();
            }

            public void flushNative() {
                VXMLDoc.this.dbg.ASSERT(this.context_ instanceof NativeText, "error flushNative()");
                StringBuffer sb = this.context_.getText();
                if (sb != null) {
                    String text = new String(sb).trim();
                    if (text.length() > 0) {
                        NativeOutItem item = new NativeOutItem(text, Visitor.this.dialog_.getName());
                        AddOutItemCommand c = new AddOutItemCommand(item);
                        Visitor.this.execContents_.appendExecContent(c);
                    }
                    this.context_.resetText();
                }
                this.context_ = this.speakText_;
            }

            private class BaseText {
                private StringBuffer text_ = null;

                BaseText() {
                }

                public void resetText() {
                    this.text_ = new StringBuffer();
                }

                public StringBuffer getText() {
                    if (this.text_ == null) {
                        this.text_ = new StringBuffer("");
                    }
                    return this.text_;
                }

                public void setText(StringBuffer text) {
                    this.text_ = text;
                }

                public void appendString(String text) {
                    VXMLDoc.this.dbg.ASSERT(TextBuf.this.context_ != null, "context_ null error");
                    StringBuffer sb = TextBuf.this.context_.getText();
                    if (sb != null && text != null && text.length() > 0) {
                        if (sb.length() > 0) {
                            sb.append("+");
                        }
                        sb.append("'");
                        sb.append(text);
                        sb.append("'");
                        TextBuf.this.context_.setText(sb);
                    }
                }

                public void appendValue(String expr) {
                    VXMLDoc.this.dbg.ASSERT(TextBuf.this.context_ != null, "context_ null error");
                    StringBuffer sb = TextBuf.this.context_.getText();
                    if (sb != null && expr != null && expr.length() > 0) {
                        if (sb.length() > 0) {
                            sb.append("+");
                        }
                        sb.append(expr);
                        TextBuf.this.context_.setText(sb);
                    }
                }
            }

            private class SpeakText
            extends BaseText {
                SpeakText() {
                }

                public void appendString(String text) {
                    String s = Util.xmlSafeRemoveSpaces(text);
                    super.appendString(s);
                }
            }

            private class LogText
            extends BaseText {
                LogText() {
                }

                public void appendString(String text) {
                    String s = Util.removeNewLines(text);
                    super.appendString(s);
                }
            }

            private class NativeText
            extends BaseText {
                NativeText() {
                }
            }
        }
    }
}

