/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.io.DeviceEvent;
import galatea.io.IOutputEventListener;
import galatea.outitem.BreakOutItem;
import galatea.outitem.OutItem;
import galatea.util.Logger;
import java.util.ArrayList;

public class BreakThread
extends Thread {
    private Logger dbg = new Logger("BreakThread", 0);
    private ArrayList listeners_ = new ArrayList();
    private long millis_ = 0L;
    private boolean start_ = false;
    private boolean term_ = false;

    public BreakThread() {
        this.setName("BreakThread");
    }

    public void addOutputEventListener(IOutputEventListener l) {
        this.listeners_.add(l);
    }

    public synchronized void outputDeviceStart(OutItem obj) {
        if (obj instanceof BreakOutItem) {
            BreakOutItem bo = (BreakOutItem)obj;
            this.dbg.print("Break: outputDeviceStart");
            Double ms = new Double(bo.getArgAsDouble() * 1000.0);
            this.millis_ = ms.longValue();
            this.start_ = true;
            this.notify();
        }
    }

    public synchronized void outputDeviceStop(OutItem obj) {
        this.notify();
    }

    public synchronized void terminate() {
        this.term_ = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BreakThread breakThread = this;
        synchronized (breakThread) {
            do {
                this.dbg.print("BreakThread wait");
                try {
                    this.wait();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!this.start_) continue;
                this.dbg.print("Break Start : " + this.millis_ + " msec");
                int i = 0;
                while (i < this.listeners_.size()) {
                    ((IOutputEventListener)this.listeners_.get(i)).enqueueOutputEvent(DeviceEvent.newOutputBusyInstance("break"));
                    ++i;
                }
                try {
                    this.wait(this.millis_);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.start_ = false;
                this.dbg.print("Break End : " + this.millis_ + " msec");
                i = 0;
                while (i < this.listeners_.size()) {
                    ((IOutputEventListener)this.listeners_.get(i)).enqueueOutputEvent(DeviceEvent.newOutputReadyInstance("break"));
                    ++i;
                }
            } while (!this.term_);
        }
        this.dbg.print("BreakThread exitting...");
    }
}

