/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.dialog.IControllerModeManager;
import galatea.dialog.IInterpretedEventListener;
import galatea.dialog.InterpretedEvent;
import galatea.dialog.RuntimeError;
import galatea.dialog.window.DialogManagerWindow;
import galatea.dialog.window.IDMWindowActionListener;
import galatea.httpserver.HttpRequestTask;
import galatea.httpserver.HttpServer;
import galatea.httpserver.HttpSession;
import galatea.httpserver.IHttpRequestResponder;
import galatea.httpserver.IHttpResponseHtmlMaker;
import galatea.io.AMThread;
import galatea.io.BreakThread;
import galatea.io.DeviceEvent;
import galatea.io.HttpSenderToDevice;
import galatea.io.IOutputEventListener;
import galatea.io.plugins.AudioPlayerSubModule;
import galatea.io.plugins.GalateaTalkSubModule;
import galatea.io.plugins.GrammarSubModule;
import galatea.io.plugins.JulianSubModule;
import galatea.io.plugins.KeypadSubModule;
import galatea.io.plugins.MotionSubModule;
import galatea.io.wrapper.GRMSubModule;
import galatea.io.wrapper.SNDSubModule;
import galatea.io.wrapper.SRMSubModule;
import galatea.io.wrapper.SSMSubModule;
import galatea.outitem.BreakOutItem;
import galatea.outitem.LogOutItem;
import galatea.outitem.NativeOutItem;
import galatea.outitem.OutItem;
import galatea.submodule.IReceiverFromSubModule;
import galatea.submodule.ISubModule;
import galatea.util.Logger;
import galatea.util.Property;
import java.util.ArrayList;

public class DeviceManager
implements IReceiverFromSubModule,
IHttpRequestResponder {
    private Logger dbg = new Logger("DEVMAN", 0);
    private AMThread amt_;
    private BreakThread bt_;
    private HttpSenderToDevice httpDevice_;
    private ArrayList subModules_ = new ArrayList();
    private ISubModule ssmSubModule_;
    private ISubModule sndSubModule_;
    private ISubModule srmSubModule_;
    private ISubModule grmSubModule_;
    private ISubModule keypadSubModule_;
    private ISubModule motionSubModule_;
    private ArrayList interpretedEventListeners_ = new ArrayList();
    private ArrayList outputEventListeners_ = new ArrayList();
    private int runLevel_ = 0;
    private int targetRunLevel_ = 1;
    private int runLevelUnchangedCount_ = 0;
    private IControllerModeManager icmode_;
    private ArrayList httpRequestTasks_ = new ArrayList();
    private HttpServer httpServer_;
    private HttpSession httpSession_;
    private DialogManagerWindow window_;

    public void start(IControllerModeManager ic0, IOutputEventListener ic1, IInterpretedEventListener ic2, IHttpResponseHtmlMaker ic3, IDMWindowActionListener ic4) {
        this.window_ = new DialogManagerWindow();
        this.window_.setDialogManagerWindowActionListener(ic4);
        this.httpServer_ = new HttpServer();
        int port = Property.getAsInt("DM.HttpServerPort", 9999);
        this.httpSession_ = new HttpSession(ic3, this);
        this.httpServer_.start(this.httpSession_, port);
        this.httpDevice_ = new HttpSenderToDevice(this.httpSession_);
        this.dbg.print("http server started. port:" + port);
        this.dbg.print("BreakThread starting..");
        this.bt_ = new BreakThread();
        this.bt_.addOutputEventListener(ic1);
        this.bt_.start();
        this.dbg.print("BreakThread started.");
        this.dbg.print("AMThread starting..");
        this.amt_ = new AMThread();
        this.icmode_ = ic0;
        this.addOutputEventListener(ic1);
        this.addInterpretedEventListener(ic2);
        if (Property.getAsBoolean("DM.UseWrapper.SSM", true)) {
            this.ssmSubModule_ = new SSMSubModule();
            this.amt_.addSubModule(this.ssmSubModule_, this, this.window_);
            this.subModules_.add(this.ssmSubModule_);
        } else {
            this.ssmSubModule_ = new GalateaTalkSubModule();
            this.ssmSubModule_.setReceiver(this);
            this.ssmSubModule_.setLogger(this.window_);
            this.subModules_.add(this.ssmSubModule_);
        }
        this.ssmSubModule_.setName("SSM");
        if (Property.getAsBoolean("DM.UseWrapper.SND", false)) {
            this.sndSubModule_ = new SNDSubModule();
            this.amt_.addSubModule(this.sndSubModule_, this, this.window_);
            this.subModules_.add(this.sndSubModule_);
        } else {
            this.sndSubModule_ = new AudioPlayerSubModule();
            this.sndSubModule_.setReceiver(this);
            this.sndSubModule_.setLogger(this.window_);
            this.subModules_.add(this.sndSubModule_);
        }
        this.sndSubModule_.setName("SND");
        if (Property.getAsBoolean("DM.UseWrapper.SRM", true)) {
            this.srmSubModule_ = new SRMSubModule();
            this.amt_.addSubModule(this.srmSubModule_, this, this.window_);
            this.subModules_.add(this.srmSubModule_);
        } else {
            this.srmSubModule_ = new JulianSubModule();
            this.amt_.addSubModule(this.srmSubModule_, this, this.window_);
            this.subModules_.add(this.srmSubModule_);
        }
        this.srmSubModule_.setName("SRM");
        if (Property.getAsBoolean("DM.UseWrapper.GRM", false)) {
            this.grmSubModule_ = new GRMSubModule();
            this.amt_.addSubModule(this.grmSubModule_, this, this.window_);
            this.subModules_.add(this.grmSubModule_);
        } else {
            this.grmSubModule_ = new GrammarSubModule();
            this.grmSubModule_.setReceiver(this);
            this.grmSubModule_.setLogger(this.window_);
            this.subModules_.add(this.grmSubModule_);
        }
        this.grmSubModule_.setName("GRM");
        if (Property.getAsBoolean("DM.UseKeypadSubModule", false)) {
            this.keypadSubModule_ = new KeypadSubModule();
            this.amt_.addSubModule(this.keypadSubModule_, this, this.window_);
            this.subModules_.add(this.keypadSubModule_);
            this.keypadSubModule_.setName("KBD");
        }
        if (Property.getAsBoolean("DM.UseMotionSubModule", true)) {
            this.motionSubModule_ = new MotionSubModule();
            this.httpDevice_.addSubModule(this.motionSubModule_, this, this.window_);
            this.subModules_.add(this.motionSubModule_);
            this.motionSubModule_.setName("MTN");
        }
        this.amt_.start();
        this.dbg.print("AMThread started.");
    }

    public void doTimerTask() throws RuntimeError {
        int i = 0;
        int n = this.subModules_.size();
        while (i < n) {
            ((ISubModule)this.subModules_.get(i)).doTimerTask();
            ++i;
        }
    }

    private void addInterpretedEventListener(IInterpretedEventListener l) {
        this.interpretedEventListeners_.add(l);
    }

    private void addOutputEventListener(IOutputEventListener l) {
        this.outputEventListeners_.add(l);
    }

    private int getRunLevel() {
        return this.runLevel_;
    }

    private void setRunLevel(int i) {
        this.runLevel_ = i;
    }

    private boolean _isRunLevel2() {
        return this.getRunLevel() == 2;
    }

    private void _dispDeviceManagerLog(String str) {
        this.window_.inputEventReceived(str);
    }

    private void _dispLogOutItem(String str) {
        this.window_.dispApplog(str);
    }

    private boolean _gotoRunLevel2() {
        this.setRunLevel(1);
        this._dispDeviceManagerLog("RunLevel:1");
        this.amt_.outputNative("rep Run = DEAD");
        this._setTargetRunLevel(2);
        return true;
    }

    private void _setTargetRunLevel(int level) {
        this.runLevelUnchangedCount_ = this.subModules_.size();
        this.targetRunLevel_ = level;
        int i = 0;
        int n = this.subModules_.size();
        while (i < n) {
            ((ISubModule)this.subModules_.get(i)).setTargetRunLevel(level);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean waitDevicesForReady() {
        this.dbg.print("wait AMThread isReady...");
        if (this._gotoRunLevel2()) ** GOTO lbl11
        this.dbg.print("failed to gotoRunLevel2.");
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(1L);
                this.doTimerTask();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
lbl11:
            // 3 sources

            ** while (!this._isRunLevel2())
        }
lbl12:
        // 1 sources

        this.dbg.print("starting done.");
        return true;
    }

    public boolean doOutput(OutItem item) {
        if (item instanceof NativeOutItem) {
            NativeOutItem o = (NativeOutItem)item;
            String str = o.getArg();
            this.amt_.outputNative(str);
            return true;
        }
        if (item instanceof BreakOutItem) {
            this.bt_.outputDeviceStart(item);
            return true;
        }
        if (item instanceof LogOutItem) {
            LogOutItem o = (LogOutItem)item;
            this._dispLogOutItem(o.getArg());
            return true;
        }
        int i = 0;
        int n = this.subModules_.size();
        while (i < n) {
            if (((ISubModule)this.subModules_.get(i)).startOutput(item)) {
                return true;
            }
            ++i;
        }
        this.dbg.print("doOutput failed:" + item.toString());
        return false;
    }

    public boolean doStop(OutItem item) {
        if (item instanceof BreakOutItem) {
            this.bt_.outputDeviceStop(item);
            return true;
        }
        int i = 0;
        int n = this.subModules_.size();
        while (i < n) {
            if (((ISubModule)this.subModules_.get(i)).stopOutput(item)) {
                return true;
            }
            ++i;
        }
        this.dbg.print("doStop failed:" + item.toString());
        return false;
    }

    public void receiveInterpreted(InterpretedEvent ev) {
        int i = 0;
        while (i < this.interpretedEventListeners_.size()) {
            ((IInterpretedEventListener)this.interpretedEventListeners_.get(i)).enqueueInterpretedEvent(ev);
            ++i;
        }
    }

    public void updateDialogStateChange(String state) {
        this.window_.dialogStateChanged(state);
    }

    public void receiveOutputBusy(String device, String message) {
        int i = 0;
        while (i < this.outputEventListeners_.size()) {
            ((IOutputEventListener)this.outputEventListeners_.get(i)).enqueueOutputEvent(DeviceEvent.newOutputBusyInstance(device, message));
            ++i;
        }
    }

    public void receiveOutputReady(String device, String message) {
        int i = 0;
        while (i < this.outputEventListeners_.size()) {
            ((IOutputEventListener)this.outputEventListeners_.get(i)).enqueueOutputEvent(DeviceEvent.newOutputReadyInstance(device, message));
            ++i;
        }
    }

    public void receiveRunLevel(int level, ISubModule src) {
        this.dbg.print("RunLevel:" + level + " sender:" + src.getName());
        if (this.targetRunLevel_ == level && this.runLevelUnchangedCount_ > 0) {
            --this.runLevelUnchangedCount_;
            if (this.runLevelUnchangedCount_ == 0) {
                this.setRunLevel(this.targetRunLevel_);
                if (level == 2) {
                    this.amt_.outputNative("rep Run = LIVE");
                    this._dispDeviceManagerLog("RunLevel:2");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String respondToHttpRequest(String module, String ev, String arg) {
        this.dbg.ASSERT(module != null, "m != null");
        this.dbg.ASSERT(ev != null, "e != null");
        if (this.httpDevice_.checkInput(module, ev)) {
            return String.valueOf(module) + " " + ev + " accepted";
        }
        if (module.equals("browser")) {
            DeviceManager deviceManager = this;
            synchronized (deviceManager) {
                this.httpRequestTasks_.add(new HttpRequestTask(ev, arg));
            }
            return "task enqueued";
        }
        return "event ignored";
    }

    public synchronized int sizeExternalTask() {
        return this.httpRequestTasks_.size();
    }

    public synchronized HttpRequestTask removeExternalTask() {
        return (HttpRequestTask)this.httpRequestTasks_.remove(0);
    }

    public void dispDocInfo(String file, String state, String src, String trans) {
        this.window_.documentLocationChanged(file);
        this.window_.dialogStateChanged(state);
        this.window_.srcFileUpdated(src);
        this.window_.translatedFileUpdated(trans);
    }

    public void dispDebuggerEvalResult(String result) {
        this.window_.dispDebuggerEvalResult(result);
    }
}

