/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.plugins;

import galatea.dialog.RuntimeError;
import galatea.grammar.GrammarTransformer;
import galatea.outitem.GrammarOutItem;
import galatea.outitem.OutItem;
import galatea.submodule.AbstractSubModule;
import galatea.util.Logger;
import galatea.util.Util;
import java.nio.charset.Charset;

public class GrammarSubModule
extends AbstractSubModule {
    private final String XML_ENCODING = "UTF-8";
    private Logger dbg = new Logger("GRM");
    private Charset charset_ = Util.getSystemDefaultCharset();
    private Charset xmlCharset_ = Charset.forName("UTF-8");
    private String document_ = "";
    private String location_ = "";
    private String transformErrors_ = "";
    private final int STOPPED = 0;
    private final int BUSY = 1;
    private final int STOPPING = 2;
    private final int ERROR = 3;
    private int state_ = 0;

    private synchronized void _setState(int newstate) {
        this.state_ = newstate;
    }

    private synchronized int _getState() {
        return this.state_;
    }

    public void doTimerTask() throws RuntimeError {
        switch (this._getState()) {
            case 3: {
                this.receiver_.receiveOutputReady("GrammarSubModule", "error");
                String err = this.transformErrors_;
                this.transformErrors_ = "";
                this._setState(0);
                this.logger_.fatalError(err);
                throw new RuntimeError(err);
            }
            case 2: {
                this.receiver_.receiveOutputReady("GrammarSubModule", "done");
                this._setState(0);
            }
        }
    }

    public boolean startOutput(OutItem item) {
        if (!(item instanceof GrammarOutItem)) {
            return false;
        }
        GrammarOutItem g = (GrammarOutItem)item;
        this.document_ = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + g.getDocument();
        this.location_ = g.getLocation();
        this.receiver_.receiveOutputBusy("GrammarSubModule", "started");
        while (this._getState() != 0) {
            try {
                this.dbg.print("wait until STOPPED");
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.dbg.print("startOutput(" + this.location_ + ") " + this.document_);
        Thread th = new Thread(new Runnable(){

            public void run() {
                GrammarTransformer gt = new GrammarTransformer();
                if (!gt.doTransform(GrammarSubModule.this.document_, GrammarSubModule.this.location_)) {
                    GrammarSubModule.this.transformErrors_ = "doTransform " + GrammarSubModule.this.location_ + "\n" + "[stderr]\n" + gt.getErrors() + "[stdout]\n" + gt.getOutputs();
                    GrammarSubModule.this._setState(3);
                } else {
                    GrammarSubModule.this.transformErrors_ = "";
                    GrammarSubModule.this._setState(2);
                }
            }
        });
        th.start();
        return true;
    }

    public boolean stopOutput(OutItem item) {
        if (!(item instanceof GrammarOutItem)) {
            return false;
        }
        this._setState(2);
        return true;
    }
}

