/*
 * Decompiled with CFR 0.152.
 */
package galatea.recogman;

import galatea.util.Logger;
import galatea.util.Property;
import galatea.util.SubProcess;
import galatea.util.Util;

public class JulianServerRunner {
    private Logger dbg = new Logger("JulianServer", 0);
    private String errors_ = "";
    private String outputs_ = "";
    private String exception_ = "";
    private SubProcess subProcess_;
    private String command_ = "C:/work/galatea4win/engine/SRM/bin/julian.exe";
    private String config_ = "-C ../jconf-default.txt";
    private String dirpath_ = "C:/work/galatea4win/engine/SRM/test";
    private boolean running_ = false;

    public JulianServerRunner() {
        if (Util.isWindows()) {
            this.dirpath_ = Property.getAsStr("JuliusServerRunner.Dir.Windows", "");
            this.command_ = Property.getAsStr("JuliusServerRunner.Exe.Windows", "");
            this.config_ = Property.getAsStr("JuliusServerRunner.Arg.Windows", "");
        } else {
            this.dirpath_ = Property.getAsStr("JuliusServerRunner.Dir", "");
            this.command_ = Property.getAsStr("JuliusServerRunner.Exe", "");
            this.config_ = Property.getAsStr("JuliusServerRunner.Arg", "");
        }
    }

    public static void main(String[] args) {
        JulianServerRunner runner = new JulianServerRunner();
        runner.run();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("shutdown hook");
                JulianServerRunner.this.setRunning(false);
            }
        });
        while (runner.isRunning()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (runner.hasErrors()) {
                System.out.print("[E] " + runner.getErrors());
                runner.clearErrors();
            }
            if (runner.hasOutputs()) {
                System.out.print("[O] " + runner.getOutputs());
                runner.clearOutputs();
            }
            System.out.flush();
        }
    }

    public boolean hasOutputs() {
        return this.outputs_.length() > 0;
    }

    public boolean hasErrors() {
        return this.errors_.length() > 0;
    }

    public boolean isRunning() {
        return this.running_;
    }

    public void setRunning(boolean b) {
        this.running_ = b;
    }

    public boolean run() {
        this.subProcess_ = new SubProcess(String.valueOf(this.command_) + " " + this.config_);
        if (this.subProcess_ == null) {
            return false;
        }
        this.dbg.print("starting..");
        if (!this.subProcess_.run(this.dirpath_)) {
            this.dbg.print(this.subProcess_.getError());
            return false;
        }
        this.dbg.print("started.");
        this.errors_ = "";
        this.outputs_ = "";
        this.exception_ = "";
        Thread th = new Thread(new Runnable(){

            public void run() {
                while (JulianServerRunner.this.running_) {
                    String out;
                    String er = JulianServerRunner.this.subProcess_.receiveFromStderrNB();
                    if (er.length() > 0) {
                        JulianServerRunner julianServerRunner = JulianServerRunner.this;
                        julianServerRunner.errors_ = String.valueOf(julianServerRunner.errors_) + er + "\n";
                    }
                    if ((out = JulianServerRunner.this.subProcess_.receiveFromStdoutNB()).length() > 0) {
                        JulianServerRunner julianServerRunner = JulianServerRunner.this;
                        julianServerRunner.outputs_ = String.valueOf(julianServerRunner.outputs_) + out + "\n";
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                JulianServerRunner.this.subProcess_.destroy();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        this.running_ = true;
        th.start();
        return true;
    }

    public String getErrors() {
        return this.errors_;
    }

    public String getOutputs() {
        return this.outputs_;
    }

    public String getException() {
        return this.exception_;
    }

    public void clearErrors() {
        this.errors_ = "";
    }

    public void clearOutputs() {
        this.outputs_ = "";
    }

    public void destroy() {
        this.subProcess_.destroy();
    }
}

