/*
 * Decompiled with CFR 0.152.
 */
package galatea.relaxer.pdoc;

import galatea.relaxer.pdoc.PdocBody;
import galatea.relaxer.pdoc.RStack;
import galatea.relaxer.pdoc.UJAXP;
import galatea.relaxer.pdoc.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PdocPdoc
implements Serializable,
Cloneable {
    private float version_;
    private String head_;
    private PdocBody body_;

    public PdocPdoc() {
    }

    public PdocPdoc(PdocPdoc source) {
        this.setup(source);
    }

    public PdocPdoc(RStack stack) {
        this.setup(stack);
    }

    public PdocPdoc(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PdocPdoc(Element element) {
        this.setup(element);
    }

    public PdocPdoc(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocPdoc(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PdocPdoc(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PdocPdoc(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PdocPdoc(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PdocPdoc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocPdoc source) {
        this.version_ = source.version_;
        this.head_ = source.head_;
        if (source.body_ != null) {
            this.setBody((PdocBody)source.getBody().clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        this.head_ = URelaxer.getElementPropertyAsStringByStack(stack, "head");
        this.setBody(new PdocBody(stack));
    }

    public Object clone() {
        return new PdocPdoc(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("pdoc");
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        if (this.head_ != null) {
            URelaxer.setElementPropertyByString(element, "head", this.head_);
        }
        this.body_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public float getVersion() {
        return this.version_;
    }

    public void setVersion(float version) {
        this.version_ = version;
    }

    public String getHead() {
        return this.head_;
    }

    public void setHead(String head) {
        this.head_ = head;
    }

    public PdocBody getBody() {
        return this.body_;
    }

    public void setBody(PdocBody body) {
        this.body_ = body;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<pdoc");
        buffer.append(" version=\"");
        buffer.append(URelaxer.getString(this.getVersion()));
        buffer.append("\"");
        buffer.append(">");
        if (this.head_ != null) {
            buffer.append("<head>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getHead())));
            buffer.append("</head>");
        }
        this.body_.makeTextElement(buffer);
        buffer.append("</pdoc>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<pdoc");
        buffer.write(" version=\"");
        buffer.write(URelaxer.getString(this.getVersion()));
        buffer.write("\"");
        buffer.write(">");
        if (this.head_ != null) {
            buffer.write("<head>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getHead())));
            buffer.write("</head>");
        }
        this.body_.makeTextElement(buffer);
        buffer.write("</pdoc>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<pdoc");
        buffer.print(" version=\"");
        buffer.print(URelaxer.getString(this.getVersion()));
        buffer.print("\"");
        buffer.print(">");
        if (this.head_ != null) {
            buffer.print("<head>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getHead())));
            buffer.print("</head>");
        }
        this.body_.makeTextElement(buffer);
        buffer.print("</pdoc>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getVersionAsString() {
        return URelaxer.getString(this.getVersion());
    }

    public String getHeadAsString() {
        return URelaxer.getString(this.getHead());
    }

    public void setVersionByString(String string) {
        this.setVersion(Float.parseFloat(string));
    }

    public void setHeadByString(String string) {
        this.setHead(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "pdoc")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "version")) {
            return false;
        }
        $match$ = true;
        Element child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "head")) {
            target.popElement();
        }
        $match$ = true;
        if (!PdocBody.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocPdoc.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocPdoc.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

