/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

public class Logger {
    private int debuglevel;
    private static int count_ = 0;
    private String name_ = "DM";

    public Logger(String name, int defaultLevel) {
        String s = System.getProperty("Debug." + name);
        this.debuglevel = s == null ? defaultLevel : Integer.parseInt(s);
        this.name_ = name;
    }

    public Logger(String name) {
        String s = System.getProperty("Debug." + name);
        this.debuglevel = s == null ? 0 : Integer.parseInt(s);
        this.name_ = name;
    }

    public Logger() {
        this.debuglevel = 0;
    }

    public void setLevel(int level) {
        this.debuglevel = level;
    }

    public int getLevel() {
        return this.debuglevel;
    }

    public void doPrint(String msg) {
        System.err.println("[" + ++count_ + " " + this.name_ + " " + Thread.currentThread().getName() + "] " + msg);
    }

    public void print(String msg) {
        if (this.debuglevel != 0) {
            this.doPrint(msg);
        }
    }

    public void print(String msg, int level) {
        if (this.debuglevel >= level) {
            this.doPrint(msg);
        }
    }

    public void err(String msg) {
        if (this.debuglevel != 0) {
            System.err.println(msg);
        }
    }

    public void err(String msg, int level) {
        if (this.debuglevel >= level) {
            System.err.println(msg);
        }
    }

    public void DIE(Exception e) {
        if (this.debuglevel != 0) {
            System.err.println("DIE");
            System.exit(1);
        }
    }

    public void DIE(String msg) {
        if (this.debuglevel != 0) {
            System.err.println("DIE: " + msg);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bool, String msg) {
        if (this.debuglevel != 0 && !bool) {
            System.err.println("ASSERTION FAILED: " + msg);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bool, String msg, int level) {
        if (this.debuglevel >= level && !bool) {
            System.err.println("ASSERTION FAILED: " + msg);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        Logger dbg = new Logger("DM", 5);
        dbg.print("1: this is shown.", 4);
        dbg.print("2: this is shown.", 5);
        dbg.print("3: not shown.", 6);
        int a = 1;
        int b = 2;
        dbg.ASSERT(a == a, "4: not shown.");
        dbg.ASSERT(a == b, "5: this is shown.", 4);
        dbg.ASSERT(a == b, "6: not shown.", 5);
        dbg.ASSERT(a == b, "7: not shown.", 6);
    }
}

