/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import galatea.util.StringHashArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static String _error = "";

    private Util() {
    }

    public static void main(String[] args) throws Exception {
        String s = Util.resolveAdrs("http://aaa.bbb.com/index.vxml", "sub/next.vxml");
        System.out.println(s);
        s = Util.resolveAdrs("/lab/common/src/nishi/galatea/gdm-current/phoenix/", "../tests/audio/hoge.wav");
        System.out.println(s);
        s = Util.resolveAdrs("/lab/common/src/nishi/galatea/gdm-current/phoenix", "../tests/audio/hoge.wav");
        System.out.println(s);
        s = Util.resolveAdrs("file:C:/lab/common/src/nishi/galatea/gdm-current/phoenix.vxml", "../tests/audio/hoge.wav");
        System.out.println(s);
        s = Util.resolveAdrs("file:D:/lab/common/src/nishi/galatea/gdm-current/phoenix.vxml", "../tests/audio/hoge.wav");
        System.out.println(s);
    }

    public static String getError() {
        return _error;
    }

    public static String readURL(String filename) {
        _error = "";
        String buf = "";
        if (filename.startsWith("http:")) {
            try {
                String line;
                URL url = new URL(filename);
                HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                uc.setRequestMethod("GET");
                InputStreamReader isr = new InputStreamReader(uc.getInputStream());
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    buf = String.valueOf(buf) + line;
                }
                br.close();
                uc.disconnect();
            }
            catch (Exception e) {
                _error = e.toString();
            }
        } else {
            _error = "readURL() : unsupported function.";
        }
        return buf;
    }

    public static int saveURL(String src, String dest, Charset cs) {
        _error = "";
        int ret = 0;
        String content = Util.readURL(src);
        if (_error.equals("")) {
            try {
                Util.writeToFile(dest, content, cs);
            }
            catch (Exception e) {
                _error = e.toString();
                ret = 1;
            }
        } else {
            ret = 1;
        }
        return ret;
    }

    public static void saveUrlAsBinary(String filename, String dest) {
        _error = "";
        if (filename.startsWith("http:")) {
            try {
                int n;
                URL url = new URL(filename);
                HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                uc.setRequestMethod("GET");
                InputStream is = uc.getInputStream();
                FileOutputStream fos = new FileOutputStream(dest);
                int SIZE = 8196;
                byte[] buf = new byte[8196];
                while ((n = is.read(buf, 0, 8196)) != -1) {
                    fos.write(buf, 0, n);
                }
                fos.close();
                is.close();
                uc.disconnect();
            }
            catch (Exception e) {
                _error = e.toString();
            }
        } else {
            _error = "readURL() : unsupported function.";
        }
    }

    public static String mktemp() {
        return Util.mktemp("");
    }

    public static String mktemp(String suffix) {
        _error = "";
        String ret = "";
        String prefix = "galatea";
        try {
            File temp = File.createTempFile(prefix, suffix);
            temp.deleteOnExit();
            if (temp != null) {
                ret = temp.getAbsolutePath();
            }
        }
        catch (Exception e) {
            _error = e.toString();
        }
        return ret;
    }

    public static String getSuffix(String str) {
        int pos = str.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos);
    }

    public static void halt(String msg) {
        System.err.println(msg);
        while (true) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static String removeSpaces(String str) {
        StringBuffer retStr = new StringBuffer("");
        if (str == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(str, " \t\n\r");
        while (st.hasMoreTokens()) {
            retStr.append(st.nextToken());
        }
        if (retStr.length() == 0) {
            return "";
        }
        return retStr.toString();
    }

    public static String xmlSafeRemoveSpaces(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer retStr = new StringBuffer("");
        boolean inTag = false;
        StringTokenizer st = new StringTokenizer(str, " \t\n\r");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("<") && !token.equals("<")) {
                inTag = true;
            }
            if (token.endsWith(">")) {
                inTag = false;
            }
            retStr.append(token);
            if (!inTag) continue;
            retStr.append(" ");
        }
        if (retStr.length() == 0) {
            return "";
        }
        return retStr.toString();
    }

    public static String removeNewLines(String str) {
        StringBuffer retStr = new StringBuffer("");
        if (str == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(str, "\n\r");
        while (st.hasMoreTokens()) {
            retStr.append(st.nextToken());
        }
        if (retStr.length() == 0) {
            return "";
        }
        return retStr.toString();
    }

    public static String encodeXmlChars(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer t = new StringBuffer("");
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '<') {
                t.append("&lt;");
            } else if (ch == '>') {
                t.append("&gt;");
            } else if (ch == '&') {
                t.append("&amp;");
            } else {
                t.append(ch);
            }
            ++i;
        }
        return t.toString();
    }

    public static String decodeXmlChars(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        ret = ret.replaceAll("&lt;", "<");
        ret = ret.replaceAll("&gt;", ">");
        ret = ret.replaceAll("&amp;", "&");
        return ret;
    }

    public static String resolveAdrs(String base, String rel) {
        String prefix = "";
        if (base == null || rel == null) {
            return "";
        }
        if (base.endsWith("#") && rel.startsWith("#")) {
            return String.valueOf(base) + rel.replaceFirst("#", "");
        }
        if (base.startsWith("file:") && base.charAt(6) == ':') {
            prefix = base.substring(0, 7);
            base = base.substring(7);
        }
        String s = "";
        try {
            URI u1 = new URI(base);
            URI u2 = new URI(rel);
            URI u3 = u1.resolve(u2);
            s = u3.toString();
        }
        catch (URISyntaxException e) {
            s = "error:resolveAdrs(base=" + base + " rel=" + rel + ")";
        }
        return String.valueOf(prefix) + s;
    }

    public static String getUriFragment(String uri) {
        String fragment = Util.getFirstGroup("^[^#]+#(.*)$", uri);
        if (fragment == null) {
            return "";
        }
        return fragment;
    }

    public static String getUriWithoutFragment(String uri) {
        String path = Util.getFirstGroup("^([^#]+)#.*$", uri);
        if (path == null) {
            return uri;
        }
        return path;
    }

    public static String getFileNameFromRequest(String str) {
        String f = Util.getFirstGroup("^([^\\?]+)\\?.*$", str);
        if (f == null) {
            return str;
        }
        return f;
    }

    public static StringHashArray getQueryFromRequest(String str) {
        StringHashArray ha = new StringHashArray();
        String f = Util.getFirstGroup("^[^\\?]+\\?(.*)$", str);
        if (f == null) {
            return ha;
        }
        String[] items = f.split("&");
        int i = 0;
        while (i < items.length) {
            String[] tmp = items[i].split("=");
            if (tmp.length == 2) {
                ha.set(tmp[0], tmp[1]);
            }
            ++i;
        }
        return ha;
    }

    public static String getFirstGroup(String pat, String str) {
        Pattern p = Pattern.compile(pat);
        Matcher m = p.matcher(str);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static boolean isSameFile(String f1, String f2) {
        boolean b = false;
        try {
            URI u1 = new URI(f1);
            URI u2 = new URI(f2);
            URI u3 = new URI(u1.getScheme(), u1.getUserInfo(), u1.getHost(), u1.getPort(), u1.getPath(), u1.getQuery(), u2.getFragment());
            if (u2.equals(u3)) {
                b = true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return b;
    }

    public static void writeToFile(String file, String content, Charset cs) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, cs);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(content);
        bw.close();
        osw.close();
        fos.close();
    }

    public static String loadFromFile(String file, Charset cs) throws Exception {
        String line;
        String content = "";
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, cs);
        BufferedReader reader = new BufferedReader(isr);
        while ((line = reader.readLine()) != null) {
            content = String.valueOf(content) + line;
            content = String.valueOf(content) + "\n";
        }
        reader.close();
        isr.close();
        fis.close();
        return content;
    }

    public static ArrayList makeTokenizedList(String src, String delim) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(src, delim, false);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v;
    }

    public static String removeTags(String str) {
        String s = str.replaceAll("<[^>]*>", "");
        return s;
    }

    public static String getStringHead(String str) {
        if ((str = Util.removeNewLines(str)).length() > 40) {
            str = String.valueOf(str.substring(0, 40)) + "...";
        }
        return str;
    }

    public static String getDocumentFromTemplate(String html, StringHashArray replaces) {
        String ret = html;
        int i = 0;
        while (i < replaces.size()) {
            String key = replaces.getKey(i);
            String val = replaces.getAsString(i);
            ret = Util.replaceAll(ret, key, val);
            ++i;
        }
        return ret;
    }

    public static String replaceAll(String src, String key, String val) {
        String ret = "";
        int pos = 0;
        while (pos < src.length()) {
            int found = -1;
            found = src.indexOf(key, pos);
            if (found < 0) {
                ret = String.valueOf(ret) + src.substring(pos);
                break;
            }
            ret = String.valueOf(ret) + src.substring(pos, found);
            ret = String.valueOf(ret) + val;
            pos = found + key.length();
        }
        return ret;
    }

    public static String readInputStream(InputStream is, Charset cs) {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, cs));
        String buf = "";
        while (true) {
            String line = null;
            try {
                line = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (line == null) break;
            buf = String.valueOf(buf) + line;
            buf = String.valueOf(buf) + "\n";
        }
        try {
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buf;
    }

    public static long getCurrentTimeInMillis() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public static Charset getSystemDefaultCharset() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        Charset charset = Charset.forName("UTF-8");
        if (osName.startsWith("Windows") && osArch.equalsIgnoreCase("x86")) {
            charset = Charset.forName("Shift_JIS");
        }
        if (osName.equals("Linux") && osArch.equalsIgnoreCase("i386")) {
            charset = Charset.forName("EUC-JP");
        }
        return charset;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }

    public static boolean isLinux() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Linux");
    }
}

