#!/usr/bin/ruby
#
# (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
#
# $Id: MON.rb,v 1.2 2006/11/13 02:32:50 nishi Exp $
#
# Galatea Monitor
#
# to @MON set SysLogText = message
# to @MON set AppLogText = message
# to @MON set Run = EXIT

$revision = '$Revision: 1.2 $'

$tk_thread_safe = TRUE
require 'tk'

# -------------

menubar = TkFrame.new {
  relief 'raised'
  borderwidth 1
  pack('fill' => 'x')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "File"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Clear Logs', 'command' => proc{
      $syslog.delete '1.0', 'end'
      $syslog.insert 'end', "[SysLog]\n"
      $applog.delete '1.0', 'end'
      $applog.insert 'end', "[AppLog]\n"
      $start_day = Time.now.to_f
    }
    add 'command', 'label' => 'Save Syslog', 'command' => proc{
      filename = Tk.getSaveFile
      if filename != "" then
	puts "syslog filename: " + filename; STDOUT.flush
	textdata = $syslog.get('1.0', 'end')
	file = open( filename, "w" )
	file.print( textdata )
	file.close
      end
    }
    add 'command', 'label' => 'Save Applog', 'command' => proc{
      filename = Tk.getSaveFile
      if filename != "" then
	puts "applog filename: " + filename; STDOUT.flush
        textdata = $applog.get('1.0', 'end')
        file = open( filename, "w" )
        file.print( textdata )
        file.close
      end
    }
#   add 'command', 'label' => 'Exit', 'command' => proc{exit}
#   add 'command', 'label' => 'AM Quit', 'command' => proc{
#     puts "AM quit"; STDOUT.flush
#     system "./fin"
#   }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "Bg"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'bg1', 'command' => proc{
      puts "to \@FSM set Background = bg1"; STDOUT.flush
    }
    add 'command', 'label' => 'bg2', 'command' => proc{
      puts "to \@FSM set Background = bg2"; STDOUT.flush
    }
    add 'command', 'label' => 'bg3', 'command' => proc{
      puts "to \@FSM set Background = bg3"; STDOUT.flush
    }
    add 'command', 'label' => 'bg4', 'command' => proc{
      puts "to \@FSM set Background = bg4"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "Mask"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'man01', 'command' => proc{
      puts "to \@FSM set Mask = man01"; STDOUT.flush
    }
    add 'command', 'label' => 'man02', 'command' => proc{
      puts "to \@FSM set Mask = man02"; STDOUT.flush
    }
    add 'command', 'label' => 'woman01', 'command' => proc{
      puts "to \@FSM set Mask = woman01"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "Speaker"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'male01', 'command' => proc{
      puts "to \@SSM set Speaker = male01"; STDOUT.flush
    }
    add 'command', 'label' => 'male02', 'command' => proc{
      puts "to \@SSM set Speaker = male02"; STDOUT.flush
    }
    add 'command', 'label' => 'female01', 'command' => proc{
      puts "to \@SSM set Speaker = female01"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "Auto"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'AutoBlink OFF', 'command' => proc{
      puts "to \@FSM set Autonomous = BLINK 0"; STDOUT.flush
    }
    add 'command', 'label' => 'AutoBlink ON', 'command' => proc{
      puts "to \@FSM set Autonomous = BLINK 1"; STDOUT.flush
    }
    add 'command', 'label' => 'AutoMove OFF', 'command' => proc{
      puts "to \@FSM set Autonomous = MOVE 0"; STDOUT.flush
    }
    add 'command', 'label' => 'AutoMove ON', 'command' => proc{
      puts "to \@FSM set Autonomous = MOVE 1"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "FaceExp"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Neutral', 'command' => proc{
      puts "to \@FSM set FaceExp = NEUTRAL"; STDOUT.flush
    }
    add 'command', 'label' => 'Happy', 'command' => proc{
      puts "to \@FSM set FaceExp = HAPPY 1 100 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Disgusted', 'command' => proc{
      puts "to \@FSM set FaceExp = DISGUSTED 1 100 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Sad', 'command' => proc{
      puts "to \@FSM set FaceExp = SAD 1 100 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Angry', 'command' => proc{
      puts "to \@FSM set FaceExp = ANGRY 1 100 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Surprised', 'command' => proc{
      puts "to \@FSM set FaceExp = SURPRISED 1 100 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Feared', 'command' => proc{
      puts "to \@FSM set FaceExp = FEARED 1 100 0"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "HeadRot"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Left', 'command' => proc{
      puts "to \@FSM set HeadRotAbs.1 = 0 -10 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Center', 'command' => proc{
      puts "to \@FSM set HeadRotAbs.1 = 0 0 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Right', 'command' => proc{
      puts "to \@FSM set HeadRotAbs.1 = 0 10 0"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "EyeRot"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Left', 'command' => proc{
      puts "to \@FSM set EyeRot = 0 -10 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Center', 'command' => proc{
      puts "to \@FSM set EyeRot = 0 0 0"; STDOUT.flush
    }
    add 'command', 'label' => 'Right', 'command' => proc{
      puts "to \@FSM set EyeRot = 0 10 0"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "FaceMot"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Blink', 'command' => proc{
      puts "to \@FSM set FaceMot = BLINK 1"; STDOUT.flush
    }
    add 'command', 'label' => 'Nod', 'command' => proc{
      puts "to \@FSM set FaceMot = NOD 1"; STDOUT.flush
    }
    add 'command', 'label' => 'Refuse', 'command' => proc{
      puts "to \@FSM set FaceMot = REFUSE 1"; STDOUT.flush
    }
    add 'command', 'label' => 'Listen', 'command' => proc{
      puts "to \@FSM set FaceMot = LISTEN 1"; STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

TkMenubutton.new(menubar) { |mb|
  text "Demo"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Say Hello', 'command' => proc{
      puts "to \@AM-MCL set Speak = こんにちは。"; STDOUT.flush
    }
    add 'command', 'label' => 'Say Bye', 'command' => proc{
      puts "to \@AM-MCL set Speak = さようなら。"; STDOUT.flush
    }
    add 'command', 'label' => 'Use PAR', 'command' => proc{
      puts 'to @PAR set Init = 1'
      puts 'to @PAR set Cmd = sleep 1.0'
      puts 'to @PAR set Cmd = to @FSM set FaceExp = HAPPY 1 100 1000'
      puts 'to @PAR set Cmd = sleep 1.4'
      puts 'to @PAR set Cmd = to @FSM set FaceExp = SAD 1 100 1000'
      puts 'to @PAR set Cmd = sleep 2.0'
      puts 'to @PAR set Cmd = to @FSM set FaceMot = NOD 1'
      puts 'to @AM-MCL set Speak = 私には、うれしいことも、悲しいことも、いろいろあります。'
      STDOUT.flush
    }
    add 'command', 'label' => 'Use SND', 'command' => proc{
      puts "to \@SND set Play = /usr/share/sndconfig/sample.au"
      STDOUT.flush
    }
  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

$test_grammar = '<grammar version="1.0"><rule id="S"> <ruleref uri="ROOT"></ruleref></rule><rule id="ROOT"> <ruleref uri="NS_B"></ruleref> <ruleref uri="SENTENCE"></ruleref> <ruleref uri="NS_E"></ruleref></rule><rule id="NS_B"><token phoneme="silB;">silB</token></rule><rule id="NS_E"><token phoneme="silE;">silE</token></rule><rule id="SENTENCE"> <ruleref uri="HELP1"></ruleref> </rule><rule id="HELP1"><token phoneme="h;e;r;u;p;u;">HELP</token></rule><rule id="ROOT"> <ruleref uri="NS_B"></ruleref> <ruleref uri="PRE"></ruleref> <ruleref uri="SP"></ruleref> <ruleref uri="SENTENCE"></ruleref> <ruleref uri="NS_E"></ruleref></rule><rule id="ROOT"> <ruleref uri="NS_B"></ruleref> <ruleref uri="PRE"></ruleref> <ruleref uri="SP"></ruleref> <ruleref uri="SENTENCE"></ruleref> <ruleref uri="POST"></ruleref> <ruleref uri="NS_E"></ruleref></rule><rule id="SP"><token phoneme="sp;">sp</token></rule><rule id="PRE"> <ruleref uri="PRE1"></ruleref> </rule><rule id="PRE1"><token phoneme="a:;">あー:</token></rule><rule id="POST"> <ruleref uri="POST1"></ruleref> </rule><rule id="POST1"><token phoneme="d;e;s;">です:</token></rule><rule id="g1"> <token phoneme="h;a;i;" sym="はい">はい</token> </rule><rule id="SENTENCE"><ruleref uri="g1"></ruleref></rule><rule id="g2"> <token phoneme="i:;e;" sym="いいえ">いいえ</token> </rule><rule id="SENTENCE"><ruleref uri="g2"></ruleref></rule><rule id="rule_coffee"> <token phoneme="k;o:;h;i:;" sym="こーひー">コーヒー</token> </rule><rule id="SENTENCE"><ruleref uri="rule_coffee"></ruleref></rule><rule id="rule_tea"> <token phoneme="k;o:;ch;a;" sym="こうちゃ">紅茶</token> </rule><rule id="SENTENCE"><ruleref uri="rule_tea"></ruleref></rule></grammar>'

TkMenubutton.new(menubar) { |mb|
  text "SRM"
  menu TkMenu.new(mb) {
    add 'command', 'label' => 'Start', 'command' => proc{
      puts "to \@SIM set SRM_Recog = START"
      STDOUT.flush
    }

    add 'command', 'label' => 'XML renraku', 'command' => proc{
      puts "to \@SIM set SRM_XML_File = GramXML/renraku/renraku.xml"
      STDOUT.flush
      # 発話「甲斐さんの連絡先を教えて下さい」
    }
    add 'command', 'label' => 'XML string', 'command' => proc{
      puts "to \@SIM set SRM_XML_String = " + $test_grammar
      STDOUT.flush
      # 発話「はい」
    }
    add 'command', 'label' => 'Julian vfr', 'command' => proc{
      puts "to \@SIM set SRM_Julian = GramJulian/vfr/vfr"
      STDOUT.flush
      # 発話「上着を白にしてください」
    }
    add 'command', 'label' => 'Julian name', 'command' => proc{
      puts "to \@SIM set SRM_Julian = GramJulian/attendant/name"
      STDOUT.flush
      # 発話「小泉さんお願いします」
    }

    add 'command', 'label' => 'Pause', 'command' => proc{
      puts "to \@SRM set Run = PAUSE"
      STDOUT.flush
    }
    add 'command', 'label' => 'Resume', 'command' => proc{
      puts "to \@SRM set Run = RESUME"
      STDOUT.flush
    }
    add 'command', 'label' => 'Stop', 'command' => proc{
      puts "to \@SRM set Run = STOP"
      STDOUT.flush
    }

#    add 'command', 'label' => 'INIT', 'command' => proc{
#      puts "to \@SRM set Run = INIT"
#      STDOUT.flush
#    }
#    add 'command', 'label' => 'START', 'command' => proc{
#      puts "to \@SRM set Run = START"
#      STDOUT.flush
#    }
#    add 'command', 'label' => 'Set vfr', 'command' => proc{
#      puts "to \@SRM set Grammar = GramJulian/vfr/vfr.dfa"
#      puts "to \@SRM set Dic = GramJulian/vfr/vfr.dict"
#      STDOUT.flush
#    }
#    add 'command', 'label' => 'Set name', 'command' => proc{
#      puts "to \@SRM set Grammar = GramJulian/attendant/name.dfa"
#      puts "to \@SRM set Dic = GramJulian/attendant/name.dict"
#      STDOUT.flush
#    }
#    add 'command', 'label' => 'Set renraku.xml', 'command' => proc{
#      puts "to \@SRM set Grammar = GramXML/renraku/renraku.xml"
#      STDOUT.flush
#    }

  }
  pack('side' => 'left', 'padx' => '1m')
}

# -------------

frame_toolbar = TkFrame.new {
  pack('fill' => 'x')
}

#TkButton.new(frame_toolbar) {
#  text 'Save AppLog'
#  command proc{
#    filename = Tk.getSaveFile
#    if filename != "" then
#      puts "applog filename: " + filename; STDOUT.flush
#      textdata = $applog.get('1.0', 'end')
#      file = open( filename, "w" )
#      file.print( textdata )
#      file.close
#    end
#  }
#  pack('side' => 'left')
#}

# -------------

$syslog = nil
$applog = nil
$start_day = Time.now.to_f

Thread.start {
  while gets

    if /^set\s+SysLogText\s+=\s+(.*)$/ =~ $_ then
      str = $1
      unless $syslog.nil? then
	day = Time.now
	ds = day.strftime("%M:%S ") + "%.3f" % (day.to_f - $start_day)
	$syslog.insert 'end', format("%s %s\n", ds, str) 
	$syslog.yview 100
      end
    end 

    if /^set\s+AppLogText\s+=\s+(.*)$/ =~ $_ then
      str = $1
      unless $applog.nil? then
	day = Time.now
	ds = day.strftime("%M:%S ") + "%.3f" % (day.to_f - $start_day)
	$applog.insert 'end', format("%s %s\n", ds, str) 
	$applog.yview 100
      end
    end 

    if /^set\s+Run\s+=\s+EXIT$/ then
      Process.exit!(0)
    end

  end
}

# -------------

frame1 = TkFrame.new { 
  pack('side'=>'top', 'fill'=>'both', 'expand'=>'true') 
}

$bar1 = TkScrollbar.new(frame1) {
  pack('side'=>'right', 'fill'=>'y')
  command proc { |args| $syslog.yview(*args) }
}
$syslog = TkText.new(frame1) {
#  width 80
  height 10
  wrap 'none'
  pack('side'=>'left', 'fill'=>'both', 'expand'=>'true')
  yscrollcommand proc { |first, last| $bar1.set(first, last) }
  insert 'end', "[SysLog]\n"
}

# -------------

frame2 = TkFrame.new { 
  pack('side'=>'top', 'fill'=>'both', 'expand'=>'true') 
}

$bar2 = TkScrollbar.new(frame2) {
  pack('side'=>'right', 'fill'=>'y')
  command proc { |args| $applog.yview(*args) }
}
$applog = TkText.new(frame2) {
#  width 80
  height 10
  wrap 'none'
  pack('side'=>'left', 'fill'=>'both', 'expand'=>'true')
  yscrollcommand proc { |first, last| $bar2.set(first, last) }
  insert 'end', "[AppLog]\n"
}

# -------------

Tk.root.title("Galatea Monitor 1.0 "+$revision)
Tk.mainloop

# end of file
