#!/usr/bin/perl
## (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
##
##  $Id: drink.cgi,v 1.1 2006/11/24 08:57:54 nishi Exp $
##
##  drink2.cgi: VoiceXML CGI script 
##  2001/07 by nishi@vox.dj.kit.ac.jp
##  2003/06 modified by nishi@hil.t.u-tokyo.ac.jp
##
##  This file is written in EUC.

require './cgi-lib.pl';
require './jcode.pl';

&ReadParse;
$drink = $in{'drink'};

if ($drink eq 'coffee' ) {
  $price = 400;
  $drink_jp = 'コーヒー';
} elsif ($drink eq 'tea' ) {
  $price = 450;
  $drink_jp = '紅茶';
} elsif ($drink eq 'milk' ) {
  $price = 300;
  $drink_jp = 'ミルク';
} else {
  $price = 0;
}

print "Content-Type:text/xml\n\n";
print "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
print "<vxml version=\"1.0\">\n";
print "<form>\n";
if ($price != 0) {
    print "    <block>\n";
    print "        $drink_jpですね。$price円です。\n";
    print "    </block>\n";
}
print "    <var name=\"dummy\" expr=\"1\"/>\n";
print "    <field name=\"drink\">\n";
print "      <prompt>\n";
print "        コーヒー、紅茶、ミルクのうちどれが良いですか?\n";
print "      </prompt>\n";
print "      <grammar>\n";
print "       <rule> <token sym=\"こーひー\">coffee</token> </rule>\n";
print "       <rule> <token sym=\"こうちゃ\">tea</token> </rule>\n";
print "       <rule> <token sym=\"みるく\">milk</token> </rule>\n";
print "       <rule> <token sym=\"ぎゅうにゅう\">milk</token> </rule>\n";
print "      </grammar>\n";
print "    </field>\n";
print "    <block>\n";
print "      <submit next=\"drink.cgi\" namelist=\"drink dummy\"/>\n";
print "    </block>\n";
print "  </form>\n";
print "</vxml>\n";

# end of file
