/*
 * $Id: GalateaBase.java,v 1.3 2006/11/17 05:07:41 nishi Exp $
 *
 * Galatea Submodule base class
 * by Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 */

package galatea.agent;

import galatea.util.AMBuffer;
import galatea.util.StringHashArray;
import galatea.util.Util;

import java.util.regex.*;
import java.nio.charset.Charset;
import java.text.DecimalFormat;


public class GalateaBase
{
	protected String modulename_;
	protected boolean debug_ = false;
	protected StringHashArray myslot_;
	protected StringHashArray myprop_;
	
	private AMBuffer ambuf_;
	private DecimalFormat intFormatter_ = new DecimalFormat("0");
//	private DecimalFormat doubleFormatter_ = new DecimalFormat("0.000");
	
	public GalateaBase()
	{
		ambuf_ = new AMBuffer(Util.getSystemDefaultCharset()); 
		modulename_ = "GalateaBase";
		myslot_ = new StringHashArray();
		myslot_.set("Run","DEAD");
		myslot_.set("ProtocolVersion", "ProtocolVersion 1.0");
		myslot_.set("ModuleVersion", "ModuleVersion 1.0");
		myprop_ = new StringHashArray();
	}
	
	private String _format(int i)
	{
		return intFormatter_.format(i);
	}
	
//	private String _format(double d)
//	{
//		return doubleFormatter_.format(d);
//	}
	
	public void sendSet(String mod, String slot, String str)
	{
		String s = "to @" + mod + " set " + slot + " = " + str;
		ambuf_.send(s);
	}
	
	public void sendSet(String mod, String slot, int num)
	{
		String s = "to @" + mod + " set " + slot + " = " + _format(num);
		ambuf_.send(s);
	}
	
	public void printOut(String str)
	{
		ambuf_.send(str);
	}
	
	public void printDebug(String str)
	{
		if (debug_) {
			System.err.println(str);
			System.err.flush();
		}
	}
	
	public void printTell(String str)
	{
		ambuf_.send("tell " + str);
	}
	
	public void printRep(String str)
	{
		ambuf_.send("rep " + str);
	}
	
	public void doSet(String slot, String arg)
	{
		// overrided
	}
	
	public void doProp(String prop, String arg)
	{
		// overrided
	}
	
	public void acceptFrom(String mod, String str)
	{
		// overrided
	}
	
	public void acceptTo(String mod, String str)
	{
		// overrided
	}
	
	public void run()
	{
		Pattern p1 = Pattern.compile("^\\s*set\\s+([^\\s=]*)\\s*=\\s*(.*)$");
		Pattern p2 = Pattern.compile("^\\s*prop\\s+([^\\s=]*)\\s*=\\s*(.*)$");
		Pattern p3 = Pattern.compile("^\\s*inq\\s+(.*)$");
		Pattern p4 = Pattern.compile("^\\s*From\\s+\\@(\\S+)\\s(.*)$");
		Pattern p5 = Pattern.compile("^\\s*to\\s+\\@(\\S+)\\s(.*)$");
		Matcher m;
		while (true) {
			String s;
			while ((s = ambuf_.receive()).length() > 0) {
				if ((m = p1.matcher(s)).matches()) {
					myslot_.set(m.group(1), m.group(2));
					doSet(m.group(1), m.group(2));
					if (m.group(1).equals("Run")) {
						if (m.group(2).equals("INIT")) {
							myslot_.set("Run", "LIVE");
						} else if (m.group(2).equals("EXIT")) {
							myslot_.set("Run", "DEAD");
						}
					}
				} else if ((m = p2.matcher(s)).matches()) {
					myprop_.set(m.group(1), m.group(2));
					doProp(m.group(1), m.group(2));
				} else if ((m = p3.matcher(s)).matches()) {
					printRep(m.group(1) + " = " + myslot_.get(m.group(1)));
				} else if ((m = p4.matcher(s)).matches()) {
					acceptFrom(m.group(1), m.group(2));
				} else if ((m = p5.matcher(s)).matches()) {
					acceptTo(m.group(1), m.group(2));
				}
			}
			try {
				Thread.sleep(0,1);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	
	/**
	 * java -cp classes galatea.GalateaBase
	 */
	public static void main(String argv[])
	{
		GalateaBase gb = new GalateaBase();
		gb.run();
	}
	
}

/* end of file */
