/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: Command.java,v 1.3 2006/11/20 01:13:35 nishi Exp $
 */

package galatea.command;

import galatea.dialog.ICommandContext;
import galatea.dialog.RuntimeError;
import galatea.scripting.ECMAScript;
import galatea.util.Logger;
import galatea.util.Util;

public abstract class Command
{
	protected Logger dbg = new Logger("Command");
	
	protected ICommandContext interpreterContext_ = null;
	protected ECMAScript ecmascript_ = null;
	
	public void setContext(ICommandContext ic, ECMAScript sc)
	{
		interpreterContext_ = ic;
		ecmascript_ = sc;
	}
	
	private String condition_ = "true";
	
	public void setCondition(String s)
	{
		if (s == null) {
			condition_ = "true";
		}
		condition_ = s;
	}
	
	public String getConditionAsEncodedString()
	{
		return Util.encodeXmlChars(condition_);
	}
	
	public boolean hasCondition()
	{
		if (condition_ == null) 
			return false;
		return ! condition_.equals("true");
	}
	
	private String with_ = "";
	
	public void setWith(String s) {
		with_ = s;
	}
	public String getWith() {
		return with_;
	}
	
	public boolean evaluateCondition() throws RuntimeError
	{
		if (condition_ == null)
			return true;
		if (with_.length() > 0) {
			condition_ = "with(" + with_ + "){" + condition_ + "}";
		}
		
		String r = ecmascript_.evaluate(condition_); 
		boolean b = false;
		if (r.equals("true")) {
			b = true;
		}
		return b;
	}
	
	public String toString()
	{
		String s = "<command/>";
		return s;
	}
	
	public void execute() throws RuntimeError
	{
		dbg.print("Empty Command execute()");
	}
	
}
