/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: CompositeCommand.java,v 1.3 2006/11/20 01:13:35 nishi Exp $
 */

package galatea.command;

import galatea.dialog.RuntimeError;
import galatea.util.Logger;

import java.util.ArrayList;

public class CompositeCommand extends Command
{
	private Logger dbg = new Logger("CC");
	private ArrayList commands_ = null;
	
	public CompositeCommand(ArrayList v)
	{
		commands_ = v;
	}
	
	public CompositeCommand(ArrayList v, String cond)
	{
		commands_ = v;
		setCondition(cond);
	}
	
	public void setCommands(ArrayList v)
	{
		commands_ = v;
	}
	
	public ArrayList getCommands()
	{
		return commands_;
	}
	
	public void addCommand(Command c)
	{
		commands_.add(c);
	}
	
	public void addScriptCommand(String script)
	{
		commands_.add(new EvaluateCommand(script));
	}
	
	public void addScriptCommand(String script, String with)
	{
		commands_.add(new EvaluateCommand(script, with));
	}
	
	
	public String toString()
	{
		String s = "  <cmd";
		if (hasCondition()) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += ">\n";
		int n = commands_.size();
		for(int i=0; i<n; i++) {
			Command cmd = (Command)commands_.get(i);
			s += " " + cmd.toString();
			s += "\n";
		}
		s += "  </cmd>";
		return s;
	}
	
	public void execute() throws RuntimeError
	{
		if ( evaluateCondition() == true ) {
			dbg.print("CC:adding "+commands_.size()+" command(s).");
			interpreterContext_.insertCommandsTop(commands_);
		}
	}
}
