/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: EndCommand.java,v 1.2 2006/11/20 01:13:35 nishi Exp $
 */

package galatea.command;

import galatea.dialog.RuntimeError;
import galatea.util.Util;

public class EndCommand extends Command
{
	
	boolean now_;
	String next_;
	
	public EndCommand(boolean now)
	{
		now_ = now;
	}
	
	public EndCommand(String next, String cond)
	{
		next_ = next;
		setCondition(cond);
		now_ = false;
	}
	
	public EndCommand(String next, String cond, boolean now)
	{
		next_ = next;
		setCondition(cond);
		now_ = now;
	}
	
	public EndCommand()
	{
		now_ = false;
	}
	
	public boolean isNow()
	{
		return(now_);
	}
	
	
	public String toString()
	{
		String s = "  <end";
		if ( hasCondition() ) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += " now=\"" + now_ +"\"";
		if ( next_ != null && next_.length() > 0 ) {
			s += ">" + Util.encodeXmlChars(next_) + "</end>";
		} else {
			s += "/>";
		}
		return s;
	}
	
	
	public void execute() throws RuntimeError
	{
		interpreterContext_.setEndFlag(true);
		interpreterContext_.setEndImm(now_);
		if ( next_ != null ) {
			String nf = ecmascript_.evaluate(next_);
			interpreterContext_.setNextDocFile(nf);
		}
	}
	
}
