/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: InterpretedEvent.java,v 1.1 2006/11/20 01:13:35 nishi Exp $
 */
package galatea.dialog;

import galatea.io.DeviceEvent;
import galatea.io.DeviceEvent.State;
import galatea.io.DeviceEvent.Type;
import galatea.relaxer.event.EventEv;

import java.io.StringReader;


public class InterpretedEvent extends DeviceEvent {
	private InterpretedEvent(String str2) {
		super(Type.INPUT, State.READY, "input", str2);
	}

	public static InterpretedEvent newInstance(String src, String content) {
		String text = content;
		String script = "$utterance='" + content + "'";
		String xmlevent = 
			"<ev src=\"" + src + "\" type=\"INPUT\"><interpreted>"
			+"<text>" + text + "</text>"
			+"<script>" + script + "</script></interpreted></ev>";
		return new InterpretedEvent(xmlevent);
	}
	
	public static InterpretedEvent newInstance(
			String src, String text, String slot, String val) {
		String script = 
			"$utterance='" + text + "';" + slot + "='" + val + "';" 
			+ slot + "$.justfilled=true;";
		String xmlevent = 
			"<ev src=\"" + src + "\" type=\"INPUT\"><interpreted>"
			+"<text>" + text + "</text>"
			+"<script>" + script + "</script></interpreted></ev>";
		return new InterpretedEvent(xmlevent);
	}
	
	public static InterpretedEvent newInstance(String xmlevent) {
		return new InterpretedEvent(xmlevent);
	}
}
