/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: OutputEventQueueManager.java,v 1.1 2006/11/20 01:13:35 nishi Exp $
 */
package galatea.io;

import galatea.util.Logger;

import java.util.*;

public class OutputEventQueueManager            
{
	private Logger dbg = new Logger("EQM", 0);
	
	private ArrayList queue_; // ArrayList<DeviceEvent>
	
	public OutputEventQueueManager()
	{
		queue_ = new ArrayList();
	}
	
	public synchronized void discard()
	{
		queue_.clear();
	}
	
	public synchronized void enqueue(DeviceEvent o)
	{
		queue_.add((Object)o);
		dbg.print("EQM: added " + o.getClass().getName() 
				+ ", total:" + queue_.size() );
	}
	
	public synchronized DeviceEvent dequeue()  
	{
		DeviceEvent ret;
		
		if (queue_.isEmpty()) {
			return null;
		} else {
			ret = (DeviceEvent)queue_.remove(0);
			dbg.print("EQM: removed " + ret.getClass().getName() 
					+ ", total:" + queue_.size() );
			return ret;
		}
	}
	
}
