/*
 * $Id: JulianServerRunner.java,v 1.7 2007/01/15 03:16:37 nishi Exp $
 */
package galatea.recogman;

import galatea.util.Logger;
import galatea.util.Property;
import galatea.util.SubProcess;
import galatea.util.Util;

public class JulianServerRunner {
	
	private Logger dbg = new Logger("JulianServer", 0);
	
	private String errors_ = "";
	private String outputs_ = "";
	private String exception_ = "";
	private SubProcess subProcess_;
	
	// fullpath でないと Runtime.exec() error
	private String command_ = "C:/work/galatea4win/engine/SRM/bin/julian.exe";
	private String config_ = "-C ../jconf-default.txt";
	private String dirpath_ = "C:/work/galatea4win/engine/SRM/test";
	private boolean running_ = false;

	public JulianServerRunner() {
		super();
		if (Util.isWindows()) {
			dirpath_ = Property.getAsStr("JuliusServerRunner.Dir.Windows", "");
			command_ = Property.getAsStr("JuliusServerRunner.Exe.Windows", "");
			config_  = Property.getAsStr("JuliusServerRunner.Arg.Windows", "");
		} else {
			dirpath_ = Property.getAsStr("JuliusServerRunner.Dir", "");
			command_ = Property.getAsStr("JuliusServerRunner.Exe", "");
			config_  = Property.getAsStr("JuliusServerRunner.Arg", "");
		}
	}

	public static void main(String args[]) {
		final JulianServerRunner runner = new JulianServerRunner();
		runner.run();
		Runtime.getRuntime().addShutdownHook(new Thread() {
		    public void run() { 
				System.out.println("shutdown hook");
		    	runner.setRunning(false);
		    }
		});
		while (runner.isRunning()) {
			try {
				Thread.sleep(1);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			if (runner.hasErrors()) {
				System.out.print("[E] " + runner.getErrors());
				runner.clearErrors();
			}
			if (runner.hasOutputs()) {
				System.out.print("[O] " + runner.getOutputs());
				runner.clearOutputs();
			}
			System.out.flush();
		}
	}
	
	public boolean hasOutputs() {
		return outputs_.length() > 0;
	}

	public boolean hasErrors() {
		return errors_.length() > 0;
	}

	public boolean isRunning() {
		return running_;
	}

	public void setRunning(boolean b) {
		running_ = b;
	}

	public boolean run() {
		subProcess_ = new SubProcess(command_ + " " + config_);
		if (subProcess_ == null) {
			return false;
		}
    	dbg.print("starting..");
		if (subProcess_.run(dirpath_) == false) {
			dbg.print(subProcess_.getError());
	    	return false;
		}
		dbg.print("started.");
		errors_ = "";
		outputs_ = "";
		exception_ = "";
		Thread th = new Thread(new Runnable() {
			public void run() {
				while (running_) {
					String er = subProcess_.receiveFromStderrNB();
					if (er.length() > 0) {
						errors_ += er + "\n";
					}
					String out = subProcess_.receiveFromStdoutNB();
					if (out.length() > 0) {
						outputs_ += out + "\n";
					}
					try {
						Thread.sleep(1);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
				subProcess_.destroy();
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		});
		running_ = true;
		th.start();
		return true;
	}
	
	public String getErrors() {
		return errors_; 
	}

	public String getOutputs() {
		return outputs_; 
	}
	
	public String getException() {
		return exception_;
	}

	public void clearErrors() {
		errors_ = "";
	}
	
	public void clearOutputs() {
		outputs_ = "";
	}
	
	public void destroy() {
		subProcess_.destroy();
	}
	
}
