/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.event;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>EventSHYPO</b> is generated from event.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="SHYPO">
 *       <optional>
 *         <attribute name="GRAM">
 *           <data type="int"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="RANK">
 *           <data type="int"/>
 *         </attribute>
 *       </optional>
 *       <attribute name="SCORE">
 *         <data type="float"/>
 *       </attribute>
 *       <optional>
 *         <attribute name="PASS">
 *           <data type="int"/>
 *         </attribute>
 *       </optional>
 *       <oneOrMore>
 *         <ref name="WHYPO"/>
 *       </oneOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="SHYPO"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="GRAM"&gt;
 *           &lt;data type="int"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="RANK"&gt;
 *           &lt;data type="int"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;attribute name="SCORE"&gt;
 *         &lt;data type="float"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="PASS"&gt;
 *           &lt;data type="int"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;oneOrMore&gt;
 *         &lt;ref name="WHYPO"/&gt;
 *       &lt;/oneOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version event.rng (Tue Jul 06 15:45:52 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class EventSHYPO implements java.io.Serializable, Cloneable {
    private Integer GRAM_;
    private Integer RANK_;
    private float SCORE_;
    private Integer PASS_;
    // List<EventWHYPO>
    private java.util.List WHYPO_ = new java.util.ArrayList();

    /**
     * Creates a <code>EventSHYPO</code>.
     *
     */
    public EventSHYPO() {
    }

    /**
     * Creates a <code>EventSHYPO</code>.
     *
     * @param source
     */
    public EventSHYPO(EventSHYPO source) {
        setup(source);
    }

    /**
     * Creates a <code>EventSHYPO</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EventSHYPO(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EventSHYPO</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EventSHYPO(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EventSHYPO</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EventSHYPO(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EventSHYPO</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventSHYPO(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EventSHYPO</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventSHYPO(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EventSHYPO</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventSHYPO(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EventSHYPO</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventSHYPO(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EventSHYPO</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventSHYPO(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EventSHYPO</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventSHYPO(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the EventSHYPO <code>source</code>.
     *
     * @param source
     */
    public void setup(EventSHYPO source) {
        int size;
        GRAM_ = source.GRAM_;
        RANK_ = source.RANK_;
        SCORE_ = source.SCORE_;
        PASS_ = source.PASS_;
        this.WHYPO_.clear();
        size = source.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            addWHYPO((EventWHYPO)source.getWHYPO(i).clone());
        }
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        GRAM_ = URelaxer.getAttributePropertyAsIntObject(element, "GRAM");
        RANK_ = URelaxer.getAttributePropertyAsIntObject(element, "RANK");
        SCORE_ = URelaxer.getAttributePropertyAsFloat(element, "SCORE");
        PASS_ = URelaxer.getAttributePropertyAsIntObject(element, "PASS");
        WHYPO_.clear();
        while (true) {
            if (EventWHYPO.isMatch(stack)) {
                addWHYPO(new EventWHYPO(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new EventSHYPO((EventSHYPO)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("SHYPO");
        int size;
        if (this.GRAM_ != null) {
            URelaxer.setAttributePropertyByInt(element, "GRAM", this.GRAM_);
        }
        if (this.RANK_ != null) {
            URelaxer.setAttributePropertyByInt(element, "RANK", this.RANK_);
        }
        URelaxer.setAttributePropertyByFloat(element, "SCORE", this.SCORE_);
        if (this.PASS_ != null) {
            URelaxer.setAttributePropertyByInt(element, "PASS", this.PASS_);
        }
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EventSHYPO</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventSHYPO</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the int property <b>GRAM</b>.
     *
     * @return int
     */
    public int getGRAM() {
        if (GRAM_ == null) {
            return(-1);
        }
        return (GRAM_.intValue());
    }

    /**
     * Gets the int property <b>GRAM</b>.
     *
     * @param GRAM
     * @return int
     */
    public int getGRAM(int GRAM) {
        if (GRAM_ == null) {
            return(GRAM);
        }
        return (this.GRAM_.intValue());
    }

    /**
     * Gets the int property <b>GRAM</b>.
     *
     * @return Integer
     */
    public Integer getGRAMAsInteger() {
        return (GRAM_);
    }

    /**
     * Check the int property <b>GRAM</b>.
     *
     * @return boolean
     */
    public boolean checkGRAM() {
        return (GRAM_ != null);
    }

    /**
     * Sets the int property <b>GRAM</b>.
     *
     * @param GRAM
     */
    public void setGRAM(int GRAM) {
        this.GRAM_ = new Integer(GRAM);
    }

    /**
     * Sets the int property <b>GRAM</b>.
     *
     * @param GRAM
     */
    public void setGRAM(Integer GRAM) {
        this.GRAM_ = GRAM;
    }

    /**
     * Gets the int property <b>RANK</b>.
     *
     * @return int
     */
    public int getRANK() {
        if (RANK_ == null) {
            return(-1);
        }
        return (RANK_.intValue());
    }

    /**
     * Gets the int property <b>RANK</b>.
     *
     * @param RANK
     * @return int
     */
    public int getRANK(int RANK) {
        if (RANK_ == null) {
            return(RANK);
        }
        return (this.RANK_.intValue());
    }

    /**
     * Gets the int property <b>RANK</b>.
     *
     * @return Integer
     */
    public Integer getRANKAsInteger() {
        return (RANK_);
    }

    /**
     * Check the int property <b>RANK</b>.
     *
     * @return boolean
     */
    public boolean checkRANK() {
        return (RANK_ != null);
    }

    /**
     * Sets the int property <b>RANK</b>.
     *
     * @param RANK
     */
    public void setRANK(int RANK) {
        this.RANK_ = new Integer(RANK);
    }

    /**
     * Sets the int property <b>RANK</b>.
     *
     * @param RANK
     */
    public void setRANK(Integer RANK) {
        this.RANK_ = RANK;
    }

    /**
     * Gets the float property <b>SCORE</b>.
     *
     * @return float
     */
    public float getSCORE() {
        return (SCORE_);
    }

    /**
     * Sets the float property <b>SCORE</b>.
     *
     * @param SCORE
     */
    public void setSCORE(float SCORE) {
        this.SCORE_ = SCORE;
    }

    /**
     * Gets the int property <b>PASS</b>.
     *
     * @return int
     */
    public int getPASS() {
        if (PASS_ == null) {
            return(-1);
        }
        return (PASS_.intValue());
    }

    /**
     * Gets the int property <b>PASS</b>.
     *
     * @param PASS
     * @return int
     */
    public int getPASS(int PASS) {
        if (PASS_ == null) {
            return(PASS);
        }
        return (this.PASS_.intValue());
    }

    /**
     * Gets the int property <b>PASS</b>.
     *
     * @return Integer
     */
    public Integer getPASSAsInteger() {
        return (PASS_);
    }

    /**
     * Check the int property <b>PASS</b>.
     *
     * @return boolean
     */
    public boolean checkPASS() {
        return (PASS_ != null);
    }

    /**
     * Sets the int property <b>PASS</b>.
     *
     * @param PASS
     */
    public void setPASS(int PASS) {
        this.PASS_ = new Integer(PASS);
    }

    /**
     * Sets the int property <b>PASS</b>.
     *
     * @param PASS
     */
    public void setPASS(Integer PASS) {
        this.PASS_ = PASS;
    }

    /**
     * Gets the EventWHYPO property <b>WHYPO</b>.
     *
     * @return EventWHYPO[]
     */
    public EventWHYPO[] getWHYPO() {
        EventWHYPO[] array = new EventWHYPO[WHYPO_.size()];
        return ((EventWHYPO[])WHYPO_.toArray(array));
    }

    /**
     * Sets the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void setWHYPO(EventWHYPO[] WHYPO) {
        this.WHYPO_.clear();
        for (int i = 0;i < WHYPO.length;i++) {
            addWHYPO(WHYPO[i]);
        }
    }

    /**
     * Sets the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void setWHYPO(EventWHYPO WHYPO) {
        this.WHYPO_.clear();
        addWHYPO(WHYPO);
    }

    /**
     * Adds the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void addWHYPO(EventWHYPO WHYPO) {
        this.WHYPO_.add(WHYPO);
    }

    /**
     * Adds the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void addWHYPO(EventWHYPO[] WHYPO) {
        for (int i = 0;i < WHYPO.length;i++) {
            addWHYPO(WHYPO[i]);
        }
    }

    /**
     * Gets number of the EventWHYPO property <b>WHYPO</b>.
     *
     * @return int
     */
    public int sizeWHYPO() {
        return (WHYPO_.size());
    }

    /**
     * Gets the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     * @return EventWHYPO
     */
    public EventWHYPO getWHYPO(int index) {
        return ((EventWHYPO)WHYPO_.get(index));
    }

    /**
     * Sets the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     * @param WHYPO
     */
    public void setWHYPO(int index, EventWHYPO WHYPO) {
        this.WHYPO_.set(index, WHYPO);
    }

    /**
     * Adds the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     * @param WHYPO
     */
    public void addWHYPO(int index, EventWHYPO WHYPO) {
        this.WHYPO_.add(index, WHYPO);
    }

    /**
     * Remove the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     */
    public void removeWHYPO(int index) {
        this.WHYPO_.remove(index);
    }

    /**
     * Remove the EventWHYPO property <b>WHYPO</b> by object.
     *
     * @param WHYPO
     */
    public void removeWHYPO(EventWHYPO WHYPO) {
        this.WHYPO_.remove(WHYPO);
    }

    /**
     * Clear the EventWHYPO property <b>WHYPO</b>.
     *
     */
    public void clearWHYPO() {
        this.WHYPO_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<SHYPO");
        if (GRAM_ != null) {
            buffer.append(" GRAM=\"");
            buffer.append(URelaxer.getString(getGRAM()));
            buffer.append("\"");
        }
        if (RANK_ != null) {
            buffer.append(" RANK=\"");
            buffer.append(URelaxer.getString(getRANK()));
            buffer.append("\"");
        }
        buffer.append(" SCORE=\"");
        buffer.append(URelaxer.getString(getSCORE()));
        buffer.append("\"");
        if (PASS_ != null) {
            buffer.append(" PASS=\"");
            buffer.append(URelaxer.getString(getPASS()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</SHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<SHYPO");
        if (GRAM_ != null) {
            buffer.write(" GRAM=\"");
            buffer.write(URelaxer.getString(getGRAM()));
            buffer.write("\"");
        }
        if (RANK_ != null) {
            buffer.write(" RANK=\"");
            buffer.write(URelaxer.getString(getRANK()));
            buffer.write("\"");
        }
        buffer.write(" SCORE=\"");
        buffer.write(URelaxer.getString(getSCORE()));
        buffer.write("\"");
        if (PASS_ != null) {
            buffer.write(" PASS=\"");
            buffer.write(URelaxer.getString(getPASS()));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</SHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<SHYPO");
        if (GRAM_ != null) {
            buffer.print(" GRAM=\"");
            buffer.print(URelaxer.getString(getGRAM()));
            buffer.print("\"");
        }
        if (RANK_ != null) {
            buffer.print(" RANK=\"");
            buffer.print(URelaxer.getString(getRANK()));
            buffer.print("\"");
        }
        buffer.print(" SCORE=\"");
        buffer.print(URelaxer.getString(getSCORE()));
        buffer.print("\"");
        if (PASS_ != null) {
            buffer.print(" PASS=\"");
            buffer.print(URelaxer.getString(getPASS()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</SHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getGRAMAsString() {
        return (URelaxer.getString(getGRAM()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRANKAsString() {
        return (URelaxer.getString(getRANK()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSCOREAsString() {
        return (URelaxer.getString(getSCORE()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPASSAsString() {
        return (URelaxer.getString(getPASS()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setGRAMByString(String string) {
        setGRAM(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRANKByString(String string) {
        setRANK(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSCOREByString(String string) {
        setSCORE(Float.parseFloat(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPASSByString(String string) {
        setPASS(Integer.parseInt(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EventSHYPO</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "SHYPO")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "SCORE")) {
            return (false);
        }
        $match$ = true;
        if (!EventWHYPO.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!EventWHYPO.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventSHYPO</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventSHYPO</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
