/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlForm</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="form">
 *       <optional>
 *         <attribute name="id">
 *           <data type="ID"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="scope">
 *           <choice>
 *             <value type="NMTOKEN">document</value>
 *             <value type="NMTOKEN">dialog</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <zeroOrMore>
 *         <choice>
 *           <ref name="object"/>
 *           <ref name="subdialog"/>
 *           <ref name="link"/>
 *           <ref name="record"/>
 *           <zeroOrMore>
 *             <ref name="grammar"/>
 *           </zeroOrMore>
 *           <ref name="transfer"/>
 *           <ref name="script"/>
 *           <ref name="field"/>
 *           <ref name="initial"/>
 *           <ref name="catch"/>
 *           <ref name="help"/>
 *           <ref name="noinput"/>
 *           <ref name="error"/>
 *           <ref name="filled"/>
 *           <ref name="block"/>
 *           <ref name="nomatch"/>
 *           <ref name="property"/>
 *           <ref name="var"/>
 *         </choice>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="form"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="id"&gt;
 *           &lt;data type="ID"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="scope"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;document&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;dialog&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;choice&gt;
 *           &lt;ref name="object"/&gt;
 *           &lt;ref name="subdialog"/&gt;
 *           &lt;ref name="link"/&gt;
 *           &lt;ref name="record"/&gt;
 *           &lt;zeroOrMore&gt;
 *             &lt;ref name="grammar"/&gt;
 *           &lt;/zeroOrMore&gt;
 *           &lt;ref name="transfer"/&gt;
 *           &lt;ref name="script"/&gt;
 *           &lt;ref name="field"/&gt;
 *           &lt;ref name="initial"/&gt;
 *           &lt;ref name="catch"/&gt;
 *           &lt;ref name="help"/&gt;
 *           &lt;ref name="noinput"/&gt;
 *           &lt;ref name="error"/&gt;
 *           &lt;ref name="filled"/&gt;
 *           &lt;ref name="block"/&gt;
 *           &lt;ref name="nomatch"/&gt;
 *           &lt;ref name="property"/&gt;
 *           &lt;ref name="var"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:11 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlForm implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlVxmlChoice {
    public static final String SCOPE_DOCUMENT = "document";
    public static final String SCOPE_DIALOG = "dialog";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String id_;
    private String scope_;
    // List<IVxmlFormChoice>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlForm</code>.
     *
     */
    public VxmlForm() {
    }

    /**
     * Creates a <code>VxmlForm</code>.
     *
     * @param source
     */
    public VxmlForm(VxmlForm source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlForm</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlForm(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlForm</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlForm(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlForm</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlForm(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlForm</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlForm(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlForm</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlForm(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlForm</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlForm(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlForm</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlForm(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlForm</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlForm(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlForm</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlForm(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlForm</code> by the VxmlForm <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlForm source) {
        int size;
        id_ = source.id_;
        scope_ = source.scope_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlFormChoice)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlForm</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlForm</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlForm</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        scope_ = URelaxer.getAttributePropertyAsString(element, "scope");
        content_.clear();
        while (true) {
            if (VxmlObject.isMatch(stack)) {
                addContent(new VxmlObject(stack));
            } else if (VxmlSubdialog.isMatch(stack)) {
                addContent(new VxmlSubdialog(stack));
            } else if (VxmlRecord.isMatch(stack)) {
                addContent(new VxmlRecord(stack));
            } else if (VxmlLink.isMatch(stack)) {
                addContent(new VxmlLink(stack));
            } else if (VxmlTransfer.isMatch(stack)) {
                addContent(new VxmlTransfer(stack));
            } else if (VxmlGrammar.isMatch(stack)) {
                addContent(new VxmlGrammar(stack));
            } else if (VxmlScript.isMatch(stack)) {
                addContent(new VxmlScript(stack));
            } else if (VxmlField.isMatch(stack)) {
                addContent(new VxmlField(stack));
            } else if (VxmlBlock.isMatch(stack)) {
                addContent(new VxmlBlock(stack));
            } else if (VxmlCatch.isMatch(stack)) {
                addContent(new VxmlCatch(stack));
            } else if (VxmlError.isMatch(stack)) {
                addContent(new VxmlError(stack));
            } else if (VxmlHelp.isMatch(stack)) {
                addContent(new VxmlHelp(stack));
            } else if (VxmlNoinput.isMatch(stack)) {
                addContent(new VxmlNoinput(stack));
            } else if (VxmlFilled.isMatch(stack)) {
                addContent(new VxmlFilled(stack));
            } else if (VxmlNomatch.isMatch(stack)) {
                addContent(new VxmlNomatch(stack));
            } else if (VxmlProperty.isMatch(stack)) {
                addContent(new VxmlProperty(stack));
            } else if (VxmlVar.isMatch(stack)) {
                addContent(new VxmlVar(stack));
            } else if (VxmlInitial.isMatch(stack)) {
                addContent(new VxmlInitial(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlForm((VxmlForm)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "form");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }
        if (this.scope_ != null) {
            URelaxer.setAttributePropertyByString(element, "scope", this.scope_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlFormChoice value = (IVxmlFormChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlForm</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlForm</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlForm</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlForm</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlForm</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlForm</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public String getId() {
        return (id_);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
     * Gets the String property <b>scope</b>.
     *
     * @return String
     */
    public String getScope() {
        return (scope_);
    }

    /**
     * Sets the String property <b>scope</b>.
     *
     * @param scope
     */
    public void setScope(String scope) {
        this.scope_ = scope;
    }

    /**
     * Gets the IVxmlFormChoice property <b>content</b>.
     *
     * @return IVxmlFormChoice[]
     */
    public IVxmlFormChoice[] getContent() {
        IVxmlFormChoice[] array = new IVxmlFormChoice[content_.size()];
        return ((IVxmlFormChoice[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlFormChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlFormChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlFormChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlFormChoice content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlFormChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlFormChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlFormChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlFormChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlFormChoice property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlFormChoice property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlFormChoice
     */
    public IVxmlFormChoice getContent(int index) {
        return ((IVxmlFormChoice)content_.get(index));
    }

    /**
     * Sets the IVxmlFormChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlFormChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlFormChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlFormChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlFormChoice property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlFormChoice property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlFormChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlFormChoice property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "form", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (id_ != null) {
            buffer.append(" ");
            buffer.append("id");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }
        if (scope_ != null) {
            buffer.append(" ");
            buffer.append("scope");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getScope())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlFormChoice value = (IVxmlFormChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlFormChoice value = (IVxmlFormChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "form", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "form", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (id_ != null) {
            buffer.write(" ");
            buffer.write("id");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }
        if (scope_ != null) {
            buffer.write(" ");
            buffer.write("scope");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getScope())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlFormChoice value = (IVxmlFormChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlFormChoice value = (IVxmlFormChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "form", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "form", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (id_ != null) {
            buffer.print(" ");
            buffer.print("id");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }
        if (scope_ != null) {
            buffer.print(" ");
            buffer.print("scope");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getScope())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlFormChoice value = (IVxmlFormChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlFormChoice value = (IVxmlFormChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "form", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getScopeAsString() {
        return (URelaxer.getString(getScope()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setScopeByString(String string) {
        setScope(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlForm</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "form")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (VxmlObject.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSubdialog.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRecord.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLink.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlTransfer.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlGrammar.isMatchHungry(target)) {
                    $match$ = true;
            while (VxmlGrammar.isMatchHungry(target)) {
                }
            } else if (VxmlScript.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlField.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBlock.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlError.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlHelp.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNoinput.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlFilled.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNomatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProperty.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVar.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlInitial.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlForm</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlForm</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
