/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlItem</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="item">
 *       <optional>
 *         <attribute name="repeat">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="repeat-prob">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="weight">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <mixed>
 *         <zeroOrMore>
 *           <choice>
 *             <ref name="ruleref"/>
 *             <ref name="item"/>
 *             <ref name="token"/>
 *             <ref name="one-of"/>
 *             <ref name="tag"/>
 *           </choice>
 *         </zeroOrMore>
 *       </mixed>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="item"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="repeat"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="repeat-prob"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="weight"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;mixed&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;choice&gt;
 *             &lt;ref name="ruleref"/&gt;
 *             &lt;ref name="item"/&gt;
 *             &lt;ref name="token"/&gt;
 *             &lt;ref name="one-of"/&gt;
 *             &lt;ref name="tag"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/mixed&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:10 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlItem implements java.io.Serializable, Cloneable, IRNSContainer, IVxmlItemMixed, IVxmlItemMixedChoice, IRVisitable, IRNode, IVxmlRuleMixed, IVxmlRuleMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String repeat_;
    private String repeatProb_;
    private String weight_;
    // List<IVxmlItemMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlItem</code>.
     *
     */
    public VxmlItem() {
    }

    /**
     * Creates a <code>VxmlItem</code>.
     *
     * @param source
     */
    public VxmlItem(VxmlItem source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlItem</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlItem(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlItem</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlItem(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlItem</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlItem(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlItem</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlItem(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlItem</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlItem(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlItem</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlItem(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlItem</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlItem(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlItem</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlItem(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlItem</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlItem(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlItem</code> by the VxmlItem <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlItem source) {
        int size;
        repeat_ = source.repeat_;
        repeatProb_ = source.repeatProb_;
        weight_ = source.weight_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlItemMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlItem</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlItem</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlItem</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        repeat_ = URelaxer.getAttributePropertyAsString(element, "repeat");
        repeatProb_ = URelaxer.getAttributePropertyAsString(element, "repeat-prob");
        weight_ = URelaxer.getAttributePropertyAsString(element, "weight");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlRuleref.isMatch(stack)) {
                addContent(new VxmlRuleref(stack));
            } else if (VxmlToken.isMatch(stack)) {
                addContent(new VxmlToken(stack));
            } else if (VxmlItem.isMatch(stack)) {
                addContent(new VxmlItem(stack));
            } else if (VxmlOneOf.isMatch(stack)) {
                addContent(new VxmlOneOf(stack));
            } else if (VxmlTag.isMatch(stack)) {
                addContent(new VxmlTag(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlItem((VxmlItem)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "item");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.repeat_ != null) {
            URelaxer.setAttributePropertyByString(element, "repeat", this.repeat_);
        }
        if (this.repeatProb_ != null) {
            URelaxer.setAttributePropertyByString(element, "repeat-prob", this.repeatProb_);
        }
        if (this.weight_ != null) {
            URelaxer.setAttributePropertyByString(element, "weight", this.weight_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlItemMixed value = (IVxmlItemMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlItem</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlItem</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlItem</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlItem</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlItem</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlItem</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>repeat</b>.
     *
     * @return String
     */
    public String getRepeat() {
        return (repeat_);
    }

    /**
     * Sets the String property <b>repeat</b>.
     *
     * @param repeat
     */
    public void setRepeat(String repeat) {
        this.repeat_ = repeat;
    }

    /**
     * Gets the String property <b>repeatProb</b>.
     *
     * @return String
     */
    public String getRepeatProb() {
        return (repeatProb_);
    }

    /**
     * Sets the String property <b>repeatProb</b>.
     *
     * @param repeatProb
     */
    public void setRepeatProb(String repeatProb) {
        this.repeatProb_ = repeatProb;
    }

    /**
     * Gets the String property <b>weight</b>.
     *
     * @return String
     */
    public String getWeight() {
        return (weight_);
    }

    /**
     * Sets the String property <b>weight</b>.
     *
     * @param weight
     */
    public void setWeight(String weight) {
        this.weight_ = weight;
    }

    /**
     * Gets the IVxmlItemMixed property <b>content</b>.
     *
     * @return IVxmlItemMixed[]
     */
    public IVxmlItemMixed[] getContent() {
        IVxmlItemMixed[] array = new IVxmlItemMixed[content_.size()];
        return ((IVxmlItemMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlItemMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlItemMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlItemMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlItemMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlItemMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlItemMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlItemMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlItemMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlItemMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlItemMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlItemMixed
     */
    public IVxmlItemMixed getContent(int index) {
        return ((IVxmlItemMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlItemMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlItemMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlItemMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlItemMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlItemMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlItemMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlItemMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlItemMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "item", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (repeat_ != null) {
            buffer.append(" ");
            buffer.append("repeat");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getRepeat())));
            buffer.append("\"");
        }
        if (repeatProb_ != null) {
            buffer.append(" ");
            buffer.append("repeat-prob");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getRepeatProb())));
            buffer.append("\"");
        }
        if (weight_ != null) {
            buffer.append(" ");
            buffer.append("weight");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getWeight())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlItemMixed value = (IVxmlItemMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlItemMixed value = (IVxmlItemMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "item", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (repeat_ != null) {
            buffer.write(" ");
            buffer.write("repeat");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getRepeat())));
            buffer.write("\"");
        }
        if (repeatProb_ != null) {
            buffer.write(" ");
            buffer.write("repeat-prob");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getRepeatProb())));
            buffer.write("\"");
        }
        if (weight_ != null) {
            buffer.write(" ");
            buffer.write("weight");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getWeight())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlItemMixed value = (IVxmlItemMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlItemMixed value = (IVxmlItemMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "item", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (repeat_ != null) {
            buffer.print(" ");
            buffer.print("repeat");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getRepeat())));
            buffer.print("\"");
        }
        if (repeatProb_ != null) {
            buffer.print(" ");
            buffer.print("repeat-prob");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getRepeatProb())));
            buffer.print("\"");
        }
        if (weight_ != null) {
            buffer.print(" ");
            buffer.print("weight");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getWeight())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlItemMixed value = (IVxmlItemMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlItemMixed value = (IVxmlItemMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "item", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRepeatAsString() {
        return (URelaxer.getString(getRepeat()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRepeatProbAsString() {
        return (URelaxer.getString(getRepeatProb()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getWeightAsString() {
        return (URelaxer.getString(getWeight()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRepeatByString(String string) {
        setRepeat(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRepeatProbByString(String string) {
        setRepeatProb(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setWeightByString(String string) {
        setWeight(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlItem</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "item")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlRuleref.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlToken.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlItem.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlOneOf.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlTag.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlItem</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlItem</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
