/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlMedia</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="media">
 *       <optional>
 *         <attribute name="type">
 *           <text/>
 * 
 *         </attribute>
 *       </optional>
 *       <choice>
 *         <oneOrMore>
 *           <ref name="native"/>
 *         </oneOrMore>
 *         <mixed>
 *           <zeroOrMore>
 *            <choice>
 *             <ref name="audio"/>
 *             <ref name="prosody"/>
 *             <ref name="voice"/>
 *             <ref name="emotion"/>
 *             <ref name="CONTEXT"/>
 *             <ref name="REGWORD"/>
 *             <ref name="VOICE"/>
 *             <ref name="PITCH"/>
 *             <ref name="break"/>
 *             <ref name="phoneme"/>
 *             <ref name="say-as"/>
 *             <ref name="paragraph"/>
 *             <ref name="p"/>
 *             <ref name="sentence"/>
 *             <ref name="s"/>
 *             <ref name="LANG"/>
 *             <ref name="PARTOFSP"/>
 *             <ref name="PRON"/>
 *             <ref name="RATE"/>
 *             <ref name="VOLUME"/>
 *             <ref name="enumerate"/>
 *             <ref name="value"/>
 *             <ref name="emphasis"/>
 *             <ref name="mark"/>
 *             <ref name="BOOKMARK"/>
 *             <ref name="EMPH"/>
 *             <ref name="SPELL"/>
 *             <ref name="SILENCE"/>
 *             <ref name="SPEECH"/>
 *             <ref name="RESET"/>
 *            </choice>
 *           </zeroOrMore>
 *         </mixed>
 *       </choice>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="media"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="type"&gt;
 *           &lt;text/&gt;
 * 
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;choice&gt;
 *         &lt;oneOrMore&gt;
 *           &lt;ref name="native"/&gt;
 *         &lt;/oneOrMore&gt;
 *         &lt;mixed&gt;
 *           &lt;zeroOrMore&gt;
 *            &lt;choice&gt;
 *             &lt;ref name="audio"/&gt;
 *             &lt;ref name="prosody"/&gt;
 *             &lt;ref name="voice"/&gt;
 *             &lt;ref name="emotion"/&gt;
 *             &lt;ref name="CONTEXT"/&gt;
 *             &lt;ref name="REGWORD"/&gt;
 *             &lt;ref name="VOICE"/&gt;
 *             &lt;ref name="PITCH"/&gt;
 *             &lt;ref name="break"/&gt;
 *             &lt;ref name="phoneme"/&gt;
 *             &lt;ref name="say-as"/&gt;
 *             &lt;ref name="paragraph"/&gt;
 *             &lt;ref name="p"/&gt;
 *             &lt;ref name="sentence"/&gt;
 *             &lt;ref name="s"/&gt;
 *             &lt;ref name="LANG"/&gt;
 *             &lt;ref name="PARTOFSP"/&gt;
 *             &lt;ref name="PRON"/&gt;
 *             &lt;ref name="RATE"/&gt;
 *             &lt;ref name="VOLUME"/&gt;
 *             &lt;ref name="enumerate"/&gt;
 *             &lt;ref name="value"/&gt;
 *             &lt;ref name="emphasis"/&gt;
 *             &lt;ref name="mark"/&gt;
 *             &lt;ref name="BOOKMARK"/&gt;
 *             &lt;ref name="EMPH"/&gt;
 *             &lt;ref name="SPELL"/&gt;
 *             &lt;ref name="SILENCE"/&gt;
 *             &lt;ref name="SPEECH"/&gt;
 *             &lt;ref name="RESET"/&gt;
 *            &lt;/choice&gt;
 *           &lt;/zeroOrMore&gt;
 *         &lt;/mixed&gt;
 *       &lt;/choice&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:11 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlMedia implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String type_;
    private IVxmlMediaChoice content_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlMedia</code>.
     *
     */
    public VxmlMedia() {
    }

    /**
     * Creates a <code>VxmlMedia</code>.
     *
     * @param source
     */
    public VxmlMedia(VxmlMedia source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlMedia</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlMedia(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlMedia</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlMedia(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlMedia</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlMedia(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlMedia</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlMedia(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlMedia</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlMedia(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlMedia</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlMedia(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlMedia</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlMedia(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlMedia</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlMedia(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlMedia</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlMedia(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the VxmlMedia <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlMedia source) {
        int size;
        type_ = source.type_;
        if (source.content_ != null) {
            setContent((IVxmlMediaChoice)source.getContent().clone());
        }
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        if (VxmlMediaRef.isMatch(stack)) {
            setContent(new VxmlMediaRef(stack));
        } else if (VxmlMediaMixed.isMatch(stack)) {
            setContent(new VxmlMediaMixed(stack));
        } else {
            throw (new IllegalArgumentException());
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlMedia((VxmlMedia)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "media");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        this.content_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlMedia</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlMedia</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the IVxmlMediaChoice property <b>content</b>.
     *
     * @return IVxmlMediaChoice
     */
    public IVxmlMediaChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IVxmlMediaChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlMediaChoice content) {
        this.content_ = content;
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "media", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (type_ != null) {
            buffer.append(" ");
            buffer.append("type");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }
        content_.makeTextAttribute(buffer);
        buffer.append(">");
        content_.makeTextElement(buffer);
        buffer.append("</");
        URelaxer.makeQName(prefix, "media", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "media", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (type_ != null) {
            buffer.write(" ");
            buffer.write("type");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.write("\"");
        }
        content_.makeTextAttribute(buffer);
        buffer.write(">");
        content_.makeTextElement(buffer);
        buffer.write("</");
        URelaxer.makeQName(prefix, "media", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "media", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (type_ != null) {
            buffer.print(" ");
            buffer.print("type");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }
        content_.makeTextAttribute(buffer);
        buffer.print(">");
        content_.makeTextElement(buffer);
        buffer.print("</");
        URelaxer.makeQName(prefix, "media", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (content_ != null) {
            classNodes.add(content_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlMedia</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "media")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (VxmlMediaRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (VxmlMediaMixed.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlMedia</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlMedia</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
