/*
 * Galatea Dialog Manager:
 * (c)2003-2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: ECMAScript.java,v 1.6 2006/11/30 02:20:29 nishi Exp $
 *
 * Simple wrappar class for Mozilla Rhino JavaScript Engine
 */

package galatea.scripting;

import galatea.util.Util;
import galatea.dialog.RuntimeError;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.Global;

public class ECMAScript {
	private Context context_ = null;
	private Scriptable scope_ = null;
	
	public ECMAScript() throws RuntimeError
	{
		try {
			context_ = Context.enter();
			scope_ = context_.initStandardObjects(null);
			
			Global global = new Global(context_);
			scope_.put("Shell", scope_, global);
			
			ScriptingTools tools = new ScriptingTools();
			scope_.put("Tools", scope_, tools);
			
		} catch (Exception e) {
			throw new RuntimeError(e.getMessage());
		}
	}
	
//	public static void runtimeError(String msg)
//	{
//		System.err.println(msg);
//	}

//	public void exit()
//	{
//		context_.exit();
//	}
	
	
	public String evaluate(String script) throws RuntimeError
	{
		if ( context_ == null )
			return "context_error";
		
		if ( scope_ == null )
			return "scope_error";
		
		if ( script == null )
			return "error";
		
		String str = "error";
		
		Object result = null;
		
		try {
			result = context_.evaluateString(scope_, script, "GalateaDialogManager", 1, null);
			// str = context_.toString(result);
			str = result.toString();
			
		} catch (Exception e) {
			throw new RuntimeError(e.getMessage() + "\n"
					+ script);
		}
		return str;
	}
	
	public String getVersion() {
		return context_.getImplementationVersion();
	}
	
	public static void main(String args[]) throws Exception 
	{
		ECMAScript sc = new ECMAScript(); // ECMAScript.getInstance();
		String r = "";
		/*
		 r = sc.evaluate("o = {a:1, b:['x','y']}"); System.err.println(r);
		 r = sc.evaluate("o.b[0]"); System.err.println(r);
		 r = sc.evaluate("p = {a:1}"); System.err.println(r);
		 r = sc.evaluate("p.b = 2"); System.err.println(r);
		 r = sc.evaluate("1+1"); System.err.println(r);
		 r = sc.evaluate("p"); System.err.println(r);
		 */
		/*
		 r = sc.evaluate("var when = new Object();"); System.err.println(r);
		 r = sc.evaluate("var dialog = new Object();"); System.err.println(r);
		 r = sc.evaluate("dialog.when = when;"); System.err.println(r);
		 r = sc.evaluate("dialog.when.value = 20;"); System.err.println(r);
		 r = sc.evaluate("when.value;"); System.err.println(r);
		 */
		String s ="weather = new Object();"
			+"weather.initial1 = undefined;"
			+"weather.place  = undefined;"
			+"weather.when   = undefined;"
			+"weather.block2 = undefined;"
			+"weather.initial1$ = new Object();"
			+"weather.initial1$.promptcount = 1;"
			+"weather.place$ = new Object();"
			+"weather.place$.promptcount = 1;"
			+"weather.place$.justfilled = false;"
			+"weather.when$ = new Object();"
			+"weather.when$.promptcount = 1;"
			+"weather.when$.justfilled = false;"
			+"weather.nextitem$ = 'hello';";
		
		r = sc.evaluate(s); System.err.println(r);
		
		s = "with(weather){ nextitem$ }";
		r = sc.evaluate(s); System.err.println(r);
		
		s = "with(weather){ 'hoge' }";
		r = sc.evaluate(s); System.err.println(r);
		
		//r = sc.objectToString("o"); System.err.println(r);
		
		//sc.exit();
	}
}

