/**
 * $Id: ISubModule.java,v 1.11 2006/12/18 00:55:17 nishi Exp $
 */
package galatea.submodule;

import galatea.dialog.ISystemEventLogger;
import galatea.dialog.RuntimeError;
import galatea.io.ISenderToDevice;
import galatea.outitem.OutItem;

public interface ISubModule {

	public ISubModule setSender(ISenderToDevice sender);

	public ISubModule setReceiver(IReceiverFromSubModule receiver);

	public ISubModule setLogger(ISystemEventLogger logger);
	
	/**
	 * (for Chain of Responsibility pattern)
	 * if true : processed by this module
	 * if false : delegated to others
	 */
	public boolean receiveFromDevice(String str);

	/**
	 * (for Chain of Responsibility pattern)
	 * if true : processed by this module
	 * if false : delegated to others
	 */
	public boolean filterOutputNative(String str);

	public void doTimerTask() throws RuntimeError;

	public String getName();
	public void setName(String name);

	/**
	 * (for Chain of Responsibility pattern)
	 * if true : processed by this module
	 * if false : delegated to others
	 */
	public boolean startOutput(OutItem item); 
	/**
	 * (for Chain of Responsibility pattern)
	 * if true : processed by this module
	 * if false : delegated to others
	 */
	public boolean stopOutput(OutItem item);

	public void setTargetRunLevel(int i);

}