/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: HashArray.java,v 1.3 2006/11/17 02:31:20 nishi Exp $
 */

package galatea.util;

//import galatea.main.Debug;

import java.util.ArrayList;
import java.util.HashMap;

public class HashArray
{
//	private Debug dbg = new Debug(9);
	
	// Map<String key, Object obj>
	private HashMap hashMap_ = null; 
	
	// array to keep the order of put
	private ArrayList keys_ = null;
	
	public HashArray()
	{
		hashMap_ = new HashMap();
		keys_ = new ArrayList();
	}
	
	public Object put(String key, Object value)
	{
		if (! has(key)) {
			keys_.add((Object)key);
		}
		Object ret = hashMap_.put((Object)key, (Object)value);
		return ret;
	}
	
	public Object set(String key, Object value)
	{
		return put(key, value);
	}
	
	public Object get(String key)
	{
		return hashMap_.get((Object)key);
	}
	
	public boolean has(String key)
	{
		Object o = hashMap_.get((Object)key);
		if (o == null) {
			return false;
		}
		return true;
	}
	
	public int size()
	{
		return keys_.size();
	}
	
	public String getKey(int i)
	{
		return (String)keys_.get(i);
	}
	
	public Object get(int i)
	{
		return hashMap_.get(getKey(i));
	}
	
	public String toString()
	{
		String s ="";
		for (int i = 0; i < size(); i++) {
			s += i + ":" + getKey(i) + ":" + get(i).toString() + " ";
		}
		return s;
	}
	
	/**
	 * make HashArray.run
	 */
	public static void main(String args[]) throws Exception
	{
		HashArray v = new HashArray();
		v.put("taro", "090-1234-5678");
		v.put("jiro", "090-2222-2222");
		v.put("mike", "090-3333-3333");
		
		System.out.println(v.get("mike"));
		System.out.println(v.get(0)); // taro
		System.out.println(v.toString());
	}
	
}
