/*
 * $Id: Messages.java,v 1.1 2006/11/20 01:13:35 nishi Exp $
 */
package galatea.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {

	private static ResourceBundle resourceBundle;
	
	public static void setup(String bundleName) {
		resourceBundle = ResourceBundle.getBundle(bundleName);
	}

	public static String getString(String key) {
		try {
			return resourceBundle.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
	
	public static boolean getAsBoolean(String key) {
		return Boolean.valueOf(getString(key)).booleanValue();
	}

	public static int getAsInteger(String key, int defaultValue) {
		int ret = defaultValue;
		try {
			ret = Integer.valueOf(getString(key)).intValue();
		} catch (Exception e) {}
		return ret;
	}

	public static float getAsFloat(String key) {
		return Float.valueOf(getString(key)).floatValue();
	}
}
