/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: NetUtil.java,v 1.6 2006/12/18 00:55:17 nishi Exp $
 */
package galatea.util;

import galatea.document.DocError;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


public class NetUtil 
{
	private NetUtil() 
	{
	}
	
	public static String getTopName(Element elem)
	{
		String topName;
		if (elem.getNodeType() == Node.ELEMENT_NODE) {
			topName = elem.getNodeName();
		} else {
			topName = "";
		}
		return topName;
	}
		
//	public static String getXMLEncodingDirective(String filename, 
//			String defaultEnc)
//	{
//		URL url;
//		HttpURLConnection uc;
//		try {
//			url = new URL(filename);
//			uc = (HttpURLConnection)url.openConnection();
//			uc.setUseCaches(false);
//			uc.setRequestMethod("GET");
//		} catch (MalformedURLException e1) {
//			return defaultEnc;
//		} catch (IOException e1) {
//			return defaultEnc;
//		}
//		String enc = "JISAutoDetect"; 
//		BufferedReader br;
//		try {
//			br = new BufferedReader(new InputStreamReader(uc.getInputStream(), enc));
//		} catch (UnsupportedEncodingException e1) {
//			return defaultEnc;
//		} catch (IOException e1) {
//			return defaultEnc;
//		}
//		while(true) {
//			String line;
//			try {
//				line = br.readLine();
//				if (line == null) {
//					break;
//				} else {
//					if (line.startsWith("<?xml ")) {
//						String s = line.replaceAll("\"", "'");
//						// encoding='xxx'
//						String e = Util.getFirstGroup(".*encoding[\\s]*=[\\s]*'([^']+)'.*", s);
//						if (e != null) {
//							return e;
//						}
//					}
//				}
//			} catch (IOException e1) {
//			}
//		}
//		return defaultEnc;
//	}
//	
//	public static Element loadXMLFile_old(String filename) throws Exception
//	{
//		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
//		DocumentBuilder builder = factory.newDocumentBuilder();
//		Document root;
//		if (filename.startsWith("http:")) {
//			String encoding = getXMLEncodingDirective(filename, "UTF-8");
//			
//			String buf = "";
//			URL url = new URL(filename);
//			HttpURLConnection uc;
//			uc = (HttpURLConnection)url.openConnection();
//			uc.setUseCaches(false);
//			uc.setRequestMethod("GET");
//			
//			BufferedReader br = new BufferedReader(
//					new InputStreamReader(uc.getInputStream(), encoding));
//			while(true) {
//				String line = br.readLine();
//				if (line == null) {
//					break;
//				} else {
//					if (!line.startsWith("<?xml ")) {
//						buf += line;
//						buf += "\n";
//					}
//				}
//			}
//			
//			// 属性値がアンパサンドを含む場合には，
//			// "&amp;"などの文字実体参照として表記しなければならない
//			// buf = buf.replaceAll("&", "&amp;");
//			root = builder.parse(new ByteArrayInputStream(buf.getBytes("UTF-8")));
//			br.close();
//			
//			uc.disconnect();
//		} else {
//			root = builder.parse(filename);
//		}
//		Element elem = root.getDocumentElement();
//		return elem;
//	}
	
	// http の場合はまずファイル全体をバイナリ列として取得する
	// バイト列をスキャンして ?> が出現するまでをディレクティブと見なし、
	// encoding を取得する。デフォルトは UTF-8 とする。
	// 以降の文字列は encoding に基づいて解釈し、
	// 内部的には UTF-8 に変換して DOM Parser に解釈させる
	public static Element loadXMLFile(String filename) throws Exception
	{
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document root;
		if (filename.startsWith("http:")) {
			URL url = new URL(filename);
			HttpURLConnection uc;
			uc = (HttpURLConnection)url.openConnection();
			uc.setRequestMethod("GET");
			InputStream is = uc.getInputStream();
			ByteArrayOutputStream os = new ByteArrayOutputStream();
			final int SIZE = 8196;
			byte[] buf = new byte[SIZE];
			while (true) {
				int n = is.read(buf,0,SIZE);
				if (n == -1) break;
				os.write(buf,0,n);
			}
			byte[] bytes = os.toByteArray();
			os.close();
			is.close();
			uc.disconnect();
			String encoding = "UTF-8"; // default
			int pos = 0;
			for (int i=0; i < bytes.length; i++) {
				if (bytes[i] == '>' && i > 0 && bytes[i-1] == '?') {
					String line = new String(bytes,0,i+1);
					if (line.startsWith("<?xml ")) {
						String s = line.replaceAll("\"", "'");
						// encoding='xxx'
						String e = Util.getFirstGroup(".*encoding[\\s]*=[\\s]*'([^']+)'.*", s);
						if (e != null) {
							encoding = e;
						}
					}
					pos = i+1;
					break;
				}
			}
			int len = bytes.length - pos;
			String content = new String(bytes, pos, len, encoding);
			InputStream is2 = new ByteArrayInputStream(content.getBytes("UTF-8"));
			root = builder.parse(is2);
		} else {
			root = builder.parse(filename);
		}
		Element elem = root.getDocumentElement();
		return elem;
	}
	
	
	public static String loadTextFile(String filename) throws Exception
	{
		String doc = Util.readURL(filename);
		if (Util.getError().equals("")) {
			return doc;
		}
		throw new DocError(Util.getError());
	}
	
	
	public static String makeString(Element element) {
		TransformerFactory factory = TransformerFactory.newInstance();
		Transformer transformer;
		try {
			transformer = factory.newTransformer();
		} catch (TransformerConfigurationException e) {
			return e.toString(); // e.printStackTrace();
		}
		DOMSource src = new DOMSource(element);
		StringWriter writer = new StringWriter();
		StreamResult target = new StreamResult(writer);
		try {
			transformer.transform(src, target);
		} catch (Exception e) {
			return e.toString(); // e.printStackTrace();
		}
		String ws = new String(writer.getBuffer());
		return ws;
	}
	
	/**
	 */
	public static void main(String args[]) throws Exception
	{
		String s;
		// s = loadXMLFile("/data/workspace/gdm/tests/vxml/form.vxml").toString();
		s = loadXMLFile("http://localhost/bento/vxml/vxml-begin.php").toString();
		System.err.println(s);
	}
	
}
