// $Id: demo.js,v 1.5 2006/11/20 03:15:56 nishi Exp $ 
// 

var statusId = 0;
var focusPos = 0;

function bodyOnLoad() {
	setStatusText("document load done.");
	setStatusId(0);
	setFocusPos(0);
}

function bodyOnUnload() {
	stopListen();
}

function stopListen() {
	if (req2.readyState != 4) {
		setStatusText("request abort.");
		req2.abort();
	}
}

function startDialog() {
	$("slot1").innerHTML = "";
	$("slot2").innerHTML = "";
	$("slot3").innerHTML = "";
	var msg = "こちらは特急券販売システムです。出発地をどうぞ。";
	doPrompt(msg);
	setStatusId(1);
}

function onRecogDummy(arg1,arg2,arg3) {
	$("can1").innerHTML = arg1;
	$("can2").innerHTML = arg2;
	$("can3").innerHTML = arg3;
	setFocusPos(1);
	doConfirmPrompt(1);
}

function onPositive() {
	setStatusText("Positive");
	if (focusPos > 0) {
		switch (statusId) {
		case 1:
			$("slot1").innerHTML = $("can" + focusPos).innerHTML;
			setStatusId(2);
			doPrompt("到着地をどうぞ。");
			break;
		case 2:
			$("slot2").innerHTML = $("can" + focusPos).innerHTML;
			setStatusId(3);
			doPrompt("到着時刻をどうぞ。");
			break;
		case 3:
			$("slot3").innerHTML = $("can" + focusPos).innerHTML;
			setStatusId(4);
			doPrompt("これでよろしいですか？");
			break;
		case 4:
			setStatusId(5);
			doPrompt("検索結果はｘｘｘです。");
			break;
		case 5:
			setStatusId(1);
			doPrompt("出発地をどうぞ。");
			break;
		}
	}
}

function doPrompt(msg) {
	// stopOutputSync();
	$("prompt").innerHTML = msg;
	speakAtServer(msg);
}

function doConfirmPrompt(pos) {
	var msg = $("can" + pos).innerHTML + "ですか？";
	doPrompt(msg);
}

function onDoubtful() {
	setStatusText("Doubtful");
	if (focusPos == 1 || focusPos == 2) {
		setFocusPos(focusPos + 1);
		doConfirmPrompt(focusPos);
	} else if (focusPos == 3) {
		setFocusPos(1);
		doConfirmPrompt(focusPos);
	}
}

function setStatusText(str) {
	$("statusText").innerHTML = str;
}

function setStatusId(id) {
	statusId = id;
	$("statusId").innerHTML = id;
}

function setFocusPos(pos) {
	if (1 <= focusPos && focusPos <= 3) {
		$("can" + focusPos).style.color = '#000000';
	}
	focusPos = pos;
	if (1 <= focusPos && focusPos <= 3) {
		$("can" + focusPos).style.color = '#ff0000';
	}
}

function handleKeyDown(e) {
	var kc = getKeyCode(e);
	var str = "keyDown:" + kc;
	$("statusKeyDown").innerHTML = str;
	return true;
}

function handleKeyPress(e) {
	var kc = getKeyCode(e);
	var str = "keyPress:" + kc;
	$("statusKeyPress").innerHTML = str;
	return true;
}

var req2 = createXMLHttpRequest();
var listenAtServerUrl = "/?m=browser&e=listen";

function listenAtServerStateChangeHandler() {
	try {
		if (req2.readyState == 4) {
			if (req2.status == 200) {
				var data = req2.responseText;
				// setStatusText("listen done:" + data);
				
				// request next connection
				req2 = createXMLHttpRequest();
				req2.onreadystatechange = listenAtServerStateChangeHandler;
				req2.open("GET", listenAtServerUrl, true);
				req2.send(null);
				setStatusText("listen started again. lastdata:" + data);
			} else {
				setStatusText("data receive error readyState:" + req2.readyState);
			}
		}
	} catch(e) {
		if(typeof e == 'object') {
			alert(e.message);
		} else {
			alert(e);
		}
	}
}

function listenAtServer() {
	req2.onreadystatechange = listenAtServerStateChangeHandler;
	if (req2.readyState == 0) {
		req2.open("GET", listenAtServerUrl, true);
		req2.send(null);
		setStatusText("listen started");
	} else {
		setStatusText("listen readyState:" + req2.readyState);
	}
}

// end of file
