#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<setjmp.h>
#include	"command.h"
#include	"confpara.h"

#define INIT_SLOT_TABLE
#include	"slot.h"

char *moduleVersion = "Speech Synthesis Module Ver. 1.01 (syn-020703)";
char *protocolVersion = "Protocol Ver. 0";

void init_conf();
void read_conf(char *);
int speakerID(char *);
void set_default_conf();
void init_text_analysis();
void init_hmmsynth();
void set_da_signal();
void read_phonemes(char *);
void init_tag();
void init_mora();
void init_morph();
void init_aphrase();
void init_breath();
void init_phoneme();
void init_sentence();
void refresh_tag();
void refresh_mora();
void refresh_morph();
void refresh_aphrase();
void refresh_breath();
void refresh_phoneme();
void refresh_sentence();
void refresh_hmmsynth();
int RepMsg(char *, ...);
int TmpMsg(char *, ...);
int ErrMsg(char *, ...);
void init_parameter();
void make_duration();
void make_parameter();
void unknown_com();
void restart(int);
void text_analysis();
void send_speakerset();
void send_speaker();
void send_text(char *);
void send_phoneme(char *);
void send_duration(char *);
void do_synthesis();
void do_output(char *);
void abort_output();
void text_analysis_file();
void reset_output();
void parameter_generation();
void modify_duration();
void make_cumul_time();
void modify_f0();
void modify_power();
void modify_voice();
int make_sleep_time(char *, long *);
long sleepMs(long);

void init_slot_prop()
{
	prop_Run = AutoOutput;
	prop_ModuleVersion = AutoOutput;
	prop_ProtocolVersion = AutoOutput;
	prop_SpeakerSet = AutoOutput;
	prop_Speaker = AutoOutput;
	prop_Text = AutoOutput;
	prop_Text_text = AutoOutput;
	prop_Text_pho = AutoOutput;
	prop_Text_dur = AutoOutput;
	prop_Speak = AutoOutput;
	prop_Speak_text = AutoOutput;
	prop_Speak_pho = AutoOutput;
	prop_Speak_dur = AutoOutput;
	prop_Speak_utt = AutoOutput;
	prop_Speak_len = AutoOutput;
	prop_Speak_stat = AutoOutput;
}

/* : ץ൯ư˰٤¹ */
void initialize()
{
	void setRun();

	set_da_signal();

	init_slot_prop();
	init_text_analysis();
	init_hmmsynth();
	read_phonemes( phlist_file );
	init_tag();
	init_mora();
	init_morph();
	init_aphrase();
	init_breath();
	init_phoneme();
	init_sentence();
	strcpy( slot_Speak_stat, "IDLE" );
	setRun( "=", "LIVE" );
	slot_Log_file[0] = '\0';   logfp = NULL;
	slot_Log_chasen= slot_Log_tag = slot_Log_phoneme = 0;
	slot_Log_mora = slot_Log_morph = slot_Log_aphrase = 0;
	slot_Log_breath = slot_Log_sentence = 0;
}

/* : ԤӤ˼¹ */
void refresh()
{
	refresh_tag();
	refresh_mora();
	refresh_morph();
	refresh_aphrase();
	refresh_breath();
	refresh_phoneme();
	refresh_sentence();
	refresh_hmmsynth();
}

int commandID( char *com )
{
	int 	i;
	for( i=0; i<NUM_COMMAND; ++i )  {
		if( strcmp(com,commandTable[i].name)==0 )  return commandTable[i].id;
	}
	return -1;
}

int slotID( char *slot )
{
	int 	i;
	for( i=0; i<NUM_SLOT; ++i )  {
		if( strcmp(slot,slotTable[i].name)==0 )  return slotTable[i].id;
	}
	return -1;
}

#define	MAX_CLINE	9192
static char cline[MAX_CLINE];

int read_command( char **args )
{
	int 	n=0, p=0, c, pre_c;

	/* by nishi */
	while ( (c= getchar()) == EOF);

/* to skip space */
	while( c==' ' || c=='\t' )  { c = getchar(); };

/* to get a command name */
	*(args++) = &(cline[p]);
	while( c!=' ' && c!='\t' && c!='\n' && c!= EOF )  {
		cline[p++] = c;  c = getchar();
	};
	cline[p++] = '\0';  ++n;

/* to skip space */
	while( c==' ' || c=='\t' )  { c = getchar(); };

/* to get a slot name */
	*(args++) = &(cline[p]);
	while( c!=' ' && c!='\t' && c!='=' && c!='<' && c!='\n' && c!= EOF )  {
		cline[p++] = c;  c = getchar();
	};
	cline[p++] = '\0';  ++n;

/* to skip space */
	while( c==' ' || c=='\t' )  { c = getchar(); };

/* to get relation */
	*(args++) = &(cline[p]);
	if( c=='=' || c=='<' )  {
		cline[p++] = pre_c = c;  c = getchar();
		if( pre_c=='<' && c=='<' )  {
			cline[p++] = c;  c = getchar();
		}
		cline[p++] = '\0';  ++n;
	}

/* to skip space */
	while( c==' ' || c=='\t' )  { c = getchar(); };

/* to get a value */
	*(args++) = &(cline[p]);
	while( c!='\n' && c!= EOF )  {
		cline[p++] = c;  c = getchar();
		if( p >= MAX_CLINE )  {
			ErrMsg( "* Command line is too long\n" );
			restart( 1 );
		}
	};
	cline[p++] = '\0';  ++n;

	return n;
}


/*---------------------------------------------------------*/
/*      inq command                                        */
/*---------------------------------------------------------*/

void inqRun()
{
	RepMsg( "rep Run = %s\n", slot_Run );
}

void inqModuleVersion()
{
	RepMsg( "rep ModuleVersion = \"%s\"\n", moduleVersion );
}

void inqProtocolVersion()
{
	RepMsg( "rep ProtocolVersion = \"%s\"\n", protocolVersion );
}

void inqSpeakerSet()
{
	send_speakerset();
}

void inqSpeaker()
{
	send_speaker();
}

void inqTextText()
{
	send_text( "Text.text" );
}

void inqTextPho()
{
	send_phoneme( "Text.pho" );
}

void inqTextDur()
{
	send_duration( "Text.dur" );
}

void inqSpeakText()
{
	send_text( "Speak.text" );
}

void inqSpeakPho()
{
	send_phoneme( "Speak.pho" );
}

void inqSpeakDur()
{
	send_duration( "Speak.dur" );
}

void inqSpeakUtt()
{
	TmpMsg( "Sorry. Not implemented ...\n" );
}

void inqSpeakLen()
{
	TmpMsg( "Sorry. Not implemented ...\n" );
}

void inqSpeakStat()
{
	RepMsg( "rep Speak.stat = %s\n", slot_Speak_stat );
}

/*---------------------------------------------------------*/
/*      set command                                        */
/*---------------------------------------------------------*/

void setRun( char *rel, char *val )
{
	if( strcmp(rel,"=")!=0 )  { unknown_com();  return; }

	if( strcmp(val,"EXIT")==0 )  {
		strcpy( slot_Run, "EXIT" );
		if( prop_Run == AutoOutput )  inqRun();
		exit(0);
	} else if( strcmp(val,"LIVE")==0 )  {
		strcpy( slot_Run, "LIVE" );
		if( prop_Run == AutoOutput )  inqRun();
	} else {
		unknown_com();
	}
}

void setSpeaker( char *rel, char *val )
{
	int s;

	if( strcmp(rel,"=")!=0 )  { unknown_com();  return; }

	s = speakerID( val );
	if( s >= 0 )  {
		spid = s;
		if( prop_Speaker == AutoOutput )  inqSpeaker();
	}
}

void setText( char *rel, char *val )
{
	strcpy( slot_Speak_stat, "PROCESSING" );
	if( prop_Speak_stat == AutoOutput )  inqSpeakStat();

	if( strcmp(rel,"=")==0 )  {
		refresh();
		text_analysis( val );	/* ƥȲ */
		if( prop_Text_text == AutoOutput )  inqTextText();
		if( prop_Speak_text == AutoOutput )  inqSpeakText();

		parameter_generation();	/* ѥ᡼(F0,MLSAե륿,³Ĺ) */
		do_synthesis();		/* ȷ */
#ifdef PRINTDATA
		TmpMsg( "Synthesis Done.\n" );
#endif
/*	} else if( strcmp(rel,"<")==0 )  {
	} else if( strcmp(rel,"<<")==0 )  {
*/		
	} else {
		unknown_com();
	}		
	strcpy( slot_Speak_stat, "READY" );
	if( prop_Speak_stat == AutoOutput )  inqSpeakStat();
}

void setSpeak( char *rel, char *val )
{
	int error;
	long sleep_ms;

	if( strcmp(rel,"=")!=0 )  { unknown_com();  return; }

	if( strcmp(val,"NOW")==0 )  {
		strcpy( slot_Speak_stat, "SPEAKING" );
		if( prop_Speak_stat == AutoOutput )  inqSpeakStat();
		do_output(NULL);	/*  */

	} else if( strcmp(val,"STOP")==0 )  {
/*		TmpMsg( "Sorry. Not implemented ...\n" );	*/
		abort_output();

	} else {
		/* val = "12:34:56.789" or "+1000" */
		error = make_sleep_time( val, &sleep_ms );
		if( error )  {
			unknown_com();
		} else {
#ifdef PRINTDATA
			TmpMsg( "sleep_ms: %d\n", sleep_ms );
#endif
			if( sleep_ms > 0 )  sleepMs( sleep_ms );
			strcpy( slot_Speak_stat, "SPEAKING" );
			if( prop_Speak_stat == AutoOutput )  inqSpeakStat();
			do_output(NULL);	/*  */
		}
	}
/*	strcpy( slot_Speak_stat, "IDLE" );
	if( prop_Speak_stat == AutoOutput )  inqSpeakStat();
*/
}

/*-------------------*/

void setSave( char *rel, char *filename )
{
	if( strcmp(rel,"=")==0 )  {
		do_output( filename );
	} else {
		unknown_com();
	}
}

/* 䥤η̤ե뤫ɤ߹ */
void setFile( char *rel, char *filename )
{
	if( strcmp(rel,"=")==0 )  {
		refresh();
		text_analysis_file( filename );	/* ƥȲ */
		parameter_generation();	/* ѥ᡼(F0,MLSAե륿,³Ĺ) */
		do_synthesis();		/* ȷ */
		TmpMsg( "Synthesis Done.\n" );
	} else {
		unknown_com();
	}		
}

void setLog( char *rel, char *filename )
{
	if( strcmp(rel,"=")==0 )  {
		if( logfp && strcmp(slot_Log_file,"CONSOLE")!=0 )  fclose( logfp );
		strcpy( slot_Log_file, filename );
		if( strcmp(filename,"CONSOLE")==0 ) {
			logfp = stderr;
		} else {
			logfp = fopen( filename, "a" );
			if( logfp == NULL )   {
			  ErrMsg( "log file open error ... $s\n", filename );
			}
		}
	} else {
		unknown_com();
	}
}

void setLogChasen( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_chasen = 1;
	  } else {
		slot_Log_chasen = 0;
	  }
	} else {
		unknown_com();
	}
}

void setLogTag( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_tag = 1;
	  } else {
		slot_Log_tag = 0;
	  }
	} else {
		unknown_com();
	}
}

void setLogPhoneme( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_phoneme = 1;
	  } else {
		slot_Log_phoneme = 0;
	  }
	} else {
		unknown_com();
	}
}

void setLogMora( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_mora = 1;
	  } else {
		slot_Log_mora = 0;
	  }
	} else {
		unknown_com();
	}
}

void setLogMorph( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_morph = 1;
	  } else {
		slot_Log_morph = 0;
	  }
	} else {
		unknown_com();
	}
}

void setLogAphrase( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_aphrase = 1;
	  } else {
		slot_Log_aphrase = 0;
	  }
	} else {
		unknown_com();
	}
}

void setLogBreath( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_breath = 1;
	  } else {
		slot_Log_breath = 0;
	  }
	} else {
		unknown_com();
	}
}

void setLogSentence( char *rel, char *val )
{
	if( strcmp(rel,"=")==0 )  {
	  if( strcmp( val, "YES" )==0 ) {
		slot_Log_sentence = 1;
	  } else {
		slot_Log_sentence = 0;
	  }
	} else {
		unknown_com();
	}
}

/*---------------------------------------------------------*/

void parameter_generation()
{
/* ν */
	init_parameter();

/* Ƿ³Ĺη */
	make_duration();
/* Ƿ³Ĺѹ */
	modify_duration();
	make_cumul_time();
	modify_voice();

	if( prop_Text_pho == AutoOutput )  inqTextPho();
	if( prop_Speak_pho == AutoOutput )  inqSpeakPho();
	if( prop_Text_dur == AutoOutput )  inqTextDur();
	if( prop_Speak_dur == AutoOutput )  inqSpeakDur();


/* ѥ᡼ F0,MLSAե륿 */
	make_parameter();

/* F0,  b(0) ѹ */
	modify_f0();
	modify_power();
}

/*---------------------------------------------------------*/

int 	n_arg;
char	*v_arg[10];

void unknown_com()
{
	int 	i;
	ErrMsg( "* Unknown command line ... \n" );
	for( i=0; i<n_arg; ++i )  { ErrMsg( "%s ", v_arg[i] ); }
	ErrMsg( "\n" );
}

void usage( char* com )
{
	fprintf( stderr, "%s [-C conf-file]\n", com );
	exit(1);
}

extern int chasen_process;
static jmp_buf ebuf;

void restart( int val )
{
	longjmp( ebuf, val );
}

extern FILE *fp_err;

int main( int argc, char **argv )
{
	int n;
	char *com;

	init_conf();

	com = argv[0];
	--argc;  ++argv;
	while( argc > 0 && argv[0][0] == '-' )  {
		switch( argv[0][1] )  {
		case 'C':
			if( argc < 2 )  usage( com );
			read_conf( argv[1] );
			--argc;  ++argv;
			break;
		default:
			usage( com );
		}
		--argc;  ++argv;
	}
	set_default_conf();

	fp_err = stderr;

	initialize();

	n = setjmp( ebuf );
	if( n > 0 )  chasen_process = 0;	/* to restart 'chasen' process */

	for( ;; )  {
#ifdef PRINTDATA
		TmpMsg( "> " );
#endif
		n_arg = read_command( v_arg );

#ifdef PRINTDATA
		{
			int i;
			TmpMsg( "command is \n" );
			for( i=0; i<n_arg; ++i )  {
				TmpMsg( "  %d: %s\n", i+1, v_arg[i] );
			}
		}
#endif

		if( n_arg < 2 )  { unknown_com();  continue; }

		switch( commandID( v_arg[0] ) )  {
		  case C_set:
			if( n_arg < 4 )  { unknown_com();  break; }
			switch( slotID( v_arg[1] ) )  {
			  case S_Run:   setRun( v_arg[2], v_arg[3] );  break;
			  case S_Speaker:  setSpeaker( v_arg[2], v_arg[3] );  break;
			  case S_Text:  setText( v_arg[2], v_arg[3] );  break;
			  case S_Speak: setSpeak( v_arg[2], v_arg[3] );  break;
			  case S_Save:  setSave( v_arg[2], v_arg[3] );  break;
			  case S_File:  setFile( v_arg[2], v_arg[3] );  break;
			  case S_Log:          setLog( v_arg[2], v_arg[3] ); break;
			  case S_Log_chasen:   setLogChasen( v_arg[2], v_arg[3] ); break;
			  case S_Log_tag:      setLogTag( v_arg[2], v_arg[3] ); break;
			  case S_Log_phoneme:  setLogPhoneme( v_arg[2], v_arg[3] ); break;
			  case S_Log_mora:     setLogMora( v_arg[2], v_arg[3] ); break;
			  case S_Log_morph:    setLogMorph( v_arg[2], v_arg[3] ); break;
			  case S_Log_aphrase:  setLogAphrase( v_arg[2], v_arg[3] ); break;
			  case S_Log_breath:   setLogBreath( v_arg[2], v_arg[3] ); break;
			  case S_Log_sentence: setLogSentence( v_arg[2], v_arg[3] ); break;
			  default:
				unknown_com();
			}
			break;
		  case C_inq:
			switch( slotID( v_arg[1] ) ) {
			  case S_Run:        inqRun();  break;
			  case S_ModuleVersion: inqModuleVersion();  break;
			  case S_ProtocolVersion: inqProtocolVersion();  break;
			  case S_SpeakerSet: inqSpeakerSet();  break;
			  case S_Speaker:    inqSpeaker();  break;
			  case S_Text_text:  inqTextText();  break;
			  case S_Text_pho:   inqTextPho();  break;
			  case S_Text_dur:   inqTextDur();  break;
			  case S_Speak_text: inqSpeakText();  break;
			  case S_Speak_pho:  inqSpeakPho();  break;
			  case S_Speak_dur:  inqSpeakDur();  break;
			  case S_Speak_utt:  inqSpeakUtt();  break;
			  case S_Speak_len:  inqSpeakLen();  break;
			  case S_Speak_stat: inqSpeakStat();  break;
			  default:
				unknown_com();
			}
			break;
		  case C_prop:
			{ SlotProp prop;
			if( strcmp(v_arg[2],"=")!=0 )  { unknown_com(); break; }
			if( strcmp(v_arg[3],"AutoOutput")==0 )  {
				prop = AutoOutput;
			} else if(strcmp(v_arg[3],"NoAutoOutput")==0 )  {
				prop = NoAutoOutput;
			} else {
				unknown_com(); break;
			}
			switch( slotID( v_arg[1] ) ) {
			  case S_Run:        prop_Run = prop;  break;
			  case S_ModuleVersion: prop_ModuleVersion = prop;  break;
			  case S_ProtocolVersion: prop_ProtocolVersion = prop;  break;
			  case S_SpeakerSet: prop_SpeakerSet = prop;  break;
			  case S_Speaker:    prop_Speaker = prop;  break;
			  case S_Text:       prop_Text = prop;  break;
			  case S_Text_text:  prop_Text_text = prop;  break;
			  case S_Text_pho:   prop_Text_pho = prop;  break;
			  case S_Text_dur:   prop_Text_dur = prop;  break;
			  case S_Speak:      prop_Speak = prop;  break;
			  case S_Speak_text: prop_Speak_text = prop;  break;
			  case S_Speak_pho:  prop_Speak_pho = prop;  break;
			  case S_Speak_dur:  prop_Speak_dur = prop;  break;
			  case S_Speak_utt:  prop_Speak_utt = prop;  break;
			  case S_Speak_len:  prop_Speak_len = prop;  break;
			  case S_Speak_stat: prop_Speak_stat = prop;  break;
			  default:
				unknown_com();
			}
			}
			break;
		  default:
			unknown_com();
		}
	}
	exit(0);
}
