#!/usr/bin/perl
#  ---------------------------------------------------------------  #
#           The HMM-Based Speech Synthesis System (HTS)             #
#                       HTS Working Group                           #
#                                                                   #
#                  Department of Computer Science                   #
#                  Nagoya Institute of Technology                   #
#                               and                                 #
#   Interdisciplinary Graduate School of Science and Engineering    #
#                  Tokyo Institute of Technology                    #
#                                                                   #
#                     Copyright (c) 2001-2006                       #
#                       All Rights Reserved.                        #
#                                                                   #
#  Permission is hereby granted, free of charge, to use and         #
#  distribute this software and its documentation without           #
#  restriction, including without limitation the rights to use,     #
#  copy, modify, merge, publish, distribute, sublicense, and/or     #
#  sell copies of this work, and to permit persons to whom this     #
#  work is furnished to do so, subject to the following conditions: #
#                                                                   #
#    1. The source code must retain the above copyright notice,     #
#       this list of conditions and the following disclaimer.       #
#                                                                   #
#    2. Any modifications to the source code must be clearly        #
#       marked as such.                                             #
#                                                                   #
#    3. Redistributions in binary form must reproduce the above     #
#       copyright notice, this list of conditions and the           #
#       following disclaimer in the documentation and/or other      #
#       materials provided with the distribution.  Otherwise, one   #
#       must contact the HTS working group.                         #
#                                                                   #
#  NAGOYA INSTITUTE OF TECHNOLOGY, TOKYO INSTITUTE OF TECHNOLOGY,   #
#  HTS WORKING GROUP, AND THE CONTRIBUTORS TO THIS WORK DISCLAIM    #
#  ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL       #
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   #
#  SHALL NAGOYA INSTITUTE OF TECHNOLOGY, TOKYO INSTITUTE OF         #
#  TECHNOLOGY, HTS WORKING GROUP, NOR THE CONTRIBUTORS BE LIABLE    #
#  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY        #
#  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,  #
#  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS   #
#  ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR          #
#  PERFORMANCE OF THIS SOFTWARE.                                    #
#                                                                   #
#  ---------------------------------------------------------------  #

if (@ARGV<3) {
   print "window.pl dimensionality infile winfile1 winfile2 ... \n";
   exit(0);
}

$ignorevalue = -1.0e+10;

# dimensionality of input vector
$dim = $ARGV[0];

# open infile as a sequence of static coefficients 
open(INPUT,"$ARGV[1]") || die "cannot open file : $ARGV[1]";
@STAT=stat(INPUT);
read(INPUT,$data,$STAT[7]);
close(INPUT);

$nwin = @ARGV-2;

$n = $STAT[7]/4;  # number of data
$T = $n/$dim;     # number of frames of original data


# load original data
@original = unpack("f$n",$data);  # original data must be stored in float, natural endian


# apply window
for($i=1;$i<=$nwin;$i++) {
   # load $i-th window coefficients
   open(INPUT,"$ARGV[$i+1]") || die "cannot open file : $ARGV[$i+1]";
   $data = <INPUT>;
   @win = split(' ',$data);
   $size = $win[0];   # size of this window

   if ($size % 2 != 1) {             
      die "Size of window must be 2*n + 1 and float"; 
   }

   $nlr = ($size-1)/2; 

   # calcurate $i-th coefficients
   for ($t=0; $t<$T; $t++) {
      for ($j=0; $j<$dim; $j++) {
         # check space boundary (ex. voiced/unvoiced boundary)
         $boundary = 0;
         for ($k=-$nlr; $k<=$nlr; $k++) {      
            if ($t+$k>=0 && $t+$k<$T && $original[($t+$k)*$dim+$j] == $ignorevalue) {
               $boundary = 1;
            }
         }
         if ($boundary==0) {
            $transformed[$t*$nwin*$dim+$dim*($i-1)+$j] = 0.0;
            for ($k=-$nlr; $k<=$nlr; $k++) {
               if ($t+$k>=0 && $t+$k<$T) { 
                  $transformed[$t*$nwin*$dim+$dim*($i-1)+$j] += $win[$k+$nlr+1]*$original[($t+$k)*$dim+$j];
               }
            }
         }
         else {
            $transformed[$t*$nwin*$dim+$dim*($i-1)+$j] = $ignorevalue;
         }
      }
   }
}

$n = $n*$nwin;

$data = pack("f$n",@transformed);

print $data;

# end of delta.pl
