#!/usr/bin/perl
#  ---------------------------------------------------------------  #
#           The HMM-Based Speech Synthesis System (HTS)             #
#                       HTS Working Group                           #
#                                                                   #
#                  Department of Computer Science                   #
#                  Nagoya Institute of Technology                   #
#                               and                                 #
#   Interdisciplinary Graduate School of Science and Engineering    #
#                  Tokyo Institute of Technology                    #
#                                                                   #
#                     Copyright (c) 2001-2006                       #
#                       All Rights Reserved.                        #
#                                                                   #
#  Permission is hereby granted, free of charge, to use and         #
#  distribute this software and its documentation without           #
#  restriction, including without limitation the rights to use,     #
#  copy, modify, merge, publish, distribute, sublicense, and/or     #
#  sell copies of this work, and to permit persons to whom this     #
#  work is furnished to do so, subject to the following conditions: #
#                                                                   #
#    1. The source code must retain the above copyright notice,     #
#       this list of conditions and the following disclaimer.       #
#                                                                   #
#    2. Any modifications to the source code must be clearly        #
#       marked as such.                                             #
#                                                                   #
#    3. Redistributions in binary form must reproduce the above     #
#       copyright notice, this list of conditions and the           #
#       following disclaimer in the documentation and/or other      #
#       materials provided with the distribution.  Otherwise, one   #
#       must contact the HTS working group.                         #
#                                                                   #
#  NAGOYA INSTITUTE OF TECHNOLOGY, TOKYO INSTITUTE OF TECHNOLOGY,   #
#  HTS WORKING GROUP, AND THE CONTRIBUTORS TO THIS WORK DISCLAIM    #
#  ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL       #
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   #
#  SHALL NAGOYA INSTITUTE OF TECHNOLOGY, TOKYO INSTITUTE OF         #
#  TECHNOLOGY, HTS WORKING GROUP, NOR THE CONTRIBUTORS BE LIABLE    #
#  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY        #
#  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,  #
#  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTUOUS   #
#  ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR          #
#  PERFORMANCE OF THIS SOFTWARE.                                    #
#                                                                   #
#  ---------------------------------------------------------------  #


# Settings ==============================
$spkr = 'sako';
$data = 'istc_b50';
$qnum = '001';
$ver  = '1';

@SET        = ('cmp','dur');
@cmp        = ('mcp','lf0');
@dur        = ('dur');
$ref{'cmp'} = \@cmp;
$ref{'dur'} = \@dur;

%thr  = ('mcp' => "000",  # minimum state occupancy 
         'lf0' => "000",
         'dur' => "000");

%lamb = ('mcp' => "1.0",  # tree size control param. for MDL
         'lf0' => "1.0",
         'dur' => "1.0");

%gam  = ('mcp' => "000",  # stats load threshold
         'lf0' => "000",
         'dur' => "000");

%t2s  = ('mcp' => "cmp",  # feature type to mmf convertion
         'lf0' => "cmp",
         'dur' => "dur");

%strb = ('mcp' => "1",  # stream start
         'lf0' => "2",
         'dur' => "1");

%stre = ('mcp' => "1",  # stream end
         'lf0' => "4",
         'dur' => "1");

%msdi = ('mcp' => "0",  # msd information
         'lf0' => "1");

%strw = ('mcp' => "1.0",  # stream weights
         'lf0' => "1.0");

%ordr = ('mcp' => '19',  # feature order  
         'lf0' => '1');

%nwin = ('mcp' => '3',  # number of windows
         'lf0' => '3');

%mdcp = ('dy' => 'd');
#%mdcp = ('dy' => 'd',   # model copy
#         'A'  => 'a',
#         'I'  => 'i',
#         'U'  => 'u',
#         'E'  => 'e',
#         'O'  => 'o');


# Speech Analysis/Synthesis Setting ==============
# analysis
$sr = 16000;   # sampling rate (Hz)
$fs = 80;      # frame period (point) 
$fw = 0.42;    # frequency warping
$fr = $fs/$sr; # frame period (sec)

# synthesis (postfiltering)
$pf = 1.4;     # postfiltering coefficient
$fl = 4096;    # FFT length
$co = 2047;    # order of cepstrum to approximate mel cepstrum


# Global Value ==========================
$nState = 5;                # number of states
$nIte   = 5;                # number of iterations for embedded training 
$beam   = "1000 100 5000";  # initial, inc, and upper limit of beam width
$wf     = 3;                # mixture weight flooring
foreach $set (@SET) {       # variance flooring  
   $vf{$set} = 0.01;
}


# Directories & Commands ===============
# project directories
$prjdir = '/home/sako/istc/VoiceMaker-1.1';

# HTS commands
$HCOMPV = '/istc/pub/bin/HCompV';
$HINIT  = '/istc/pub/bin/HInit';
$HREST  = '/istc/pub/bin/HRest';
$HEREST = '/istc/pub/bin/HERest';
$HHED   = '/istc/pub/bin/HHEd';
$HMGENS = '/istc/pub/bin/HMGenS';
$ENGINE = '/istc/pub/bin/hts_engine';

# SPTK commands
$X2X    = '/istc/pub/SPTK-3.0/bin/x2x';
$FREQT  = '/istc/pub/SPTK-3.0/bin/freqt';
$C2ACR  = '/istc/pub/SPTK-3.0/bin/c2acr';
$VOPR   = '/istc/pub/SPTK-3.0/bin/vopr';
$MC2B   = '/istc/pub/SPTK-3.0/bin/mc2b';
$BCP    = '/istc/pub/SPTK-3.0/bin/bcp';
$SOPR   = '/istc/pub/SPTK-3.0/bin/sopr';
$MERGE  = '/istc/pub/SPTK-3.0/bin/merge';
$B2MC   = '/istc/pub/SPTK-3.0/bin/b2mc';
$EXCITE = '/istc/pub/SPTK-3.0/bin/excite';
$MLSADF = '/istc/pub/SPTK-3.0/bin/mlsadf';

# SoX (to add RIFF header)
$SOX = '/usr/bin/sox';


# Switch ================================
$MKEMV = 1;  # preparing environments
$HCMPV = 1;  # computing a global variance
$IN_RE = 1;  # initialization & reestimation
$MMMMF = 1;  # making a monophone mmf
$ERST0 = 1;  # embedded reestimation (monophone)
$MN2FL = 1;  # copying monophone mmf to fullcontext one
$ERST1 = 1;  # embedded reestimation (fullcontext)
$CXCL1 = 1;  # tree-based context clustering (cmp)
$ERST2 = 1;  # embedded reestimation (clustered)
$UNTIE = 1;  # untying the parameter sharing structure
$ERST3 = 1;  # embedded reestimation (untied)
$CXCL2 = 1;  # tree-based context clustering (cmp)
$ERST4 = 1;  # embedded reestimation (re-clustered)
$CXCL3 = 1;  # tree-based context clustering (dur)
$MKUN1 = 1;  # making unseen models (1mix)
$PGEN1 = 1;  # generating speech parameter sequences (1mix)
$WGEN1 = 1;  # synthesizing waveforms (1mix)
$CONVM = 1;  # converting mmfs to the hts_engine file format
$ENGIN = 1;  # synthesizing waveforms using hts_engine
$UPMIX = 0;  # increasing the number of mixture components (1mix -> 2mix)
$ERST5 = 0;  # embedded reestimation (2mix)
$CXCL4 = 0;  # tree-based context clustering (dur, 2mix)
$MKUN2 = 0;  # making unseen models (2mix)
$PGEN2 = 0;  # generating speech parameter sequences (2mix)
$WGEN2 = 0;  # synthesizing waveforms (2mix)

1;
