import com.nttdocomo.lang.*;
import com.nttdocomo.ui.*;
import java.util.*;
import java.io.*;

import javax.microedition.io.Connector;

/*
 * $Id$
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
 public class Game2chCanvas extends Canvas implements Runnable{
 	
 	//萔
	private final int SC_WIDTH = getWidth();   //XN[
	private final int SC_HEIGHT = getHeight(); //XN[
	private final int I_WIDTH = 24;			 //L
	private final int I_HEIGHT = 24;			 //L
	private final int INIT_PHASE_LEVEL = 1;      //PhaseLevel̏l
	private final int MAX_PHASE_LEVEL = 5;      //PhaseLevel̍ől
	private final int MAX_PHASE_POINT = 16;		 //̒lȏɂȂƃxAbv
	private final int ENEMYMOVEMENT = 4;		 //Gړ
	private final int MAXENEMY = 10;			 //G
	private final int INIT_HITPOINT = 3;		 //HP
	private final int S_INIT = 0;		     //V[
	private final int S_TITLE = 3;			 //^CgV[
	private final int S_PLAY = 1;			 //vCV[
	private final int S_GAMEOVER = -1;		 //Q[I[o[V[
	private final int S_PAUSE = -2;			 //|[YV[
	private final int DATA_HISCORE = 0;		 //DATAL^ʒu
	
	//ϐ
	int bg_scroll = 0;
	int wall_scroll = 0;
	int num_y = SC_HEIGHT/16;
	int num_x = SC_WIDTH/16;
	private Graphics g;
	private Image[] image = new Image[6];
	private Image[] wall = new Image[7];
	private Thread thread;
	private int aaa = 0;
	private int hiscore;	//nCXRA
	private int scene;	//V[
	private int hitpoint;	//qbg|Cg
	private int score;	//XRA
	private int phaseLevel; //phase level
	private int phasePoint; //phase point
	private int targetX;	//LXW
	private int targetY;	//LYW
	private int num;		//摜ԍ
	private int key;		//擾L[Xe[^X
	private int[] enemyX = new int[MAXENEMY];//GLXW
	private int[] enemyY = new int[MAXENEMY];//GLYW
	private int[] starX = new int[10];//GLXW
	private int[] starY = new int[10];//GLYW
	private boolean[] enemyFlag = new boolean[MAXENEMY];//ptO
	private int acc_x, acc_y;//x(x:, y:c)
	private int i=0;		//GLp
	Random rand = new Random();//

	/**
	 * RXgN^
	 *
	 */
	public Game2chCanvas() {
	}
	
	/**
	 * Cs
	 *
	 */
	public void exe(){
		
		MediaImage m;
		long sleepTime=0;
		try {
			g=getGraphics();
			
			//摜̃[h
			for (int i=5;i>=0;i--) {
				m=MediaManager.getImage("resource:///"+i+".gif");
				m.use();
				image[i]=m.getImage();
			}
			
			//摜̃[h
			for (int i=6;i>=0;i--) {
				m=MediaManager.getImage("resource:///w_"+i+".gif");
				m.use();
				wall[i]=m.getImage();
			}			
		
			//pXbh
			thread = new Thread(this);
			thread.start();
			
			//C[v
			while (true) {
				tick();
				while (System.currentTimeMillis()<sleepTime+100);
				sleepTime=System.currentTimeMillis();
			}
		}catch(Exception e){
			e.printStackTrace();//xxx
		}	
	}
	
	/**
	 * C[v
	 *
	 */
	private void tick() {
		
		if (scene == S_INIT) {
			//gCgϐ̏
			hiscore = load(DATA_HISCORE);
			for(int i=0;i<MAXENEMY;i++){
					enemyX[i] = 0;
					enemyY[i] = SC_HEIGHT;
					enemyFlag[i] = false;
			}
			acc_x = 0;
			acc_y = 0;
			hitpoint = INIT_HITPOINT;
			score = 0;
			targetX=SC_WIDTH/2;
			targetY=SC_HEIGHT/6;
			phaseLevel = INIT_PHASE_LEVEL;
			phasePoint = 0;
			scene = S_TITLE;
			setSoftLabel(SOFT_KEY_1,"");
		}
		
		//ʂ̕`
		g.lock();
		drawBackground();
		drawWall();
		if(scene == S_TITLE) {
			g.setColor(Graphics.getColorOfName(Graphics.GRAY));
			g.drawImage(image[4],
						SC_WIDTH/2 - image[4].getWidth()/2 ,
						SC_HEIGHT/2 - image[4].getHeight()/2 );
			 g.drawString("Ver.0.1.1 by 273"
						,5
					,15);
			g.setColor(Graphics.getColorOfName(Graphics.WHITE));
			 g.drawString("Ver.0.1.1 by 273"
						,4
						,14);
						
			setSoftLabel(SOFT_KEY_2,"");
		} else if(scene == S_PLAY) {
			num = 0;
			//̕`
			enemyMoving();

			//L[Ԃ̎擾
			key=getKeypadState();
			if ((1<<Display.KEY_UP&key)!=0) {
				acc_y = 0;
				phasePoint = 0;
				phaseLevel = INIT_PHASE_LEVEL;
			}
			//L[Ƃ
			if ((1<<Display.KEY_DOWN&key)!=0) {
				if (acc_y < 8) acc_y++;
				if(phasePoint < MAX_PHASE_POINT*MAX_PHASE_LEVEL-3) phasePoint +=3;
				phaseLevel = (phasePoint/MAX_PHASE_POINT)+1;
				score += acc_y*(phaseLevel-1);
			}
			//L[𗣂ĂƂ
			if ((1<<Display.KEY_DOWN&key)==0) {
				if (targetY > SC_HEIGHT/6) {
					targetY-=3;
					if (acc_y >0) acc_y--;
				}
				if(phasePoint > 0) phasePoint-=1;
				else phasePoint = 0;
				phaseLevel = (phasePoint/MAX_PHASE_POINT)+1;
			} 
			//L[Ƃ
			if ((1<<Display.KEY_LEFT&key)==0) {
				if (acc_x>2 && acc_x>-18) acc_x--;
			}
			//L[𗣂ĂƂ
			if ((1<<Display.KEY_LEFT&key)!=0) {
				if (acc_x > -12)acc_x -= 2;
				num = 1;
			} 
			//L[Ƃ
			if ((1<<Display.KEY_RIGHT&key)==0){
				if (acc_x<-2 && acc_x < 18) acc_x++;
			}
			//L[𗣂ĂƂ
			if ((1<<Display.KEY_RIGHT&key)!=0){
				if (acc_x < 12)acc_x += 2;
				num = 2;
			}
			//E̓ւ
			if (targetX>SC_WIDTH-I_WIDTH/2) targetX = -I_WIDTH/2;
			if (targetX<-I_WIDTH/2) targetX = SC_WIDTH-I_WIDTH/2;
			
			//if((targetY+acc_y) > SC_HEIGHT/2) targetY = SC_HEIGHT/2;
			if((targetY+acc_y) >(SC_HEIGHT/3*2)) targetY = (SC_HEIGHT/3*2); 
			else if (targetY+acc_y < SC_HEIGHT/6) targetY = SC_HEIGHT/6;
			else if (targetY < SC_HEIGHT/6*5) targetY += acc_y;
			targetX += acc_x;
	
			g.drawImage(image[num],targetX,targetY);
		
			//XRA̕`
			score++;
			if(phaseLevel>2) score += (1<<(phaseLevel-3))+1;
			g.setColor(Graphics.getColorOfName(Graphics.WHITE));
			g.drawString(":" + String.valueOf(score),4,14);
			g.drawString("HP:" + String.valueOf(hitpoint),60,14);
			g.drawString("HI:" + String.valueOf(hiscore),90,14);
			g.drawString("PhaseLevel:" + String.valueOf(phaseLevel),4,24);

			setSoftLabel(SOFT_KEY_1,"~");
			setSoftLabel(SOFT_KEY_2, "I");

		} else if (scene == S_GAMEOVER){
			if (score>hiscore) { 
				save(score,DATA_HISCORE);
			}
				
			g.setColor(Graphics.getColorOfName(Graphics.WHITE));
			g.drawString("SCORE:" +  String.valueOf(score)
						,SC_WIDTH/2 - 20
						,SC_HEIGHT/2);
						
			setSoftLabel(SOFT_KEY_1,"ײ");
		} else if (scene == S_PAUSE){
			g.setColor(Graphics.getColorOfName(Graphics.WHITE));
			g.drawString("PAUSE"
						,SC_WIDTH/2 - 20
						,SC_HEIGHT/2);

			setSoftLabel(SOFT_KEY_1,"ĊJ");
		}
		g.unlock(true);
	}
	
	/**
	 * wi̕`
	 */
	private void drawBackground(){
		g.setColor(Graphics.getColorOfName(Graphics.BLACK));
		g.fillRect(0,0,SC_WIDTH,SC_HEIGHT);
		//wiC[W
		/*
		for (int i=0; i < num_x; i++){
			for(int j=0; j <= num_y; j++) {
				g.drawImage(image[5],i*16,j*16-bg_scroll);		
			}
		}
		if (bg_scroll < 15) {
			bg_scroll++;
		} else {
			bg_scroll = 0;
		}
		*/
	}
	/**
	 * wi̕`
	 */
	private void drawWall(){
		//wiC[W
		for (int i=0; i <= num_y; i++){
			g.drawImage(wall[0],0,i*16-wall_scroll);		
			g.drawImage(wall[4],SC_WIDTH-16,i*16-wall_scroll);		
		}
		if (wall_scroll < 14) {
			wall_scroll+=2;
		} else {
			wall_scroll = 0;
		}
	}
	/**
	 * XNb`pbhւ̏
	 * @param data ݃f[^
	 * @param pos ݈ʒu
	 */
	public void save(int data, int pos){

		DataOutputStream out = null;
		try {
			out = Connector.openDataOutputStream(
			   "scratchpad:///0;pos="+pos);

			out.writeInt(data);
		 	out.close();
		}
		catch( IOException e) {
		  	e.printStackTrace();
		} 

	}
	
	/**
	 * XNb`pbh̓ǂݍ
	 * @param pos ǂݍ݈ʒu
	 * @return int ǂݍ݃f[^
	 */
	public int load(int pos){
		
		int data = 0;
		try{
			DataInputStream in = Connector.openDataInputStream(
				"scratchpad:///0;pos="+pos);
			data = in.readInt();
			in.close();
		}catch(IOException e){
			e.printStackTrace();//ǂݍݎs̎̏
		}
		return data;
	}
	
	/**
	 * G̐ƈړ
	 *
	 */
	private void enemyMoving(){
		for(i=0;i<MAXENEMY;i++){
			if(enemyFlag[i]==true){
				//G̈ړ
				enemyY[i] -= ENEMYMOVEMENT + acc_y;
				if(enemyY[i]<-16){
					enemyFlag[i] = false;
				}else{
					g.drawImage(image[3],enemyX[i],enemyY[i]);
				}
			}else if(enemyFlag[i]==false && Math.abs(rand.nextInt()%100)<5){
				//G̐ݏo
				enemyX[i] = Math.abs(rand.nextInt()%SC_WIDTH);
				enemyY[i] = SC_HEIGHT;
				enemyFlag[i] = true;
			}
		}
	}
	/**
	 * 蔻p[v
	 */
	public void run(){
		while(true){
			judge();
		}
	}

	/**
	 * 蔻
	 */
	private void judge(){
		for(int j=0;j<MAXENEMY;j++){
			if(enemyFlag[j]==true){
				//蔻
				/*
				if(targetX - enemyX[j] > -I_WIDTH && //E
					targetX - enemyX[j] < 16 &&           //
					targetY - enemyY[j] > -I_HEIGHT && //
					targetY - enemyY[j] < 16){				//
				*/
				if(targetX - enemyX[j] > -18 && //E
					targetX - enemyX[j] < 10  && //
					targetY - enemyY[j] > -18 && //
					targetY - enemyY[j] < 10){ //
					g.setColor(Graphics.getColorOfName(Graphics.RED));
					g.fillRect(0,0,SC_WIDTH,SC_HEIGHT);
					enemyFlag[j] = false;
					//hitpoint--;
					if(hitpoint <=0) { scene = S_GAMEOVER; }
				}
			}
		}
	}
	
	/**
	 * HP()
	 */
	public void recover(){
		throw new UnsupportedOperationException();
	}
	/**
	 * L[Cxǧo
	 * @param nType Cxg^Cv
	 * @param nParam Cxgp[^
	 */
	public void processEvent(int nType, int nParm){
		if(nType == Display.KEY_PRESSED_EVENT) {
			switch(nParm) {
				case Display.KEY_SOFT1:
					if (scene==S_GAMEOVER){
						scene=S_INIT;
					} else if (scene==S_PLAY) {
						scene=S_PAUSE;
					} else if (scene==S_PAUSE) {
						scene=S_PLAY;
					}
					break;
				case Display.KEY_SOFT2:
					if (scene==S_TITLE){
						scene=S_PLAY;
					} else {
					  IApplication.getCurrentApp().terminate();
					}
					break;
			}
		}
	}

	public void paint(Graphics g) {}
}
