import java.util.Random;

import com.nttdocomo.ui.AudioPresenter;
import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.MApplication;
import com.nttdocomo.ui.PhoneSystem;

/**
 * LoXNX
 */
public class GraphicsCanvas extends Canvas {
	//////// tB[h ///////////////
	/** LN^[IuWF */
	private Character[] character;
	/** yIuWF */
	private Music music;
	/** wi摜IuWF */
	private BackGround background;
	/** ~[WbNIuWF */
	private AudioPresenter audio;
	/** OtBNXIuWF */
	private Graphics graphics;
	/** N */
	private int state;
	
	/** oꂳL̍ő吔 */
	private final int CHARACTER_MAX = 8;
	/** x~ */
	public static final int STATE_PAUSE = 0;
	/** 񊈐 */
	public static final int STATE_DEACTUBE = 1;
	/**  */
	public static final int STATE_ACTIVE = 2;
	
	//////// RXgN^ ////////////
	GraphicsCanvas() {
		character = new Character[CHARACTER_MAX];
		music = new Music();
		background = new BackGround();
		
		for(int i = 0; i < CHARACTER_MAX; i++) {
			character[i] = new Character();
		}
		
		graphics = getGraphics();
		state = STATE_DEACTUBE;
		
		audio = AudioPresenter.getAudioPresenter();
		audio.setMediaListener(music);
	}
	
	/**
	 * Cs
	 */
	void execution() {
		/////// [J /////////
		int attribute = 0;
		
		background.create();
		
		if(Profile.getPlayState() == true) musicPlay();
		
		try {
			while(true) {
				attribute = PhoneSystem.getAttribute(PhoneSystem.DEV_MAILBOX);
				
				if(attribute == PhoneSystem.ATTR_MAIL_NONE) process1();
				else process2();
				
				Thread.sleep(100);
			}
		} catch(InterruptedException e) {}
	}
	
	/**
	 * M[̃vZX
	 */
	private void process1() {
		//////// [J ///////////
		Random rand = new Random();
		
		graphics.lock();
		graphics.clearRect(0,0,getWidth(),getHeight());
		graphics.drawImage(background.getImage(),getWidth()/2-120,getHeight()/2-135);
		
		for(int i = 0; i < CHARACTER_MAX; i++) {
			//=== tOĂȂȂ ===
			if(character[i].getFlag() == false) {
				//=== 1/10̊mŃL ====
				if(rand.nextInt()%10 == 0) {
					//=== 1/4̊mŃL̓oʒǔ ====
					switch(Math.abs(rand.nextInt())%4) {
						//=== Eʂ ====
						case 0:
							character[i].createNomal(-16,Math.abs(rand.nextInt())%getHeight());
							character[i].setDirectionX(true);
						break;
						//=== ʂ ====
						case 1:
							character[i].createNomal(getWidth()+16,Math.abs(rand.nextInt())%getHeight());
							character[i].setDirectionX(false);
						break;
						//=== ʂ ====
						case 2:
							character[i].createNomal(Math.abs(rand.nextInt())%getWidth(),-16);
							character[i].setDirectionY(true);
						break;
						//=== ʂ ====
						case 3:
							character[i].createNomal(Math.abs(rand.nextInt())%getWidth(),getHeight()+16);
							character[i].setDirectionY(false);
						break;
					}
				}
			}
			
			//=== tOĂȂ ====
			if(character[i].getFlag() == true) {
				character[i].move();
				
				graphics.drawImage(character[i].getImage(),character[i].getX()-16,character[i].getY()-16);
				
				//=== L̏ ====
				if(character[i].getX() < -16) character[i].dispose();
				if(character[i].getX() > getWidth()+16) character[i].dispose();
				if(character[i].getY() < -16) character[i].dispose();
				if(character[i].getY() > getHeight()+16) character[i].dispose();
			}
		}
		
		graphics.unlock(true);
	}
	
	/**
	 * M[L̃vZX
	 */
	private void process2() {
		//////// [J ///////////
		Random rand = new Random();
		
		graphics.lock();
		graphics.clearRect(0,0,getWidth(),getHeight());
		graphics.drawImage(background.getImage(),getWidth()/2-120,getHeight()/2-135);
		
		for(int i = 0; i < CHARACTER_MAX; i++) {
			//=== tOĂȂȂ ===
			if(character[i].getFlag() == false) {
				//=== 1/10̊mŃL ====
				if(rand.nextInt()%10 == 0) {
					//=== 1/4̊mŃL̓oʒǔ ====
					switch(Math.abs(rand.nextInt())%4) {
						//=== Eʂ ====
						case 0:
							character[i].createSpesial(-60,Math.abs(rand.nextInt())%getHeight());
							character[i].setDirectionX(true);
						break;
						//=== ʂ ====
						case 1:
							character[i].createSpesial(getWidth()+60,Math.abs(rand.nextInt())%getHeight());
							character[i].setDirectionX(false);
						break;
						//=== ʂ ====
						case 2:
							character[i].createSpesial(Math.abs(rand.nextInt())%getWidth(),-45);
							character[i].setDirectionY(true);
						break;
						//=== ʂ ====
						case 3:
							character[i].createSpesial(Math.abs(rand.nextInt())%getWidth(),getHeight()+45);
							character[i].setDirectionY(false);
						break;
					}
				}
			}
			
			//=== tOĂȂ ====
			if(character[i].getFlag() == true) {
				character[i].move();
				
				graphics.drawImage(character[i].getImage(),character[i].getX()-60,character[i].getY()-45);
				
				//=== L̏ ====
				if(character[i].getX() < -60) character[i].dispose();
				if(character[i].getX() > getWidth()+60) character[i].dispose();
				if(character[i].getY() < -45) character[i].dispose();
				if(character[i].getY() > getHeight()+45) character[i].dispose();
			}
		}
		
		graphics.unlock(true);
	}
	
	/**
	 * y̍Đ
	 */
	public void musicPlay() {
		music.create();
		
		audio.setSound(music.getSound());
		audio.play();
	}
	
	/**
	 * y̒~
	 * 
	 */
	public void musicStop() {
		audio.stop();
	}
	
	/**
	 * NԂ̐ݒ
	 * @param state N
	 */
	public void setState(int state) {
		this.state = state;
	}
	
	/**
	 * NԂ̎擾
	 * @return N
	 */
	public int getState() {
		return state;
	}
	
	/**
	 * yCg()
	 * @param graphics `ɎgpGraphicsIuWFNg
	 */
	public void paint(Graphics graphics) {}
	
	/**
	 * L[Cxg
	 * @param type Cxg̃^Cv
	 * @param param Cxg̃p[^
	 */
	public void processEvent(int type, int param) {
		//=== NԂ̎ ====
		if(state == STATE_ACTIVE) {
			if(type == Display.KEY_RELEASED_EVENT) {
				switch(param) {
					//=== \tgL[1ꂽ ====
					case Display.KEY_SOFT1:
						((MApplication)MApplication.getCurrentApp()).deactivate();
						setSoftLabel(SOFT_KEY_1,"");
						setSoftLabel(SOFT_KEY_2,"");
						break;
					
					//=== \tgL[2ꂽ ====
					case Display.KEY_SOFT2:
						if(Profile.getPlayState() == true) {
							musicStop();
							Profile.setPlayState(false);
							setSoftLabel(SOFT_KEY_2,"~");
						} else {
							musicPlay();
							Profile.setPlayState(true);
							setSoftLabel(SOFT_KEY_2,"");
						}
						
						break;
					
					case Display.KEY_IAPP:
						((MApplication)MApplication.getCurrentApp()).deactivate();
						setSoftLabel(SOFT_KEY_1,"");
						setSoftLabel(SOFT_KEY_2,"");
						break;
				}
			}
		}
	}
}
