import java.io.DataInputStream;
import java.io.IOException;

import javax.microedition.io.Connector;

import com.nttdocomo.io.HttpConnection;
import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.MediaImage;
import com.nttdocomo.ui.MediaManager;
import com.nttdocomo.ui.MediaSound;

/**
 * HTTPRlNV[eBeBNX
 */
public class HttpConnectionUtility {
	//////// RXgN^ ///////////
	private HttpConnectionUtility() {}
	
	//////// \bh ////////////////
	/**
	 * lbg[Nf[^eʓǍ
	 * @param url ǍݐURL Sting^
	 * @return Ǎ񂾃f[^e int^
	 */
	public static int getDataLength(String url) {
		/////// [J //////////
		int length = 0;
		HttpConnection http = null;
		
		try {
			http = (HttpConnection)Connector.open(url,Connector.READ);
			http.setRequestMethod(HttpConnection.GET);
			http.connect();
			
			length = (int)http.getLength();
			
			http.close();
		} catch(IOException e) {}
		
		return length;
	}

	/**
	 * lbg[Nf[^Ǎ
	 * @param url ǍݐURL String^
	 * @return Ǎ񂾃f[^ byte[]^
	 */
	public static byte[] getData(String url) {
		/////// [J //////////
		byte[] data = null;
		HttpConnection http = null;
		DataInputStream in = null;
		
		try {
			http = (HttpConnection)Connector.open(url,Connector.READ);
			http.setRequestMethod(HttpConnection.GET);
			http.connect();
			
			data = new byte[(int)http.getLength()];
			
			in = http.openDataInputStream();
			in.read(data);
			
			in.close();
			http.close();
		} catch(IOException e) {}
		
		return data;
	}
	
	/**
	 * lbg[Nf[^Ǎ
	 * @param url ǍݐURL String^
	 * @param length Ǎ݃f[^
	 * @return Ǎ񂾃f[^ byte[]^
	 */
	public static byte[] getData(String url, int length) {
		/////// [J //////////
		byte[] data = null;
		HttpConnection http = null;
		DataInputStream in = null;
		
		try {
			http = (HttpConnection)Connector.open(url,Connector.READ);
			http.setRequestMethod(HttpConnection.GET);
			http.connect();
			
			data = new byte[length];
			
			in = http.openDataInputStream();
			in.read(data);
			
			in.close();
			http.close();
		} catch(IOException e) {}
		
		return data;
	}
	
	/**
	 * lbg[N摜Ǎ
	 * @param url ǍݐURL String^
	 * @return Ǎ񂾉摜 Image^
	 */
	public static Image getImage(String url) {
		/////// [J //////////
		Image image = null;
		MediaImage media = null;
		HttpConnection http = null;
		DataInputStream in = null;
		
		try {
			http = (HttpConnection)Connector.open(url,Connector.READ);
			http.setRequestMethod(HttpConnection.GET);
			http.connect();
			
			in = http.openDataInputStream();
			
			media = MediaManager.getImage(in);
			media.use();
			image = media.getImage();
			
			in.close();
			http.close();
		} catch(IOException e) {}
		
		return image;
	}
	
	/**
	 * lbg[NTEhǍ
	 * @param url ǍݐURL String^
	 * @return Ǎ񂾃TEh MediaSound^
	 */
	public static MediaSound getSound(String url) {
		/////// [J //////////
		MediaSound sound = null;
		HttpConnection http = null;
		DataInputStream in = null;
		
		try {
			http = (HttpConnection)Connector.open(url,Connector.READ);
			http.setRequestMethod(HttpConnection.GET);
			http.connect();
			
			in = http.openDataInputStream();
			
			sound = MediaManager.getSound(in);
			sound.use();
			
			in.close();
			http.close();
		} catch(IOException e) {}
		
		return sound;
	}
}
