import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.MediaSound;

/**
 * XNb`pbhf[^vtB[NX
 */
public class Profile {
	//////// tB[h ///////////
	/** f[^TCY */
	private static int[] size;
	
	/** L摜 */
	public static final int CHARACTER_MAX = 71;
	/** wi摜 */
	public static final int PICTURE_MAX = 3;
	/** y */
	public static final int MUSIC_MAX = 28;
	/** fBAő吔 */
	public static final int MEDIA_MAX = CHARACTER_MAX+PICTURE_MAX+MUSIC_MAX;
	/** int^̃oCg */
	public static final int INT_SIZE = 4;
	/** f[^eʊi[oCg */
	public static final int DATA_SIZE = MEDIA_MAX*INT_SIZE;
	
	//////// RXgN^ //////////
	private Profile() {}
	
	//////// \bh ////////////////
	/**
	 * f[^TCYIuWF̏
	 */
	public static void use() {
		size = new int[MEDIA_MAX];
		
		for(int i = 0; i < MEDIA_MAX; i++) {
			size[i] = ScratchpadUtility.loadInt(i*INT_SIZE);
		}
	}
	
	/**
	 * f[^TCYIuWF̔j
	 */
	public static void dispose() {
		size = null;
	}
	
	/**
	 * L摜̓Ǎ
	 * @param number IuWFNgԍ
	 * @return Ǎ񂾉摜 Image^
	 */
	public static Image getImage(int number) {
		//////// [J ///////////
		int offset = DATA_SIZE;
		Image image = null;
		
		if(number >= 0) {
			if(number < CHARACTER_MAX+PICTURE_MAX) {
				for(int i = 0; i < number; i++) offset += size[i];
				image = ScratchpadUtility.loadImage(offset);
			}
		}
		
		return image;
	}
	
	/**
	 * y̓Ǎ
	 * @param number IuWFNgԍ
	 * @return Ǎ񂾉y MediaSound^
	 */
	public static MediaSound getSound(int number) {
		/////// [J ////////////
		int offset = DATA_SIZE;
		MediaSound sound = null;
		
		if(number >= CHARACTER_MAX+PICTURE_MAX) {
			if(number < MEDIA_MAX) {
				for(int i = 0; i < number; i++) offset += size[i];
				sound = ScratchpadUtility.loadSound(offset);
			}
		}
		
		return sound;
	}
	
	/**
	 * ItZbg̓Ǎ
	 * @param number IuWFNgԍ
	 * @return Ǎ񂾃ItZbg int^
	 */
	public static int getOffset(int number) {
		/////// [J //////////
		int offset = DATA_SIZE;
		
		if(number < MEDIA_MAX) {
			for(int i = 0; i < number; i++) offset += size[i];
		}
		
		return offset;
	}
	
	/**
	 * yĐԂ̓Ǎ
	 * @return yĐ Đ true, ĐȂ false
	 */
	public static boolean getPlayState() {
		/////// [J //////////
		int offset = DATA_SIZE;
		int play = 0;
		
		for(int i = 0; i < MEDIA_MAX; i++) offset += size[i];
		
		play = ScratchpadUtility.loadInt(offset);
		
		if(play == 0) return false;
		else return true;
	}
	
	/**
	 * yĐԂ̏
	 * @param state yĐ Đ true, ĐȂ false
	 */
	public static void setPlayState(boolean state) {
		/////// [J //////////
		int offset = DATA_SIZE;
		
		for(int i = 0; i < MEDIA_MAX; i++) offset += size[i];
		
		if(state == false) ScratchpadUtility.writeInt(0,offset);
		else ScratchpadUtility.writeInt(1,offset);
	}
	
	/**
	 * f[^eʂ̓Ǎ
	 * @param number IuWFNgԍ
	 * @return Ǎ񂾃f[^e int^
	 */
	public static int getSize(int number) {
		////// [J //////////
		int data = 0;
		
		if(number < MEDIA_MAX) data = size[number];
		
		return data;
	}
	
	/**
	 * XNb`pbhf[^Ă邩ۂ
	 * @return Ă true, ĂȂ false
	 */
	public static boolean checkInit() {
		if(size == null) return false;
		return true;
	}
}
