import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import javax.microedition.io.Connector;

import com.nttdocomo.io.ConnectionException;
import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.MediaImage;
import com.nttdocomo.ui.MediaManager;
import com.nttdocomo.ui.MediaSound;

/**
 * XNb`pbh[eBeBNX
 */
public class ScratchpadUtility {
	//////// RXgN^ /////////
	private ScratchpadUtility(){}
	
	//////// \bh ///////////////
	/**
	 * XNb`pbhւ̏
	 * @param data ݃f[^ byte[]^
	 * @param offset ݊Jnʒu n߂牽oCgڂ
	 */
	public static void writeData(byte[] data, int offset) {
		/////// [J //////////
		DataOutputStream out = null;
		
		try {
			out = Connector.openDataOutputStream("scratchpad:///0;pos="+ offset);
			out.write(data);
			out.close();
		} catch(IOException e) {}
	}
	
	/**
	 * XNb`pbhւ̏
	 * @param data ݃f[^ int^
	 * @param offset ݊Jnʒu n߂牽oCgڂ
	 */
	public static void writeInt(int data, int offset) {
		/////// [J ///////////
		DataOutputStream out = null;
		
		try {
			out = Connector.openDataOutputStream("scratchpad:///0;pos="+ offset);
			out.writeInt(data);
			out.close();
		} catch(IOException e) {}
	}
	
	/**
	 * XNb`pbh̓Ǎ
	 * @param offset Ǎ݊Jnʒu n߂牽oCgڂ
	 * @return Ǎ񂾉摜 Image^
	 */
	public static Image loadImage(int offset) {
		/////// [J ////////////
		Image image = null;
		MediaImage media = null;
		
		try {
			media = MediaManager.getImage("scratchpad:///0;pos="+ offset);
			media.use();
			image = media.getImage();
		} catch(ConnectionException e) {}
		
		return image;
	}
	
	/**
	 * XNb`pbh̓Ǎ
	 * @param offset Ǎ݊Jnʒu n߂牽oCgڂ
	 * @return Ǎ񂾃TEh MediaSound^
	 */
	public static MediaSound loadSound(int offset) {
		/////// [J /////////////
		MediaSound sound = null;
		
		try {
			sound = MediaManager.getSound("scratchpad:///0;pos="+ offset);
			sound.use();
		} catch(ConnectionException e) {}
		
		return sound;
	}
	
	/**
	 * XNb`pbh̓Ǎ
	 * @param offset Ǎ݊Jnʒu n߂牽oCgڂ
	 * @return Ǎ񂾃f[^ int^
	 */
	public static int loadInt(int offset) {
		////// [J //////////
		int data = 0;
		DataInputStream in = null;
		
		try {
			in = Connector.openDataInputStream("scratchpad:///0;pos="+ offset);
			data = in.readInt();
			in.close();
		} catch(IOException e) {}
		
		return data;
	}
	
	/**
	 * XNb`pbhɃf[^L邩ۂ
	 * @return ݂ true, ݂Ȃ false
	 */
	public static boolean checkInit() {
		/////// [J //////////
		int data = 0;
		DataInputStream in = null;
		
		try {
			in = Connector.openDataInputStream("scratchpad:///0;pos=0");
			data = in.readInt();
			in.close();
		} catch(IOException e) {}
		
		if(data == 0) {
			return false;
		} else {
			return true;
		}
	}
}
