// ObjDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbemu.h"
#include "ObjDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define R_BGP	0xFF47
#define R_OBP0	0xFF48
#define R_OBP1	0xFF49

CDC* pODC;
extern DWORD dwSize;
LPBITMAPINFO obj_info = (LPBITMAPINFO)new char[dwSize];
extern BYTE Rmem(unsigned short);
extern BYTE MEM[0x10000];
extern BYTE Colours[4];
extern bool fTileDlg, fObjDlg;
int OamNo;

/////////////////////////////////////////////////////////////////////////////
// CObjDlg _CAO


CObjDlg::CObjDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CObjDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CObjDlg)
	m_fObj1 = FALSE;
	m_fObj2 = FALSE;
	m_fObj3 = FALSE;
	m_fObj4 = FALSE;
	m_txtPos = _T("");
	m_txtNo = _T("");
	m_txtTile = _T("");
	m_txtSize = _T("");
	//}}AFX_DATA_INIT
}


void CObjDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CObjDlg)
	DDX_Check(pDX, IDC_CHECK_OBJ1, m_fObj1);
	DDX_Check(pDX, IDC_CHECK_OBJ2, m_fObj2);
	DDX_Check(pDX, IDC_CHECK_OBJ3, m_fObj3);
	DDX_Check(pDX, IDC_CHECK_OBJ4, m_fObj4);
	DDX_Text(pDX, IDC_OBJ_POSITION, m_txtPos);
	DDX_Text(pDX, IDC_OBJ_NO, m_txtNo);
	DDX_Text(pDX, IDC_OBJ_TILENO, m_txtTile);
	DDX_Text(pDX, IDC_OBJ_SIZE, m_txtSize);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CObjDlg, CDialog)
	//{{AFX_MSG_MAP(CObjDlg)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_OBJ_NEXT, OnObjNext)
	ON_BN_CLICKED(IDC_OBJ_RETURN, OnObjReturn)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjDlg bZ[W nh

void CObjDlg::OnClose()
{
	fObjDlg=false;
	CDialog::OnClose();
}

void CObjDlg::ShowObj()
{
	unsigned char posx, posy, tile, flag;
	unsigned short tdpy;
	unsigned char tdd, tds, tilebit, size;
	unsigned short tda;
	unsigned char ObjBuffer[8*16];
	unsigned int FBA;

	posy=Rmem(0xFE00+OamNo*4);
	posx=Rmem(0xFE01+OamNo*4);
	tile=Rmem(0xFE02+OamNo*4);
	flag=Rmem(0xFE03+OamNo*4);

	UpdateData(true);
	m_txtNo.Format("%d/40 (%4Xh)", OamNo, 0xFE00+OamNo*4);
	m_txtPos.Format("(%d, %d)", posx, posy);
	m_txtTile.Format("%d/256", tile);
	m_txtSize=(Rmem(0xFF40)&0x04)?"8*16":"8x8";
	m_fObj1=(flag&0x10)?true:false;
	m_fObj2=(flag&0x20)?true:false;
	m_fObj3=(flag&0x40)?true:false;
	m_fObj4=(flag&0x80)?true:false;
	UpdateData(false);

	size=8;
	size=(Rmem(0xFF40)&0x04)?16:8;
	tda=0x8000+(0x10*tile);
	for(tdpy=0; tdpy<size; tdpy++){	// ^Cf[^
		tdd = MEM[tda++];		// 1oCgڂ̃^Cf[^
		tds = MEM[tda++];	// 2oCgڂ̃^Cf[^
		FBA=tdpy*8;
		for(tilebit=(flag&0x20)?0x01:0x80; tilebit;	/*XvCĝX]*/
			tilebit=(flag&0x20)?tilebit<<1:tilebit>>1, FBA++){
			if(~tdd&~tds&tilebit)ObjBuffer[FBA]=(flag&0x10)?0x03&MEM[R_OBP1]:0x03&MEM[R_OBP0];	/*OBJppbg*/;
			if(tdd&~tds&tilebit)ObjBuffer[FBA]=(flag&0x10)?0x03&(MEM[R_OBP1]>>2):0x03&(MEM[R_OBP0]>>2);
			if(~tdd&tds&tilebit)ObjBuffer[FBA]=(flag&0x10)?0x03&(MEM[R_OBP1]>>4):0x03&(MEM[R_OBP0]>>4);
			if(tdd&tds&tilebit)ObjBuffer[FBA]=(flag&0x10)?0x03&(MEM[R_OBP1]>>6):0x03&(MEM[R_OBP0]>>6);
		}
	}

	HDC	hMemDC	= ::CreateCompatibleDC(pODC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pODC->m_hDC, &obj_info->bmiHeader, CBM_INIT, ObjBuffer, obj_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);
	::StretchBlt(pODC->m_hDC, 140, 15, 80, 80, hMemDC, 0, 0, 8, size, SRCCOPY);
	::DeleteObject(hBitmap);
}

void CObjDlg::OnObjNext()
{
	if(OamNo>=39)OamNo=39;
	else OamNo++;

	ShowObj();
}

void CObjDlg::OnObjReturn()
{
	if(OamNo<=0)OamNo=0;
	else OamNo--;

	ShowObj();
}

BOOL CObjDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	OamNo=0;

	memset(obj_info, 0, sizeof(BITMAPINFOHEADER));
	obj_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	obj_info->bmiHeader.biWidth		= 8;
	obj_info->bmiHeader.biHeight	= -16;
	obj_info->bmiHeader.biPlanes	= 1;
	obj_info->bmiHeader.biBitCount	= 8;

	// BGPWX^pbgϊ
	obj_info->bmiColors[0].rgbBlue = 
	obj_info->bmiColors[0].rgbGreen = 
	obj_info->bmiColors[0].rgbRed = Colours[0];
	obj_info->bmiColors[0].rgbReserved = 0;
	obj_info->bmiColors[1].rgbBlue = 
	obj_info->bmiColors[1].rgbGreen = 
	obj_info->bmiColors[1].rgbRed = Colours[1];
	obj_info->bmiColors[1].rgbReserved = 0;
	obj_info->bmiColors[2].rgbBlue = 
	obj_info->bmiColors[2].rgbGreen = 
	obj_info->bmiColors[2].rgbRed = Colours[2];
	obj_info->bmiColors[2].rgbReserved = 0;
	obj_info->bmiColors[3].rgbBlue = 
	obj_info->bmiColors[3].rgbGreen = 
	obj_info->bmiColors[3].rgbRed = Colours[3];
	obj_info->bmiColors[3].rgbReserved = 0;

	pODC = this->GetDC();
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CObjDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	ShowObj();
}


BOOL CObjDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){			
			case VK_ESCAPE:
				return false;
			case VK_RIGHT:
//				GetDlgItem(IDC_OBJ_NEXT)->SetFocus();
				OnObjNext();
				break;
			case VK_LEFT:
//				GetDlgItem(IDC_OBJ_RETURN)->SetFocus();
				OnObjReturn();
				break;
			default:
				break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CObjDlg::OnOK()
{

}

void CObjDlg::OnCancel()
{
	EndDialog(0);
}
