// GBEmuDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBEmuCE.h"
#include "GBEmuDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	_WINCE_GDI
#define	_WIN_CMN

CGBEmuDlg GBEmu;					// _CAONX̐錾
static void CPU();					// CPUG~[V
void InitializeMemory();			// IOWX^̏
void InitializeRegister();			// CPUWX^̏
void InitializeVideo(HDC hDC);		// obNobt@̏
void DrawLine();					// LYWX^̃C쐬
void LCDDraw();
void Interrupt();
void EndInterrupt();
CMenu	Menu;

#include "../include/defines.h"
#include "../gbcore/memory.c"
#include "../gbcore/cpu.c"
#include "../gbcore/mainloop.c"
#include "../gbcore/video.c"

/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg _CAO

CGBEmuDlg::CGBEmuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGBEmuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGBEmuDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pTMain = NULL;
}

void CGBEmuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGBEmuDlg)
		// : ̏ꏊɂ ClassWizard ɂ DDX  DDV ̌Ăяoǉ܂B
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGBEmuDlg, CDialog)
	//{{AFX_MSG_MAP(CGBEmuDlg)
	ON_WM_CLOSE()
	ON_COMMAND(ID_MENU_OPEN, OnMenuOpen)
	ON_COMMAND(ID_MENU_RESET, OnMenuReset)
	ON_COMMAND(ID_MENU_EXIT, OnMenuExit)
	ON_WM_PAINT()
	ON_COMMAND(ID_MENU_ABOUT, OnMenuAbout)
	ON_BN_CLICKED(IDC_BUTTON_OPEN, OnButtonOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg bZ[W nh

BOOL CGBEmuDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	CenterWindow(GetDesktopWindow());	// HPC ʂ̒ɐݒ

/*	if(m_Menu.LoadMenu(IDR_MENU)==0)
		MessageBox(NULL, NULL, MB_OK);
	SetMenu(&m_Menu);
*/

	hDC = ::GetDC(m_hWnd);
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	CDialog::GetClientRect(&DlgSize);
	SetRect(&DlgSize, 0, 0, GB_LCD_X-2, GB_LCD_Y-2);
//	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, 165, 190, SWP_NOMOVE);

	DWORD dwByte;

	if(AfxGetApp()->m_lpCmdLine[0]){
		hFile = CreateFile(AfxGetApp()->m_lpCmdLine, GENERIC_READ, FILE_SHARE_READ, 
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, NULL);
		ReadFile(hFile, ROM, ROM_SIZE, &dwByte, NULL);
		OnMenuReset();
	}

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

UINT CGBEmuDlg::ThreadMain(LPVOID pParam)
{
	((CGBEmuDlg*)pParam)->MainLoop();

	return 0;
}

void CGBEmuDlg::OnClose() 
{
	CPUIsRunning=0;
	EndDialog(0);
}

void CGBEmuDlg::OnMenuOpen() 
{
	OPENFILENAME ofn;
	DWORD dwByte;
	CString filename;

	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile = filename.GetBuffer(512);
	ofn.lpstrFilter = _T("Gameboy ROM Files (*.gb;*.bin)\0*.gb;*.bin\0All Files (*.*)\0*.*");
	ofn.nMaxFileTitle = 512;
	ofn.nMaxFile = 512;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = GBEmu.m_hWnd;

	if(GetOpenFileName(&ofn)){
		hFile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, 
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, NULL);
		ReadFile(hFile, ROM, ROM_SIZE, &dwByte, NULL);
		OnMenuReset();
		GetDlgItem(IDC_BUTTON_OPEN)->EnableWindow(false);
	}
}

void CGBEmuDlg::OnMenuReset() 
{
	if(hFile!=NULL){
		CPUIsRunning = 0;
		Sleep(300);
		if(!(ROM[0][0x0148]==0x00||ROM[0][0x0148]==0x01||
			ROM[0][0x0148]==0x02||ROM[0][0x0148]==0x03)){
				MessageBox(_T("Unsupported ROM size"), NULL, MB_ICONSTOP);
				return;
		}
		InitializeMemory();
		InitializeRegister();
		//MainLoop();
		m_pTMain = AfxBeginThread((AFX_THREADPROC)ThreadMain, this);
	}
}

void CGBEmuDlg::OnMenuExit() 
{
	CGBEmuDlg::OnClose();	
}

void CGBEmuDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	// ʂ̍ĕ`
	LCDDraw();
		
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void InitializeVideo(HDC hDC)
{	/*rbg}bv*/

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 8;

	bmp_info.bmiColors[0].rgbRed = 
	bmp_info.bmiColors[0].rgbGreen = 
	bmp_info.bmiColors[0].rgbBlue = Colours[0];
	bmp_info.bmiColors[0].rgbReserved = 0;
	bmp_info.bmiColors[1].rgbRed = 
	bmp_info.bmiColors[1].rgbGreen = 
	bmp_info.bmiColors[1].rgbBlue = Colours[1];
	bmp_info.bmiColors[1].rgbReserved = 0;
	bmp_info.bmiColors[2].rgbRed = 
	bmp_info.bmiColors[2].rgbGreen = 
	bmp_info.bmiColors[2].rgbBlue = Colours[2];
	bmp_info.bmiColors[2].rgbReserved = 0;
	bmp_info.bmiColors[3].rgbRed = 
	bmp_info.bmiColors[3].rgbGreen = 
	bmp_info.bmiColors[3].rgbBlue = Colours[3];
	bmp_info.bmiColors[3].rgbReserved = 0;

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CGBEmuDlg::LCDDraw()
{ // LCDʂ̃G~[Vƕ\
	memcpy(pBitmap, FrameBuffer, GB_LCD_X * GB_LCD_Y);
	hDC = ::GetDC(m_hWnd);

	::StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC, 0, 0, GB_LCD_X, GB_LCD_Y, SRCCOPY);
	::ReleaseDC(m_hWnd, hDC);
}

void CGBEmuDlg::OnMenuAbout() 
{
	GBEmu.MessageBox(_T("GameboyVM 0.03 for WinCE\nCopyright 2002 Y_N\n\nhttps://sourceforge.jp/projects/gbemu/"), NULL, MB_OK);
}

void CGBEmuDlg::OnButtonOpen() 
{
	OnMenuOpen();
}

BOOL CGBEmuDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){			
		case VK_RIGHT:
			keyflag&=~0x01;
			keyint=1;
			break;
		case VK_LEFT:
			keyflag&=~0x02;
			keyint=1;
			break;
		case VK_UP:
			keyflag&=~0x04;
			keyint=1;
			break;
		case VK_DOWN:
			keyflag&=~0x08;
			keyint=1;
			break;
		case 'Z':
			keyflag&=~0x10;
			keyint=1;
			break;
		case 'X':
			keyflag&=~0x20;
			keyint=1;
			break;
		case ' ':
			keyflag&=~0x40;
			keyint=1;
			break;
		case VK_RETURN:
			keyflag&=~0x80;
			keyint=1;
			break;
		default:
			break;
		}
	}
	if(pMsg->message==WM_KEYUP){
		switch(pMsg->wParam){
		case VK_RIGHT:
			keyflag|=0x01;
			keyint=2;
			break;
		case VK_LEFT:
			keyflag|=0x02;
			keyint=2;
			break;
		case VK_UP:
			keyflag|=0x04;
			keyint=2;
			break;
		case VK_DOWN:
			keyflag|=0x08;
			keyint=2;
			break;
		case 'Z':
			keyflag|=0x10;
			keyint=2;
			break;
		case 'X':
			keyflag|=0x20;
			keyint=2;
			break;
		case ' ':
			keyflag|=0x40;
			keyint=2;
			break;
		case VK_RETURN:
			keyflag|=0x80;
			keyint=2;
			break;
		default:
			break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CGBEmuDlg::OnOK()
{

}

