
/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/



void InitializeRegister()
{ /*CPUWX^̏*/
	cpu.AF=0x01B0;
	cpu.BC=0x0013;
	cpu.DE=0x00D8;
	cpu.HL=0x014D;
	cpu.SP=0xFFFE;
	cpu.PC=0x0100;
    cpu.ime=0;
    cpu.halt=0;
    cpu.stop=0;
	keyflag=0xFF;
	keyint=0;
	mbc=1;
	rambc=0;
	e_rambc=0;
    CPUIsRunning=1;
	irq_type=-1;
	irqs[0]=0;
	irqs[1]=0;
	irqs[2]=0;
	irqs[3]=0;
	irqs[4]=0;
}

_inline void EndInterrupt()
{
	u32	irq_sp;

	REG[r_IF]&=~bit_mask[irq_type];
	
	irqs[irq_type]=0;
	irq_type=-1;
	for(irq_sp=0;irq_sp<5;irq_sp++){
		if(irqs[irq_sp]){
			cpu.ime=0;
			REG[r_IF]|=bit_mask[irq_sp];
			if(cpu.halt){
				cpu.halt=0;
				cpu.PC++;
			}
			PUSH(cpu.PCH,cpu.PCL);
			cpu.PC=irq_adr[irq_sp];
			irq_type=irq_sp;
			return;
		}
	}
}

_inline void Interrupt(int irq)
{
	if((REG[r_IE] & bit_mask[irq]) && (cpu.ime)){
		if(irq_type==-1){
			cpu.ime=0;
			REG[r_IF]|=bit_mask[irq];
			if(cpu.halt){
				cpu.halt=0;
				cpu.PC++;
			}
			PUSH(cpu.PCH,cpu.PCL);
			cpu.PC=irq_adr[irq];
			irq_type=irq;
		}else{
			irqs[irq]=1;
		}
	}
}


#ifdef	_WIN32_GDI
void CGBEmuDlg::MainLoop()
#endif
#ifdef	_WINCE_GDI
void CGBEmuDlg::MainLoop()
#endif
#ifdef	_SDL
static void MainLoop()
#endif
#ifdef	_WIN32_LITE
static void MainLoop()
#endif
{
	static int htime=456;		/*70224/154=456clock:1087s*/
	static long ttime=0;
	static u32 r_div=0;
	static u32 cycle=0;
	static u32 tmppc;
	static u32 irq_flags=0;
	static const u32 tac_table[]={4096, 262144, 65536, 16384};
	static DWORD WaitTime;	/*^C}[1000/59.73=16.74*/
	
	WaitTime = timeGetTime() + 17;

	while(CPUIsRunning){

		REG[r_STAT]&=~0x07;	/*modetȌ init mode flags*/

		htime-=cycle;
		if(htime<=0){
			htime+=456;	/* h-sync*/
			irq_flags=0;
			if(REG[r_LCDC]&0x80){
				REG[r_LY]=(REG[r_LY]>=154)?0:REG[r_LY]+1;
#ifdef	_WIN32_GDI
				if(f16Dib)DrawLine16();else
#endif	/*_WIN32_GDI*/
				DrawLine();
				if(REG[r_LY]==0){	/* v-sync*/
					DrawLCD();
					FrameCount++;
#ifdef	_WIN32_GDI
					if(fSound && (REG[r_NR52]&0x80)){
						PlayGBSound();
					}
					if(fFps)ShowFps();
#endif	/*_WIN32_GDI*/
#ifdef	_SDL
					SDL_PollEvent(&event);
					if(event.type==SDL_QUIT)exit(0);
#endif	/*_SDL*/
					while((WaitTime > timeGetTime()) && fVsync){Sleep(1);};	/*ҋ@*/
					WaitTime = timeGetTime() + 17;
				}
			}else{
				REG[r_STAT]&=~0x04;
				REG[r_LY]=0;
			}
		}

		if(REG[r_LCDC]&0x80){	/*LCDғ lcd running*/
			if(REG[r_LY]>=144){	/*A*/
				REG[r_STAT]|=0x01;
				if(REG[r_LY]==144){	/* AJn v-blank*/
					if(!(irq_flags&0x20)){
						irq_flags=0x20;
						Interrupt(IRQ_VBLANK);
					}else if((REG[r_STAT]&0x10) && !(irq_flags&0x02)){
						irq_flags=0x02;
						Interrupt(IRQ_LCDC);	/*Mode01*/
					}
				}
				if(REG[r_LY]==REG[r_LYC])REG[r_STAT]|=0x04;
			}else if(REG[r_LY]==REG[r_LYC]){
				REG[r_STAT]|=0x04;
				if((REG[r_STAT]&0x40) && !(irq_flags&0x80)){
					irq_flags=0x80;
					Interrupt(IRQ_LCDC);	/*LY==LYC*/
					if(htime<=204){/*mode00*/}
					else if(htime<=376)REG[r_STAT]|=0x03;
					else REG[r_STAT]|=0x02;
				}
			}else if(htime<=204){	/*A h-blank*/
				if((REG[r_STAT]&0x08) && !(irq_flags&0x04)){
					irq_flags=0x04;
					Interrupt(IRQ_LCDC);	/*mode00*/
				}
			}else if(htime<=376){	/*OAM,VRAMANZX*/
				REG[r_STAT]|=0x03;	/*mode11*/
			}else{	/*OAMANZX*/
				REG[r_STAT]|=0x02;
				if((REG[r_STAT]&0x20) && !(irq_flags&0x10)){
					irq_flags=0x10;
					Interrupt(IRQ_LCDC);	/*Mode10*/
				}
			}
		}

		r_div+=cycle;	/*256NbNłP*/
		if(r_div>=256){
			r_div-=256;
			REG[r_DIV]++;
		}

		if(REG[r_TAC]&0x04){  /*TIMA^C}[Jn*/
			ttime+=cycle;
			if(tac_table[(REG[r_TAC]&0x03)]-ttime<=0){	/*̓NbN̑I*/
				REG[r_TIMA]++;
				ttime-=tac_table[(REG[r_TAC]&0x03)];
				if((u8)(REG[r_TIMA]+1)==0){
					REG[r_TIMA]=REG[r_TMA];
					Interrupt(IRQ_TIMER);
				}
			}
		}

		if(REG[r_SC]==0x80){	/*f[^]*/
			REG[r_SC]&=~0x80;
			REG[r_SB]=0xFF;	/*Ms*/
			/*Interrupt(IRQ_SERIAL);*/
		}

		if(keyint){	/*{^̒e*/
			/*if(keyint==1)*/Interrupt(IRQ_KEY);	/*High-to-Low*/
			keyint=0;
		}

#ifdef	_WIN32_GDI
		if(fSound)Sound_ch1(cycle);
		if(fNext){
			fNext=false;
			SuspendThread(m_pTMain->m_hThread);
			SuspendThread(m_pTGUI->m_hThread);
			m_pDasm->UpdateStack(true);
			m_pDasm->UpdateRegs();
			m_pDasm->SetDisasm();
		}
		if(fBreak){
			if((cpu.PC==bp1)||(cpu.PC==bp2)||(cpu.PC==bp3)){
				SuspendThread(m_pTMain->m_hThread);
				SuspendThread(m_pTGUI->m_hThread);
				m_pDasm->UpdateStack(true);
				m_pDasm->UpdateRegs();
				m_pDasm->SetDisasm();
			}
		}
#endif	/*_WIN32_GDI*/
		
		if(RMem(cpu.PC)==0xCB){
			cycle=Cycles_cb[RMem(cpu.PC)];
			tmppc=2;
			Cpu_cb();	
		}else{
			cycle=Cycles[RMem(cpu.PC)];
			tmppc=PC_table[RMem(cpu.PC)];
			Cpu();
		}
		cpu.PC+=tmppc;
	}

}
