
/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/


void InitializeMemory();
static int WMem(u16, u8);
_inline u8 RMem(u16);

void InitializeMemory()
{ /*oN֖̐ؑΉ*/

	REG[r_P1]=0xCF;

	REG[r_TIMA]=0x00;
	REG[r_TMA]=0x00;
	REG[r_TAC]=0x00;

	REG[r_NR10]=0x80;
	REG[r_NR11]=0xBF;
	REG[r_NR12]=0xF3;
	REG[r_NR14]=0xBF;
	REG[r_NR21]=0x3F;
	REG[r_NR22]=0x00;
	REG[r_NR24]=0xBF;
	REG[r_NR30]=0x7F;
	REG[r_NR31]=0xFF;
	REG[r_NR32]=0x9F;
	REG[r_NR34]=0xBF;
	REG[r_NR41]=0xFF;
	REG[r_NR42]=0x00;
	REG[r_NR43]=0x00;
	REG[r_NR44]=0xBF;
	REG[r_NR50]=0x77;
	REG[r_NR51]=0xF3;
	REG[r_NR52]=0xF1;

	REG[r_LCDC]=0x91;
	REG[r_SCY]=0x00;
	REG[r_SCX]=0x00;
	REG[r_LYC]=0x00;
	REG[r_BGP]=0xFC;
	REG[r_OBP0]=0xFF;
	REG[r_OBP1]=0xFF;
	REG[r_WY]=0x00;
	REG[r_WX]=0x00;
	REG[r_IE]=0x00;
}

static int WMem(u16 adr, u8 val)
{	/*Write memory, (1=ݕs,0=݉)*/
	u8	mbc_type;
	u16 copy_loop;

	mbc_type=ROM[0][0x147];

	if(0x4000<=adr && adr<0x6000){
		if(mbc_type==0x02||mbc_type==0x03){	/*MBC1:RAMoN̑I*/
			val&=0x03;	/*XXXXXXBB*/
			rambc=val;
			return 0;
		}
	}else if(0x2000<=adr){
		if(0x01<=mbc_type && mbc_type<=0x03){	/*MBC1*/
			val&=0x1F;	/*XXXBBBBB*/
			if(ROM[0][0x148]==0x01)val&=0x03;	/*I[ot[΍*/
			if(ROM[0][0x148]==0x02)val&=0x07;
			if(ROM[0][0x148]==0x03)val&=0x0F;
			if(val==0)val++;	/*ROM Bank#10͎włȂ*/
			mbc=val;
			return 0;
		}else if(mbc_type==0x05 || mbc_type==0x06){	/*MBC2*/
			val&=0x0F;	/*XXXXBBBB*/
			if(ROM[0][0x148]==0x01)val&=0x03;	/*I[ot[΍*/
			if(ROM[0][0x148]==0x02)val&=0x07;
			if(val==0)val++;	/*ROM Bank#10͎włȂ*/
			mbc=val;
			return 0;
		}
	}else if(0x0000<=adr){	/*RAMoÑ݂tO*/
		if(mbc_type==0x02 || mbc_type==0x03){	/*MBC1:RAM ݋tO*/
			e_rambc=((val&0x0F)==0x0A)?1:0;
		}
		return 0;
	}

	if(0xFF00<=adr){	/*IOWX^*/
		if(R_STAT==adr){
			REG[r_STAT]=val&0xF8;	/*3bitmodetO*/
			return 0;
		}
		if(R_P1==adr){	/*4-5bit݂oȂ*/
			if(val&0x10)REG[r_P1]|=0x10;
			else REG[r_P1]&=0xEF;
			if(val&0x20)REG[r_P1]|=0x20;
			else REG[r_P1]&=0xDF;
			return 0;
		}
		if(R_DMA==adr){	/*DMA]*/
			REG[r_DMA]=val;
			tmp16=(u16)(val<<8);	/*0x100PʂŎwł*/
			if(0xF100<=tmp16)return 2;	/*͈͊O̓]*/
			copy_loop=0;
			while(copy_loop<0x100){
				OAM[copy_loop++]=RMem(tmp16++);
			}
			return 0;
		}
		if(R_DIV==adr){
			REG[r_DIV]=0x00;
			return 0;
		}
		if(R_LY==adr)return 1;	/*LY͓ǎp*/
		REG[adr-0xFF00]=val;/*default*/
		return 0;
	}else if(0xFE00<=adr){			/*OAM*/
		if(REG[r_STAT] & 0x02){	/*mode2*/
			/*if(0xFE00<=adr && adr<0xFEA0)return 1;*/	
		}
		OAM[adr-0xFE00]=val;/*default*/
		return 0;
	}else if(0xE000<=adr){			/*RAM̃~[*/
		InRAM[adr-0xE000]=val;
		return 0;
	}else if(0xC000<=adr){			/*RAM*/
		InRAM[adr-0xC000]=val;
		return 0;
	}else if(0xA000<=adr){			/*J[gbWRAM*/
		if(mbc_type==0x02||mbc_type==0x03){	/*MBC1:RAM*/
			if(e_rambc){
				RAM[rambc][adr-0xA000]=val;
			}
		}
		return 0;
	}else if(0x8000<=adr){			/*rfIRAM*/
		if((REG[r_STAT] & 0x03)==0x03){	/*mode3*/
			/*if(0x8000<=adr && adr<0xA000)return 1;*/	
		}
		VRAM[adr-0x8000]=val;
		return 0;
	}

	return 1;
}

_inline u8 RMem(u16 adr)
{
	u8 tmp;

	if(0xFF00<=adr){									/*IOWX^*/
		if(R_P1==adr){	/*{^ǂݎ*/
			tmp=REG[r_P1];
			tmp=(tmp&0xF0)|(((tmp&0x10)?0xF:(keyflag&0xF))&
			((tmp&0x20)?0xF:((keyflag>>4)&0xF)));
			return tmp;
		}
		return REG[adr-0xFF00];
	}
	else if(0xFE00<=adr)return OAM[adr-0xFE00];			/*OAM*/
	else if(0xE000<=adr)return InRAM[adr-0xE000];		/*RAM̃~[*/
	else if(0xC000<=adr)return InRAM[adr-0xC000];		/*RAM*/
	else if(0xA000<=adr)return RAM[rambc][adr-0xA000];	/*ORAM*/
	else if(0x8000<=adr)return VRAM[adr-0x8000];		/*rfIRAM*/
	else if(0x4000<=adr)return ROM[mbc][adr-0x4000];	/*oNP`*/
	return ROM[0][adr];						/*0x0000<=adr:oNO*/
}

