
/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/



_inline void BIT(u8 num, u8 dest)
{
	if(dest & num)RF(_Z);else SF(_Z);
	RF(_N);
	SF(_H);
}


static void Cpu_cb(){
	static u8 tmp8;
	static u8 opcode;

	opcode=RMem((u16)(cpu.PC+1));

	switch(opcode){	

#define RLC(dest)	RF(_N);RF(_H);if((dest) & 0x80)SF(_C);else SF(_C);\
		dest=((dest)<<1)|((dest)>>7);if(dest)RF(_Z);else SF(_Z)
	case 0x00 : RLC(cpu.B);break;
	case 0x01 : RLC(cpu.C);break;
	case 0x02 : RLC(cpu.D);break;
	case 0x03 : RLC(cpu.E);break;
	case 0x04 : RLC(cpu.H);break;
	case 0x05 : RLC(cpu.L);break;
	case 0x06 : tmp8=RMem(cpu.HL);
			RF(_N);RF(_H);if((tmp8) & 0x80)SF(_C);else SF(_C);
			tmp8=(u8)(((tmp8)<<1)|((tmp8)>>7));if(tmp8)RF(_Z);else SF(_Z);
			WMem(cpu.HL,tmp8);break;
	case 0x07 : RLC(cpu.A);break;

#define RRC(dest)	RF(_N);RF(_H);if((dest) & 0x01)SF(_C);else RF(_C);\
		dest=((dest)>>1)|((dest)<<7);if(dest)RF(_Z);else SF(_Z)
	case 0x08 : RRC(cpu.B);break;
	case 0x09 : RRC(cpu.C);break;
	case 0x0A : RRC(cpu.D);break;
	case 0x0B : RRC(cpu.E);break;
	case 0x0C : RRC(cpu.H);break;
	case 0x0D : RRC(cpu.L);break;
	case 0x0E : tmp8=RMem(cpu.HL);
		RF(_N); RF(_H);if(tmp8 & 0x01)SF(_C);else RF(_C);
		tmp8=(u8)((tmp8>>1)|(tmp8<<7));if(tmp8)RF(_Z);else SF(_Z);
		WMem(cpu.HL,tmp8);break;
	case 0x0F : RRC(cpu.A);break;

#define RL(dest)	RF(_N);RF(_H);if((dest) & 0x80)SF(_C);else RF(_C);\
		dest=(dest<<1)|FC; if(dest)RF(_Z);else SF(_Z)
	case 0x10 : RL(cpu.B);break;
	case 0x11 : RL(cpu.C);break;
	case 0x12 : RL(cpu.D);break;
	case 0x13 : RL(cpu.E);break;
	case 0x14 : RL(cpu.H);break;
	case 0x15 : RL(cpu.L);break;
	case 0x16 : tmp8=RMem(cpu.HL);
			RF(_N);RF(_H);if(tmp8 & 0x80)SF(_C);else RF(_C);
			tmp8=(u8)((tmp8<<1)|FC);if(tmp8)RF(_Z);else SF(_Z);
			WMem(cpu.HL,tmp8);break;
	case 0x17 : RL(cpu.A);break;

#define RR(dest)	RF(_N);RF(_H);if((dest) & 0x01)SF(_C);else RF(_C);\
		dest=((dest)>>1)|((cpu.F&_C)<<3); if(dest)RF(_Z);else SF(_Z)
	case 0x18 : RR(cpu.B);break;
	case 0x19 : RR(cpu.C);break;
	case 0x1A : RR(cpu.D);break;
	case 0x1B : RR(cpu.E);break;
	case 0x1C : RR(cpu.H);break;
	case 0x1D : RR(cpu.L);break;
	case 0x1E : tmp8=RMem(cpu.HL);
		RF(_N);RF(_H);if((tmp8) & 0x01)SF(_C);else RF(_C);
		tmp8=(u8)(((tmp8)>>1)|((cpu.F&_C)<<3)); if(tmp8)RF(_Z);else SF(_Z);
		WMem(cpu.HL,tmp8);break;
	case 0x1F : RR(cpu.A);break;

#define SLA(dest)	RF(_N); RF(_H);if((dest) & 0x80)SF(_C);else RF(_C);\
		dest<<=1; if(dest)RF(_Z);else SF(_Z)
	case 0x20 : SLA(cpu.B);break;
	case 0x21 : SLA(cpu.C);break;
	case 0x22 : SLA(cpu.D);break;
	case 0x23 : SLA(cpu.E);break;
	case 0x24 : SLA(cpu.H);break;
	case 0x25 : SLA(cpu.L);break;
	case 0x26 : tmp8=RMem(cpu.HL);
		RF(_N); RF(_H);if(tmp8 & 0x80)SF(_C);else RF(_C);
		tmp8<<=1;if(tmp8)RF(_Z);else SF(_Z); 
		WMem(cpu.HL,tmp8);break;
	case 0x27 : SLA(cpu.A);break;

#define SRA(dest)	RF(_N); RF(_H);if(dest & 0x01)SF(_C);else RF(_C);\
		dest=((dest)>>1)|((dest) & 0x80);if(dest)RF(_Z);else SF(_Z)
	case 0x28 : SRA(cpu.B);break;
	case 0x29 : SRA(cpu.C);break;
	case 0x2A : SRA(cpu.D);break;
	case 0x2B : SRA(cpu.E);break;
	case 0x2C : SRA(cpu.H);break;
	case 0x2D : SRA(cpu.L);break;
	case 0x2E : tmp8=RMem(cpu.HL);
		RF(_N); RF(_H);if(tmp8 & 0x01)SF(_C);else RF(_C);
		tmp8=(u8)(tmp8>>1)|(tmp8 & 0x80);if(tmp8)RF(_Z);else SF(_Z);
		WMem(cpu.HL,tmp8);break;
	case 0x2F : SRA(cpu.A);break;

#define SWAP(dest)	RF(_N);RF(_H);RF(_C);\
		dest=((dest)>>4)|((dest)<<4); if(dest)RF(_Z);else SF(_Z)
	case 0x30 : SWAP(cpu.B);break;
	case 0x31 : SWAP(cpu.C);break;
	case 0x32 : SWAP(cpu.D);break;
	case 0x33 : SWAP(cpu.E);break;
	case 0x34 : SWAP(cpu.H);break;
	case 0x35 : SWAP(cpu.L);break;
	case 0x36 : tmp8=RMem(cpu.HL);
			RF(_N);RF(_H);RF(_C);
			tmp8=(u8)((tmp8>>4)|(tmp8<<4));if(tmp8)RF(_Z);else SF(_Z);
			WMem(cpu.HL,tmp8);break;
	case 0x37 : SWAP(cpu.A);break;

#define SRL(dest)	RF(_N);RF(_H);if(dest & 0x01)SF(_C);else RF(_C);\
		dest>>=1; if(dest)RF(_Z);else SF(_Z)
	case 0x38 : SRL(cpu.B);break;
	case 0x39 : SRL(cpu.C);break;
	case 0x3A : SRL(cpu.D);break;
	case 0x3B : SRL(cpu.E);break;
	case 0x3C : SRL(cpu.H);break;
	case 0x3D : SRL(cpu.L);break;
	case 0x3E : tmp8=RMem(cpu.HL);
		RF(_N);RF(_H);if(tmp8 & 0x01)SF(_C);else RF(_C);
		tmp8>>=1; if(tmp8)RF(_Z);else SF(_Z);
		WMem(cpu.HL,tmp8);break;
	case 0x3F : SRL(cpu.A);break;

	case 0x40 : BIT(0x01,cpu.B);break;
	case 0x41 : BIT(0x01,cpu.C);break;
	case 0x42 : BIT(0x01,cpu.D);break;
	case 0x43 : BIT(0x01,cpu.E);break;
	case 0x44 : BIT(0x01,cpu.H);break;
	case 0x45 : BIT(0x01,cpu.L);break;
	case 0x46 : BIT(0x01,RMem(cpu.HL));break;
	case 0x47 : BIT(0x01,cpu.A);break;
	case 0x48 : BIT(0x02,cpu.B);break;
	case 0x49 : BIT(0x02,cpu.C);break;
	case 0x4A : BIT(0x02,cpu.D);break;
	case 0x4B : BIT(0x02,cpu.E);break;
	case 0x4C : BIT(0x02,cpu.H);break;
	case 0x4D : BIT(0x02,cpu.L);break;
	case 0x4E : BIT(0x02,RMem(cpu.HL));break;
	case 0x4F : BIT(0x02,cpu.A);break;
	case 0x50 : BIT(0x04,cpu.B);break;
	case 0x51 : BIT(0x04,cpu.C);break;
	case 0x52 : BIT(0x04,cpu.D);break;
	case 0x53 : BIT(0x04,cpu.E);break;
	case 0x54 : BIT(0x04,cpu.H);break;
	case 0x55 : BIT(0x04,cpu.L);break;
	case 0x56 : BIT(0x04,RMem(cpu.HL));break;
	case 0x57 : BIT(0x04,cpu.A);break;
	case 0x58 : BIT(0x08,cpu.B);break;
	case 0x59 : BIT(0x08,cpu.C);break;
	case 0x5A : BIT(0x08,cpu.D);break;
	case 0x5B : BIT(0x08,cpu.E);break;
	case 0x5C : BIT(0x08,cpu.H);break;
	case 0x5D : BIT(0x08,cpu.L);break;
	case 0x5E : BIT(0x08,RMem(cpu.HL));break;
	case 0x5F : BIT(0x08,cpu.A);break;
	case 0x60 : BIT(0x10,cpu.B);break;
	case 0x61 : BIT(0x10,cpu.C);break;
	case 0x62 : BIT(0x10,cpu.D);break;
	case 0x63 : BIT(0x10,cpu.E);break;
	case 0x64 : BIT(0x10,cpu.H);break;
	case 0x65 : BIT(0x10,cpu.L);break;
	case 0x66 : BIT(0x10,RMem(cpu.HL));break;
	case 0x67 : BIT(0x10,cpu.A);break;
	case 0x68 : BIT(0x20,cpu.B);break;
	case 0x69 : BIT(0x20,cpu.C);break;
	case 0x6A : BIT(0x20,cpu.D);break;
	case 0x6B : BIT(0x20,cpu.E);break;
	case 0x6C : BIT(0x20,cpu.H);break;
	case 0x6D : BIT(0x20,cpu.L);break;
	case 0x6E : BIT(0x20,RMem(cpu.HL));break;
	case 0x6F : BIT(0x20,cpu.A);break;
	case 0x70 : BIT(0x40,cpu.B);break;
	case 0x71 : BIT(0x40,cpu.C);break;
	case 0x72 : BIT(0x40,cpu.D);break;
	case 0x73 : BIT(0x40,cpu.E);break;
	case 0x74 : BIT(0x40,cpu.H);break;
	case 0x75 : BIT(0x40,cpu.L);break;
	case 0x76 : BIT(0x40,RMem(cpu.HL));break;
	case 0x77 : BIT(0x40,cpu.A);break;
	case 0x78 : BIT(0x80,cpu.B);break;
	case 0x79 : BIT(0x80,cpu.C);break;
	case 0x7A : BIT(0x80,cpu.D);break;
	case 0x7B : BIT(0x80,cpu.E);break;
	case 0x7C : BIT(0x80,cpu.H);break;
	case 0x7D : BIT(0x80,cpu.L);break;
	case 0x7E : BIT(0x80,RMem(cpu.HL));break;
	case 0x7F : BIT(0x80,cpu.A);break;

#define RES(num,dest)	dest&=num
	case 0x80 : RES(0xFE,cpu.B);break;
	case 0x81 : RES(0xFE,cpu.C);break;
	case 0x82 : RES(0xFE,cpu.D);break;
	case 0x83 : RES(0xFE,cpu.E);break;
	case 0x84 : RES(0xFE,cpu.H);break;
	case 0x85 : RES(0xFE,cpu.L);break;
	case 0x86 : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0xFE));break;
	case 0x87 : RES(0xFE,cpu.A);break;
	case 0x88 : RES(0xFD,cpu.B);break;
	case 0x89 : RES(0xFD,cpu.C);break;
	case 0x8A : RES(0xFD,cpu.D);break;
	case 0x8B : RES(0xFD,cpu.E);break;
	case 0x8C : RES(0xFD,cpu.H);break;
	case 0x8D : RES(0xFD,cpu.L);break;
	case 0x8E : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0xFD));break;
	case 0x8F : RES(0xFD,cpu.A);break;
	case 0x90 : RES(0xFB,cpu.B);break;
	case 0x91 : RES(0xFB,cpu.C);break;
	case 0x92 : RES(0xFB,cpu.D);break;
	case 0x93 : RES(0xFB,cpu.E);break;
	case 0x94 : RES(0xFB,cpu.H);break;
	case 0x95 : RES(0xFB,cpu.L);break;
	case 0x96 : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0xFB));break;
	case 0x97 : RES(0xFB,cpu.A);break;
	case 0x98 : RES(0xF7,cpu.B);break;
	case 0x99 : RES(0xF7,cpu.C);break;
	case 0x9A : RES(0xF7,cpu.D);break;
	case 0x9B : RES(0xF7,cpu.E);break;
	case 0x9C : RES(0xF7,cpu.H);break;
	case 0x9D : RES(0xF7,cpu.L);break;
	case 0x9E : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0xF7));break;
	case 0x9F : RES(0xF7,cpu.A);break;
	case 0xA0 : RES(0xEF,cpu.B);break;
	case 0xA1 : RES(0xEF,cpu.C);break;
	case 0xA2 : RES(0xEF,cpu.D);break;
	case 0xA3 : RES(0xEF,cpu.E);break;
	case 0xA4 : RES(0xEF,cpu.H);break;
	case 0xA5 : RES(0xEF,cpu.L);break;
	case 0xA6 : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0xEF));break;
	case 0xA7 : RES(0xEF,cpu.A);break;
	case 0xA8 : RES(0xDF,cpu.B);break;
	case 0xA9 : RES(0xDF,cpu.C);break;
	case 0xAA : RES(0xDF,cpu.D);break;
	case 0xAB : RES(0xDF,cpu.E);break;
	case 0xAC : RES(0xDF,cpu.H);break;
	case 0xAD : RES(0xDF,cpu.L);break;
	case 0xAE : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0xDF));break;
	case 0xAF : RES(0xDF,cpu.A);break;
	case 0xB0 : RES(0xBF,cpu.B);break;
	case 0xB1 : RES(0xBF,cpu.C);break;
	case 0xB2 : RES(0xBF,cpu.D);break;
	case 0xB3 : RES(0xBF,cpu.E);break;
	case 0xB4 : RES(0xBF,cpu.H);break;
	case 0xB5 : RES(0xBF,cpu.L);break;
	case 0xB6 : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0xBF));break;
	case 0xB7 : RES(0xBF,cpu.A);break;
	case 0xB8 : RES(0x7F,cpu.B);break;
	case 0xB9 : RES(0x7F,cpu.C);break;
	case 0xBA : RES(0x7F,cpu.D);break;
	case 0xBB : RES(0x7F,cpu.E);break;
	case 0xBC : RES(0x7F,cpu.H);break;
	case 0xBD : RES(0x7F,cpu.L);break;
	case 0xBE : WMem(cpu.HL,(u8)(RMem(cpu.HL) & 0x7F));break;
	case 0xBF : RES(0x7F,cpu.A);break;

#define SET(num,dest)	dest|=num
	case 0xC0 : SET(0x01,cpu.B);break;
	case 0xC1 : SET(0x01,cpu.C);break;
	case 0xC2 : SET(0x01,cpu.D);break;
	case 0xC3 : SET(0x01,cpu.E);break;
	case 0xC4 : SET(0x01,cpu.H);break;
	case 0xC5 : SET(0x01,cpu.L);break;
	case 0xC6 : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x01));break;
	case 0xC7 : SET(0x01,cpu.A);break;
	case 0xC8 : SET(0x02,cpu.B);break;
	case 0xC9 : SET(0x02,cpu.C);break;
	case 0xCA : SET(0x02,cpu.D);break;
	case 0xCB : SET(0x02,cpu.E);break;
	case 0xCC : SET(0x02,cpu.H);break;
	case 0xCD : SET(0x02,cpu.L);break;
	case 0xCE : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x02));break;
	case 0xCF : SET(0x02,cpu.A);break;
	case 0xD0 : SET(0x04,cpu.B);break;
	case 0xD1 : SET(0x04,cpu.C);break;
	case 0xD2 : SET(0x04,cpu.D);break;
	case 0xD3 : SET(0x04,cpu.E);break;
	case 0xD4 : SET(0x04,cpu.H);break;
	case 0xD5 : SET(0x04,cpu.L);break;
	case 0xD6 : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x04));break;
	case 0xD7 : SET(0x04,cpu.A);break;
	case 0xD8 : SET(0x08,cpu.B);break;
	case 0xD9 : SET(0x08,cpu.C);break;
	case 0xDA : SET(0x08,cpu.D);break;
	case 0xDB : SET(0x08,cpu.E);break;
	case 0xDC : SET(0x08,cpu.H);break;
	case 0xDD : SET(0x08,cpu.L);break;
	case 0xDE : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x08));break;
	case 0xDF : SET(0x08,cpu.A);break;
	case 0xE0 : SET(0x10,cpu.B);break;
	case 0xE1 : SET(0x10,cpu.C);break;
	case 0xE2 : SET(0x10,cpu.D);break;
	case 0xE3 : SET(0x10,cpu.E);break;
	case 0xE4 : SET(0x10,cpu.H);break;
	case 0xE5 : SET(0x10,cpu.L);break;
	case 0xE6 : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x10));break;
	case 0xE7 : SET(0x10,cpu.A);break;
	case 0xE8 : SET(0x20,cpu.B);break;
	case 0xE9 : SET(0x20,cpu.C);break;
	case 0xEA : SET(0x20,cpu.D);break;
	case 0xEB : SET(0x20,cpu.E);break;
	case 0xEC : SET(0x20,cpu.H);break;
	case 0xED : SET(0x20,cpu.L);break;
	case 0xEE : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x20));break;
	case 0xEF : SET(0x20,cpu.A);break;
	case 0xF0 : SET(0x40,cpu.B);break;
	case 0xF1 : SET(0x40,cpu.C);break;
	case 0xF2 : SET(0x40,cpu.D);break;
	case 0xF3 : SET(0x40,cpu.E);break;
	case 0xF4 : SET(0x40,cpu.H);break;
	case 0xF5 : SET(0x40,cpu.L);break;
	case 0xF6 : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x40));break;
	case 0xF7 : SET(0x40,cpu.A);break;
	case 0xF8 : SET(0x80,cpu.B);break;
	case 0xF9 : SET(0x80,cpu.C);break;
	case 0xFA : SET(0x80,cpu.D);break;
	case 0xFB : SET(0x80,cpu.E);break;
	case 0xFC : SET(0x80,cpu.H);break;
	case 0xFD : SET(0x80,cpu.L);break;
	case 0xFE : WMem(cpu.HL,(u8)(RMem(cpu.HL)|0x80));break;
	case 0xFF : SET(0x80,cpu.A);break;

#ifdef	_WIN32_GDI
	default   : __assume(0);
#endif	/*_WIN32_GDI*/
	}
}

