
/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/



HMIDIOUT hMidiOut;

void CGBEmuDlg::PlayGBSound()
{	/*byte-PXe[^XAQAR*/
	u32 wave1, wave2, wave3, vol;
//	char str[50];

	if(!(MEM[R_NR52]&fChannel&0x01)){
		midiOutShortMsg(hMidiOut, 0x00000080|(0x00007F00&old_wave1));	/*ch1 m[gIt*/
//		CDialog::SetWindowText("ch1 off");
		return;
	}else{
		wave1=MEM[R_NR13]+((MEM[R_NR14]&0x07)<<8);	/*0-11 bits*/
	//	wave=131072/(2048-wave);	/*=4194304/(32*(2048-wave))*/
	//	wave=(((wave/0x200)/2)<<8)&0x00007F00;
		//wave=wave/16;
		//if(wave==0x80)wave=0x7F;
		wave1=(u32)((wave1>>4)*0.8);	/*䗦̕ϊ 128<=2048*/
	//	+((MEM[R_NR50]&0x07)<<20);

	//	if(wave==old_wave)return;	/*gωĂȂ΍XVȂ*/
	//	else 
		midiOutShortMsg(hMidiOut, 0x00000080|(0x00007F00&old_wave1));	/*ch1 m[gIt*/
		vol=(u32)((MEM[R_NR50]&0x07)*env_vol1*1.2);	/*}X^[{[{Gx[v*/
		if(vol>0x7F)CPUIsRunning=0;
		wave1=((wave1<<8)&0x00007F00)|((vol<<16)&0x007F0000);
		old_wave1=wave1;
/*		if(!fFps){
			_itoa(wave1, str, 16);
			CDialog::SetWindowText(str);
		}*/
		midiOutShortMsg(hMidiOut, 0x00000090|wave1);
	}
	
	if(!(MEM[R_NR52]&fChannel&0x02)){	/*TEh2 OFF*/
		midiOutShortMsg(hMidiOut, 0x00000081|(0x00007F00&old_wave2));	/*ch2 m[gIt*/
	}else{
		wave2=MEM[R_NR23]+((MEM[R_NR24]&0x07)<<8);	/*0-11 bits*/
		wave2=(u32)((wave2>>4)*0.7);	/*䗦̕ϊ 128<=2048*/
		midiOutShortMsg(hMidiOut, 0x00000081|(0x00007F00&old_wave2));	/*ch2 m[gIt*/
		old_wave2=wave2=((wave2<<8)&0x00007F00)|((MEM[R_NR50]&0x07)<<20);	/*{[*/
		midiOutShortMsg(hMidiOut, 0x00000091|wave2);
	}
	
	if(!(MEM[R_NR52]&fChannel&0x04)){	/*TEh2 OFF*/
		midiOutShortMsg(hMidiOut, 0x00000082|(0x00007F00&old_wave3));	/*ch3 m[gIt*/
	}else{
		wave3=MEM[R_NR33]+((MEM[R_NR34]&0x07)<<8);	/*0-11 bits*/
		wave3=(u32)((wave3>>4)*0.7);	/*䗦̕ϊ 128<=2048*/
		midiOutShortMsg(hMidiOut, 0x00000082|(0x00007F00&old_wave3));	/*ch3 m[gIt*/
		old_wave3=wave3=((wave3<<8)&0x00007F00)|((MEM[R_NR50]&0x07)<<20);	/*{[*/
		midiOutShortMsg(hMidiOut, 0x00000092|wave2);
	}
}

static void Sound_ch1(int clock)
{
	u32	wave, nr10, vol;
	/*32768clock=128Hz*/
	/*256clock=1/128*/

	sweep_time+=clock;

	nr10=MEM[R_NR10];
	if((nr10&0x07) &&	/*XEB[v*/
		(sweep_time>=(((nr10>>4)&0x07)*256))){	/*XEB[v-̑*/
		sweep_time=0;
		wave=MEM[R_NR13]+((MEM[R_NR14]&0x07)<<8);
		if(nr10&0x08){
			wave-=wave/(1<<(nr10&0x07));
		}else{
			wave+=wave/(1<<(nr10&0x07));
		}
		MEM[R_NR13]=(u8)wave;	/*NR13NR14̉3bitf[^*/
		MEM[R_NR14]=(MEM[R_NR14]&0xF8)|(0x07&(u8)(wave>>8));
	}

	if(MEM[R_NR12]==0x00){
		env_vol1=0x0F;
	}else if(MEM[R_NR12]&0x08){	/*{[̑*/
		env_vol1=0x0F;
	}else{	/*{[̌*/
		env_time+=clock;
		if((env_time>=(u32)(MEM[R_NR12]&0x07)*65536)){	/*Gx[v-ʂ̑*/
			env_vol1=0x0F;
			env_time=0;
			vol=(MEM[R_NR12]>>4)&0x0F;	/*{[ 0-15*/
			if(env_tmp1!=vol){	/*Gx[vXV*/
				env_tmp1=vol;
				env_off1=0;	/*{[_EItZbg*/
				env_time+=clock;
			}
			if(env_vol1)env_off1++;
			//env_vol1=vol-env_off1;
		}
	}

}

void InitializeSound()
{


}
