/***************************************************************/
//
//
//		DirectX	[particle.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 07/25
/*---------------------------------------------------------------
Update : 2016/07/25
			particle.cpp̍쐬
			SetParticle,
			InitParticle,
			UninitPArticle,
			UpdateParticle,
			DrawParticle,
			MakeVertexParticle,
			SetVertexParticle,
			SetVertexColor,
			GetPArticle̒ǉ
			
Update : 2016/09/03
			p[eBNp[^̑啝ȕύX
			pos > center,
			move > speedɕύX
			color,
			amountOfChangeInRadius,
			amountOfChangeInColor̒ǉ
			SetParticleI[o[[h
			UpdateParticlȇ啝ȕύX
			-> ̒ǉ
			-> F┼aȂǂύX\ɒ
			֐̕ύX
			-> SetVertexParticle > SetVertexParticleCoord
			-> SetVertexColor    > SetVertexParticleColor
			SetVertexParticleSpriteUV,
			ep[eBNp[^GetSet֐̒ǉ

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include <time.h>
#include "main.h"
#include "particle.h"

#include "game_equation.h"


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define NUM_PARTICLE (2)							// |S

#define NUM_VERTEX (4)								// _
#define NUM_INDEX  (6)								// _CfbNX

#define NUM_POLYGON (2)								// |S


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define PARTICLE_TEXTURENAME "data/TEXTURE/effect000.jpg"

#define PARTICLE_LIFE ( 100 )						// GtFNg̎

#define PARTICLE_RADIUS (30)						// wi̕

// Effeksser
// XX
// }`eNX`

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexParticle(LPDIRECT3DDEVICE9 pDevice);
												// _̍쐬
void SetVertexParticleCoord( VERTEX_2D *pVtx , const int index );
												// GtFNg̐ݒu
void SetVertexParticleColor( VERTEX_2D *pVtx , const int index );
												// F̐ݒ
void SetVertexParticleSpriteUV( VERTEX_2D *pVtx , const int index  );
												// UVl̐ݒ
/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureParticle = nullptr;			// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferParticle = nullptr;		// _obt@C^[tF[Xւ̃|C^
LPDIRECT3DINDEXBUFFER9  g_pIndexBufferParticle = nullptr;	// _CfbNXC^[tF[Xւ̃|C^

PARTICLE particle[ PARTICLE_MAX ] = {};						// p[eBN

static int frame;

static int effectNumber = 0;
static int CountBuf[ PARTICLE_MAX ] = {};


// p[eBN
void InitParticle( void )
{

	srand( ( unsigned int ) time( NULL ) );


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	// p[eBNp[^[
	for( int index = 0; index < PARTICLE_MAX ; index++ ){

		particle[ index ].life   = 0; 
		particle[ index ].radius = PARTICLE_RADIUS;
		particle[ index ].arc    = RADIAN( 10 * index );

		particle[ index ].ambientPower = D3DXVECTOR2( 0, 0 );

		CountBuf[ index ] = 0;
	}

	effectNumber = 0;

	// VERTEX_2D̐ݒ
	MakeVertexParticle( pDevice );

		// eNX`̓ǂݍ
	if( FAILED(D3DXCreateTextureFromFile( pDevice, PARTICLE_TEXTURENAME, &g_pTextureParticle )))
	{
		#ifdef _DEBUG
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
		#endif	// _DEBUG
	}


}

// p[eBNI
void UninitParticle( void )
{

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureParticle)

	// CfbNXobt@̊J
	SAFE_RELEASE( g_pIndexBufferParticle )

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferParticle)


}

// p[eBNXV
void UpdateParticle( void )
{


	// zAhX
	VERTEX_2D *pVtx;


	// gpGtFNg̏
	effectNumber = 0;


	// p[eBN̍XV
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		// gpobt@̏( {ȂʏōŝX}[gx̂߂ŏ )
		CountBuf[ index ] = 0;

		if( particle[ index ].life ){


			// gpGtFNg̃JEg
			CountBuf[ effectNumber ] = index;
			effectNumber++;
				

			{ // p[eBNp[^[̍XV


				// p[eBN݃t[̍XV
				particle[ index ].life -= 1 ;
				particle[ index ].age  += 1;

				// F̐ݒ
				particle[ index ].color.r -= particle[ index ].amountOfChangeInColor.r;
				particle[ index ].color.g -= particle[ index ].amountOfChangeInColor.g;
				particle[ index ].color.b -= particle[ index ].amountOfChangeInColor.b;
				particle[ index ].color.a -= particle[ index ].amountOfChangeInColor.a;
				if( particle[ index ].color.a < 0.0f ){
					particle[ index ].color.a = 0.0f;
				}

				/*// a̍XVƐݒ
				particle[ index ].radius -= particle[ index ].amountOfChangeInRadius;
				if( particle[ index ].radius < 0.0f ){
					particle[ index ].radius = 0.0f;
				}*/

				// x̉Z
				particle[ index ].speed.x *= particle[ index ].velocity.x;
				particle[ index ].speed.y *= particle[ index ].velocity.y;

				// p[eBN̈ړ
				particle[ index ].center.x += particle[ index ].speed.x * cosf( particle[ index ].arc );
				particle[ index ].center.y += particle[ index ].speed.y * sinf( particle[ index ].arc );

				// ͂ɂxNgϊ
				if( particle[ index ].age > 10 ){
					particle[ index ].center += particle[ index ].ambientPower;
				}

				// ʊOh~
				if( __ObjectScreenOut( &particle[ index ].center, particle[ index ].radius )){
				
					particle[ index ].life = 0;
				}


			} // -> END ( PARTICLE UPDATE )
			
		}	// if( particle[ index ].life ) -> END
	}	// for -> END


	// obt@bNzAhX擾
	g_pVtxBufferParticle -> Lock(0,0,(void**)&pVtx,0);

	// _̊i[
	for( int index = 0; index < effectNumber; index++ ){

		// GtFNg̐ݒu
		SetVertexParticleColor( pVtx, index );
		SetVertexParticleCoord( pVtx, index );
	}

	// obt@̃AbN
	g_pVtxBufferParticle->Unlock();

}

// p[eBN̕`
void DrawParticle( void )
{


	// foCX̎󂯎菈
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );


	/*// Z̐ݒ
	pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );		
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
	pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );*/


	// Xg[
	pDevice->SetStreamSource(0,					
		g_pVtxBufferParticle,								// ǂ̒_obt@\ƌԂ...
		0,													// f[^̃ItZbg
		sizeof( VERTEX_2D ));								// XgChl(oCg)


	// _tH[}bg̐ݒ
	pDevice->SetFVF( FVF_VERTEX_2D );

	// CfbNXobt@̐ݒ
	pDevice ->SetIndices( g_pIndexBufferParticle );

	// eNX`̐ݒ
	pDevice->SetTexture( 0, g_pTextureParticle );
	
	// |S̕`
	pDevice ->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 0, NUM_INDEX * effectNumber, 0, NUM_POLYGON * effectNumber );

	/*// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );*/



}

// _̍쐬
HRESULT MakeVertexParticle( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_2D *pVtx;										// zAhX
	unsigned int *pIndex;									// zCfbNXAhX


	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX * PARTICLE_MAX,	// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,								// gp@
			FVF_VERTEX_2D,									// gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,								// obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferParticle,							// i[|C^
			NULL)))
	{
		#ifdef _DEBUG
		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		#endif	// _DEBUG
		return E_FAIL;
	}


	// CfbNXobt@̒`
	if( FAILED( pDevice ->CreateIndexBuffer(
		sizeof( VERTEX_2D ) * NUM_INDEX * PARTICLE_MAX,
		D3DUSAGE_WRITEONLY,
		D3DFMT_INDEX32,
		D3DPOOL_MANAGED,
		&g_pIndexBufferParticle,
		NULL)))
	{
	
		#ifdef _DEBUG
		MessageBox( NULL, "Indexւ݂̏Ɏs܂!!", "Index Buffer ERROR !!", MB_OK | MB_ICONWARNING );
		#endif	// -> _DEBUG
		return E_FAIL;
	}


	// obt@bNzAhX擾
	g_pVtxBufferParticle -> Lock(0,0,(void**)&pVtx,0);		// GPUVRAMւ̑bN


	// _obt@[̐ݒ
	for( int index = 0; index < PARTICLE_MAX ; index++ ){


		// _W̐ݒ
		SetVertexParticleCoord( pVtx , index );

		// _F̐ݒ
		SetVertexParticleColor( pVtx , index );

		// _UVl̐ݒ
		SetVertexParticleSpriteUV( pVtx , index );

		// _RHW
		pVtx[ 0 + ( NUM_VERTEX * index ) ].rhw = 1.0f;
		pVtx[ 1 + ( NUM_VERTEX * index ) ].rhw = 1.0f;
		pVtx[ 2 + ( NUM_VERTEX * index ) ].rhw = 1.0f;
		pVtx[ 3 + ( NUM_VERTEX * index ) ].rhw = 1.0f;

	}

	// obt@̃AbN
	g_pVtxBufferParticle->Unlock( );

	// CfbNXbNzAhX擾
	g_pIndexBufferParticle->Lock( 0, 0, (void**)&pIndex, 0 );


	// _W̐ݒ
	for( int index = 0; index < PARTICLE_MAX ; index++ ){

		pIndex[ 0 + ( NUM_INDEX * index ) ] = 0 + ( NUM_VERTEX * index );
		pIndex[ 1 + ( NUM_INDEX * index ) ] = 1 + ( NUM_VERTEX * index );
		pIndex[ 2 + ( NUM_INDEX * index ) ] = 2 + ( NUM_VERTEX * index );
		pIndex[ 3 + ( NUM_INDEX * index ) ] = 2 + ( NUM_VERTEX * index );
		pIndex[ 4 + ( NUM_INDEX * index ) ] = 1 + ( NUM_VERTEX * index );
		pIndex[ 5 + ( NUM_INDEX * index ) ] = 3 + ( NUM_VERTEX * index );

	}

	// obt@̃AbN
	g_pIndexBufferParticle ->Unlock( );


	return S_OK;

}

// p[eBNWݒu
void SetVertexParticleCoord( VERTEX_2D *pVtx , const int index )
{


	// pVtx     >> zAhX
	// arryycenter >> ǂ̔Ԗڂ̃GtFNg...


	D3DXVECTOR2 start,end;			//n_ƏI_


	// WvZparticle
	start.x = particle[ index ].center.x - particle[ index ].radius;
	start.y = particle[ index ].center.y - particle[ index ].radius;
	end.x   = particle[ index ].center.x + particle[ index ].radius;
	end.y   = particle[ index ].center.y + particle[ index ].radius;


	// _W̐ݒ
	pVtx[ 0 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, start.y, 0.0f);
	pVtx[ 1 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   start.y, 0.0f);
	pVtx[ 2 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, end.y,   0.0f);
	pVtx[ 3 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   end.y,   0.0f);


}

// p[eBNFύX֐
void SetVertexParticleColor( VERTEX_2D *pVtx , const int index )
{
	
	// ̕ύX
	pVtx[ 0 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	pVtx[ 1 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	pVtx[ 2 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	pVtx[ 3 + (index * NUM_VERTEX) ].color = particle[ index ].color;
	

}

// p[eBNUVl̃Zbg
void SetVertexParticleSpriteUV( VERTEX_2D *pVtx , const int index  )
{

	pVtx[ 0 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[ 1 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[ 2 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[ 3 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f, 1.0f );

}

// EMIT PARTICLE FUNCTIONS

// p[eBN(I[ݒver)
void SetParticleEx( const D3DXVECTOR2 center, const D3DXVECTOR2 speed, const D3DXVECTOR2 velocity, const D3DXCOLOR color, const D3DXCOLOR colorValue, const float radius, const float angle, const int life )
{


	// GtFNg̐ݒu
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		if( !particle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				particle[ index ].center   = center;

				// p[eBN̑x
				particle[ index ].speed    = speed; 

				// p[eBN̉x
				particle[ index ].velocity = velocity; 

				// p[eBNړ̐ݒ
				particle[ index ].arc      = angle;

				// p[eBNF
				particle[ index ].color    = color;

				// p[eBNa
				particle[ index ].radius   = radius;

				// p[eBN̑݃t[
				particle[ index ].life     = life;

				// p[eBNωʒ萔
				particle[ index ].amountOfChangeInColor = colorValue;
				
			
			} // -> END ( PARTICLE SET )

			break;

		}
	}

}

// p[eBN
void SetParticle( const LPD3DXVECTOR2 center, const LPD3DXVECTOR2 speed, const LPD3DXVECTOR2 velocity, const D3DXCOLOR color, const float radius, const int referenceAngle, const int actualAngle, const unsigned int life )
{

	// GtFNg̐ݒu
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		if( !particle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				particle[ index ].center   = *center;

				// p[eBN̑x
				particle[ index ].speed    = *speed; 

				// p[eBN̉x
				particle[ index ].velocity = *velocity; 

				// p[eBNړ̐ݒ
				particle[ index ].arc      =  ((( rand( )%actualAngle ) + referenceAngle ) - 314 ) * 0.01f;

				// p[eBNF
				particle[ index ].color    =  color;

				// p[eBNa
				particle[ index ].radius   =  radius;

				// p[eBN̑݃t[
				particle[ index ].life     =  life;

				// p[eBNωʒ萔
				particle[ index ].amountOfChangeInColor.a  = particle[ index ].color.a / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.a  *= 0.1f;
				particle[ index ].amountOfChangeInColor.r  = particle[ index ].color.r / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.g  = particle[ index ].color.g / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.b  = particle[ index ].color.b / particle[ index ].life;
				particle[ index ].amountOfChangeInRadius   = particle[ index ].radius / particle[ index ].life;
				
			
			} // -> END ( PARTICLE SET )

			break;

		}
	}

}

// p[eBN(ڑ)
void SetParticle( const D3DXVECTOR2 center, const D3DXVECTOR2 speed, const D3DXVECTOR2 velocity, const D3DXCOLOR color, const float radius, const int referenceAngle, const int actualAngle, const unsigned int life )
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		if( !particle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				particle[ index ].center   =  center;		

				// p[eBN̑x
				particle[ index ].speed    =  speed; 

				// p[eBN̉x
				particle[ index ].velocity =  velocity; 

				// p[eBNړ̐ݒ
				particle[ index ].arc      =  ((( rand( )%actualAngle ) + referenceAngle ) - 314 ) * 0.01f;

				// p[eBNF
				particle[ index ].color    =  color;

				// p[eBNa
				particle[ index ].radius   =  radius;

				// p[eBN̑݃t[
				particle[ index ].life     =  life;

				// p[eBNωʒ萔
				particle[ index ].amountOfChangeInColor.a  = particle[ index ].color.a / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.a  *= 0.1f;
				particle[ index ].amountOfChangeInColor.r  = particle[ index ].color.r / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.g  = particle[ index ].color.g / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.b  = particle[ index ].color.b / particle[ index ].life;
				particle[ index ].amountOfChangeInRadius   = (particle[ index ].radius - 10) / particle[ index ].life;
				
			
			} // -> END ( PARTICLE SET )

			break;

		}
	}

}

// p[eBN(F_)
void SetParticle( const D3DXVECTOR2 center, const D3DXVECTOR2 speed, const D3DXVECTOR2 velocity, const float radius, const int referenceAngle, const int actualAngle, const unsigned int life )
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		if( !particle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				particle[ index ].center   =  center;		

				// p[eBN̑x
				particle[ index ].speed    =  speed; 

				// p[eBN̉x
				particle[ index ].velocity =  velocity; 

				// p[eBNړ̐ݒ
				particle[ index ].arc      =  ((( rand( )%actualAngle ) + referenceAngle ) - 314 ) * 0.01f;

				// p[eBNF
				particle[ index ].color    =  D3DXCOLOR( rand()%100 * 0.01f, rand()%100 * 0.01f, rand()%100 * 0.01f , rand()%100 * 0.01f );

				// p[eBNa
				particle[ index ].radius   =  radius;

				// p[eBN̑݃t[
				particle[ index ].life     =  life;

				// p[eBNωʒ萔
				particle[ index ].amountOfChangeInColor.a  = particle[ index ].color.a / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.r  = particle[ index ].color.r / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.g  = particle[ index ].color.g / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.b  = particle[ index ].color.b / particle[ index ].life;
				particle[ index ].amountOfChangeInRadius   = (particle[ index ].radius - 10) / particle[ index ].life;
				
			
			} // -> END ( PARTICLE SET )

			break;

		}
	}

}

// p[eBN(I[_)
void SetParticle( const D3DXVECTOR2 center )
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		if( !particle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				particle[ index ].center   =  center;

				// p[eBN̑x
				particle[ index ].speed    =  D3DXVECTOR2( rand( )%5, rand( )%5 ); 

				// p[eBN̉x
				particle[ index ].velocity =  D3DXVECTOR2( 1.0f + ((( rand( )%200 ) - 100  ) * 0.001f ), 1.0f + ((( rand( )%200 ) - 100  ) * 0.001f ) ); 

				// p[eBNړ̐ݒ
				particle[ index ].arc      =  (( rand( )%628 ) - 314 ) * 0.01f;

				// p[eBNF
				particle[ index ].color    =  D3DXCOLOR( rand()%100 * 0.01f, rand()%100 * 0.01f, rand()%100 * 0.01f , rand()%100 * 0.01f );

				// p[eBNa
				particle[ index ].radius   =  rand( )%20 + 5;

				// p[eBN̑݃t[
				particle[ index ].life     =  rand( )%100 + 50;

				// p[eBNωʒ萔
				particle[ index ].amountOfChangeInColor.a  = particle[ index ].color.a / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.r  = particle[ index ].color.r / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.g  = particle[ index ].color.g / particle[ index ].life;
				particle[ index ].amountOfChangeInColor.b  = particle[ index ].color.b / particle[ index ].life;
				particle[ index ].amountOfChangeInRadius   = (particle[ index ].radius - 10) / particle[ index ].life;
				
			
			} // -> END ( PARTICLE SET )

			break;

		}
	}

}

// p[eBNW^( x̐ݒ )
void SetParticle( const D3DXVECTOR2 center, const float radius, const D3DXVECTOR2 speed, const D3DXVECTOR2 velocity,  const float length, const D3DXCOLOR color, unsigned int life)
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for (int index = 0; index < PARTICLE_MAX; index++) {

		if (!particle[index].life) {


			{ // p[eBNp[^[̐ݒ

			  // p[eBN̑݃t[
				particle[index].life = life;

				// p[eBNSW
				particle[index].center = center;

				// p[eBN̑x
				//particle[index].speed.x = (float)length / particle[index].life;
				//particle[index].speed.y = (float)length / particle[index].life;
				particle[index].speed = -speed;

				// p[eBN̉x
				particle[index].velocity = velocity;

				// p[eBNړ̐ݒ
				particle[index].arc = ((rand() % 628) - 314) * 0.01f;

				// p[eBNF
				particle[index].color = color;

				// p[eBNa
				particle[index].radius = radius;

				// p[eBNωʒ萔
				particle[index].amountOfChangeInColor.a = particle[index].color.a / particle[index].life;
				particle[index].amountOfChangeInColor.r = particle[index].color.r / particle[index].life;
				particle[index].amountOfChangeInColor.g = particle[index].color.g / particle[index].life;
				particle[index].amountOfChangeInColor.b = particle[index].color.b / particle[index].life;
				particle[index].amountOfChangeInRadius  = particle[index].radius / particle[index].life;

				// ʒu
				particle[index].center.x = particle[index].center.x + length * cosf( particle[index].arc );
				particle[index].center.y = particle[index].center.y + length * sinf( particle[index].arc );

			} // -> END ( PARTICLE SET )

			break;

		}
	}

}

// p[eBNW^
void SetParticle( const D3DXVECTOR2 center, const float radius, const D3DXVECTOR2 speed, const float length, const D3DXCOLOR color, unsigned int life)
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for (int index = 0; index < PARTICLE_MAX; index++) {

		if (!particle[index].life) {


			{ // p[eBNp[^[̐ݒ

			  // p[eBN̑݃t[
				particle[index].life = life;

				// p[eBNSW
				particle[index].center = center;

				// p[eBN̑x
				//particle[index].speed.x = (float)length / particle[index].life;
				//particle[index].speed.y = (float)length / particle[index].life;
				particle[index].speed = -speed;

				// p[eBN̉x
				particle[index].velocity = D3DXVECTOR2(1.0f + (((rand() % 200) - 100) * 0.001f), 1.0f + (((rand() % 200) - 100) * 0.001f));

				// p[eBNړ̐ݒ
				particle[index].arc = ((rand() % 628) - 314) * 0.01f;

				// p[eBNF
				particle[index].color = color;

				// p[eBNa
				particle[index].radius = radius;

				// p[eBNωʒ萔
				particle[index].amountOfChangeInColor.a = particle[index].color.a / particle[index].life;
				particle[index].amountOfChangeInColor.r = particle[index].color.r / particle[index].life;
				particle[index].amountOfChangeInColor.g = particle[index].color.g / particle[index].life;
				particle[index].amountOfChangeInColor.b = particle[index].color.b / particle[index].life;
				particle[index].amountOfChangeInRadius = (particle[index].radius - 10) / particle[index].life;

				// ʒu
				particle[index].center.x = length * cosf( RADIAN(30) );
				particle[index].center.y = length * sinf( RADIAN(30) );

			} // -> END ( PARTICLE SET )

			break;

		}
	}

}

// p[eBN^
void EmitExplosion( D3DXVECTOR2 center, const float radius, D3DXVECTOR2 speed, const D3DXVECTOR2 velocity, const D3DXCOLOR color, const D3DXCOLOR colorValue, const int life, const int scale )
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for ( int index = 0; index < PARTICLE_MAX; index++ ) {

		if ( !particle[index].life ) {


			{ // p[eBNp[^[̐ݒ

				// p[eBN̑݃t[
				particle[index].life = life;

				// p[eBNSW
				float angle  = ((rand() % 628) - 314) * 0.01f;
				float length = ( float )( rand( )%scale );

				center.x = center.x + scale * cosf( angle ); 
				center.y = center.y + scale * sinf( angle );

				particle[index].center = center;

				// p[eBN̑x
				speed += D3DXVECTOR2(1.0f + (((rand() % 200) - 100) * 0.001f), 1.0f + (((rand() % 200) - 100) * 0.001f));


				particle[index].speed  = speed;

				// p[eBN̉x
				particle[index].velocity = velocity;

				// p[eBNړ̐ݒ
				particle[index].arc = ( (rand( ) % 628 ) - 314) * 0.01f;

				// p[eBNF
				particle[index].color = color;

				// p[eBNa
				particle[index].radius = radius;

				// p[eBNωʒ萔
				particle[index].amountOfChangeInColor.a = particle[ index ].color.a / particle[index].life;
				particle[index].amountOfChangeInRadius = (particle[ index ].radius - 10) / particle[index].life;

				// ͂̒ǉ
				particle[ index ].ambientPower = D3DXVECTOR2( 1.7f, 0.5f );
			
				// ݃t[̏
				particle[ index ].age  = 0;


			} // -> END ( PARTICLE SET )

			break;

		}
	}


}

// GetSet FUNCTIONS

// p[eBN̎擾
PARTICLE* GetParticle( void )
{
	return &particle[0];
}

// p[eBNSW̍Đݒ
void SetParticleCenterCoord( LPD3DXVECTOR2 coord, const int index )
{

	particle[ index ].center = *coord;

}

// p[eBNSW̎擾
D3DXVECTOR2 GetParticleCenterCoord( const int index )
{

	return particle[ index ].center;

}

// p[eBNx̍Đݒ
void SetParticleSpeed( LPD3DXVECTOR2 coord, const int index )
{

	particle[ index ].center = *coord;

}

// p[eBNx̎擾
D3DXVECTOR2 GetParticleSpeed( const int index )
{

	return particle[ index ].center;

}

// p[eBNx̍Đݒ
void SetParticleVelocity( LPD3DXVECTOR2 speed, const int index )
{

	particle[ index ].speed = *speed;

}

// p[eBNx̎擾
D3DXVECTOR2 GetParticleVelocity( const int index )
{

	return particle[ index ].speed;

}

// p[eBN̐F̍Đݒ
void SetParticleColor( D3DXCOLOR color, const int index )
{

	particle[ index ].color = color;

}

// p[eBN̐F̎擾
D3DXCOLOR GetParticleColor( const int index )
{

	return particle[ index ].color;

}

// p[eBN̕ωF̍Đݒ
void SetParticleChangeColor( D3DXCOLOR color, const int index )
{

	particle[ index ].amountOfChangeInColor = color;

}

// p[eBN̕ωF̎擾
D3DXCOLOR GetParticleChangeColor( const int index )
{

	return particle[ index ].amountOfChangeInColor;

}

// p[eBNa̍Đݒ
void SetParticleRadius( float radius, const int index )
{

	particle[ index ].radius = radius;

}

// p[eBNa̎擾
float GetParticleRadius( const int index )
{

	return particle[ index ].radius;

}

// p[eBNaωʂ̍Đݒ
void SetParticleChangeRadius( float radius, const int index )
{

	particle[ index ].amountOfChangeInRadius = radius;

}

// p[eBNaωʂ̎擾
float GetParticleChangeRadius( const int index )
{

	return particle[ index ].amountOfChangeInRadius;

}

// p[eBNopx̍Đݒ
void SetParticleEmitAngle( float arc, const int index )
{

	particle[ index ].arc = arc;

}

// p[eBNopx̎擾
float GetParticleEmitAngle( const int index )
{

	return particle[ index ].arc;

}

// p[eBN݃t[̍Đݒ
void SetParticleLife( int life, const int index )
{

	particle[ index ].life = life;

}

// p[eBN݃t[̎擾
int GetParticleLife( const int index )
{

	return particle[ index ].life;

}





