<?php

###############################################################################
# korean_utf-8.php
# This is the english language page for Geeklog!
# Special thanks to Mischa Polivanov for his work on this project
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten AT securitygeeks DOT com
# Copyright (C) 2007 IvySOHO Ivy(KOMMA Tetsuko/Kim Younghie)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
################################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => '글쓴이',
    2 => '전체글 표시',
    3 => '건의 덧글',
    4 => '편집',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => '관리기능',
    10 => '덧글관리',
    11 => '글',
    12 => '블럭',
    13 => '화제',
    14 => '',
    15 => '',
    16 => '',
    17 => '사용자',
    18 => 'SQL Query',
    19 => '로그아웃',
    20 => '개인정보',
    21 => '이름',
    22 => '아이디',
    23 => '관리수준',
    24 => '손님',
    25 => '덧글추가',
    26 => '덧글에 대한 책임은 글쓴이에게 전적으로 있으며, 사이트관리자는 책임 지지 않습니다',
    27 => '최신덧글',
    28 => '삭제',
    29 => '-',
    30 => '이전 글',
    31 => '사용 가능한 HTML태그',
    32 => '에러, 이름이 입력 않습니다',
    33 => '에러, 로그파일에 기록되지 않습니다',
    34 => '에러',
    35 => '로그아웃',
    36 => 'on',
    37 => '-',
    38 => 'RSS 배신',
    39 => '갱신',
    40 => '',
    41 => '손님',
    42 => '글쓴이',
    43 => '덧글추가',
    44 => '원래 글',
    45 => '나의 SQL 에러번호는',
    46 => '나의 SQL 에러메세지는',
    47 => '로그인',
    48 => '나의 어카운트',
    49 => '설정',
    50 => 'SQL문장에 에러가 있습니다',
    51 => '도움',
    52 => '신규',
    53 => '관리화면',
    54 => '파일을 열수 없습니다',
    55 => '다음 장소에서 에러가 있었습니다',
    56 => '조회',
    57 => '비밀번호',
    58 => '로그인',
    59 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">신규등록</a>",
    60 => '덧글달기',
    61 => '어카운트 작성',
    62 => '워드',
    63 => '덧글설정',
    64 => '기사를 친구에게 메일로 보내기',
    65 => '인쇄용 화면',
    66 => '',
    67 => '어서오세요',
    68 => '홈(집)',
    69 => '연락처',
    70 => '검색',
    71 => '덧글달기',
    72 => '링크',
    73 => '',
    74 => '',
    75 => '검색',
    76 => '사이트정보',
    77 => '플러그인(확장기능)',
    78 => '',
    79 => '최신정보',
    80 => '건의 글',
    81 => '건의 글',
    82 => '시간이내',
    83 => '덧글',
    84 => '',
    85 => '(48시간이내)',
    86 => '  -',
    87 => '(최근 2주간)',
    88 => '',
    89 => '',
    90 => '홈',
    91 => '페이지 작성시간',
    92 => '초',
    93 => '저작권',
    94 => '본 페이지의 모든 상표와 저작권은 각각의 소유자에게 귀속합니다.',
    95 => '켜짐',
    96 => '그룹(집단)',
    97 => '단어목록',
    98 => '플러그인',
    99 => '글',
    100 => '-',
    101 => '',
    102 => '',
    103 => '데이터베이스',
    104 => '：',
    105 => '그룹메일',
    106 => '방문수',
    107 => 'GL버젼체크',
    108 => '케슈해결',
    109 => '불량글 보고',
    110 => '사이트관리자에게 투고를 알립니다',
    111 => '',
    112 => '등록자수',
    113 => '도큐멘트',
    114 => '트랙백',
    115 => '-',
    116 => '트랙백',
    117 => '전체글',
    118 => '다음장으로',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">비밀번호 재발행</a> ",
    120 => '이 덧글에 대한 영구링크',
    121 => '덧글 (%d 건)',
    122 => '트랙백 (%d 건)',
    123 => '모든 HTML을 허가.  글에는 자동태그 [story:<id>][staticpage:<id>][event:<id>] 이용가능. ex）[story:abc123 caption]',
    124 => '전체선택을 삭제 할 경우, 여기를 클릭',
    125 => '부분선택을 삭제해도 괜찮겠습니까?',
    126 => '전체선택 혹은 선택해제',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => '덧글달기',
    2 => '덧글쓰기 방법',
    3 => '로그아웃',
    4 => '어카운트 작성',
    5 => '이름',
    6 => '덧글쓰기는 로그인이 필요합니다.  어카운트가 없을 경우, 아래 양식으로 새 어카운트를 작성할 수 있습니다.',
    7 => '당신은',
    8 => "초 전에 덧글을 쓰셨습니다. 덧글과 덧글  사이는{$_CONF['commentspeedlimit']}초 이상의 간격이 필요합니다.",
    9 => 'Comment',
    10 => '레포트 보내기',
    11 => '덧글달기',
    12 => '제목과 내용을',
    13 => '개인정보',
    14 => '표시테스트',
    15 => '이 덧글 레포트',
    16 => '제목',
    17 => '에러',
    18 => '주의사항',
    19 => '내용과 관련된 주제로 투고 바랍니다',
    20 => '가능한 한 새 주제 보다는 덧글쓰기를 바랍니다.',
    21 => '다른 사람의 덧글을 충분히 읽고 동일한 덧글은 자제 하시기 바랍니다',
    22 => '내용을 잘 알 수 있는 제목으로',
    23 => '당신의 메일주소는 표시 되지 않습니다',
    24 => '손님',
    25 => '덧글을 사이트 관리자에게 알려도 괜찮겠습니까?',
    26 => '%s 씨는 다음의 덧글을 실례라고 지적하고 있습니다',
    27 => '부적절 신고',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment."
);

###############################################################################
# users.php

$LANG04 = array(
    1 => '어카운트 정보',
    2 => '이름',
    3 => '이름',
    4 => '비밀번호',
    5 => '메일주소',
    6 => '홈페이지',
    7 => '자기소개',
    8 => 'PGP키',
    9 => '보존',
    10 => '최근 10건의 덧글',
    11 => '-',
    12 => '개인정보',
    13 => '메일로 다이제스트 읽습니다',
    14 => '이 비밀번호는 자동적으로 만들어진 것이므로, 비밀번호 갱신을 권합니다.  비밀번호 갱신은 사이트에 로그인 한 후, [나의 어카운트]를 클릭하여 변경 바랍니다.',
    15 => "{$_CONF['site_name']} 에 당신의 어카운트가 작성 되었습니다.  이 어카운트를 사용하기 위해서는 아래의 사용자 이름과 비밀번호로 로그인 할 필요가 있습니다.  이 메일은 만약을 위해 보존해 두시기 바랍니다.",
    16 => '비밀번호 재발행 알림',
    17 => '어카운트 없슴',
    18 => '이 메일주소는 유효하지 않습니다.',
    19 => '사용자 이름 또는 주소 중에 이미 사용되고 있습니다.',
    20 => '이 메일주소는 유효하지 않습니다.',
    21 => '에러',
    22 => "{$_CONF['site_name']} 어카운트 작성",
    23 => "{$_CONF['site_name']} 어카운트를 작성하면 제안 및 의견, 덧글달기 등 본 사이트 기능 전부를 사용 할 수 있습니다.  어카운트가 없으면 손님으로만 투고 할 수 있습니다.  한편 등록된 메일주소는 절대로 표시되지 않으므로 안심하시기 바랍니다. 사용자 이름은 30문자 이내이며 반각(半角) 전각(全角) 양쪽 모두 가능합니다.",
    24 => '비밀번호는 여기 메일주소로 보내집니다.',
    25 => '비밀번호를 잊어버렸을 경우, 여기에',
    26 => '등록 시 사용된 이름 또는 메일주소<font color=\"red\"> 어느 하나를 입력</font>하고, [비밀번호 보내기]를 클릭해 주시기 바랍니다.  등록된 메일주소로 새로운 비밀번호 설정방법을 알려드립니다.',
    27 => '어카운트 작성',
    28 => ' 비밀번호 메일로 보내기',
    29 => '로그아웃 마침:',
    30 => '로그인 마침:',
    31 => '로그인 필요.',
    32 => '서명',
    33 => '공개된 바 없습니다',
    34 => '이름',
    35 => '재변경 비밀번호',
    36 => 'http:// 부터 시작',
    37 => '당신의 덧글로 사용.',
    38 => '당신에 대한 소개문입니다.  공개됩니다.',
    39 => '당신의 공개 PGP 키',
    40 => '화제아이콘 비표시',
    41 => '수정 허락',
    42 => '날짜 적힌 양식',
    43 => '표시된 글 수',
    44 => '박스(상자) 비표시',
    45 => '표시설정',
    46 => '다음의 아이템 제외',
    47 => '뉴스상자 설정',
    48 => '화제',
    49 => '글에 아이콘 비표시',
    50 => '관심이 없으면 체크를 해제',
    51 => '글에만 표시',
    52 => '초기값',
    53 => '매일 밤 그날의 기사 메일로 수신',
    54 => '읽고싶지 않은 투고자 이름과 주제 체크',
    55 => '전체체크를 해제 할 경우 초기값이 반영됩니다.  초기값은 하나라도 체크가 표시되어 있으면 무시 되므로 읽고 싶은 것 전부 체크 바랍니다.  초기값은 굵은 글씨의 화제입니다',
    56 => '글쓴이 이름',
    57 => '표시모드',
    58 => '대체 가능한 순서',
    59 => '덧글 최대수',
    60 => '덧글 표시방법',
    61 => '순서',
    62 => '초기값은 100입니다',
    63 => "비밀번호를 메일로 보냈습니다.  메세지에 로그인 방법을 알려드렸습니다. {$_CONF['site_name']}의 이용을 기다리고 있습니다.",
    64 => '덧글설정',
    65 => '로그인 바랍니다',
    66 => '로그인 바랍니다',
    67 => '등록일시',
    68 => '인증의 보존기간',
    69 => '일단 로그인 한 다음, 얼만큼의 정보를 남겨 놓을 수 있습니까?',
    70 => "{$_CONF['site_name']}의 표시와 내용 설정",
    71 => "{$_CONF['site_name']}의 특징으로, 표시된 글의 화제와 표시를 자유로 바꿀 수 있습니다. 그러기 위해서는 우선, {$_CONF['site_name']}에<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">사용자 등록</a>할 필요가 있습니다.  이미 등록을 마쳤다면 왼쪽 양식으로 로그인 바랍니다.",
    72 => '화제',
    73 => '말',
    74 => '이 사이트의 디자인 변경',
    75 => '기사는 메일로 보내졌습니다.  받는이:',
    76 => '다음 목록에서 화제를 선택하면 하루가 끝날 무렵 그 화제에 관한 글을 메일로 받을 수 있습니다. 관심있는 화제를 선택해 주세요.',
    77 => '아바다(자기사진)',
    78 => '아바다(자기사진) 첨가',
    79 => '아바다 삭제는 여기를 체크',
    80 => '로그인',
    81 => '메일보내기',
    82 => '사용자 최신 덧글 10건',
    83 => '사용자 덧글 모두보기. 사용자:',
    84 => '전체 덧글수',
    85 => '덧글총수',
    86 => '사용자의 덧글모음 검색. 사용자:',
    87 => '당신의 로그인 이름',
    88 => "%s 씨, 안녕하세요? \n\n{$_CONF['site_name']}로 부터의 소식입니다. \n\n아래의 페이지에서 비밀번호 재발행 수속을 거치시기 바랍니다. \n그 다음부터는 새 비밀번호로 로그인 하시기 바랍니다. \n만약 이 메일은 아닌 것으로 여겨시지면, 다른 사람의 메일주소를 실수로\n입력하셨을 가능성이 있습니다.  비밀번호가 변경되는 경우는 없음으로\n안심하시기 바랍니다.\n\n",
    89 => "비밀번호를 변경하고 싶지 않으시다면 이 메세지를 무시하시기 바랍니다. \n\n",
    90 => '아래에 새 비밀번호를 입력 바랍니다..  이 양식이 제출될 때 까지는 지금의 비밀번호가 유효하므로 주의 바랍니다.',
    91 => '새 비밀번호 설정',
    92 => '새 비밀번호 입력',
    93 => '방금의 비밀번호 변경요구는 %d 초 전이었습니다.  이 사이트에서는 변경을 위해 %d 초 기다려 주시기 바랍니다.',
    94 => '어카운트(%s) 삭제',
    95 => '데이터베이스에서 어카운트 삭제는 아래의 [어카운트 삭제] 단추를 클릭 하시기 바랍니다. 그러면 당신의 어카운트 이름으로 투고된 글과 덧글은 <strong> 삭제되지 않습니다</strong>.  이들의 기사와 덧글은 [손님] 의 덧글로 표시됩니다.',
    96 => '어카운트 삭제',
    97 => '어카운트 삭제확인',
    98 => '정말 어카운트를 삭제 하시겠습니까.  삭제 하시면 이 사이트에 새로운 어카운트를 만들지 않는 한 로그인 할 수 없습니다.  죄송합니다만, 한번 더 [어카운트 삭제] 단추를 클릭 하시기 바랍니다.',
    99 => '개인정보 옵션',
    100 => '관리자 메일',
    101 => '사이트관리자 메일수신',
    102 => '다른 사용자의 메일',
    103 => '다른 사용자의 메일수신',
    104 => '온라인 여부표시',
    105 => '[현재 로그인 상황]에 이름표시',
    106 => '사는 곳(거주지)',
    107 => '공개프로필에 표시',
    108 => '새 비밀번호 확인',
    109 => '새 비밀번호 재입력',
    110 => '현재 비밀번호',
    111 => '현재 비밀번호 입력',
    112 => '로그인 시행횟수를 초과했습니다. 다음에 다시 로그인 바랍니다',
    113 => '로그인에 실패했습니다.',
    114 => '어카운트가 무효로 되었습니다.',
    115 => '어카운트가 무효로 되었으므로 로그인 할 수 없습니다. 관리자에게 연락 바랍니다.',
    116 => '당신의 어카운트는 관리자가 유효로 될 때를 기다리고 있습니다.  관리자가 승인 할 때까지 로그인을 할 수 없습니다.',
    117 => 'Your account is currently awaiting activation by an administrator. You will not be able to login until your account has been approved.',
    118 => "{$_CONF['site_name']}  당신의 어카운트가 유효로 되었습니다.  다음의 링크에서 당신의 이름(username)으로 보낸 메일 비밀번호로 로그인 할 수 있습니다.",
    119 => '비밀번호를 잊어버렸을 경우, 아래의 링크에서 새로운 비밀번호를 신청 할 수 있습니다.',
    120 => '어카운트가 유효로 되었습니다.',
    121 => '서비스',
    122 => '죄송합니다만, 사용자의 신규등록은 정지 중입니다.',
    123 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">신규등록</a>",
    124 => '(확인) 메일주소',
    125 => '양쪽의 입력란에 같은 메일주소를 입력 바랍니다.',
    126 => '확인을 위해 반복해서 같은 것을 입력 바랍니다.',
    127 => '설정 변경은 현재의 비밀번호를 입력할 필요가 있습니다.',
    128 => '이름',
    129 => '비밀번호와 메일주소',
    130 => '개인정보',
    131 => '매일의 다이제스트판 옵션',
    132 => '매일의 다이제스트판 기능',
    133 => '덧글표시',
    134 => '덧글옵션',
    135 => '<li>디펄트의 덧글 표시법 </li><li> 덧글을 표시하는 디펄트의 순서 </li><li> 표시하는 덧글 최대수를 설정해 주세요.  디펄트는 100건입니다. </li>',
    136 => '화제와 글쓴이 제외',
    137 => '기사의 필터링',
    138 => '그외 설정',
    139 => '레이아웃과 언어',
    140 => '<li> [화제별 아이콘 비표시] 를 체크하면 기사에 화제별 아이콘이 표시되지 않습니다</li><li> [박스 비표시]를 체크하면 관리자 메뉴, 사용자 메뉴, 주제 만이 표시되지 않습니다. <li> 1페이지에 표시한 글의 최대수를 설정해 주시기 바랍니다. </li><li> 화제와 원하는 날짜를 설정 바랍니다</li>.',
    141 => '개인정보 설정',
    142 => '디펄트 설정에서는 다른 사용자와 관리자가 당신에게 메일주소를 보낼 수 있으며, 온라인 여부를 표시하도록 되어 있습니다.  개인정보를 보호하고자 이에 대응하는 옵션의 체크를 풀어주시기 바랍니다.',
    143 => '블러그필터링',
    144 => '블러그 표시, 비표시',
    145 => '공개프로필',
    146 => '비밀번호와 메일주소',
    147 => '비밀번호, 메일주소, 자동로그인 기능을 편집합니다.  비밀번호와 메일주소는 확인을 위해, 2회 입력할 필요가 있습니다.',
    148 => '개인정보',
    149 => '다른 사용자도 읽을 수 있는 개인정보를 편집합니다. <li> [서명]은 덧글과 게시판의 덧글에 들어있습니다 </li><li> [자기소개] 는 다른 사용자도 읽을 수 있는 짤막한 자기소개입니다 </li><li>[PGP 공개키]를 공개합시다<li>',
    150 => '',
    156 => '어카운트 삭제',
    157 => '어카운트 삭제옵션',
    158 => 'Time Zone',
    159 => 'This email was generated automatically. Please do not reply to this email.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => '글없음.',
    2 => '글없음. 이 화제에 관한 덧글이 없거나, 표시설정을 너무 많이 하였거나 어느 한 쪽입니다.',
    3 => '화제 %s 에 관한 글',
    4 => '오늘의 주요기사',
    5 => '다음',
    6 => '앞으로',
    7 => '처음',
    8 => '마지막'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => '메세지를 보내는 도중 에러가 발생했습니다.  다시 한번 시도하시기 바랍니다',
    2 => '메세지는 보내졌습니다.',
    3 => '메일주소를 올바로 입력 하셨습니까?',
    4 => '이름, 메일주소, 건명 내용 모두 입력 바랍니다',
    5 => '해당 사용자 없슴',
    6 => '에러가 발생했습니다.',
    7 => '사용자 정보',
    8 => '이름',
    9 => 'URL',
    10 => '받는이',
    11 => '이름',
    12 => '메일 주소',
    13 => '건명',
    14 => '본문',
    15 => 'HTML은 사용 할 수 없습니다',
    16 => '송신',
    17 => '친구에게 글 보내기',
    18 => '받는이',
    19 => '받는이 메일주소',
    20 => '이름',
    21 => '메일주소',
    22 => '모든 항목에 입력 바랍니다',
    23 => "이 메일은 %s씨가{$_CONF['site_url']}의 기사를 당신에게 전하고 싶다고 하여 %s의 주소로 보내졌습니다. 이것은 결코 불량메일이 아니며, 보내진 주소는 절대로 다른 목적으로 사용되지 않습니다.",
    24 => '이 기사에 관한 제안 및 의견은 다음 장소에서만 가능.',
    25 => '이 기능을 사용하기 위해서는 로그인 바랍니다.',
    26 => '이 양식으로 메일 보내기',
    27 => '짤막한 메세지',
    28 => '%s 씨의 메세지',
    29 => "오늘의{$_CONF['site_name']} 다이제스트.  받는이:",
    30 => '오늘의 뉴스레터.  받는이:',
    31 => '제목',
    32 => '날짜',
    33 => ' 다음 장소에서 전체글 보기가 가능합니다',
    34 => '마지막 메세지.',
    35 => '죄송합니다만, 이 사용자의 메일은 접수될 수 없습니다.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => '검색옵션',
    2 => '키워드',
    3 => '화제',
    4 => '전부',
    5 => '종류',
    6 => '글',
    7 => '덧글',
    8 => '소유자',
    9 => '전부',
    10 => '검색',
    11 => '검색결과',
    12 => '건이 해당',
    13 => '검색결과 : 해당없습니다',
    14 => '해당하는 것이 없었습니다.',
    15 => '다른 키워드로 검색하시기 바랍니다',
    16 => '제목',
    17 => '날짜',
    18 => '소유자',
    19 => " {$_CONF['site_name']} 전체글 검색",
    20 => '날짜',
    21 => '～',
    22 => '(서식은 YYYY-MM-DD)',
    23 => '건의 방문',
    24 => '%d 건 찾았습니다.',
    25 => '다음의 키워드 검색',
    26 => '건',
    27 => '초',
    28 => '해당하는 기사, 덧글은 찾지 못했습니다.',
    29 => '기사, 덧글 검색결과',
    30 => '',
    31 => '블랙인으로 부터 해당하는 것을 찾지 못했습니다.',
    32 => '',
    33 => 'URL',
    34 => '장소',
    35 => '하루동안',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '검색문자 순서는 3문자 이상 필요합니다',
    42 => '날짜적힌 서식은 YYYY-MM-DD (년 - 월- 일) 로 바랍니다',
    43 => '정확한 문자순서',
    44 => '전부포함',
    45 => '양쪽 모두 포함',
    46 => '다음',
    47 => '앞',
    48 => '소유자',
    49 => '날짜',
    50 => '방문자수',
    51 => '',
    52 => '장소',
    53 => '기사 검색결과',
    54 => '덧글 검색결과',
    55 => '검색문자순서',
    56 => 'AND',
    57 => 'OR',
    58 => '다음 검색결과로 &gt;&gt',
    59 => '1페이지에 이르는 건수',
    60 => '건',
    61 => '검색조건 수정',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => '사이트에 관한 통계',
    2 => '시스템 전체에 대한 접수 수',
    3 => '기사(덧글) 수',
    4 => '',
    5 => '',
    6 => '',
    7 => '최다클릭 기사 톱 10',
    8 => '글 제목',
    9 => '건',
    10 => '이 사이트에는 글이 한 건도 없거나, 아무도 방문한 적 없는 어느 한쪽 일 것입니다.',
    11 => '최다덧글 기사 톱 10',
    12 => '건',
    13 => '이 사이트에는 글이 한 건도 없거나, 덧글쓴이 없는 어느 한쪽 일 것입니다.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => '최다검색 기사 톱 10',
    23 => '메일주소',
    24 => '친구들에게 소개된 기사는 없는 것 같습니다.',
    25 => '트랙백 톱 10',
    26 => '트랙백 없음',
    27 => '등록된 사용자 수',
    28 => '',
    29 => '',
    30 => '힛트',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => '관련정보',
    2 => '친구에게 메일로 기사보내기',
    3 => '인쇄용 페이지',
    4 => '기사 옵션',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => ' %s 를 덧글달기 전에 로그인 바랍니다',
    2 => '로그인',
    3 => '신규등록',
    4 => '',
    5 => '',
    6 => '덧글달기',
    7 => '로그인 필요',
    8 => '덧글달기',
    9 => '이 사이트에 정보를 투고 할 경우 다음의 규칙을 지켜 주시기 바랍니다.  <ul><li>  필요한 모든 항목에 입력 바랍니다. <li> 정확하고 충분한 정보를 제공해 주시기 바랍니다. <li>URL에 대해서는 특히 주의하여 확인하시기 바랍니다</ㅕㅣ>',
    10 => '제목',
    11 => '',
    12 => '개시일',
    13 => '종료일',
    14 => '장소',
    15 => '설명',
    16 => '',
    17 => '',
    18 => '',
    19 => '먼저 읽어주시기 바랍니다',
    20 => '',
    21 => '',
    22 => '입력 미비',
    23 => '전부 입력',
    24 => '덧글허락',
    25 => '%s 덧글 허락',
    26 => '덧글 간격제한',
    27 => '이름',
    28 => '화제',
    29 => '기사',
    30 => '지난 회 당신은,',
    31 => "초 전에 덧글을 쓰셨습니다.  덧글달기 간격은{$_CONF['speedlimit']}초 이상을 유지하시기 바랍니다.",
    32 => '미리보기',
    33 => '기사 미리보기',
    34 => '로그아웃',
    35 => 'HTML 태그 사용 불가능',
    36 => '덧글모드',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => '주소 1',
    45 => '주소 2',
    46 => '지역이름',
    47 => '시,군',
    48 => '우편번호',
    49 => '',
    50 => '',
    51 => '장소',
    52 => '삭제',
    53 => '어카운트 작성',
    54 => 'Story Introduction',
    55 => 'Story Body'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => '관리권한 필요',
    2 => '로그인 할 수 없음. 다시 한번 입력해 주세요',
    3 => '비밀번호가 틀립니다.  사용자 이름',
    4 => '이름',
    5 => '비밀번호',
    6 => '관리용 조건은 모두가 기록됩니다. <br' . XHTML . '> 이 페이지는 관리자만이 사용할 수 있습니다.',
    7 => '로그인'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => '여기를 관리할 권한이 없습니다',
    2 => '이 블로그를 편집할 권한 없습니다',
    3 => '블로그 편집',
    4 => '힛트를 읽어내는 도중 에러가 발생했습니다. (error.log를 참조해 주세요)',
    5 => 'Yes',
    6 => 'No',
    7 => '전부',
    8 => '블로그 보완수준',
    9 => '블로그 순서',
    10 => '',
    11 => '포탈블로그',
    12 => '정상블로그',
    13 => '포탈블로그 옵션',
    14 => 'RSS URL',
    15 => 'RSS 갱신일시',
    16 => '정상블로그 옵션',
    17 => '블로그콘텐츠(HTML 가능)',
    18 => '블로그제목, 보완수준, 콘텐츠를 입력하시기 바랍니다.',
    19 => '블로그 관리',
    20 => 'Regular Blocks',
    21 => '보완',
    22 => 'Dynamic Blocks',
    23 => '순서',
    24 => 'Dynamic',
    25 => '블로그 편집, 삭제는 블로그의 편집 아이콘을, 신규작성은 위의 [신규작성] 링크를 클릭합니다.',
    26 => '레이아웃용 블로그',
    27 => 'PHP 블로그',
    28 => 'PHP 블로그옵션',
    29 => '관수',
    30 => 'PHP를 이용한 블로그를 사용 할 경우 접두자 [phpblock_](예 phpblock_themetester)의 PHP 관수명을 입력하시기 바랍니다.  이 접두자가 붙어 있지 않은 관수는 불러낼 수 없습니다.  이것은 악의를 가진 사용자가 사이트에 유해한 관수를 정의하는 것을 피하기 위한 것입니다.  관수명에 0은 필요 없습니다.  모든 PHP블럭관수는  /path/to/geeklog/system/lib-custom.php에 정리하시기 바랍니다.  그러면 Geeklog를 업그레이드 하여도 계속적으로 사용 할 수 있습니다.',
    31 => 'PHP블로그에 에러가 있습니다.  %s가 존재하지 않습니다.',
    32 => '에러. 미입력 항목이 있습니다.',
    33 => '포탈블로그 rdf파일에는 URL을 입력할 필요 있습니다',
    34 => 'PHP블로그에는 제목과 관수명을 입력 바랍니다',
    35 => '일반 블로그에는 제목과 내용을 입력 바랍니다',
    36 => '레이아웃용 블로그에는 내용을 입력 바랍니다',
    37 => 'PHP블럭 관수명이 부적절합니다.',
    38 => 'PHP블럭의 관수명은 접두자\phpblock_themetester)가 필요합니다.  보완 대책에 협력 바랍니다.',
    39 => '표시장소',
    40 => '왼쪽',
    41 => '오른쪽',
    42 => '블로그의 제목과 표시 순서를 입력 바랍니다',
    43 => '홈페이지에만',
    44 => 'Multiple',
    45 => "관리권한이 없는 블로그를 편집하려고 하셨습니다.  이 행위는 기록됩니다.<ahref=\"{$_CONF['site_admin_url']}/block.php\">블럭의 편집</a>화면으로 돌아가시기 바랍니다.",
    46 => '이동',
    47 => 'None',
    48 => '블로그아이디',
    49 => '(반각 영문, 숫자 그리고 하이푼)',
    50 => 'The Block Name can not be empty',
    51 => 'http://를 포함함',
    52 => '빈칸을 그대로 남겨놓으면 이 블로그에 대한 도움아이콘은 표시 되지 않습니다.',
    53 => '유효',
    54 => '보존',
    55 => '취소',
    56 => '삭제',
    57 => '블로그를 아래로',
    58 => '블로그를 위로',
    59 => '블로그를 오른쪽으로',
    60 => '블로그를 왼쪽으로',
    61 => '제목없음',
    62 => '글 검색수',
    63 => '블로그 제목 부적절합니다.',
    64 => '제목란을 비워놓으면 안됩니다.  HTML을 포함시켜도 안됩니다.',
    65 => '순서',
    66 => '자동태그',
    67 => '자동태그체크',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.',
    69 => 'Plugin Name'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => '앞 기사',
    2 => '다음 기사',
    3 => '모드',
    4 => '덧글모드',
    5 => '기사편집',
    6 => '기사 없음',
    7 => '사용자',
    8 => '보존',
    9 => '미리보기',
    10 => '취소',
    11 => '삭제',
    12 => '기사아이디',
    13 => '',
    14 => '',
    15 => '일시',
    16 => '모두문',
    17 => '본문',
    18 => '검색건수',
    19 => '덧글수',
    20 => '핑(Ping)',
    21 => '핑을 보내다',
    22 => '기사관리',
    23 => ' 기사의 편집, 삭제는 기사의 편집아이콘, 기사의 열람은 기사의 제목, 새로운 기사를 작성하는 경우는 [신규작성]을 클릭해 주세요.',
    24 => '지정한 기사아이디는 이미 사용되고 있습니다.  다른 기사아이디를 입력 바랍니다.',
    25 => '기사의 등록 중에 에러가 있습니다.',
    26 => '기사 미리보기',
    27 => '<p> 자동태그[imageX] 대신에 [unscaledX]를 사용하면 동영상은 원래 크기로 표시 됩니다. </p>',
    28 => '<b> 미리보기 </b>: 동영상 첨부기사를 미리보기 할 경우, 미리보기 단추를 클릭하지 않고, 우선 드래프드 모드로 저장해 주세요.  미리보기 단추는 동영상이 없는 경우에만 클릭하시기 바랍니다. </p>',
    29 => '트랙백 수',
    30 => '파일을 업로드 할 때 에러가 발생하였습니다.',
    31 => '제목과 모두문을 입력해 주세요',
    32 => '주요기사',
    33 => '주요기사는 마지막으로 지정된 1건입니다.',
    34 => '드래프트',
    35 => '○',
    36 => '－',
    37 => '동일한 투고자로 부터의 덧글',
    38 => '동일한 주제',
    39 => '메일주소 소개',
    40 => '',
    41 => "관리권한이 없는 기사를 편집하려고 하셨습니다. 이 행위는 기록됩니다.  다음의 기사는 읽기전용입니다.  읽기를 다 마치면<a href=\"{$_CONF['site_admin_url']}/story.php\"> 기사의 편집화면 </a> 으로 돌아가 주세요.",
    42 => "관리권한이 없는 기사를 편집하려고 하셨습니다. 이 행위는 기록됩니다.<a href=\"{$_CONF['site_admin_url']}/story.php\">기사의 편집화면</a>으로 돌아가 주세요.",
    43 => '',
    44 => '',
    45 => '',
    46 => ' <b> 주의: </b> 날짜가 지정된 기사를 다음의 원하는 날짜로 변경할 경우 그 날까지 기사는 표시되지 않습니다.  그리고 RSS 힛트에도 반영되지 않으며, 검색와 사이트 정보에도 반영되지 않습니다.',
    47 => 'image',
    48 => 'image',
    49 => 'right',
    50 => 'left',
    51 => '<p> 첨부된 동영상은 자동태그로 기록해 주세요.  서식은 [imageX], [imageX_오른쪽], [imageX_왼쪽] (X는 첨부된 화면의 번호)(예 [image1]). 주의: 첨부된 동영상은 기사 중에 전부 사용하지 않으면 기사를 저장할 수 없습니다. <BR><P><B> 미리보기</B>: 동영상이 있는 기사는 드래프트(글쓰기연습)으로 저장하여 검색하시기 바랍니다. 미리보기 단추는 동영상이 없을 경우에만 이용할 수 있습니다.</p>',
    52 => '',
    53 => '은 사용될 수 없습니다.  보존하기 전에 모두문 내지 본문에서 동영상을 사용하지 않으면 안됩니다.',
    54 => '첨부된 동영상은 사용되지 않습니다.',
    55 => '기사를 보존하는 경우, 다음의 에러가 발생하였습니다.  보존하기 전에 수정 하시기 바랍니다.',
    56 => '주제 아이콘 표시',
    57 => '원래크기 동영상을 표시',
    58 => '압축옵션',
    59 => '옵션',
    60 => '',
    61 => '자동압축',
    62 => '자동삭제',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => '편집영역의 확대',
    68 => '편집영역의 축소',
    69 => '투고일시와 공개모드 설정',
    70 => '툴바 선택',
    71 => '기본적이 툴바',
    72 => '기본적인 툴바',
    73 => '확장툴바',
    74 => '확장툴바 그 2',
    75 => '전 기능',
    76 => '공개옵션',
    77 => '어드벤스트 에디터 이용은 브라우저에서 JavaScript를 사용할 수 있는 환경이 필요합니다.  이 옵션은 config.php 에서 무효로 될 수 있습니다.',
    78 => '<a href="%s/story.php?mode=edit&sid=%s&editopt=default">정상에디터를 사용하는 경우</a>',
    79 => '미리보기',
    80 => '에디터',
    81 => '공개옵션',
    82 => '동영상',
    83 => '압축',
    84 => '바 밋션',
    85 => '전부표시',
    86 => '어드벤스트 에디터',
    87 => '기사에 대한 정보',
    88 => 'Wiki-style format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.',
    'autotag_desc_story' => '[story: id alternate title] - Displays a link to a Story using the Story Title as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => '토픽 편집',
    2 => '토픽 아이디',
    3 => '토픽 이름',
    4 => '토픽 아이콘파일 지정',
    5 => '(반각의 영문 숫자 그리고 하이푼-)',
    6 => '토픽 삭제시 관련기사 및 블로그 전부 삭제 됩니다',
    7 => '토픽아이디와 토픽이름 입력',
    8 => '토픽(기사카테고리) 관리',
    9 => '토픽의 편집, 삭제는 토픽이름을, 새로운 토픽 작성은 [신규작성] 링크를 클릭 바랍니다.  네모상자 안은 당신의 접속레벨입니다. *는 덧글쓰기 할 때의 디펄드 토픽입니다.',
    10 => '나열순서',
    11 => '1페이지 해당하는 글수',
    12 => '접속이 거절 되었습니다',
    13 => "관리권한이 없는 토픽을 편집하려고 하셨습니다.  이 행위는 기록됩니다.<a href=\"{$_CONF['site_admin_url']}/topic.php\"> 토픽 편집화면</a>으로 돌아가십시오.",
    14 => '대체방법',
    15 => '알파벳 순',
    16 => '신규토픽',
    17 => 'New Topic',
    18 => '관리화면',
    19 => '보존',
    20 => '취소',
    21 => '삭제',
    22 => '디펄트',
    23 => '이 토픽을를 신규기사로 투고 할 경우에 디펄트로 됩니다.',
    24 => '(*)',
    25 => '압축',
    26 => '토픽을 압축합니다.',
    27 => '토픽아이콘 업로드',
    28 => '최대',
    29 => '파일 업로드 할 때 에러',
    30 => 'Stories in Topic',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Parent Topic',
    33 => 'Inherit',
    34 => 'Items of child topic are inherited',
    35 => 'Hidden',
    36 => 'Topic will be hidden and cannot be viewed directly, only inherited',
    37 => 'Root',
    38 => 'All',
    39 => 'Homepage Only',
    40 => 'Assign one or more topics. ',
    41 => 'If "All" is selected then the item will appear for all topics. If "Homepage Only" is selected then item will appear just on the homepage. Else you must select at least one topic to assign the item to. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Inherit',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Yes',
    51 => 'No',
    52 => 'Story',
    53 => 'Image',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => '사용자를 편집',
    2 => '사용자아이디',
    3 => '사용자 이름',
    4 => '이름',
    5 => '비밀번호',
    6 => '보완수준',
    7 => '메일주소',
    8 => '홈페이지',
    9 => '(반각영문 숫자 그리고 하이푼)',
    10 => '이름, 메일주소 입력',
    11 => '사용자관리',
    12 => '사용자의 편집, 삭제는 사용자별 편집 아이콘, 신규 사용자의 작성은 [신규작성], 사용자의 일괄등록 (임포트)는 [일괄등록], 사용자의 일괄삭제는 [일괄삭제]를 클릭해 주세요.',
    13 => '보완',
    14 => '등록일',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '보존',
    21 => '등록하고자 하는 사용자 이름은 이미 존재합니다',
    22 => '에러',
    23 => '일괄등록',
    24 => '사용자 일괄등록',
    25 => '사용자를 Geeklog에 일괄등록 할 수 있습니다(중복체크 첨부).  일괄등록하는 파일은 사용자는 한 줄에 한명씩, 각 사용자의 데이터는 탭(tab) 활용으로 [성명, 사용자 이름, 메일주소] 순 입니다.  사용자의 비밀번호는 무작위로 결정됩니다. 파일은 반드시 본 사이트와 동일한 문자코드의 텍스트 형식으로 저장해 주시기 바랍니다.',
    26 => '',
    27 => '',
    28 => '화면 삭제일 경우 체크',
    29 => '패스',
    30 => '일괄등록',
    31 => '신규사용자',
    32 => '처리가 완료 되었습니다.  %d 건 등록이 이루어졌습니다.  %d 건의 에러가 발생하였습니다.',
    33 => '검색',
    34 => '에러: 등록할 파일 지정 바랍니다.',
    35 => '마지막 로그인 일시',
    36 => '아직',
    37 => '사용자아이디',
    38 => '그룹 통합검색',
    39 => '비밀번호 (재입력)',
    40 => '등록일',
    41 => '마지막 로그인',
    42 => '금지',
    43 => '유효로 될 때까지 대기중',
    44 => '승인 될 때 까지 대기중',
    45 => '유효',
    46 => '사용자 상태',
    47 => '편집',
    48 => '관리자 그룹표시',
    49 => '관리자 그룹',
    50 => '이 그룹을 관리자그룹으로 필터링 할 경우 체크 바랍니다.',
    51 => '온라인 기간',
    52 => '<br' . XHTML . '> 주: [온라인 기간] 이란 처음에 어카운트를 등록할 때 부터 전회 로그인 할 때 까지의 일수입니다.,',
    53 => '등록마침',
    54 => '일괄삭제',
    55 => 'config.php 에서 <code>$_CONF[\'lastlogin\'] = true;</code> 로 할 경우에만 이 기능은 작동되지 않습니다.',
    56 => '삭제한 사용자의 종류를 선택하여 [목록갱신]을 클릭하시기 바랍니다.  다음에는 삭제하고 싶지 않은 사용자의 체크를 풀고 [삭제] 아이콘을 클릭 하시기 바랍니다.  이 목록이 페이지에 걸쳐 있는 경우 현재 표시된 사용자만이 삭제되지 않는다는 것에 주의하시기 바랍니다.',
    57 => '유령 사용자',
    58 => '일시적 사용자',
    59 => '과거의 사용자',
    60 => 'Users that registered more than ',
    61 => '개월 전에 등록했지만, 한번도 로그인 한 적 없는 사용자',
    62 => 'Users that registered more than ',
    63 => '개월 전에 등록하여 그 후 24시간 이내에 로그인 한 적 있지만, 그 이후 한번도 로그인 한 적 없는 사용자',
    64 => '단지',
    65 => '개월간 사이트를 방문하지 않은 보통의 사용자',
    66 => '목록갱신',
    67 => '등록하여 몇개월간 경과',
    68 => '온라인 시간',
    69 => '온라인 월수',
    70 => '삭제 불가능',
    71 => '삭제 되었습니다.',
    72 => '삭제할 사용자가 선택되지 않았습니다',
    73 => '삭제하면 원 위치로 돌아가지 않습니다. 선택한 사용자 전부를 삭제해도 괜찮겠습니까?',
    74 => '최근 사용자',
    75 => '최후 등록한 사용자',
    76 => ' 개월 동안 등록한 사용자',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => '승인',
    2 => '삭제',
    3 => '편집',
    4 => '프로필',
    10 => '제목',
    11 => '개시일',
    12 => 'URL',
    13 => '덧글',
    14 => '날짜',
    15 => '화제',
    16 => '사용자 이름',
    17 => '이름',
    18 => '메일주소',
    34 => '덧글관리',
    35 => '기사의 등록신청',
    36 => 'Parent or Comment',
    37 => '',
    38 => '실행',
    39 => '현재 신청자 없음',
    40 => '사용자의 등록신청',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => '그룹메일 보내기',
    2 => '보낸이 이름',
    3 => '보낸이',
    4 => '건명',
    5 => '내용',
    6 => '보낸이',
    7 => '사용자 전부',
    8 => '관리자',
    9 => '옵션',
    10 => 'HTML',
    11 => '긴급',
    12 => '그룹메일 보내기',
    13 => '입력해서 고침',
    14 => '사용자의 수신허가 설정을 무시하고 보내기',
    15 => '보내기 중에 에러가 발생. 받는이:',
    16 => '메세지의 보내기를 완료하였습니다.  받는이:',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>다른메세지를 보내기</a>",
    18 => '보낸이',
    19 => '보충: 등록자 전원에게 송신하기 위해서는 보낸이를 [logged-in Users]로 해 주시기 바랍니다.',
    20 => "<successcount> 건의 메세지 보내기는 성공하였으며, <failcount> 건의 메세지의 보내기에는 실패하였습니다.  개별메세지 보내기 상태는 다음과 같습니다.<a href=\"{$_CONF['site_admin_url']}/mail.php\">별도의 메세지를 송신</a> <a href=\"{$_CONF['site_admin_url']}/moderation.php\">하거나,</a>관리화면으로 돌아갈 수 있습니다.",
    21 => '보내기 실패',
    22 => '보내기 성공',
    23 => '실패한 것은 없습니다.',
    24 => '성공한 것은 없습니다.',
    25 => '-- 그룹을 선택 --',
    26 => '모든 영역에 입력해 주시기 바랍니다.  또한 그룹은 드랩다운 목록에서 선택하시기 바랍니다.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Geeklog 와 최악의 경우 시스템에 악영향을 주는 경우가 있습니다. 악영향을 피하기 위해서 Geeklog의 홈페이지에서는 다양한 OS로 검토한 플러그인 만을 게재하고 있으므로<a href=\"http://www.geeklog.net\" target=\"_blank\">Geeklog 홈페이지</a>에서만 다운로드 하시기 바랍니다. 플러그인 인스트롤에 관해서는 시스템의 명령에 따라 실행할 필요가 있으므로, 특히 공식 사이트 이외에서 다운로드 할 경우는 이 점에 주의 바랍니다. 또한 그러한 주의는 플러인의 인스트롤 성공과 플러그인으로 인한 영향에 관해서 우리들은 아무런 보증을 하지 않습니다.  플러그인 인스트롤 방법은 각기 인스트롤에 같이 꾸려져 있습니다.',
    2 => '플러그인 인스트롤에 관한 주의',
    3 => '플러그인 인스트롤 양식',
    4 => '플러그인 파일',
    5 => '플러그인 관리',
    6 => '주의 : 플러그인은 이미 인스트롤 되어 있습니다.',
    7 => '인스트롤 하려는 플러그인은 이미 존재하고 있습니다.  재인스트롤 하기 전에 일단 삭제해 주시기 바랍니다.',
    8 => '플러그인의 호환성 체크에 실패 하였습니다.',
    9 => '이 플러그인은 새로운 버젼의 Geeklog가 필요합니다. <a href=http://www.geeklog.net>Geeklog</a>를 업그레이드 할지 새로운 버젼의 플러그인을 준비하시기 바랍니다.',
    10 => '<br' . XHTML . '><b> 플러그인은 인스트롤 되지 않습니다 </b><br' . XHTML . '><br' . XHTML . '>, <br' . XHTML . '><b>',
    11 => '플러그인을 수정, 삭제할 경우에는 플러그인의 편집 아이콘을 클릭하시기 바랍니다.  플러그인 작자페이지 링크도 같이 표시 됩니다.  플러그인 버젼은 인스트롤 중의 것과 파일에서 구할 수 있는 것이 표시 됩니다.  이들로 부터 플러그인 갱신에 대한 판단을 할 수 있습니다.',
    12 => '플러그인 에디터 ()에 플러그인 이름이 전해지지 않았습니다.',
    13 => '플러그인 편집',
    14 => '신규플러그인',
    15 => '관리화면',
    16 => '플러그인 이름',
    17 => '플러그인 버젼',
    18 => 'GL버젼',
    19 => '유효',
    20 => '예',
    21 => '아니오',
    22 => '인스트롤',
    23 => '보존',
    24 => '취소',
    25 => '삭제',
    26 => '플러그인 이름',
    27 => '플러그인 웹페이지',
    28 => '플러그인버젼',
    29 => 'GL버젼',
    30 => '이 플러그인을 삭제하시겠습니까?',
    31 => '이 플러그인을 삭제해도 괜찮겠습니까?  삭제하면 관련된 파일과 데이터 전부 삭제됩니다.  삭제 할 경우에는 [삭제] 단추를 다시 한번 클릭해 주시기 바랍니다.',
    32 => '<p><b> 자동링크 태그의 양식이 올바르지 않습니다.',
    33 => '최신버젼',
    34 => '갱신',
    35 => '편집',
    36 => '코드',
    37 => '데이터',
    38 => '갱신 되었습니다',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => '피이드 작성',
    2 => '저장',
    3 => '삭제',
    4 => '취소',
    10 => 'RSS배신관리',
    11 => '새로운 피이드',
    12 => '관리화면',
    13 => '피이드를 수정, 삭제할 경우는 제목의 왼쪽 아이콘을 클릭하시기 바랍니다.  새로운 피이드를 작성 할 경우 [신규피이드]를 클릭 하시기 바랍니다.',
    14 => '제목',
    15 => '종류',
    16 => '파일명',
    17 => '포멧',
    18 => '갱신일',
    19 => '유효',
    20 => '예',
    21 => '아니오',
    22 => '<i> (피이드가 없습니다) </i>',
    23 => '모든 기사',
    24 => '피이드 편집',
    25 => '피이드 제목',
    26 => '배신 최대건수',
    27 => '엔트리(입장) 길이',
    28 => '(0 = 본문없음, 1 = 본문 전부, 기타 = 지정된 문자수로 제한)',
    29 => '설명',
    30 => '갱신',
    31 => '문자코드',
    32 => '언어',
    33 => '화제',
    34 => '건',
    35 => '시간이내',
    36 => '피드 종류를 선택하시기 바랍니다',
    37 => '',
    38 => '에러 : 입력하지 않은 항목이 있습니다.',
    39 => '피이드의 제목, 설명. 파일명을 입력하시기 바랍니다.',
    40 => '입장수 혹은 취득한 시간을 입력하기바랍니다.',
    41 => '링크',
    42 => '',
    43 => '전부',
    44 => '없음',
    45 => '헤드링크 할 화제',
    46 => '표시건수',
    47 => '검색',
    48 => '편집',
    49 => '로고',
    50 => "본 사이트로 부터의 상대 URL ({$_CONF['site_url']})",
    51 => '선택한 피이드명은 다른 피이드에서 사용 되었습니다.  다른 이름으로 하시기 바랍니다.',
    52 => '에러 : 이 파일명은 이미 사용되고 있습니다',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "비밀번호를 메일로 보냈으니 확인 하시기 바랍니다.  이용방법은 메일을 참조하시기 바랍니다.{$_CONF['site_name']}",
    2 => "에 기사를 투고해 주셔서 감사합니다.  기사는 스탭에게 통지하였습니다. 승인이 되면 즉시 사이트에 게재 됩니다.{$_CONF['site_name']} ",
    3 => '',
    4 => '',
    5 => '어카운트 정보는 변경 되었습니다.',
    6 => '표시설정을 보존 하였습니다.',
    7 => '덧글 설정변경을.',
    8 => '로그아웃이 완료 되었습니다.',
    9 => '기사변경을 반영 하였습니다.',
    10 => '기사의 삭제가 완료 되었습니다.',
    11 => '블로그 변경을 반영하였습니다.',
    12 => '블러그 삭제가 완료 되었습니다.',
    13 => '주제 변경을 반영 하였습니다.',
    14 => '화제와 그외에 포함된 모든 기사와 블러그를 삭제 하였습니다.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '사용자 정보는 보존 되었습니다.',
    22 => '사용자를 삭제 하였습니다.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => '메세지는 보내졌습니다.',
    28 => '플러그인을 보존 하였습니다.',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => '접속에 실패하였습니다',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '시스템으로 부터의 메세지',
    41 => '',
    42 => '',
    43 => '',
    44 => '플러그인을 인스트롤 하였습니다',
    45 => '플러그인을 삭제 하였습니다',
    46 => '',
    47 => '',
    48 => "{$_CONF['site_name']}에 등록해 주셔서 감사합니다.  관리자 측에서 심사합니다.  등록이 인정되면 당신의 등록된 메일주소에 비밀번호가 보내집니다.",
    49 => '그룹이 무사히 등록되었습니다.',
    50 => '그룹을 삭제하였습니다.',
    51 => '사용자 이름이 이미 사용되고있습니다.  다른 이름을 지정하시기 바랍니다.',
    52 => '입력된 메일주소는 무효한 주소로 보입니다.',
    53 => '새로운 비밀번호가 등록 되었습니다.',
    54 => '당신의 신규비밀번호 발행신청 기한이 지났습니다.  아래의 양식으로 재신청 하시기 바랍니다.',
    55 => '메일이 송신 되었습니다.  도착된 메일 지시에 따라 새로운 비밀번호를 설정하시기 바랍니다.',
    56 => '메일주소는 다른 어카운트에서 이미 사용되었습니다.',
    57 => '어카운트의 삭제가 완료 되었습니다.',
    58 => '피이드가 무사히 보존 되었습니다.',
    59 => '피이드가 삭제 되었습니다.',
    60 => '플러그인이 갱신 되었습니다.',
    61 => '%s 플러그인 : 메세지의 플레이스 홀더가 불명입니다.',
    62 => '트랙백의 코멘트가 삭제되었습니다.',
    63 => '트랙백의 코멘트가 삭제되는 과정에서 문제가 발생 하였습니다.',
    64 => '트랙백이 무사히 보내졌습니다.',
    65 => '웹블러그 디렉토리 서비스가 확보 되었습니다.',
    66 => '웹블러그 디렉토리 서비스가 삭제 되었습니다.',
    67 => '새 비밀번호와 확인용 비밀번호가 일치하지 않습니다.',
    68 => '올바른 비밀번호를 입력하시기 바랍니다.',
    69 => '어카운트가 정지 되었습니다.',
    70 => '어카운트는 관리자의 승인을 기다리고 있습니다.',
    71 => '어카운트가 등록되어 관리자의 승인을 기다리고 있습니다.',
    72 => '플러그인의 인스트롤 할 때 에러 발생이 있었습니다.  error.log를 확인하시기 바랍니다.',
    73 => '플러그인을 삭제 하는 동안 에러가 있었습니다.  See error.log를 확인하시기 바랍니다.',
    74 => '핑백이 무사히 보내졌습니다.',
    75 => '트랙백은 POST request 로 보낼 필요가 있습니다.',
    76 => '이 항목을 삭제해도 괜찮겠습니까?',
    77 => '경고:<br' . XHTML . '> 데폴트의 인코딩을 UTF-8로 설정 하였습니다만, 서버가 멀티바이트 인코딩을 지원해 주고 있지 않습니다.  PHP용에 mbstring 모즐을 인스트롤 하지만 UTF-8 에서는 없는 캐랙터 셋트없이 언어로 변경해 주시기 바랍니다.',
    78 => '메일주소와 확인용 메일주소는 동일하게 입력해 주시기 바랍니다.',
    79 => '열고자 한 페이지는 이 사이트에 더 이상 존재하지 않는 관수를 참조 하시기 바랍니다.',
    80 => '이 피이드를 작성한 플러그인은 현재 무효로 되었습니다.  그 플러그인을 다시 유효로 하지 않으면 피이드는 편집 할 수 없습니다.',
    81 => '로그인 정보의 입력이 부정확한 것으로 보입니다.  다시 한번 더 로그인 하여 고쳐 주시기 바랍니다.',
    82 => '로그인 시행횟수 제한을 초과하였습니다.  잠시 지난 후 다시 로그인 하시기 바랍니다.',
    83 => '비밀번호, 메일주소, 인증의 보존기간을 변경하려면 현재의 비밀번호를 입력하시기 바랍니다.',
    84 => '어카운트를 삭제 하려면 현재의 비밀번호를 입력하시기 바랍니다.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => '접속',
    'ownerroot' => '소유자/Root',
    'group' => '그룹',
    'readonly' => '읽기전용',
    'accessrights' => '접속권한',
    'owner' => '소유자',
    'grantgrouplabel' => '위의 그룹에 편집권을 부여하다',
    'permmsg' => '참고: 멤버 혹은 로그인 한 멤버. 손님이란 로그인 하지 않고 열람하는 일반의 열람자.',
    'securitygroups' => '보안그룹(세큐리티그룹)',
    'editrootmsg' => "관리권한이 있어도 고정(root)사용자로 되지 않으면 고정사용자를 편집 할 수 없습니다.  그들 이외의 사용자의 편집은 가능합니다.  권한없이 고정사용자를 편집하고자 하는 경우, 기록에 남게 되므로 주의 하시기 바랍니다. <a href=\"{$_CONF['site_admin_url']}/user.php\"> 사용자 관리페이지 </a>로 돌아가시기 바랍니다.",
    'securitygroupsmsg' => '이 사용자가 소속한 그룹에 체크 하시기 바랍니다.',
    'groupeditor' => '그룹편집',
    'description' => '자세한 설명',
    'name' => '이름',
    'rights' => '권한',
    'missingfields' => '미입력 항목',
    'missingfieldsmsg' => '이름과 설명을 입력해 주시기 바랍니다',
    'groupmanager' => '그룹관리',
    'newgroupmsg' => '그룹 편집, 삭제는 각 그룹의 편집아이콘을 클릭, 그룹 작성은 [신규작성] 링크를 클릭하시기 바랍니다.  [코아(핵심) 그룹]은 시스템으로 사용하기 위해서 삭제 할 수 없습니다.',
    'groupname' => '그룹이름',
    'coregroup' => '핵심그룹',
    'yes' => 'Yes',
    'no' => 'No',
    'corerightsdescr' => "이 그룹은{$_CONF['site_name']}의 [핵심그룹]입니다.  그러므로 본 그룹의 권한을 편집 할 수 없으므로 다음의 권한 목록은 읽기전용으로 되어 있습니다.",
    'groupmsg' => '본 사이트의 보장된 그룹은 계층적으로 되어 있습니다.  본 그룹을 다음의 그룹에 추가할 경우, 그 그룹이 지닌 권한과 동일한 권한을 본 그룹에도 부여하게 됩니다. 가능하시다면 본 그룹에게 권한을 부여할 경우 다음의 그룹의 권한을 계승 시키는 방법으로 됩니다. 본 그룹에 개별적으로 권한을 부여할 경우 다음의 [권한] 부분에서 다양한 기능에 선택할 수 있습니다. 본 그룹을 추가 시킬 경우 아래의 그룹 옆에 있는 박스에 체크해 주시기 바랍니다.',
    'coregroupmsg' => "본 그룹은{$_CONF['site_name']}의 [핵심그룹]입니다.  그러므로 본 그룹에 소속된 그룹은 편집 할 수 없습니다.  다음의 목록은 읽기전용으로 되어 있습니다.",
    'rightsdescr' => '그룹의 접속권은 다음의 권한으로 부여 되지만, 그룹이 소속한 그룹 전체의 권한을 계승 하고 있습니다.  다음에서 체크되지 않은 권한은 본 그룹에 소속된 그룹으로 부터 계승한 권한입니다. 체크되어 있는 권한은 본 그룹 자체가 직접 부여한 권한입니다.',
    'lock' => '잠금',
    'members' => '멤버(회원)　',
    'anonymous' => '손님',
    'permissions' => '승인',
    'permissionskey' => 'R = 열람, E = 편집, (편집권은 열람권을 포함합니다)',
    'edit' => '편집',
    'none' => '없슴',
    'accessdenied' => '접속 실패.',
    'storydenialmsg' => "이 기사를 검색할 권한이 없습니다.  이것은 당신이{$_CONF['site_name']}의 멤버가 아니기 때문인 것으로 여겨집니다. {$_CONF['site_name']} 의<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\"> 멤버가 되면 </a>으로 검색 할 수 있습니다.",
    'nogroupsforcoregroup' => '이 그룹은 다른 어떤 그룹에도 소속되어 있지 않습니다.',
    'grouphasnorights' => '이 그룹은 관리권한을 일체 소유하고 있지 않습니다.',
    'newgroup' => '신규',
    'adminhome' => '관리화면',
    'save' => '보존(저장)',
    'cancel' => '취소',
    'delete' => '삭제',
    'canteditroot' => '고정그룹에 소속되지 않은 고정그룹을 편집하고자 하므로 접속은 거절 되었습니다.  이 에러가 이상하다고 생각되는 경우에는 시스템 관리자에게 연락하시기 바랍니다.',
    'listusers' => '사용자 표시와 편집',
    'listthem' => '목록',
    'usersingroup' => '"%s"%s 에 포함된 사용자 통합검색',
    'usergroupadmin' => '그룹 관리',
    'add' => '추가',
    'remove' => '삭제',
    'availmembers' => '사용자 통합검색',
    'groupmembers' => '그룹멤버',
    'canteditgroup' => '그룹을 편집하기 위해서는 그룹의 멤버가 아니면 안됩니다.  이 메세지가 에러일 경우 시스템 관리자에게 연락하시기 바랍니다.',
    'cantlistgroup' => '멤버목록을 검색하기 위해서는 그룹멤버가 되지 않으면 안됩니다.  이 메세지가 에러로 되어 있을 경우 시스템 관리자에게 연락하시기 바랍니다.',
    'editgroupmsg' => '그룹멤버를 편집하기 위해서는 멤버 이름을 클릭하여 [추가] 내지는 [삭제] 단추를 클릭하시기 바랍니다. 사용자 그룹멤버일 경우는 오른쪽에만 표시됩니다.  편집이 끝나면 [보존] 단추를 클릭해 주시기 바랍니다. 관리화면으로 돌아갑니다.',
    'listgroupmsg' => '그룹 <b>%s</b> 포함된 사용자：',
    'search' => '검색',
    'submit' => '등록',
    'limitresults' => '결과로 좁혀짐',
    'group_id' => '그룹아이디ID',
    'plugin_access_denied_msg' => '이 플러그인의 관리권한이 없으므로 관리화면으로 접속하려고 합니다.  이 행위는 기록됩니다.',
    'groupexists' => '이 그룹 이름은 이미 존재합니다.',
    'groupexistsmsg' => '같은 그룹이름이 있습니다.  그룹이름은 각각 다를 필요가 있습니다.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => '이전 백업수（10）',
    'do_backup' => '백업 실행',
    'backup_successful' => '데이터베이스 백업을 완료 하였습니다',
    'db_explanation' => 'Geeklog를 백업하기 위해서는 다음의 단추를 클릭하시기 바랍니다.',
    'not_found' => "패스 지정에 잘못이 있으므로 mysqdump가 실행 가능해지지 않습니다.<br" . XHTML . "><strong>\$_DB_mysqldump_path</strong>의 설정을 config.php로 체크하시기 바랍니다.  <br" . XHTML . "> 현재의 설정은 \n<var>{$_DB_mysqldump_path}</var>입니다.",
    'zero_size' => '백업에 실패했습니다.  파일의 크기가 0 바이트(bytes) 입니다.',
    'path_not_found' => "{$_CONF['backup_path']} 는 존재하지 않으며 디랙토리는 아닙니다.",
    'no_access' => "에러 :{$_CONF['backup_path']}디렉토리에 접속 할 수 없습니다.",
    'backup_file' => '백업 파일',
    'size' => '크기',
    'bytes' => '바',
    'total_number' => '백업 총수는 %d입니다.',
    'download' => 'Click to download this file',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => '홈(집)',
    2 => '메일보내기',
    3 => '기사공개',
    4 => '',
    5 => '',
    6 => '',
    7 => '사이트 정보',
    8 => '개인설정',
    9 => '검색',
    10 => '검색옵션',
    11 => '기사관리'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',
    2 => '<b>%s</b>는 어디에도 찾을 수 없습니다.',
    3 => '지정된 파일은 존재하지 않습니다.  메인페이지를 체크해 보시거나 검색페이지에서 살펴 보시기바랍니다.'
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => '로그인 하시기 바랍니다',
    2 => '죄송합니다만 먼저 로그인 하시기 바랍니다.',
    3 => '로그인',
    4 => '신규등록'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => '트랙백',
    'from' => '부터',
    'tracked_on' => '트랙백 켜짐',
    'read_more' => '더 읽기',
    'intro_text' => '\'%s\'씨에 대해서 다른 사이트에서는 다음과 같이 말하고 있습니다:',
    'no_comments' => '이 기사에는 트랙백, 덧글이 없습니다.',
    'this_trackback_url' => '이 엔트리의 트랙백 URL:',
    'num_comments' => '%d 건의 트랙백',
    'send_trackback' => '트랙백, 핑 보내기',
    'preview' => '미리보기',
    'editor_title' => '트랙백 보내기',
    'trackback_url' => '트랙백 URL',
    'entry_url' => '엔트리 URL',
    'entry_title' => '엔트리 제목',
    'blog_name' => '사이트 이름',
    'excerpt' => '개요',
    'truncate_warning' => '주 : 수신된 사이트 측에서 개요를 끊어버릴 경우가 있습니다.',
    'button_send' => '보내기',
    'button_preview' => '미리보기',
    'send_error' => '에러',
    'send_error_details' => '트랙백 송신 중에 에러가 발생하였습니다.',
    'url_missing' => '엔트리 URL',
    'url_required' => '엔트리 URL은 반드시 입력하시기 바랍니다.',
    'target_missing' => '트랙백 URL이 없습니다.',
    'target_required' => '트랙백 URL을 입력하시기 바랍니다.',
    'error_socket' => '소켓을 열 수 없었습니다.',
    'error_response' => '불명한 응답이 되돌아 왔습니다.',
    'error_unspecified' => '불명한 에러입니다.',
    'select_url' => '트랙백 URL을 선택하시기 바랍니다.',
    'not_found' => '트랙백 URL 을 찾을 수 없습니다.',
    'autodetect_failed' => '덧글을 보내고자 한 기사의 트랙백 URL을 찾을 수 없었습니다.  URL을 다음에 입력하시기 바랍니다.',
    'trackback_explain' => '이하의 링크에서 트랙백을 보내고자 하는 URL을 선택하시기 바랍니다.  이기사의 올바른 트랙백 URL을 결정합니다.  URL을 알고 계시면 <a href="%s"> 스스로 입력 </a>하는 것이 가능합니다.',
    'no_links_trackback' => '링크를 찾을 수 없습니다.  이 엔트리에 트랙백을 보낼 수 없습니다.',
    'pingback' => '핑백',
    'pingback_results' => '핑백 결과',
    'send_pings' => '빙백 보내기',
    'send_pings_for' => '"%s" 에 핑 보내기',
    'no_links_pingback' => '링크를 찾을 수 없습니다.  이 엔트리에 대한 핑백은 보내지지 않았습니다.',
    'pingback_success' => '핑백 보내기 했습니다.',
    'no_pingback_url' => '핑백 URL을 찾을 수 없습니다.',
    'resend' => '다시보내기',
    'ping_all_explain' => '당신이 링크하신 것을 상대방의 사이트에 알리거나 (<ahref=\"http://en.wikipedia.org/wiki/Pingback\">트랙백</a>)，웹블러그 디렉토리 서비스에 핑을 보내어 사이트가 갱신 된 것을 알리거나, 누군가의 사이트의 기사에 대해서 글을 쓸 경우에<a href="http://ja.wikipedia.org/wiki/%E3%83%88%E3%83%A9%E3%83%83%E3%82%AF%E3%83%90%E3%83%83%E3%82%AF">를 보내기 등을 할 수 있습니다.',
    'pingback_button' => '핑백 보내기',
    'pingback_short' => '이 엔트리에서 링크된 모든 사이트에 핑백을 보내기',
    'pingback_disabled' => '(핑백은 무효합니다)',
    'ping_button' => '핑백을 보내기',
    'ping_short' => '웹블러그 디렉토리 서비스에 핑',
    'ping_disabled' => '(핑은 무효합니다)',
    'trackback_button' => '트랙백을 보내기',
    'trackback_short' => '트랙백을 보내기',
    'trackback_disabled' => '(트랙백은 무효합니다)',
    'may_take_a_while' => '핑백과 핑 보내기는 시간이 걸립니다.  주의 하시기 바랍니다.',
    'ping_results' => '핑의 결과',
    'unknown_method' => '불명한 핑 방법입니다.',
    'ping_success' => '핑을 보내기 하였습니다.',
    'error_site_name' => '사이트 이름을 입력하시기 바랍니다.',
    'error_site_url' => '사이트의 URL을 입력하시기 바랍니다.',
    'error_ping_url' => '올바른 핑 URL을 입력하시기 바랍니다.',
    'no_services' => '웹블러그 디렉토리 서비스가 설정 되어 있지 않습니다.',
    'services_headline' => '웹블러그 디렉토리 서비스관리',
    'service_explain' => '웹블러그 디렉토리 서비스 수정, 삭제할 경우, 편집 아이콘을 클릭하시기 바랍니다.  새로운 웹블러그 디렉토리 서비스를 작성 할 경우는 [신규서비스] 를 클릭 하시기 바랍니다.',
    'service' => '서비스',
    'ping_method' => '핑 방법',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => '표준 핑',
    'ping_extended' => '확장 핑',
    'ping_unknown' => '(불명한 방법)',
    'edit_service' => '웹블러그 디렉토리 서비스 편집',
    'trackbacks' => '트랙백',
    'editor_intro' => '<a href="%s">%s</a>에 대한 트랙백을 준비하시기 바랍니다.',
    'editor_intro_none' => '트랙백을 준비하시기 바랍니다.',
    'trackback_note' => '기사에 트랙백을 보내기 하려면, 기사일람으로 그 기사의"핑을 보내다"을 클릭하시기 바랍니다. 기사와 관계없는 트랙백을 보내기 하면 <a href="%s">이곳을 클릭</a>。',
    'pingback_explain' => '핑백 하는 URL을 입력하시기 바랍니다.  핑 백에서 다른 사이트로 부터 링크가 늘어난 것을 자동적으로 통지 합니다.',
    'pingback_url' => '핑백 URL',
    'site_url' => '이 사이트의 URL',
    'pingback_note' => '기사에 대한 핑백을 보내기 하기 위해서는 기사를 클릭 하시기 바랍니다."핑을 보내다" 에 관련 있는 기사에 핑을 보내기 하기 위해서는<a href="%s">여기를 클릭</a>.',
    'pbtarget_missing' => '핑백 URL 에서는 없습니다.',
    'pbtarget_required' => '핑백 URL 을 입력하시기 바랍니다.',
    'pb_error_details' => '다음의 핑백을 보내기 하는 중에 에러',
    'delete_trackback' => '트랙백 삭제: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => '기사검색',
    'title_year' => '%d 년의 기사검색',
    'title_month_year' => '%d년 %s 월의 기사검색',
    'nav_top' => '기사검색 트랙으로 돌아가기',
    'no_articles' => '기사가 없습니다'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '최근 %t%s  동안 신착 %i %n 건',
    'new_last' => '최신 %t %s',
    'minutes' => '분',
    'hours' => '시간',
    'days' => '일',
    'weeks' => '주',
    'months' => '개월',
    'years' => 'years',
    'minute' => '분',
    'hour' => '시간',
    'day' => '일',
    'week' => '주',
    'month' => '개월',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => '1월',
    2 => '2월',
    3 => '3월',
    4 => '4월',
    5 => '5월',
    6 => '6월',
    7 => '7월',
    8 => '8월',
    9 => '9월',
    10 => '10월',
    11 => '11월',
    12 => '12월'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => '일',
    2 => '월',
    3 => '화',
    4 => '수',
    5 => '목',
    6 => '금',
    7 => '토'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => '검색',
    'limit_results' => '결과로 좁혀짐',
    'submit' => '등록',
    'edit' => '편집',
    'edit_adv' => '어드벤스트 에디터',
    'admin_home' => '관리화면',
    'create_new' => '신규작성',
    'create_new_adv' => '신규작성',
    'enabled' => '유효해짐',
    'disabled' => 'Disabled',
    'title' => '제목',
    'page_title' => 'Page Title',
    'type' => '종류',
    'topic' => '토픽',
    'info' => 'Info',
    'help_url' => '도움파일 URL',
    'save' => '보존(저장)',
    'cancel' => '취소',
    'install' => 'Install',
    'delete' => '삭제',
    'deleteitem' => 'Delete',
    'delete_sel' => '삭제선택',
    'copy' => '복사',
    'no_results' => '찾을 수 없었습니다.',
    'data_error' => '보내기 데이터에 문제가 있습니다. 데이터를 체크하시기 바랍니다.',
    'preview' => '미리보기',
    'records_found' => '건수',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => '덧글 유효',
    -1 => '덧글 정지',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => '일람',
    'nested' => '숨겨진',
    'threaded' => '트리',
    'nocomment' => '표시하지 않음'
);

$LANG_cookiecodes = array(
    0 => '접수 된 것 없음',
    3600 => '1 시간',
    7200 => '2 시간',
    10800 => '3 시간',
    28800 => '8 시간',
    86400 => '  1일',
    604800 => '1주간',
    2678400 => '1개월'
);

$LANG_dateformats = array(
    0 => '디펄트'
);

$LANG_featurecodes = array(
    0 => '통상적인 기사',
    1 => '주목기사'
);

$LANG_frontpagecodes = array(
    0 => '해당하는 화제만을 표시',
    1 => '첫 페이지에 표시'
);

$LANG_postmodes = array(
    'plaintext' => 'plaintext',
    'html' => 'html'
);

$LANG_sortcodes = array(
    'ASC' => '기존의 차례로',
    'DESC' => '새로운 차례로'
);

$LANG_trackbackcodes = array(
    0 => '트랙백 유효',
    -1 => ' 트랙백 정지'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'owner_name' => 'Owner Name',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_pear' => 'Path Pear',
    'have_pear' => 'Have Pear?',
    'mail_settings' => 'Mail Settings',
    'allow_mysqldump' => 'Allow MySQL Dump',
    'mysqldump_path' => 'Path of Executable',
    'mysqldump_options' => 'MySQL Dump Options',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Stories per Page',
    'minnews' => 'Min. Stories per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Story',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Story as Featured?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Stories in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order',
    'autotag_permissions_story' => '[story: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Stories and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Story',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_pear' => 'Pear',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Story',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none')
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP'
);


?>
