<?php

###############################################################################
# slovak.php
# This is the Slovak language file for the Geeklog Calendar plugin
#
# Copyright (C) 2010 Miroslav Fikar
# miroslav.fikar+geeklog@gmail.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

global $LANG32;

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

# index.php
$LANG_CAL_1 = array(
    1 => 'Kalendr akci',
    2 => 'Nie s iadne akcie na zobrazenie.',
    3 => 'Kedy',
    4 => 'Kde',
    5 => 'Opis',
    6 => 'Prida akciu',
    7 => 'Nastvajce akcie',
    8 => 'By adding this event to your calendar you can quickly view only the events you are interested in by clicking "My Calendar" from the User Functions area.',
    9 => 'Prida do osobnho kalendra.',
    10 => 'Odobra z mjho kalendra',
    11 => 'Prida akciu do osobnho kalendra uvatea %s',
    12 => 'Akcia',
    13 => 'Zaiatok',
    14 => 'Koniec',
    15 => 'Sp na kalendr',
    16 => 'Kalendr',
    17 => 'Zaiaton dtum',
    18 => 'Koncov dtum',
    19 => 'Poiadavky kalendra',
    20 => 'Nadpis',
    21 => 'Zaiaton dtum',
    22 => 'URL',
    23 => 'Tvoje akcie',
    24 => 'Plnovan akcie',
    25 => 'iadne bliace sa akcie',
    26 => 'Posla akciu',
    27 => "Odoslanm akcie pre {$_CONF['site_name']} pridte vau akciu do hlavnho kalendra. Po odoslan bude akcia postpen na schvlenie a potom bude publikovan v hlavnom kalendri.",
    28 => 'Nadpis',
    29 => 'as konca',
    30 => 'as zaiatku',
    31 => 'Vetky akcie da',
    32 => 'Adresa 1',
    33 => 'Adresa 2',
    34 => 'Mesto',
    35 => 'tt',
    36 => 'PS',
    37 => 'Typ akcie',
    38 => 'Upravi typy akci',
    39 => 'Umiestenie',
    40 => 'Prida akciu do',
    41 => 'Hlavn kalendr',
    42 => 'Osobn kalendr',
    43 => 'Odkaz',
    44 => 'HTML tagy nie s povolen',
    45 => 'Odosla',
    46 => 'Akcie v systme',
    47 => 'Top Ten akci',
    48 => 'Kliknutie',
    49 => 'iadne akcie.',
    50 => 'Akcie',
    51 => 'Vymaza',
    'autotag_desc_event' => '[event: id alternate title] - Displays a link to an Event Link from the Calendar using the Event Title as the title. An alternate title may be specified but is not required.'
);

$_LANG_CAL_SEARCH = array(
    'results' => 'Vsledky kalendra',
    'title' => 'Nadpis',
    'date_time' => 'Dtum & as',
    'location' => 'Umiestenie',
    'description' => 'Opis'
);

###############################################################################
# calendar.php ($LANG30)

$LANG_CAL_2 = array(
    8 => 'Prida osobn akciu',
    9 => '%s akci',
    10 => 'Akcie pre',
    11 => 'Hlavn kalendr',
    12 => 'Mj kalendr',
    25 => 'Sp na ',
    26 => 'Cel de',
    27 => 'Tde',
    28 => 'Osobn kalendr pre',
    29 => 'Verejn kalendr',
    30 => 'Vymaza akciu',
    31 => 'Prida',
    32 => 'Akcia',
    33 => 'Dtum',
    34 => 'as',
    35 => 'Rchle prida',
    36 => 'Odosla',
    37 => 'Bohuia, pouitie osobnho kalendra nie je povolen',
    38 => 'Osobn editor akci',
    39 => 'De',
    40 => 'Tde',
    41 => 'Mesiac',
    42 => 'Prida hlavn akciu',
    43 => 'Poiadavky akci'
);

###############################################################################
# admin/plugins/calendar/index.php, formerly admin/event.php ($LANG22)

$LANG_CAL_ADMIN = array(
    1 => 'Editor akci',
    2 => 'Chyba',
    3 => 'Post Mode',
    4 => 'URL akcie',
    5 => 'Dtum zaiatku',
    6 => 'Dtum konca',
    7 => 'Umiestenie akcie',
    8 => 'Opis akcie',
    9 => '(vrtane http://)',
    10 => 'Muste zada dtum/as, nadpis a opis',
    11 => 'Sprvca kalendra',
    12 => 'Pre zmenu alebo vymazanie akcie, kliknite na ikonu akcie.  Pre vytvorenie novej akcie, kliknite na "Vytvori nov". Kliknutm na ikonu kpie vytvorte kpiu akcie.',
    13 => 'Autor',
    14 => 'Dtum zaiatku',
    15 => 'Dtum konca',
    16 => '',
    17 => "Pristupujete k akcie, na ktor nemte dostaten prva. Tento pokus byl zalogovn. Prosm, <a href=\"{$_CONF['site_admin_url']}/plugins/calendar/index.php\">vrte sa sp na administrciu akci</a>.",
    18 => '',
    19 => '',
    20 => 'uloi',
    21 => 'zrui',
    22 => 'vymaza',
    23 => 'Chybn dtum zaiatku.',
    24 => 'Chybn dtum konca.',
    25 => 'Koncov dtum je pred dtumom zaiatku.',
    26 => 'Delete old entries',
    27 => 'These are the events that are older than ',
    28 => ' months. Please click on the trashcan Icon on the bottom to delete them, or select a different timespan:<br' . XHTML . '>Find all entries that are older than ',
    29 => ' months.',
    30 => 'Update List',
    31 => 'Are You sure you want to permanently delete ALL selected users?',
    32 => 'List all',
    33 => 'No events selected for deletion',
    34 => 'Event ID',
    35 => 'could not be deleted',
    36 => 'Sucessfully deleted'
);

$LANG_CAL_MESSAGE = array(
    'save' => 'Akcia bola spene uloen.',
    'delete' => 'Akcia bola spene vymazan.',
    'private' => 'Akcia bola uloen do vho osobnho kalendra',
    'login' => 'Nemem otvori v osobn kalendr pokia sa neprihlsite',
    'removed' => 'Akcia bola odstrnen z vho osobnho kalendra',
    'noprivate' => 'Bohuia, osobn kalendre tento server nepodporuje',
    'unauth' => 'Bohuia, nemte administrtorsk prstup. Tento v pokus bol zalogovan'
);

$PLG_calendar_MESSAGE4 = "akujeme za odoslanie akcie pre {$_CONF['site_name']}.  Teraz oakva potvrdenie.  Akonhle bude potvrden, njdete ju v <a href=\"{$_CONF['site_url']}/calendar/index.php\">kalendri</a>.";
$PLG_calendar_MESSAGE17 = 'Akcia bola spene uloen.';
$PLG_calendar_MESSAGE18 = 'Akcia bola spene vymazan.';
$PLG_calendar_MESSAGE24 = 'Akcia bola uloen do kalendra.';
$PLG_calendar_MESSAGE26 = 'Akcia bola vymazan.';

// Messages for the plugin upgrade
$PLG_calendar_MESSAGE3001 = 'Plugin upgrade not supported.';
$PLG_calendar_MESSAGE3002 = $LANG32[9];

// Localization of the Admin Configuration UI
$LANG_configsections['calendar'] = array(
    'label' => 'Calendar',
    'title' => 'Calendar Configuration'
);

$LANG_confignames['calendar'] = array(
    'calendarloginrequired' => 'Calendar Login Required?',
    'hidecalendarmenu' => 'Hide Calendar Menu Entry?',
    'personalcalendars' => 'Enable Personal Calendars?',
    'eventsubmission' => 'Enable Submission Queue?',
    'showupcomingevents' => 'Show upcoming Events?',
    'upcomingeventsrange' => 'Upcoming Events Range',
    'event_types' => 'Event Types',
    'hour_mode' => 'Hour Mode',
    'notification' => 'Notification Email?',
    'delete_event' => 'Delete Events with Owner?',
    'aftersave' => 'After Saving Event',
    'default_permissions' => 'Event Default Permissions',
    'autotag_permissions_event' => '[event: ] Permissions',
    'block_enable' => 'Enabled',
    'block_isleft' => 'Display Block on Left',
    'block_order' => 'Block Order',
    'block_topic_option' => 'Topic Options',
    'block_topic' => 'Topic',
    'block_group_id' => 'Group',
    'block_permissions' => 'Permissions'
);

$LANG_configsubgroups['calendar'] = array(
    'sg_main' => 'Main Settings'
);

$LANG_tab['calendar'] = array(
    'tab_main' => 'General Calendar Settings',
    'tab_permissions' => 'Default Permissions',
    'tab_autotag_permissions' => 'Autotag Usage Permissions',
    'tab_events_block' => 'Events Block'
);

$LANG_fs['calendar'] = array(
    'fs_main' => 'General Calendar Settings',
    'fs_permissions' => 'Default Permissions',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_block_settings' => 'Block Settings',
    'fs_block_permissions' => 'Block Permissions'
);

// Note: entries 0, 1, 6, 9, 12 are the same as in $LANG_configselects['Core']
$LANG_configselects['calendar'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    6 => array('12' => 12, '24' => 24),
    9 => array('Forward to Event' => 'item', 'Display Admin List' => 'list', 'Display Calendar' => 'plugin', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('No access' => 0, 'Use' => 2),
    14 => array('No access' => 0, 'Read-Only' => 2),
    15 => array('All' => TOPIC_ALL_OPTION, 'Homepage Only' => TOPIC_HOMEONLY_OPTION, 'Select Topics' => TOPIC_SELECTED_OPTION)
);

?>
